/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.datastructures.tree.binaryTree;

import dev.brachtendorf.jimagehash.datastructures.tree.AbstractBinaryTree;
import dev.brachtendorf.jimagehash.datastructures.tree.NodeInfo;
import dev.brachtendorf.jimagehash.datastructures.tree.Result;
import dev.brachtendorf.jimagehash.datastructures.tree.binaryTree.Leaf;
import dev.brachtendorf.jimagehash.datastructures.tree.binaryTree.Node;
import dev.brachtendorf.jimagehash.hash.Hash;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class BinaryTree<T>
extends AbstractBinaryTree<T> {
    private static final long serialVersionUID = 4193396415197848158L;

    public BinaryTree(boolean ensureHashConsistency) {
        super(ensureHashConsistency);
    }

    protected BinaryTree() {
    }

    @Override
    public void addHash(Hash hash, T value) {
        super.addHash(hash, value);
    }

    @Override
    public PriorityQueue<Result<T>> getElementsWithinHammingDistance(Hash hash, int maxDistance) {
        if (this.ensureHashConsistency && this.algoId != hash.getAlgorithmId()) {
            throw new IllegalStateException("Tried to add an incompatible hash to the binary tree");
        }
        PriorityQueue<Result<T>> result = new PriorityQueue<Result<T>>();
        BigInteger hashValue = hash.getHashValue();
        int treeDepth = hash.getBitResolution();
        ArrayDeque queue = new ArrayDeque();
        queue.add(new NodeInfo(this.root, 0.0, treeDepth));
        while (!queue.isEmpty()) {
            Node failedChild;
            NodeInfo info = (NodeInfo)queue.poll();
            if (info.depth == 0) {
                Leaf leaf = (Leaf)info.node;
                for (Object o : leaf.getData()) {
                    result.add(new Result(o, info.distance, info.distance / (double)treeDepth));
                }
                continue;
            }
            boolean bit = hashValue.testBit(info.depth - 1);
            Node correctChild = info.node.getChild(bit);
            if (correctChild != null) {
                queue.add(new NodeInfo(correctChild, info.distance, info.depth - 1));
            }
            if (!(info.distance + 1.0 <= (double)maxDistance) || (failedChild = info.node.getChild(!bit)) == null) continue;
            queue.add(new NodeInfo(failedChild, info.distance + 1.0, info.depth - 1));
        }
        return result;
    }

    @Override
    public List<Result<T>> getNearestNeighbour(Hash hash) {
        if (this.ensureHashConsistency && this.algoId != hash.getAlgorithmId()) {
            throw new IllegalStateException("Tried to add an incompatible hash to the binary tree");
        }
        BigInteger hashValue = hash.getHashValue();
        int treeDepth = hash.getBitResolution();
        ArrayDeque queue = new ArrayDeque();
        ArrayList<Result<T>> result = new ArrayList<Result<T>>();
        double curBestDistance = Double.MAX_VALUE;
        queue.add(new NodeInfo(this.root, 0.0, treeDepth));
        while (!queue.isEmpty()) {
            Node correctChild;
            Node failedChild;
            NodeInfo info = (NodeInfo)queue.removeLast();
            if (info.distance > curBestDistance) continue;
            if (info.depth == 0) {
                if (curBestDistance > info.distance) {
                    result.clear();
                    curBestDistance = info.distance;
                }
                Leaf leaf = (Leaf)info.node;
                for (Object o : leaf.getData()) {
                    result.add(new Result(o, info.distance, info.distance / (double)treeDepth));
                }
                continue;
            }
            boolean bit = hashValue.testBit(info.depth - 1);
            if (info.distance + 1.0 <= curBestDistance && (failedChild = info.node.getChild(!bit)) != null) {
                queue.add(new NodeInfo(failedChild, info.distance + 1.0, info.depth - 1));
            }
            if ((correctChild = info.node.getChild(bit)) == null) continue;
            queue.add(new NodeInfo(correctChild, info.distance, info.depth - 1));
        }
        return result;
    }
}

