/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.compiler.CGAnnotation;
import net.binis.codegen.compiler.CGClassDeclaration;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGMethodDeclaration;
import net.binis.codegen.compiler.CGValueExpression;
import net.binis.codegen.compiler.utils.ElementAnnotationUtils;
import net.binis.codegen.compiler.utils.ElementUtils;
import net.binis.codegen.enrich.OpenApiEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import net.binis.codegen.options.Options;
import net.binis.codegen.tools.Reflection;
import org.apache.commons.lang3.StringUtils;

public class OpenApiElementEnricherHandler
extends BaseEnricher
implements OpenApiEnricher {
    protected static final Class<? extends Annotation> OPEN_API_CLASS = Reflection.loadClass((String)"io.swagger.v3.oas.annotations.media.Schema");
    protected static final boolean IS_OPENAPI_AVAILABLE = Objects.nonNull(OPEN_API_CLASS);

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public int order() {
        return -2147478648;
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        CGDeclaration decl;
        if (Objects.nonNull(description.getElement()) && (decl = ElementUtils.getDeclaration(description.getElement())) instanceof CGClassDeclaration) {
            CGClassDeclaration cls = (CGClassDeclaration)decl;
            cls.getMethods().forEach(this::enrichMethod);
        }
    }

    protected void enrichMethod(CGMethodDeclaration method) {
        CGAnnotation ann = null;
        if (method.getParameters().size() == 0) {
            ann = ElementAnnotationUtils.removeAnnotation((CGDeclaration)method, OPEN_API_CLASS);
        }
        if (Objects.isNull(ann)) {
            ann = ElementAnnotationUtils.addAnnotation((CGDeclaration)method, OPEN_API_CLASS, new CGExpression[0]);
        }
        ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "name", Helpers.getFieldName(method.getName().toString()));
        this.checkForRequired(method, ann);
        this.checkForDefaultValue(method, ann);
        this.checkForLength(method, ann);
        this.checkForRange(method, ann);
        Class cls = method.getReturnType().toClass();
        if (Objects.nonNull(cls)) {
            if (cls.isEnum()) {
                ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "type", "string");
                ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "allowableValues", Arrays.stream(cls.getEnumConstants()).map(Object::toString).toArray(String[]::new));
            } else if (CodeEnum.class.isAssignableFrom(cls)) {
                ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "type", "string");
                ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "allowableValues", Arrays.stream(CodeFactory.enumValues((Class)cls)).map(e -> e.name()).toArray(String[]::new));
            }
        } else {
            PrototypeDescription<ClassOrInterfaceDeclaration> proto = this.lookup.findGenerated(method.getReturnType().toSymbolString());
            if (Objects.nonNull(proto) && proto.isCodeEnum()) {
                ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "type", "string");
                ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "allowableValues", proto.getDeclaration().asEnumDeclaration().getEntries().stream().map(NodeWithSimpleName::getNameAsString).toArray(String[]::new));
            }
        }
    }

    protected void checkForRequired(CGMethodDeclaration method, CGAnnotation ann) {
        Class cls = Reflection.loadClass((String)"net.binis.codegen.validation.annotation.ValidateNull");
        if (Objects.nonNull(cls) && Objects.nonNull(ElementAnnotationUtils.getAnnotation(method, (Class<? extends Annotation>)cls))) {
            ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "required", true);
        }
    }

    protected void checkForDefaultValue(CGMethodDeclaration method, CGAnnotation ann) {
        CGAnnotation def = ElementAnnotationUtils.getAnnotation(method, Default.class);
        if (Objects.nonNull(def)) {
            this.strip(def.getArgument("value")).ifPresent(value -> ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "defaultValue", value));
        }
    }

    protected void checkForRange(CGMethodDeclaration method, CGAnnotation ann) {
        CGAnnotation a;
        Class cls = Reflection.loadClass((String)"net.binis.codegen.validation.annotation.ValidateRange");
        if (Objects.nonNull(cls) && Objects.nonNull(a = ElementAnnotationUtils.getAnnotation(method, (Class<? extends Annotation>)cls))) {
            for (CGExpression pair : a.getArguments()) {
                switch (pair.getKeyAsString()) {
                    case "max": {
                        ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "maximum", this.strip(pair.getValueAsString()));
                        break;
                    }
                    case "min": {
                        ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "minimum", this.strip(pair.getValueAsString()));
                    }
                }
            }
        }
    }

    protected void checkForLength(CGMethodDeclaration method, CGAnnotation ann) {
        CGAnnotation a;
        Class cls = Reflection.loadClass((String)"net.binis.codegen.validation.annotation.ValidateLength");
        if (Objects.nonNull(cls) && Objects.nonNull(a = ElementAnnotationUtils.getAnnotation(method, (Class<? extends Annotation>)cls))) {
            for (CGExpression pair : a.getArguments()) {
                switch (pair.getKeyAsString()) {
                    case "value": 
                    case "max": {
                        ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "maxLength", this.stripInt(pair.getValue()));
                        break;
                    }
                    case "min": {
                        ElementAnnotationUtils.addIfMissingAnnotationAttribute(ann, "minLength", this.stripInt(pair.getValue()));
                    }
                }
            }
        }
    }

    protected boolean generate(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        return description.hasOption(Options.GENERATE_OPENAPI_ALWAYS) || IS_OPENAPI_AVAILABLE && description.hasOption(Options.GENERATE_OPENAPI_IF_AVAILABLE);
    }

    protected Optional<String> strip(CGValueExpression arg) {
        CGExpression expr;
        if (Objects.nonNull(arg) && Objects.nonNull(expr = arg.getValue())) {
            return Optional.of(this.strip(arg.getValue().toString()));
        }
        return Optional.empty();
    }

    protected int stripInt(Object value) {
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected String strip(String str) {
        return StringUtils.strip((String)str, (String)"\\\"");
    }
}

