/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler;

import com.sun.source.util.Trees;
import java.util.Objects;
import javax.lang.model.element.Element;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGModifiers;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CGDeclaration
extends JavaCompilerObject {
    private static final Logger log = LoggerFactory.getLogger(CGDeclaration.class);
    protected CGModifiers modifiers;

    protected CGDeclaration(Trees trees, Element element) {
        this.instance = trees.getTree(element);
        if (!this.cls.isAssignableFrom(this.instance.getClass())) {
            log.error("Unable to get class declaration!");
        }
    }

    protected CGDeclaration(Object instance) {
        this.instance = instance;
        if (!this.cls.isAssignableFrom(instance.getClass())) {
            log.error("Unable to get class declaration!");
        }
    }

    public CGModifiers getModifiers() {
        if (Objects.isNull(this.modifiers)) {
            this.modifiers = new CGModifiers(this);
        }
        return this.modifiers;
    }

    public CGList<JavaCompilerObject> getDefs() {
        return new CGList<JavaCompilerObject>(Reflection.getFieldValue((Object)this.instance, (String)"defs"), this::onDefsModify, JavaCompilerObject.class);
    }

    public CGName getName() {
        return new CGName(Reflection.getFieldValue((Object)this.instance, (String)"name"), true);
    }

    protected <T extends JavaCompilerObject> void onDefsModify(CGList<T> list) {
        Reflection.setFieldValue((Object)this.instance, (String)"defs", (Object)list.getInstance());
    }

    public CGSymbol getSymbol() {
        return new CGSymbol(Reflection.getFieldValue((Object)this.instance, (String)"sym"));
    }

    public boolean isFinal() {
        return (this.getModifiers().flags() & 0x10L) == 16L;
    }

    public boolean isPublic() {
        return (this.getModifiers().flags() & 1L) == 1L;
    }

    public boolean isPrivate() {
        return (this.getModifiers().flags() & 2L) == 2L;
    }

    public boolean isProtected() {
        return (this.getModifiers().flags() & 4L) == 4L;
    }

    public boolean isStatic() {
        return (this.getModifiers().flags() & 8L) == 8L;
    }
}

