/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.utils;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import net.binis.codegen.compiler.CGAnnotation;
import net.binis.codegen.compiler.CGArrayTypeTree;
import net.binis.codegen.compiler.CGAssign;
import net.binis.codegen.compiler.CGBlock;
import net.binis.codegen.compiler.CGClassDeclaration;
import net.binis.codegen.compiler.CGClassSymbol;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGFieldAccess;
import net.binis.codegen.compiler.CGIdent;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGLiteral;
import net.binis.codegen.compiler.CGMethodDeclaration;
import net.binis.codegen.compiler.CGMethodInvocation;
import net.binis.codegen.compiler.CGMethodSymbol;
import net.binis.codegen.compiler.CGModifiers;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.CGNewArray;
import net.binis.codegen.compiler.CGPrimitiveTypeTree;
import net.binis.codegen.compiler.CGScope;
import net.binis.codegen.compiler.CGStatement;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.compiler.CGSymtab;
import net.binis.codegen.compiler.CGTree;
import net.binis.codegen.compiler.CGType;
import net.binis.codegen.compiler.CGTypeApply;
import net.binis.codegen.compiler.CGTypeCast;
import net.binis.codegen.compiler.CGTypeParameter;
import net.binis.codegen.compiler.CGTypeTag;
import net.binis.codegen.compiler.CGValueExpression;
import net.binis.codegen.compiler.CGVarSymbol;
import net.binis.codegen.compiler.CGVariableDecl;
import net.binis.codegen.compiler.TreeMaker;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementUtils {
    private static final Logger log = LoggerFactory.getLogger(ElementUtils.class);
    public static Map<String, Class<? extends JavaCompilerObject>> CLASS_MAP = ElementUtils.initClassMap();

    public static void init() {
    }

    protected static Map<String, Class<? extends JavaCompilerObject>> initClassMap() {
        HashMap<String, Class<? extends JavaCompilerObject>> result = new HashMap<String, Class<? extends JavaCompilerObject>>();
        ElementUtils.registerClass(result, CGAnnotation.class);
        ElementUtils.registerClass(result, CGArrayTypeTree.class);
        ElementUtils.registerClass(result, CGAssign.class);
        ElementUtils.registerClass(result, CGBlock.class);
        ElementUtils.registerClass(result, CGClassDeclaration.class);
        ElementUtils.registerClass(result, CGClassSymbol.class);
        ElementUtils.registerClass(result, CGExpression.class);
        ElementUtils.registerClass(result, CGFieldAccess.class);
        ElementUtils.registerClass(result, CGIdent.class);
        ElementUtils.registerClass(result, CGLiteral.class);
        ElementUtils.registerClass(result, CGMethodDeclaration.class);
        ElementUtils.registerClass(result, CGMethodInvocation.class);
        ElementUtils.registerClass(result, CGMethodSymbol.class);
        ElementUtils.registerClass(result, CGModifiers.class);
        ElementUtils.registerClass(result, CGName.class);
        ElementUtils.registerClass(result, CGNewArray.class);
        ElementUtils.registerClass(result, CGPrimitiveTypeTree.class);
        ElementUtils.registerClass(result, CGScope.class);
        ElementUtils.registerClass(result, CGStatement.class);
        ElementUtils.registerClass(result, CGSymbol.class);
        ElementUtils.registerClass(result, CGSymtab.class);
        ElementUtils.registerClass(result, CGTree.class);
        ElementUtils.registerClass(result, CGType.class);
        ElementUtils.registerClass(result, CGTypeApply.class);
        ElementUtils.registerClass(result, CGTypeCast.class);
        ElementUtils.registerClass(result, CGTypeParameter.class);
        ElementUtils.registerClass(result, CGTypeTag.class);
        ElementUtils.registerClass(result, CGValueExpression.class);
        ElementUtils.registerClass(result, CGVariableDecl.class);
        ElementUtils.registerClass(result, CGVarSymbol.class);
        return result;
    }

    public static CGDeclaration getDeclaration(Element element) {
        TreeMaker maker = TreeMaker.create();
        return ElementUtils.getDeclaration(element, maker);
    }

    protected static CGDeclaration getDeclaration(Element element, TreeMaker maker) {
        return switch (element.getKind()) {
            case ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE -> CGClassDeclaration.create(maker.getTrees(), element);
            case ElementKind.METHOD, ElementKind.CONSTRUCTOR -> CGMethodDeclaration.create(maker.getTrees(), element);
            case ElementKind.FIELD, ElementKind.PARAMETER -> CGVariableDecl.create(maker.getTrees(), element);
            default -> throw new GenericCodeGenException("Invalid element kind: " + element.getKind().toString());
        };
    }

    public static CGFieldAccess selfType(CGClassDeclaration decl) {
        TreeMaker maker = TreeMaker.create();
        CGName name = decl.getName();
        return maker.Select((CGExpression)maker.Ident(name), decl.toName("class"));
    }

    protected static CGFieldAccess toType(Class<?> cls) {
        TreeMaker maker = TreeMaker.create();
        return maker.Select(ElementUtils.chainDotsString(maker, cls.getCanonicalName()), maker.toName("class"));
    }

    protected static CGExpression chainDots(JavaCompilerObject node, String elem1, String elem2, String ... elems) {
        return ElementUtils.chainDots(node, -1, elem1, elem2, elems);
    }

    protected static CGExpression chainDots(JavaCompilerObject node, String[] elems) {
        return ElementUtils.chainDots(node, -1, null, null, elems);
    }

    protected static CGExpression chainDots(JavaCompilerObject node, int pos, String elem1, String elem2, String ... elems) {
        TreeMaker maker = TreeMaker.create();
        if (pos != -1) {
            maker = maker.at(pos);
        }
        CGIdent e = null;
        if (elem1 != null) {
            e = maker.Ident(node.toName(elem1));
        }
        if (elem2 != null) {
            e = e == null ? maker.Ident(node.toName(elem2)) : maker.Select((CGExpression)e, node.toName(elem2));
        }
        for (String elem : elems) {
            e = e == null ? maker.Ident(node.toName(elem)) : maker.Select((CGExpression)e, node.toName(elem));
        }
        assert (e != null);
        return e;
    }

    public static CGExpression chainDotsString(String elems) {
        return ElementUtils.chainDots((JavaCompilerObject)TreeMaker.create(), null, null, elems.split("\\."));
    }

    public static CGExpression chainDotsString(JavaCompilerObject node, String elems) {
        return ElementUtils.chainDots(node, null, null, elems.split("\\."));
    }

    public static String getSymbolFullName(Element element) {
        CGSymbol symbol = new CGSymbol(element);
        if (symbol.is(CGClassSymbol.theClass())) {
            return symbol.asClassSymbol().getQualifiedName().toString();
        }
        if (symbol.is(CGVarSymbol.theClass())) {
            return symbol.asVarSymbol().getVariableType();
        }
        return element.getSimpleName().toString();
    }

    public static CGExpression classToExpression(Class<?> cls) {
        TreeMaker maker = TreeMaker.create();
        if (cls.isPrimitive()) {
            return maker.TypeIdent(ElementUtils.primitiveTypeTag(cls));
        }
        if (cls.isArray()) {
            return maker.TypeArray(ElementUtils.classToExpression(cls.getComponentType()));
        }
        return maker.QualIdent(maker.getSymbol(cls.getCanonicalName()));
    }

    public static CGTypeTag primitiveTypeTag(Class<?> cls) {
        return switch (cls.getName()) {
            case "byte" -> CGTypeTag.BYTE;
            case "char" -> CGTypeTag.CHAR;
            case "short" -> CGTypeTag.SHORT;
            case "long" -> CGTypeTag.LONG;
            case "float" -> CGTypeTag.FLOAT;
            case "int" -> CGTypeTag.INT;
            case "double" -> CGTypeTag.DOUBLE;
            case "boolean" -> CGTypeTag.BOOLEAN;
            case "void" -> CGTypeTag.VOID;
            default -> throw new IllegalStateException("Unexpected value: " + cls.getName());
        };
    }

    public static CGExpression calcExpression(TreeMaker maker, Object value) {
        if (value instanceof CGExpression) {
            CGExpression v = (CGExpression)value;
            return v;
        }
        if (value instanceof String) {
            return maker.Literal(CGTypeTag.CLASS, value);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return maker.Literal(CGTypeTag.BOOLEAN, b != false ? 1 : 0);
        }
        if (value instanceof Long) {
            return maker.Literal(CGTypeTag.LONG, value);
        }
        if (value instanceof Integer) {
            return maker.Literal(CGTypeTag.INT, value);
        }
        if (value instanceof Double) {
            return maker.Literal(CGTypeTag.DOUBLE, value);
        }
        if (value instanceof Float) {
            return maker.Literal(CGTypeTag.FLOAT, value);
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return maker.Literal(CGTypeTag.CHAR, c.charValue());
        }
        if (value instanceof Short) {
            return maker.TypeCast(maker.TypeIdent(CGTypeTag.SHORT), maker.Literal(CGTypeTag.INT, value));
        }
        if (value instanceof Byte) {
            return maker.TypeCast(maker.TypeIdent(CGTypeTag.BYTE), maker.Literal(CGTypeTag.INT, value));
        }
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            CGSymbol symbol = maker.getSymbol(value.getClass().getCanonicalName());
            return maker.Select(maker.QualIdent(symbol), CGName.create(e.name()));
        }
        if (value instanceof Class) {
            Class c = (Class)value;
            try {
                return maker.Select((CGExpression)maker.TypeIdent(ElementUtils.primitiveTypeTag(c)), CGName.create("class"));
            }
            catch (IllegalStateException e) {
                CGSymbol symbol = maker.getSymbol(c.getCanonicalName());
                return maker.Select(maker.QualIdent(symbol), CGName.create("class"));
            }
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            CGList<CGExpression> list = CGList.nil(CGExpression.class);
            for (int i = 0; i < length; ++i) {
                list.append(ElementUtils.calcExpression(maker, Array.get(value, i)));
            }
            return maker.NewArray(null, CGList.nil(CGExpression.class), list);
        }
        return ElementUtils.createFieldAccess(maker, value.toString());
    }

    public static CGExpression createFieldAccess(TreeMaker maker, String className) {
        String[] strings = className.split("\\.");
        CGExpression classNameIdent = maker.Ident(CGName.create(strings[0]));
        for (int i = 1; i < strings.length; ++i) {
            classNameIdent = maker.Select(classNameIdent, CGName.create(strings[i]));
        }
        return classNameIdent;
    }

    protected static void registerClass(Map<String, Class<? extends JavaCompilerObject>> map, Class<? extends JavaCompilerObject> registerClass) {
        Object object = Reflection.invokeStatic((String)"theClass", registerClass, (Object[])new Object[0]);
        if (object instanceof Class) {
            Class cls = (Class)object;
            map.put(cls.getCanonicalName(), registerClass);
            CodeFactory.registerType((Class)cls, params -> CodeFactory.create((Class)registerClass, (Object[])params));
        }
    }

    public static CGExpression cloneType(TreeMaker maker, JavaCompilerObject in) {
        if (in == null) {
            return null;
        }
        if (in.is(CGPrimitiveTypeTree.theClass())) {
            return maker.TypeIdent(new CGPrimitiveTypeTree(in.getInstance()).getTypeTag());
        }
        if (in.is(CGIdent.theClass())) {
            return maker.Ident(CGName.create(new CGIdent(in.getInstance()).getName()));
        }
        if (in.is(CGTypeApply.theClass())) {
            CGTypeApply ta = new CGTypeApply(in.getInstance());
            CGList<CGExpression> lb = CGList.nil(CGExpression.class);
            for (CGExpression typeArg : ta.getTypeArguments()) {
                lb.append(ElementUtils.cloneType(maker, typeArg));
            }
            return maker.TypeApply(ElementUtils.cloneType(maker, ta.getBaseType()), lb);
        }
        log.warn("Unhandled clone type case: {}", (Object)in.getInstance().getClass().getCanonicalName());
        return (CGExpression)in;
    }
}

