/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.base;

import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.CGType;
import net.binis.codegen.compiler.JavacElements;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaCompilerObject {
    private static final Logger log = LoggerFactory.getLogger(JavaCompilerObject.class);
    protected final ProcessingEnvironment env = (ProcessingEnvironment)CodeFactory.create(ProcessingEnvironment.class, (Object[])new Object[]{Helpers.lookup.getProcessingEnvironment()});
    protected Object instance;
    protected Object context;
    protected Class cls;

    protected JavaCompilerObject() {
        Object object = this.context = Objects.nonNull(this.env) ? Reflection.invoke((String)"getContext", (Object)this.env, (Object[])new Object[0]) : CodeFactory.create((Class)Reflection.loadClass((String)"com.sun.tools.javac.util.Context"), (Object[])new Object[0]);
        if (Objects.isNull(this.context)) {
            log.error("Unable to get context from {}!", this.env.getClass());
        }
        this.init();
    }

    protected abstract void init();

    public Class getCls() {
        return this.cls;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object getContext() {
        return this.context;
    }

    public CGType getType() {
        return Tools.withRes(Reflection.getFieldValue((Object)this.instance, (String)"type"), CGType::new);
    }

    public int getPos() {
        return (Integer)Reflection.getFieldValue((Object)this.instance, (String)"pos");
    }

    public void setPos(int pos) {
        Reflection.setFieldValue((Object)this.instance, (String)"pos", (Object)pos);
    }

    public CGName toName(String name) {
        return JavacElements.create().getName(name);
    }

    public boolean is(Class cls) {
        if (JavaCompilerObject.class.isAssignableFrom(cls)) {
            return this.getClass().equals(cls);
        }
        return this.instance.getClass().equals(cls);
    }

    public String toString() {
        return this.instance.toString();
    }
}

