/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenAnnotationProcessorUtils {
    private static final Logger log = LoggerFactory.getLogger(CodeGenAnnotationProcessorUtils.class);

    public static boolean isPrototypeTest() {
        Class cls = Reflection.loadClass((String)"net.binis.codegen.test.BaseCodeGenTest");
        return Objects.nonNull(cls) && Objects.nonNull(CodeFactory.create((Class)cls, (Object[])new Object[0]));
    }

    public static boolean isElementTest() {
        Class cls = Reflection.loadClass((String)"net.binis.codegen.test.BaseCodeGenElementTest");
        return Objects.nonNull(cls) && Objects.nonNull(CodeFactory.create((Class)cls, (Object[])new Object[0]));
    }

    public static void addOpensForCodeGen(boolean openCompiler) {
        try {
            Class cModule = Reflection.loadClass((String)"java.lang.Module");
            if (Objects.isNull(cModule)) {
                return;
            }
            Method method = Reflection.findMethod((String)"implAddExportsOrOpens", (Class)cModule, (Class[])new Class[]{String.class, cModule, Boolean.TYPE, Boolean.TYPE});
            Object module = Reflection.getStaticFieldValue((Class)cModule, (String)"EVERYONE_MODULE");
            CodeGenAnnotationProcessorUtils.openRuntimeModules(method, module);
            if (openCompiler) {
                CodeGenAnnotationProcessorUtils.openCompilerModules(method, module);
            }
        }
        catch (Exception e) {
            log.error("Failed to open modules", (Throwable)e);
        }
    }

    private static void openRuntimeModules(Method method, Object module) {
        Object javaBaseModule = Reflection.invoke((String)"getModule", String.class, (Object[])new Object[0]);
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"jdk.internal.loader", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"jdk.internal.module", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"jdk.internal.vm", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"jdk.internal.vm.annotation", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"java.lang", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"java.lang.invoke", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"java.lang.module", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"java.lang.reflect", module, true, true});
        Reflection.invoke((Method)method, (Object)javaBaseModule, (Object[])new Object[]{"java.net", module, true, true});
        Class desktop = Reflection.loadClass((String)"java.awt.Desktop");
        if (desktop == null) {
            return;
        }
        Object javaDesktop = Reflection.invoke((String)"getModule", (Object)desktop, (Object[])new Object[0]);
        Reflection.invoke((Method)method, (Object)javaDesktop, (Object[])new Object[]{"sun.awt", module, true, true});
    }

    private static void openCompilerModules(Method method, Object module) {
        Object jdkCompilerModule = Reflection.invoke((String)"getModule", (Object)Reflection.loadClass((String)"com.sun.tools.javac.code.Symbol"), (Object[])new Object[0]);
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.api", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.code", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.comp", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.file", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.jvm", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.main", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.model", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.parser", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.platform", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.processing", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.resources", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.tree", module, true, true});
        Reflection.invoke((Method)method, (Object)jdkCompilerModule, (Object[])new Object[]{"com.sun.tools.javac.util", module, true, true});
    }

    public static Object getJavacProcessingEnvironment(ProcessingEnvironment processingEnv, Object procEnv) {
        Class cls = Reflection.loadClass((String)"com.sun.tools.javac.processing.JavacProcessingEnvironment");
        if (Objects.nonNull(cls)) {
            if (cls.isAssignableFrom(procEnv.getClass())) {
                return procEnv;
            }
            for (Class<?> procEnvClass = procEnv.getClass(); procEnvClass != null; procEnvClass = procEnvClass.getSuperclass()) {
                Object delegate = CodeGenAnnotationProcessorUtils.tryGetDelegateField(procEnvClass, procEnv);
                if (delegate == null) {
                    delegate = CodeGenAnnotationProcessorUtils.tryGetProxyDelegateToField(procEnvClass, procEnv);
                }
                if (delegate == null) {
                    delegate = CodeGenAnnotationProcessorUtils.tryGetProcessingEnvField(procEnvClass, procEnv);
                }
                if (delegate == null) continue;
                return CodeGenAnnotationProcessorUtils.getJavacProcessingEnvironment(processingEnv, delegate);
            }
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't get the delegate of the gradle IncrementalProcessingEnvironment. Lombok won't work.");
        }
        return null;
    }

    private static Object tryGetDelegateField(Class<?> delegateClass, Object instance) {
        try {
            Field field = Reflection.findField(instance.getClass(), (String)"delegate");
            if (Objects.nonNull(field)) {
                return Reflection.getFieldValue((Field)field, (Object)instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object tryGetProxyDelegateToField(Class<?> delegateClass, Object instance) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(instance);
            return Reflection.getFieldValue((Object)handler, (String)"val$delegateTo");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object tryGetProcessingEnvField(Class<?> delegateClass, Object instance) {
        try {
            return Reflection.getFieldValue(delegateClass, (Object)instance, (String)"processingEnv");
        }
        catch (Exception e) {
            return null;
        }
    }
}

