/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import net.binis.codegen.enrich.CustomDescription;
import net.binis.codegen.enrich.PrototypeLookup;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeLookupHandler
implements PrototypeLookup {
    private static final Logger log = LoggerFactory.getLogger(PrototypeLookupHandler.class);
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> parsed = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> generated = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, TypeDeclaration> generatedClasses = new HashMap<String, TypeDeclaration>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> generatedInterfaces = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> external = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> enums = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, CustomDescription> custom = new HashMap<String, CustomDescription>();
    private final List<Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>> prototypeMaps = new ArrayList<Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>>();
    private final JavaParser parser = new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17));
    private UnaryOperator<String> externalLookup;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;
    private Set<String> sourcesRoots;

    @Override
    public void registerParsed(String prototype, PrototypeDescription<?> parsed) {
        this.parsed.put(prototype, parsed);
        if (parsed.isCodeEnum()) {
            this.enums.put(parsed.getInterfaceFullName(), parsed);
        }
    }

    @Override
    public void registerGenerated(String prototype, PrototypeDescription<ClassOrInterfaceDeclaration> generated) {
        this.generated.put(prototype, generated);
        if (Objects.nonNull(generated.getInterface())) {
            this.generated.put(generated.getInterfaceFullName(), generated);
            this.generatedInterfaces.put(generated.getInterfaceFullName(), generated);
            this.generatedClasses.put(generated.getInterfaceFullName(), (TypeDeclaration)generated.getInterface());
        }
        if (!generated.isMixIn() && Objects.nonNull(generated.getImplementation())) {
            this.generated.put(generated.getImplementorFullName(), generated);
            this.generatedClasses.put(generated.getImplementorFullName(), (TypeDeclaration)generated.getImplementation());
        }
    }

    @Override
    public void registerGeneratedClass(String prototype, TypeDeclaration generated) {
        this.generatedClasses.put(prototype, generated);
    }

    @Override
    public void registerExternalLookup(UnaryOperator<String> lookup) {
        this.externalLookup = lookup;
    }

    @Override
    public CustomDescription createCustomDescription(String id) {
        return this.custom.computeIfAbsent(id, k -> Structures.CustomParsed.bldr().id(id).properties(Structures.defaultBuilder().build()).build());
    }

    @Override
    public CustomDescription getCustomDescription(String id) {
        return this.custom.get(id);
    }

    @Override
    public Collection<CustomDescription> custom() {
        return this.custom.values();
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findParsed(String prototype) {
        PrototypeDescription<ClassOrInterfaceDeclaration> result = this.parsed.get(prototype);
        if (Objects.isNull(result)) {
            this.handleExternal(prototype);
            return this.parsed.get(prototype);
        }
        return result;
    }

    private PrototypeDescription<ClassOrInterfaceDeclaration> handleExternal(String prototype) {
        if (Objects.nonNull(this.externalLookup) && !this.external.containsKey(prototype)) {
            String code = (String)this.externalLookup.apply(prototype);
            if (Objects.nonNull(code)) {
                ParseResult res = this.parser.parse(code);
                if (res.isSuccessful() && res.getResult().isPresent()) {
                    CompilationUnit unit = (CompilationUnit)res.getResult().get();
                    if (unit.getTypes().isNonEmpty()) {
                        TypeDeclaration type = unit.getType(0);
                        if (!type.isAnnotationDeclaration() && Generator.getCodeAnnotations(type).isPresent()) {
                            Helpers.handleType(this.parser, type, null, null, true);
                            return this.parsed.get(prototype);
                        }
                        return this.external.put(prototype, Structures.Parsed.builder().declaration(type.asTypeDeclaration()).declarationUnit(unit).spec(type.isClassOrInterfaceDeclaration() ? type.asClassOrInterfaceDeclaration() : null).build());
                    }
                    log.warn("Source parsed for '{}' but no types are found!", (Object)prototype);
                    this.external.put(prototype, null);
                } else {
                    log.warn("Source found for '{}' but it is not parsable. Some of the generation features might not be available!", (Object)prototype);
                    this.external.put(prototype, null);
                }
            } else {
                this.external.put(prototype, null);
            }
        }
        return null;
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findGenerated(String prototype) {
        PrototypeDescription<ClassOrInterfaceDeclaration> result = this.generated.get(prototype);
        if (Objects.isNull(result)) {
            result = this.generatedInterfaces.get(prototype);
        }
        return result;
    }

    @Override
    public TypeDeclaration findGeneratedClass(String name) {
        return this.generatedClasses.get(name);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findExternal(String prototype) {
        if (Objects.nonNull(prototype)) {
            this.handleExternal(prototype);
            return this.external.get(prototype);
        }
        return null;
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findByInterfaceName(String name) {
        return this.parsed.values().stream().filter(p -> Objects.nonNull(p.getInterfaceName())).filter(p -> p.getInterfaceName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findEnum(String generated) {
        return this.enums.get(generated);
    }

    @Override
    public Optional<PrototypeField> findField(String prototype, String name) {
        return (Optional)((Object)Tools.nullCheck(this.findParsed(prototype), parsed -> parsed.findField(name)));
    }

    @Override
    public boolean isParsed(String prototype) {
        return this.parsed.containsKey(prototype);
    }

    @Override
    public boolean isGenerated(String prototype) {
        return this.generated.containsKey(prototype) || this.generatedInterfaces.containsKey(prototype) || this.generatedClasses.containsKey(prototype);
    }

    @Override
    public boolean isExternal(String prototype) {
        this.handleExternal(prototype);
        if (Objects.nonNull(this.external.get(prototype))) {
            return true;
        }
        PrototypeDescription<ClassOrInterfaceDeclaration> p = this.parsed.get(prototype);
        return Objects.nonNull(p) && p.isExternal();
    }

    @Override
    public Collection<PrototypeDescription<ClassOrInterfaceDeclaration>> parsed() {
        return this.parsed.values();
    }

    @Override
    public Collection<PrototypeDescription<ClassOrInterfaceDeclaration>> generated() {
        return this.generated.values();
    }

    @Override
    public void addPrototypeMap(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        this.prototypeMaps.add((Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>)Pair.of(prototypeMap, parsed));
    }

    @Override
    public void calcPrototypeMaps() {
        this.prototypeMaps.forEach(p -> ((Map)p.getLeft()).put(((PrototypeDescription)p.getRight()).getInterfaceName(), (PrototypeDescription)p.getRight()));
    }

    @Override
    public List<PrototypeDescription<ClassOrInterfaceDeclaration>> findGeneratedByFileName(String fileName) {
        return this.generated.values().stream().filter(g -> fileName.equals(g.getPrototypeFileName())).distinct().toList();
    }

    public void clean() {
        this.parsed.clear();
        this.generated.clear();
        this.enums.clear();
        this.external.clear();
        this.prototypeMaps.clear();
        this.generatedClasses.clear();
        this.generatedInterfaces.clear();
        this.custom.clear();
    }

    @Override
    public void error(String message, Element element) {
        if (!Objects.nonNull(this.getProcessingEnvironment())) {
            throw new GenericCodeGenException(message);
        }
        log.error(message);
        this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    @Override
    public void warn(String message, Element element) {
        if (!Objects.nonNull(this.getProcessingEnvironment())) {
            throw new GenericCodeGenException(message);
        }
        log.warn(message);
        this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
    }

    @Override
    public void note(String message, Element element) {
        if (!Objects.nonNull(this.getProcessingEnvironment())) {
            throw new GenericCodeGenException(message);
        }
        log.info(message);
        this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, message, element);
    }

    @Override
    public JavaParser getParser() {
        return this.parser;
    }

    @Override
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    @Override
    public void setProcessingEnvironment(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    @Override
    public RoundEnvironment getRoundEnvironment() {
        return this.roundEnvironment;
    }

    @Override
    public void setRoundEnvironment(RoundEnvironment roundEnvironment) {
        this.roundEnvironment = roundEnvironment;
    }

    @Override
    public Set<String> getSourcesRoots() {
        return this.sourcesRoots;
    }

    @Override
    public void setSourcesRoots(Set<String> sourcesRoots) {
        this.sourcesRoots = sourcesRoots;
    }
}

