/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.List;
import java.util.Objects;
import net.binis.codegen.enrich.ToStringEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.EnrichHelpers;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.options.Options;

public class ToStringEnricherHandler
extends BaseEnricher
implements ToStringEnricher {
    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public int order() {
        return -2147433648;
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        ClassOrInterfaceDeclaration intf = description.getInterface();
        ClassOrInterfaceDeclaration impl = description.getImplementation();
        if (Objects.nonNull(impl)) {
            String name = Objects.nonNull(intf) ? intf.getNameAsString() : impl.getNameAsString();
            MethodDeclaration method = (MethodDeclaration)((MethodDeclaration)impl.addMethod("toString", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType("String")).addAnnotation(Override.class);
            StringBuilder body = new StringBuilder();
            body.append("{ return \"").append(name).append("(");
            int cnt = this.buildBody(description, impl, body);
            if (Objects.nonNull(description.getBase())) {
                if (cnt > 0) {
                    body.append("\", ");
                } else {
                    body.append("\"");
                }
                int pcnt = this.buildBody(description.getBase(), impl, body);
                if (pcnt == 0) {
                    if (cnt == 0) {
                        body.setLength(body.length() - 5);
                    } else {
                        body.setLength(body.length() - 7);
                    }
                }
            }
            body.append("\")\"; }");
            method.setBody(EnrichHelpers.block(body.toString().replace("\" + \"", "")));
        }
    }

    protected int buildBody(PrototypeDescription<ClassOrInterfaceDeclaration> description, ClassOrInterfaceDeclaration impl, StringBuilder body) {
        List<PrototypeField> fields = description.getFields();
        int cnt = 0;
        for (PrototypeField field : fields) {
            if (!this.shouldInclude(field)) continue;
            ++cnt;
            body.append(field.getName()).append(" = \" + ");
            if (field.isCollection()) {
                Helpers.addImport((Node)impl, "net.binis.codegen.tools.CollectionUtils");
                body.append("CollectionUtils.printInfo(").append(field.getName()).append(", ").append(description.hasOption(Options.TO_STRING_FULL_COLLECTION_INFO)).append(") + \", ");
                continue;
            }
            body.append(field.getName()).append(" + \", ");
        }
        if (cnt > 0) {
            body.delete(body.length() - 3, body.length());
        } else {
            body.append("\" + ");
        }
        return cnt;
    }

    protected boolean shouldInclude(PrototypeField field) {
        if (field.getIgnores().isForToString()) {
            return false;
        }
        if (field.getIgnores().isIncludedForToString()) {
            return true;
        }
        return !field.getParsed().hasOption(Options.TO_STRING_ONLY_EXPLICITLY_INCLUDED);
    }
}

