/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.Arrays;
import java.util.Objects;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.enrich.OpenApiEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import net.binis.codegen.options.Options;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;

public class OpenApiEnricherHandler
extends BaseEnricher
implements OpenApiEnricher {
    protected static final boolean IS_OPENAPI_AVAILABLE = Objects.nonNull(Reflection.loadClass((String)"io.swagger.v3.oas.annotations.media.Schema"));

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public int order() {
        return -2147478648;
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        if (this.generate(description)) {
            ClassOrInterfaceDeclaration intf = description.getInterface();
            intf.findCompilationUnit().ifPresent(unit -> {
                unit.addImport("io.swagger.v3.oas.annotations.media", false, true);
                description.getFields().forEach(this::enrichField);
            });
        }
    }

    protected void enrichField(PrototypeField field) {
        MethodDeclaration getter = field.forceGenerateInterfaceGetter();
        if (Objects.nonNull(getter)) {
            NormalAnnotationExpr ann = getter.addAndGetAnnotation("Schema");
            ann.addPair("name", "\"" + field.getName() + "\"");
            field.getDescription().getAnnotationByName("ValidateNull").ifPresent(a -> ann.addPair("required", "true"));
            this.checkForDefaultValue(field, ann);
            this.checkForLength(field, ann);
            this.checkForRange(field, ann);
            if (Objects.nonNull(field.getPrototype()) && field.getPrototype().isCodeEnum()) {
                ArrayInitializerExpr exp = new ArrayInitializerExpr();
                field.getPrototype().getDeclaration().asEnumDeclaration().getEntries().forEach(e -> exp.getValues().add((Node)new StringLiteralExpr(e.getNameAsString())));
                ann.addPair("allowableValues", (Expression)exp);
                ann.addPair("type", (Expression)new StringLiteralExpr("string"));
            } else {
                Tools.with(Reflection.loadClass((String)field.getFullType()), cls -> {
                    if (cls.isEnum()) {
                        ArrayInitializerExpr exp = new ArrayInitializerExpr();
                        Arrays.stream(cls.getEnumConstants()).forEach(e -> exp.getValues().add((Node)new StringLiteralExpr(e.toString())));
                        ann.addPair("allowableValues", (Expression)exp);
                    } else if (CodeEnum.class.isAssignableFrom((Class<?>)cls)) {
                        ArrayInitializerExpr exp = new ArrayInitializerExpr();
                        Arrays.stream(CodeFactory.enumValues((Class)cls)).forEach(e -> exp.getValues().add((Node)new StringLiteralExpr(e.name())));
                        ann.addPair("allowableValues", (Expression)exp);
                    }
                });
            }
        }
    }

    protected void checkForDefaultValue(PrototypeField field, NormalAnnotationExpr ann) {
        field.getDescription().getAnnotationByClass(Default.class).ifPresent(a -> {
            if (a instanceof NormalAnnotationExpr) {
                NormalAnnotationExpr expr = (NormalAnnotationExpr)a;
                expr.getPairs().stream().filter(p -> p.getNameAsString().equals("value")).findFirst().ifPresent(p -> ann.addPair("defaultValue", (Expression)this.strip(p.getValue())));
            } else if (a instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr expr = (SingleMemberAnnotationExpr)a;
                ann.addPair("defaultValue", (Expression)this.strip(expr.getMemberValue()));
            }
        });
    }

    protected void checkForRange(PrototypeField field, NormalAnnotationExpr ann) {
        field.getDescription().getAnnotationByName("ValidateRange").ifPresent(a -> {
            if (a instanceof NormalAnnotationExpr) {
                NormalAnnotationExpr expr = (NormalAnnotationExpr)a;
                for (MemberValuePair pair : expr.getPairs()) {
                    switch (pair.getNameAsString()) {
                        case "max": {
                            ann.addPair("maximum", (Expression)this.strip(pair.getValue()));
                            break;
                        }
                        case "min": {
                            ann.addPair("minimum", (Expression)this.strip(pair.getValue()));
                        }
                    }
                }
            }
        });
    }

    protected void checkForLength(PrototypeField field, NormalAnnotationExpr ann) {
        field.getDescription().getAnnotationByName("ValidateLength").ifPresent(a -> {
            if (a instanceof NormalAnnotationExpr) {
                NormalAnnotationExpr expr = (NormalAnnotationExpr)a;
                for (MemberValuePair pair : expr.getPairs()) {
                    switch (pair.getNameAsString()) {
                        case "value": 
                        case "max": {
                            ann.addPair("maxLength", pair.getValue());
                            break;
                        }
                        case "min": {
                            ann.addPair("minLength", pair.getValue());
                        }
                    }
                }
            } else if (a instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr expr = (SingleMemberAnnotationExpr)a;
                ann.addPair("maxLength", expr.getMemberValue());
            }
        });
    }

    protected boolean generate(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        return description.hasOption(Options.GENERATE_OPENAPI_ALWAYS) || IS_OPENAPI_AVAILABLE && description.hasOption(Options.GENERATE_OPENAPI_IF_AVAILABLE);
    }

    protected StringLiteralExpr strip(Expression value) {
        return new StringLiteralExpr(StringUtils.strip((String)StringUtils.strip((String)value.toString(), (String)"\""), (String)"\\\""));
    }
}

