/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import net.binis.codegen.compiler.CGAnnotation;
import net.binis.codegen.compiler.CGAssign;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.TreeMaker;
import net.binis.codegen.compiler.utils.ElementUtils;

public class ElementAnnotationUtils
extends ElementUtils {
    public static CGAnnotation findAnnotation(Element element, Class<? extends Annotation> annotation) {
        return ElementAnnotationUtils.findAnnotation(element, (CGAnnotation ann) -> ann.isAnnotation(annotation));
    }

    public static CGAnnotation findAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation) {
        return ElementAnnotationUtils.findAnnotation(declaration, (CGAnnotation ann) -> ann.isAnnotation(annotation));
    }

    public static CGAnnotation findAnnotation(Element element, Predicate<CGAnnotation> filter) {
        return ElementAnnotationUtils.findAnnotation(ElementAnnotationUtils.getDeclaration(element), filter);
    }

    public static CGAnnotation findAnnotation(CGDeclaration declaration, Predicate<CGAnnotation> filter) {
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!filter.test(ann)) continue;
            return ann;
        }
        return null;
    }

    public static List<CGAnnotation> findAnnotations(Element element, Predicate<CGAnnotation> filter) {
        return ElementAnnotationUtils.findAnnotations(ElementAnnotationUtils.getDeclaration(element), filter);
    }

    public static List<CGAnnotation> findAnnotations(CGDeclaration declaration, Predicate<CGAnnotation> filter) {
        ArrayList<CGAnnotation> result = new ArrayList<CGAnnotation>();
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!filter.test(ann)) continue;
            result.add(ann);
        }
        return result;
    }

    public static CGAnnotation createAnnotation(Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        if (Objects.isNull(attributes)) {
            attributes = Map.of();
        }
        TreeMaker maker = TreeMaker.create();
        CGList<CGExpression> list = CGList.nil(CGExpression.class);
        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
            list = list.append(maker.Assign(maker.Ident(CGName.create(attr.getKey())), ElementAnnotationUtils.calcExpression(maker, attr.getValue())));
        }
        return maker.Annotation(maker.QualIdent(maker.getSymbol(annotation.getCanonicalName())), list);
    }

    public static CGAnnotation addAnnotation(Element element, Class<? extends Annotation> annotation) {
        return ElementAnnotationUtils.addAnnotation(element, annotation, Map.of());
    }

    public static CGAnnotation addAnnotation(Element element, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        return ElementAnnotationUtils.addAnnotation(ElementAnnotationUtils.getDeclaration(element), annotation, attributes);
    }

    public static CGAnnotation addAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        CGAnnotation ann = ElementAnnotationUtils.createAnnotation(annotation, attributes);
        declaration.getModifiers().getAnnotations().append(ann);
        return ann;
    }

    public static CGAnnotation addAnnotation(Element element, Class<? extends Annotation> annotation, CGList<CGExpression> attributes) {
        return ElementAnnotationUtils.addAnnotation(ElementAnnotationUtils.getDeclaration(element), annotation, attributes);
    }

    public static CGAnnotation addAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation, CGList<CGExpression> attributes) {
        TreeMaker maker = TreeMaker.create();
        CGAnnotation ann = maker.Annotation(maker.QualIdent(maker.getSymbol(annotation.getCanonicalName())), attributes);
        declaration.getModifiers().getAnnotations().append(ann);
        return ann;
    }

    public static CGAnnotation addAnnotation(Element element, Class<? extends Annotation> annotation, CGExpression ... attributes) {
        return ElementAnnotationUtils.addAnnotation(element, annotation, ElementAnnotationUtils.expressionToList(attributes));
    }

    public static CGAnnotation addAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation, CGExpression ... attributes) {
        return ElementAnnotationUtils.addAnnotation(declaration, annotation, ElementAnnotationUtils.expressionToList(attributes));
    }

    public static CGAnnotation addOrReplaceAnnotation(Element element, Class<? extends Annotation> annotation) {
        return ElementAnnotationUtils.addOrReplaceAnnotation(element, annotation, Map.of());
    }

    public static CGAnnotation addOrReplaceAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation) {
        return ElementAnnotationUtils.addOrReplaceAnnotation(declaration, annotation, Map.of());
    }

    public static CGAnnotation addOrReplaceAnnotation(Element element, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        ElementAnnotationUtils.removeAnnotation(element, annotation);
        return ElementAnnotationUtils.addAnnotation(element, annotation, attributes);
    }

    public static CGAnnotation addOrReplaceAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        ElementAnnotationUtils.removeAnnotation(declaration, annotation);
        return ElementAnnotationUtils.addAnnotation(declaration, annotation, attributes);
    }

    public static CGAnnotation addOrReplaceAnnotation(Element element, Class<? extends Annotation> annotation, CGExpression ... attributes) {
        ElementAnnotationUtils.removeAnnotation(element, annotation);
        return ElementAnnotationUtils.addAnnotation(element, annotation, attributes);
    }

    public static CGAnnotation addOrReplaceAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation, CGExpression ... attributes) {
        ElementAnnotationUtils.removeAnnotation(declaration, annotation);
        return ElementAnnotationUtils.addAnnotation(declaration, annotation, attributes);
    }

    public static CGAnnotation getAnnotation(Element element, Class<? extends Annotation> annotation) {
        return ElementAnnotationUtils.getAnnotation(ElementAnnotationUtils.getDeclaration(element), annotation);
    }

    public static CGAnnotation getAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation) {
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!ann.isAnnotation(annotation)) continue;
            return ann;
        }
        return null;
    }

    public static CGAnnotation replaceAnnotation(Element element, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        ElementAnnotationUtils.removeAnnotation(element, oldAnnotation);
        return ElementAnnotationUtils.addAnnotation(element, annotation, attributes);
    }

    public static CGAnnotation replaceAnnotation(CGDeclaration declaration, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        ElementAnnotationUtils.removeAnnotation(declaration, oldAnnotation);
        return ElementAnnotationUtils.addAnnotation(declaration, annotation, attributes);
    }

    public static CGAnnotation replaceAnnotation(Element element, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation, CGExpression ... attributes) {
        ElementAnnotationUtils.removeAnnotation(element, oldAnnotation);
        return ElementAnnotationUtils.addAnnotation(element, annotation, attributes);
    }

    public static CGAnnotation replaceAnnotation(CGDeclaration declaration, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation, CGExpression ... attributes) {
        ElementAnnotationUtils.removeAnnotation(declaration, oldAnnotation);
        return ElementAnnotationUtils.addAnnotation(declaration, annotation, attributes);
    }

    public static CGAnnotation replaceAnnotationWithAttributes(Element element, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation) {
        ElementAnnotationUtils.removeAnnotation(element, oldAnnotation);
        return ElementAnnotationUtils.addAnnotation(element, annotation, oldAnnotation.getArguments());
    }

    public static CGAnnotation replaceAnnotationWithAttributes(CGDeclaration declaration, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation) {
        ElementAnnotationUtils.removeAnnotation(declaration, oldAnnotation);
        return ElementAnnotationUtils.addAnnotation(declaration, annotation, oldAnnotation.getArguments());
    }

    public static CGAnnotation removeAnnotation(Element element, Class<? extends Annotation> annotation) {
        return ElementAnnotationUtils.removeAnnotation(ElementAnnotationUtils.getDeclaration(element), annotation);
    }

    public static CGAnnotation removeAnnotation(CGDeclaration declaration, Class<? extends Annotation> annotation) {
        CGAnnotation result = null;
        CGList<CGAnnotation> list = CGList.nil(CGAnnotation.class);
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!ann.isAnnotation(annotation)) {
                list = list.append(ann);
                continue;
            }
            result = ann;
        }
        declaration.getModifiers().setAnnotations(list);
        return result;
    }

    public static CGAnnotation removeAnnotation(Element element, CGAnnotation annotation) {
        return ElementAnnotationUtils.removeAnnotation(ElementAnnotationUtils.getDeclaration(element), annotation);
    }

    public static CGAnnotation removeAnnotation(CGDeclaration declaration, CGAnnotation annotation) {
        CGAnnotation result = null;
        CGList<CGAnnotation> list = CGList.nil(CGAnnotation.class);
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!ann.getInstance().equals(annotation.getInstance())) {
                list = list.append(ann);
                continue;
            }
            result = ann;
        }
        declaration.getModifiers().setAnnotations(list);
        return result;
    }

    public static void addAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name, Object value) {
        ElementAnnotationUtils.addAnnotationAttribute(ElementAnnotationUtils.getDeclaration(element), annotation, name, value);
    }

    public static void addAnnotationAttribute(CGDeclaration declaration, Class<? extends Annotation> annotation, String name, Object value) {
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!ann.isAnnotation(annotation)) continue;
            ElementAnnotationUtils.addAnnotationAttribute(ann, name, value);
            break;
        }
    }

    public static void addAnnotationAttribute(CGAnnotation annotation, String name, Object value) {
        TreeMaker maker = TreeMaker.create();
        annotation.getArguments().append(maker.Assign(maker.Ident(CGName.create(name)), ElementAnnotationUtils.calcExpression(maker, value)));
    }

    public static void removeAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name) {
        ElementAnnotationUtils.removeAnnotationAttribute(ElementAnnotationUtils.getDeclaration(element), annotation, name);
    }

    public static void removeAnnotationAttribute(CGDeclaration declaration, Class<? extends Annotation> annotation, String name) {
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!ann.isAnnotation(annotation)) continue;
            ElementAnnotationUtils.removeAnnotationAttribute(ann, name);
            break;
        }
    }

    public static void removeAnnotationAttribute(CGAnnotation annotation, String name) {
        CGList<CGExpression> list = CGList.nil(CGExpression.class);
        for (CGExpression attr : annotation.getArguments()) {
            if (attr.getInstance().getClass().equals(CGAssign.theClass())) {
                CGAssign assign = new CGAssign(attr.getInstance());
                if (assign.getVariable().getInstance().toString().equals(name)) continue;
                list.append(attr);
                continue;
            }
            list.append(attr);
        }
        annotation.setArguments(list);
    }

    public static void replaceAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name, Object value) {
        ElementAnnotationUtils.replaceAnnotationAttribute(ElementAnnotationUtils.getDeclaration(element), annotation, name, value);
    }

    public static void replaceAnnotationAttribute(CGDeclaration declaration, Class<? extends Annotation> annotation, String name, Object value) {
        for (CGAnnotation ann : declaration.getModifiers().getAnnotations()) {
            if (!ann.isAnnotation(annotation)) continue;
            ElementAnnotationUtils.replaceAnnotationAttribute(ann, name, value);
            break;
        }
    }

    public static void replaceAnnotationAttribute(CGAnnotation annotation, String name, Object value) {
        TreeMaker maker = TreeMaker.create();
        CGList<CGExpression> list = CGList.nil(CGExpression.class);
        for (CGExpression attr : annotation.getArguments()) {
            if (attr.getInstance().getClass().equals(CGAssign.theClass())) {
                CGAssign assign = new CGAssign(attr.getInstance());
                if (!assign.getVariable().getInstance().toString().equals(name)) {
                    list.append(attr);
                    continue;
                }
                list.append(maker.Assign(maker.Ident(CGName.create(name)), ElementAnnotationUtils.calcExpression(maker, value)));
                continue;
            }
            list.append(attr);
        }
        annotation.setArguments(list);
    }

    public static void addIfMissingAnnotationAttribute(CGAnnotation annotation, String name, Object value) {
        TreeMaker maker = TreeMaker.create();
        for (CGExpression attr : annotation.getArguments()) {
            CGAssign assign;
            if (!attr.getInstance().getClass().equals(CGAssign.theClass()) || !(assign = new CGAssign(attr.getInstance())).getVariable().getInstance().toString().equals(name)) continue;
            return;
        }
        annotation.getArguments().append(maker.Assign(maker.Ident(CGName.create(name)), ElementAnnotationUtils.calcExpression(maker, value)));
    }

    protected static CGList<CGExpression> expressionToList(CGExpression ... expressions) {
        CGList<CGExpression> list = CGList.nil(CGExpression.class);
        if (Objects.nonNull(expressions)) {
            for (CGExpression attr : expressions) {
                if (!Objects.nonNull(attr)) continue;
                list = list.append(attr);
            }
        }
        return list;
    }
}

