/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import java.util.Objects;
import net.binis.codegen.enrich.OpenApiEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.options.Options;
import net.binis.codegen.tools.Reflection;

public class OpenApiEnricherHandler
extends BaseEnricher
implements OpenApiEnricher {
    private static final boolean IS_OPENAPI_AVAILABLE = Objects.nonNull(Reflection.loadClass((String)"io.swagger.v3.oas.annotations.media.Schema"));

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public int order() {
        return -2147478648;
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        if (this.generate(description)) {
            ClassOrInterfaceDeclaration intf = description.getInterface();
            intf.findCompilationUnit().ifPresent(unit -> {
                unit.addImport("io.swagger.v3.oas.annotations.media", false, true);
                description.getFields().forEach(this::enrichField);
            });
        }
    }

    private void enrichField(PrototypeField field) {
        MethodDeclaration getter = field.getInterfaceGetter();
        if (Objects.nonNull(getter)) {
            NormalAnnotationExpr ann = getter.addAndGetAnnotation("Schema");
            ann.addPair("name", "\"" + field.getName() + "\"");
            if (Objects.nonNull(field.getDescription().getAnnotationByName("ValidateNull"))) {
                ann.addPair("required", "true");
            }
        }
    }

    private boolean generate(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        return description.hasOption(Options.GENERATE_OPENAPI_ALWAYS) || IS_OPENAPI_AVAILABLE && description.hasOption(Options.GENERATE_OPENAPI_IF_AVAILABLE);
    }
}

