/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.test.JavaByteObject;
import net.binis.codegen.test.JavaSourceObject;
import net.binis.codegen.test.TestClassLoader;
import net.binis.codegen.tools.Tools;

public abstract class CompileHelper {
    public static boolean compile(TestClassLoader loader, List<Pair<String, String>> files) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        Map<String, JavaByteObject> objects = files.stream().collect(Collectors.toMap(Pair::getKey, f -> new JavaByteObject((String)f.getKey())));
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        JavaFileManager fileManager = CompileHelper.createFileManager(standardFileManager, objects);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, CompileHelper.getCompilationUnits(files));
        if (!task.call().booleanValue()) {
            diagnostics.getDiagnostics().forEach(System.out::println);
            fileManager.close();
            return false;
        }
        fileManager.close();
        files.forEach(f -> Tools.with((JavaByteObject)objects.get(f.getKey()), o -> loader.define((String)f.getKey(), (JavaByteObject)o)));
        return true;
    }

    public static JavaFileManager createFileManager(StandardJavaFileManager fileManager, final Map<String, JavaByteObject> files) {
        return new ForwardingJavaFileManager<StandardJavaFileManager>(fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
                int pos = className.indexOf(36);
                if (pos > -1) {
                    files.put(className, new JavaByteObject(className));
                }
                return (JavaFileObject)files.get(className);
            }
        };
    }

    public static Iterable<? extends JavaFileObject> getCompilationUnits(List<Pair<String, String>> files) {
        return files.stream().map(f -> new JavaSourceObject((String)f.getKey(), (String)f.getValue())).toList();
    }
}

