/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.utils;

import java.util.List;
import javax.lang.model.element.Element;
import net.binis.codegen.compiler.CGBlock;
import net.binis.codegen.compiler.CGClassDeclaration;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGFieldAccess;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGMethodDeclaration;
import net.binis.codegen.compiler.CGMethodInvocation;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.CGStatement;
import net.binis.codegen.compiler.CGSymtab;
import net.binis.codegen.compiler.CGTypeParameter;
import net.binis.codegen.compiler.CGVariableDecl;
import net.binis.codegen.compiler.TreeMaker;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.compiler.utils.ElementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementMethodUtils
extends ElementUtils {
    private static final Logger log = LoggerFactory.getLogger(ElementMethodUtils.class);

    public static CGMethodDeclaration addMethod(Element element, String name, Class<?> returnType, long flags, List<CGVariableDecl> params, CGBlock body) {
        TreeMaker maker = TreeMaker.create();
        CGDeclaration declaration = ElementMethodUtils.getDeclaration(element, maker);
        CGMethodDeclaration def = maker.MethodDef(maker.Modifiers(flags), CGName.create(name), ElementMethodUtils.classToExpression(returnType), CGList.nil(CGTypeParameter.class), CGList.from(params, CGVariableDecl.class), CGList.nil(CGExpression.class), body, null);
        declaration.getDefs().append(def);
        return def;
    }

    public static CGMethodDeclaration addConstructor(Element element, long flags, List<CGVariableDecl> params) {
        TreeMaker maker = TreeMaker.create();
        CGDeclaration declaration = ElementMethodUtils.getDeclaration(element, maker);
        return ElementMethodUtils.addConstructor((CGClassDeclaration)declaration, flags, params);
    }

    public static CGMethodDeclaration addConstructor(CGClassDeclaration cls, long flags, List<CGVariableDecl> params) {
        CGBlock body = ElementMethodUtils.createBlock(ElementMethodUtils.createStatement(ElementMethodUtils.createMethodInvocation("super", new CGExpression[0])));
        TreeMaker maker = TreeMaker.create();
        CGMethodDeclaration def = maker.MethodDef(maker.Modifiers(flags), CGName.create("<init>"), null, CGList.nil(CGTypeParameter.class), CGList.from(params, CGVariableDecl.class), CGList.nil(CGExpression.class), body, null);
        cls.getDefs().append(def);
        return def;
    }

    public static CGExpression createMethodInvocation(String methodName, CGExpression ... params) {
        TreeMaker maker = TreeMaker.create();
        CGExpression method = ElementMethodUtils.chainDotsString(maker, methodName);
        return maker.Apply(CGList.nil(CGExpression.class), method, CGList.from((JavaCompilerObject[])params, CGExpression.class));
    }

    public static CGExpression createStaticMethodInvocation(Class<?> cls, String methodName, CGExpression ... params) {
        return ElementMethodUtils.createStaticMethodInvocation(cls.getCanonicalName(), methodName, params);
    }

    public static CGExpression createStaticMethodInvocation(String cls, String methodName, CGExpression ... params) {
        TreeMaker maker = TreeMaker.create();
        CGExpression method = ElementMethodUtils.chainDotsString(maker, cls + "." + methodName);
        return maker.Apply(CGList.nil(CGExpression.class), method, CGList.from((JavaCompilerObject[])params, CGExpression.class));
    }

    public static CGMethodInvocation createClassMethodInvocation(Class<?> cls, String methodName, CGExpression ... params) {
        TreeMaker maker = TreeMaker.create();
        CGFieldAccess method = maker.Select((CGExpression)ElementMethodUtils.toType(cls), maker.toName(methodName));
        return maker.Apply(CGList.nil(CGExpression.class), method, CGList.from((JavaCompilerObject[])params, CGExpression.class));
    }

    public static CGMethodInvocation createClassMethodInvocation(String cls, String methodName, CGExpression ... params) {
        TreeMaker maker = TreeMaker.create();
        CGExpression method = ElementMethodUtils.chainDotsString(maker, cls + ".class." + methodName);
        return maker.Apply(CGList.nil(CGExpression.class), method, CGList.from((JavaCompilerObject[])params, CGExpression.class));
    }

    public static CGBlock createBlock() {
        return TreeMaker.create().Block(0L, CGList.nil(CGStatement.class));
    }

    public static CGBlock createBlock(CGStatement ... statements) {
        return TreeMaker.create().Block(0L, CGList.from((JavaCompilerObject[])statements, CGStatement.class));
    }

    public static CGStatement createStatement(CGExpression expr) {
        expr.setType(CGSymtab.voidType());
        return TreeMaker.create().Call(expr);
    }

    public static CGVariableDecl createParameter(Class<?> cls, String name) {
        TreeMaker maker = TreeMaker.create();
        return maker.VarDef(maker.Modifiers(0x200000000L), maker.toName(name), ElementMethodUtils.classToExpression(cls), null);
    }

    public static boolean paramsMatch(Element e, List<String> list) {
        CGMethodDeclaration decl;
        CGList<CGVariableDecl> params;
        CGDeclaration cGDeclaration = ElementMethodUtils.getDeclaration(e);
        if (cGDeclaration instanceof CGMethodDeclaration && (params = (decl = (CGMethodDeclaration)cGDeclaration).getParameters()).size() == list.size()) {
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i).getFullVariableType().equals(list.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

