/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import java.util.List;
import java.util.Objects;
import net.binis.codegen.compiler.CGBlock;
import net.binis.codegen.compiler.CGClassDeclaration;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGMethodDeclaration;
import net.binis.codegen.compiler.CGVariableDecl;
import net.binis.codegen.compiler.TreeMaker;
import net.binis.codegen.compiler.utils.ElementMethodUtils;
import net.binis.codegen.compiler.utils.ElementUtils;
import net.binis.codegen.enrich.InjectionEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.interfaces.ElementDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionEnricherHandler
extends BaseEnricher
implements InjectionEnricher {
    private static final Logger log = LoggerFactory.getLogger(InjectionEnricherHandler.class);

    @Override
    public void enrichElement(ElementDescription description) {
        CGClassDeclaration cls;
        CGDeclaration declaration = ElementUtils.getDeclaration(description.getElement());
        if (declaration instanceof CGClassDeclaration && !(cls = (CGClassDeclaration)declaration).isInterface() && !cls.isEnum() && !cls.isAnnotation()) {
            List<CGVariableDecl> fields = cls.getDefs().stream().filter(CGVariableDecl.class::isInstance).map(CGVariableDecl.class::cast).filter(CGDeclaration::isFinal).filter(v -> !v.isStatic()).filter(v -> Objects.isNull(v.getInitializer())).toList();
            if (!fields.isEmpty()) {
                if (cls.getDefs().stream().filter(CGMethodDeclaration.class::isInstance).map(CGMethodDeclaration.class::cast).filter(CGMethodDeclaration::isConstructor).filter(m -> m.getParameters().size() == fields.size()).noneMatch(m -> this.matchParamTypes((CGMethodDeclaration)m, fields))) {
                    this.createConstructor(cls, fields);
                }
            }
        } else {
            this.note("Injection is applicable only for classes.", description.getElement());
        }
    }

    protected void createConstructor(CGClassDeclaration cls, List<CGVariableDecl> fields) {
        TreeMaker maker = TreeMaker.create();
        CGBlock body = ElementMethodUtils.addConstructor(cls, 1L, fields.stream().map(f -> maker.VarDef(maker.Modifiers(0x200000000L), f.getName(), f.getVarType(), null)).toList()).getBody();
        fields.forEach(field -> body.getStatements().append(ElementMethodUtils.createStatement(maker.Assign(ElementUtils.createFieldAccess(maker, "this." + String.valueOf(field.getName())), maker.Ident(field.getName())))));
    }

    protected boolean matchParamTypes(CGMethodDeclaration method, List<CGVariableDecl> fields) {
        CGList<CGVariableDecl> params = method.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i).getFullVariableType().equals(fields.get(i).getFullVariableType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int order() {
        return 0;
    }
}

