/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.test;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.binis.codegen.CodeGen;
import net.binis.codegen.discoverer.AnnotationDiscoverer;
import net.binis.codegen.discovery.Discoverer;
import net.binis.codegen.generation.core.CompileHelper;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.test.JavaByteObject;
import net.binis.codegen.test.TestClassLoader;
import net.binis.codegen.test.TestExecutor;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCodeTest {
    private static final Logger log = LoggerFactory.getLogger(BaseCodeTest.class);
    protected JavaParser parser = Helpers.lookup.getParser();

    @BeforeEach
    public void beforeEach() {
        Helpers.cleanUp();
    }

    protected String getAsString(CompilationUnit file) {
        CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
        Helpers.sortImports(file);
        if (file.getType(0).isClassOrInterfaceDeclaration()) {
            Helpers.sortClass(file.getType(0).asClassOrInterfaceDeclaration());
        }
        return printer.print((Node)file);
    }

    protected void cleanUp() {
        Helpers.cleanUp();
    }

    protected String resourceAsString(String resource) {
        try {
            return new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource(resource).toURI())));
        }
        catch (Exception e) {
            log.error("Unable to load resource: {}!", (Object)resource);
            throw e;
        }
    }

    protected void load(List<Pair<String, String>> list, String resource) {
        String source = this.resourceAsString(resource);
        ParseResult parse = this.parser.parse(source);
        Assertions.assertTrue((boolean)parse.isSuccessful(), (String)parse.toString());
        ((CompilationUnit)parse.getResult().get()).findFirst(TypeDeclaration.class).ifPresent(declaration -> {
            if (Objects.nonNull(list)) {
                declaration.getFullyQualifiedName().ifPresent(name -> list.add(Pair.of((Object)((String)name), (Object)source)));
            }
            if (declaration.isAnnotationDeclaration()) {
                Structures.registerTemplate(declaration.asAnnotationDeclaration());
            }
            parse.getResult().ifPresent(u -> u.getTypes().forEach(t -> CodeGen.handleType(this.parser, t, resource, null)));
        });
    }

    protected String loadExecute(List<Pair<String, String>> list, String resource) {
        String source = this.resourceAsString(resource);
        String className = source.substring(source.indexOf("package") + 8, source.indexOf(59)) + ".Execute";
        if (Objects.nonNull(list)) {
            list.add((Pair<String, String>)Pair.of((Object)className, (Object)source));
        }
        return className;
    }

    protected boolean compile(TestClassLoader loader, List<Pair<String, String>> files, String resExecute, boolean loadAll, String ... args) {
        String className = null;
        if (Objects.nonNull(resExecute)) {
            className = this.loadExecute(files, resExecute);
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        Map<String, JavaByteObject> objects = files.stream().collect(Collectors.toMap(Pair::getKey, f -> new JavaByteObject((String)f.getKey())));
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        JavaFileManager fileManager = CompileHelper.createFileManager(standardFileManager, objects);
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(args));
        params.add("-Xlint:unchecked");
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, params, null, CompileHelper.getCompilationUnits(files));
        if (!task.call().booleanValue()) {
            diagnostics.getDiagnostics().forEach(System.out::println);
            fileManager.close();
            return false;
        }
        diagnostics.getDiagnostics().forEach(System.out::println);
        fileManager.close();
        if (loadAll) {
            objects.forEach((k, o) -> Tools.ifNull(loader.findClass((String)k), () -> loader.define((String)k, (JavaByteObject)o)));
        } else {
            files.forEach(f -> Tools.with((JavaByteObject)objects.get(f.getKey()), o -> Tools.ifNull(loader.findClass((String)f.getKey()), () -> loader.define((String)f.getKey(), (JavaByteObject)o))));
        }
        if (Objects.nonNull(resExecute)) {
            Class<?> cls = loader.findClass(className);
            Assertions.assertNotNull(cls, (String)"Executor class not found!");
            Assertions.assertNotNull(cls.getSuperclass(), (String)"Executor doesn't inherit TestExecutor!");
            Assertions.assertEquals(TestExecutor.class, cls.getSuperclass(), (String)"Executor doesn't inherit TestExecutor!");
            this.defineObjects(loader, objects);
            Reflection.withLoader((ClassLoader)loader, () -> Assertions.assertTrue((boolean)TestExecutor.test(cls), (String)"Test execution failed!"));
        }
        return true;
    }

    protected void defineObjects(TestClassLoader loader, Map<String, JavaByteObject> objects) {
        this.defineObjects(loader, objects, objects.size());
    }

    protected void defineObjects(TestClassLoader loader, Map<String, JavaByteObject> objects, int tries) {
        boolean error = false;
        for (Map.Entry<String, JavaByteObject> entry : objects.entrySet()) {
            if (!Objects.isNull(loader.findClass(entry.getKey()))) continue;
            try {
                loader.define(entry.getKey(), entry.getValue());
            }
            catch (NoClassDefFoundError ex) {
                error = true;
            }
        }
        if (error && tries > 0) {
            this.defineObjects(loader, objects, tries - 1);
        }
    }

    protected List<Pair<String, String>> newList() {
        return new ArrayList<Pair<String, String>>();
    }

    static {
        AnnotationDiscoverer.findAnnotations().stream().filter(Discoverer.DiscoveredService::isTemplate).forEach(a -> Structures.registerTemplate(a.getCls()));
    }
}

