/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.binis.codegen.generation.core.EnrichHelpers;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler {
    private static final Logger log = LoggerFactory.getLogger(CollectionsHandler.class);

    public static boolean isCollection(Type type) {
        if (type.isClassOrInterfaceType()) {
            return CollectionsHandler.isCollection(type.asClassOrInterfaceType().getNameAsString());
        }
        return false;
    }

    public static boolean isCollection(Class<?> type) {
        return CollectionsHandler.isCollection(type.getName());
    }

    public static boolean isListOrSet(String type) {
        return "List".equals(type) || "Set".equals(type) || "CodeList".equals(type) || "CodeSet".equals(type);
    }

    public static boolean isCollection(String type) {
        return CollectionsHandler.isListOrSet(type) || "Map".equals(type) || "CodeMap".equals(type);
    }

    public static MethodDeclaration addModifier(PrototypeDescription<ClassOrInterfaceDeclaration> description, ClassOrInterfaceDeclaration spec, PrototypeField declaration, String modifierName, String className, boolean isClass) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            PrototypeDescription<ClassOrInterfaceDeclaration> proto;
            ClassOrInterfaceType type = ((VariableDeclarator)declaration.getDeclaration().getVariables().get(0)).getType().asClassOrInterfaceType();
            CollectionType collection = Objects.isNull(declaration.getDescription()) ? CollectionsHandler.getCollectionType(EnrichHelpers.unit((Node)declaration.getDeclaration()), EnrichHelpers.unit((Node)spec), type) : CollectionsHandler.getCollectionType(EnrichHelpers.unit((Node)declaration.getDescription()), EnrichHelpers.unit((Node)spec), declaration.getDescription().getType().asClassOrInterfaceType());
            String generic = collection.getGeneric().stream().map(Pair::getLeft).collect(Collectors.joining(", "));
            spec.findCompilationUnit().ifPresent(u -> {
                u.addImport(collection.getInterfaceImport());
                u.addImport(collection.getImplementorInterface());
            });
            boolean embedded = false;
            if (Objects.nonNull(declaration.getTypePrototypes()) && Objects.nonNull(proto = declaration.getTypePrototypes().get(generic)) && Objects.nonNull(proto.getRegisteredClass("EmbeddedCollectionModifierIntf"))) {
                embedded = true;
            }
            String t = Helpers.calcType(spec);
            MethodDeclaration method = (MethodDeclaration)spec.addMethod(declaration.getName(), new Modifier.Keyword[0]).setType(collection.getType() + (String)(!isClass ? "<" + (String)(collection.isPrototypeParam() ? generic + (String)(embedded ? ".EmbeddedCollectionModify<" + modifierName + "." + t + ">, " : ".Modify, ") : "") + generic + ", " + (String)(Objects.nonNull(description.getRegisteredClass("EmbeddedModifierIntf")) ? "T" : modifierName + "." + t) + ">" : ""));
            if (isClass) {
                String parent = className + ".this." + declaration.getName();
                BlockStmt block = (BlockStmt)new BlockStmt().addStatement((Statement)new IfStmt().setCondition((Expression)new NameExpr().setName(parent + " == null")).setThenStmt((Statement)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName(parent)).setValue((Expression)new NameExpr().setName("new " + collection.getImplementor() + "<>()")))));
                if (collection.isPrototypeParam()) {
                    block.addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("new " + collection.getClassType() + "<>(this, " + parent + ", " + generic + ".class)")));
                } else {
                    block.addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("new " + collection.getClassType() + "<>(this, " + parent + ")")));
                }
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody(block);
                ((CompilationUnit)spec.findCompilationUnit().get()).addImport(collection.getClassImport());
                Helpers.addSuppressWarningsUnchecked((NodeWithAnnotations)method);
            } else {
                method.setBody(null);
            }
            return method;
        }
        return null;
    }

    public static CollectionType getCollectionType(CompilationUnit source, CompilationUnit destination, ClassOrInterfaceType type) {
        List<Pair<String, Boolean>> generic = Generator.getGenericsList(source, destination, type, true);
        CollectionType.CollectionTypeBuilder builder = CollectionType.builder().generic(generic);
        switch (type.getNameAsString()) {
            case "List": 
            case "CodeList": {
                builder.type("CodeList").classType("CodeListImpl").implementor("java.util.ArrayList").implementorInterface("java.util.List").prototypeParam(CollectionsHandler.isPrototypeParam(type, generic));
                break;
            }
            case "Set": 
            case "CodeSet": {
                builder.type("CodeSet").classType("CodeSetImpl").implementor("java.util.HashSet").implementorInterface("java.util.Set").prototypeParam(CollectionsHandler.isPrototypeParam(type, generic));
                break;
            }
            case "Map": 
            case "CodeMap": {
                builder.type("CodeMap").classType("CodeMapImpl").implementor("java.util.HashMap").implementorInterface("java.util.Map");
                break;
            }
            default: {
                builder.type("Unknown").classType("UnknownImpl");
            }
        }
        CollectionType result = builder.build();
        if (result.isPrototypeParam()) {
            result.setType("EmbeddedCodeCollection");
            result.setClassType("Embedded" + result.getClassType());
        }
        result.setInterfaceImport("net.binis.codegen.collection." + result.getType());
        result.setClassImport("net.binis.codegen.collection." + result.getClassType());
        return result;
    }

    private static boolean isPrototypeParam(ClassOrInterfaceType type, List<Pair<String, Boolean>> generic) {
        Optional arguments = type.getTypeArguments();
        if (arguments.isPresent() && ((NodeList)arguments.get()).isNonEmpty()) {
            return !Helpers.typeToString((Type)((NodeList)arguments.get()).get(0)).equals(generic.get(0).getKey());
        }
        return false;
    }

    public static String getCollectionType(Type type) {
        ClassOrInterfaceType t;
        Optional args;
        if (type.isClassOrInterfaceType() && (args = (t = type.asClassOrInterfaceType()).getTypeArguments()).isPresent()) {
            if ("Map".equals(t.getNameAsString()) && ((NodeList)args.get()).size() == 2) {
                return ((Type)((NodeList)args.get()).get(1)).asString();
            }
            if (((NodeList)args.get()).size() == 1) {
                return ((Type)((NodeList)args.get()).get(0)).asString();
            }
        }
        return "Object";
    }

    public static class CollectionType {
        private String type;
        private String classType;
        private String classImport;
        private String interfaceImport;
        private List<Pair<String, Boolean>> generic;
        private String implementor;
        private String implementorInterface;
        private boolean prototypeParam;

        CollectionType(String type, String classType, String classImport, String interfaceImport, List<Pair<String, Boolean>> generic, String implementor, String implementorInterface, boolean prototypeParam) {
            this.type = type;
            this.classType = classType;
            this.classImport = classImport;
            this.interfaceImport = interfaceImport;
            this.generic = generic;
            this.implementor = implementor;
            this.implementorInterface = implementorInterface;
            this.prototypeParam = prototypeParam;
        }

        public static CollectionTypeBuilder builder() {
            return new CollectionTypeBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getClassType() {
            return this.classType;
        }

        public String getClassImport() {
            return this.classImport;
        }

        public String getInterfaceImport() {
            return this.interfaceImport;
        }

        public List<Pair<String, Boolean>> getGeneric() {
            return this.generic;
        }

        public String getImplementor() {
            return this.implementor;
        }

        public String getImplementorInterface() {
            return this.implementorInterface;
        }

        public boolean isPrototypeParam() {
            return this.prototypeParam;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setClassType(String classType) {
            this.classType = classType;
        }

        public void setClassImport(String classImport) {
            this.classImport = classImport;
        }

        public void setInterfaceImport(String interfaceImport) {
            this.interfaceImport = interfaceImport;
        }

        public void setGeneric(List<Pair<String, Boolean>> generic) {
            this.generic = generic;
        }

        public void setImplementor(String implementor) {
            this.implementor = implementor;
        }

        public void setImplementorInterface(String implementorInterface) {
            this.implementorInterface = implementorInterface;
        }

        public void setPrototypeParam(boolean prototypeParam) {
            this.prototypeParam = prototypeParam;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CollectionType)) {
                return false;
            }
            CollectionType other = (CollectionType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPrototypeParam() != other.isPrototypeParam()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classType = this.getClassType();
            String other$classType = other.getClassType();
            if (this$classType == null ? other$classType != null : !this$classType.equals(other$classType)) {
                return false;
            }
            String this$classImport = this.getClassImport();
            String other$classImport = other.getClassImport();
            if (this$classImport == null ? other$classImport != null : !this$classImport.equals(other$classImport)) {
                return false;
            }
            String this$interfaceImport = this.getInterfaceImport();
            String other$interfaceImport = other.getInterfaceImport();
            if (this$interfaceImport == null ? other$interfaceImport != null : !this$interfaceImport.equals(other$interfaceImport)) {
                return false;
            }
            List<Pair<String, Boolean>> this$generic = this.getGeneric();
            List<Pair<String, Boolean>> other$generic = other.getGeneric();
            if (this$generic == null ? other$generic != null : !((Object)this$generic).equals(other$generic)) {
                return false;
            }
            String this$implementor = this.getImplementor();
            String other$implementor = other.getImplementor();
            if (this$implementor == null ? other$implementor != null : !this$implementor.equals(other$implementor)) {
                return false;
            }
            String this$implementorInterface = this.getImplementorInterface();
            String other$implementorInterface = other.getImplementorInterface();
            return !(this$implementorInterface == null ? other$implementorInterface != null : !this$implementorInterface.equals(other$implementorInterface));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CollectionType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPrototypeParam() ? 79 : 97);
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classType = this.getClassType();
            result = result * 59 + ($classType == null ? 43 : $classType.hashCode());
            String $classImport = this.getClassImport();
            result = result * 59 + ($classImport == null ? 43 : $classImport.hashCode());
            String $interfaceImport = this.getInterfaceImport();
            result = result * 59 + ($interfaceImport == null ? 43 : $interfaceImport.hashCode());
            List<Pair<String, Boolean>> $generic = this.getGeneric();
            result = result * 59 + ($generic == null ? 43 : ((Object)$generic).hashCode());
            String $implementor = this.getImplementor();
            result = result * 59 + ($implementor == null ? 43 : $implementor.hashCode());
            String $implementorInterface = this.getImplementorInterface();
            result = result * 59 + ($implementorInterface == null ? 43 : $implementorInterface.hashCode());
            return result;
        }

        public String toString() {
            return "CollectionsHandler.CollectionType(type=" + this.getType() + ", classType=" + this.getClassType() + ", classImport=" + this.getClassImport() + ", interfaceImport=" + this.getInterfaceImport() + ", generic=" + this.getGeneric() + ", implementor=" + this.getImplementor() + ", implementorInterface=" + this.getImplementorInterface() + ", prototypeParam=" + this.isPrototypeParam() + ")";
        }

        public static class CollectionTypeBuilder {
            private String type;
            private String classType;
            private String classImport;
            private String interfaceImport;
            private List<Pair<String, Boolean>> generic;
            private String implementor;
            private String implementorInterface;
            private boolean prototypeParam;

            CollectionTypeBuilder() {
            }

            public CollectionTypeBuilder type(String type) {
                this.type = type;
                return this;
            }

            public CollectionTypeBuilder classType(String classType) {
                this.classType = classType;
                return this;
            }

            public CollectionTypeBuilder classImport(String classImport) {
                this.classImport = classImport;
                return this;
            }

            public CollectionTypeBuilder interfaceImport(String interfaceImport) {
                this.interfaceImport = interfaceImport;
                return this;
            }

            public CollectionTypeBuilder generic(List<Pair<String, Boolean>> generic) {
                this.generic = generic;
                return this;
            }

            public CollectionTypeBuilder implementor(String implementor) {
                this.implementor = implementor;
                return this;
            }

            public CollectionTypeBuilder implementorInterface(String implementorInterface) {
                this.implementorInterface = implementorInterface;
                return this;
            }

            public CollectionTypeBuilder prototypeParam(boolean prototypeParam) {
                this.prototypeParam = prototypeParam;
                return this;
            }

            public CollectionType build() {
                return new CollectionType(this.type, this.classType, this.classImport, this.interfaceImport, this.generic, this.implementor, this.implementorInterface, this.prototypeParam);
            }

            public String toString() {
                return "CollectionsHandler.CollectionType.CollectionTypeBuilder(type=" + this.type + ", classType=" + this.classType + ", classImport=" + this.classImport + ", interfaceImport=" + this.interfaceImport + ", generic=" + this.generic + ", implementor=" + this.implementor + ", implementorInterface=" + this.implementorInterface + ", prototypeParam=" + this.prototypeParam + ")";
            }
        }
    }
}

