/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.utils;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import net.binis.codegen.compiler.CGClassDeclaration;
import net.binis.codegen.compiler.CGClassSymbol;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGFieldAccess;
import net.binis.codegen.compiler.CGIdent;
import net.binis.codegen.compiler.CGMethodDeclaration;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.compiler.CGTypeTag;
import net.binis.codegen.compiler.CGVarSymbol;
import net.binis.codegen.compiler.CGVariableDecl;
import net.binis.codegen.compiler.TreeMaker;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.exception.GenericCodeGenException;

public class ElementUtils {
    protected static CGDeclaration getDeclaration(Element element) {
        TreeMaker maker = TreeMaker.create();
        return ElementUtils.getDeclaration(element, maker);
    }

    protected static CGDeclaration getDeclaration(Element element, TreeMaker maker) {
        return switch (element.getKind()) {
            case ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE -> CGClassDeclaration.create(maker.getTrees(), element);
            case ElementKind.METHOD, ElementKind.CONSTRUCTOR -> CGMethodDeclaration.create(maker.getTrees(), element);
            case ElementKind.FIELD, ElementKind.PARAMETER -> CGVariableDecl.create(maker.getTrees(), element);
            default -> throw new GenericCodeGenException("Invalid element kind: " + element.getKind().toString());
        };
    }

    protected static CGFieldAccess selfType(CGClassDeclaration decl) {
        TreeMaker maker = TreeMaker.create();
        CGName name = decl.getName();
        return maker.Select((CGExpression)maker.Ident(name), decl.toName("class"));
    }

    protected static CGFieldAccess toType(Class<?> cls) {
        TreeMaker maker = TreeMaker.create();
        return maker.Select(ElementUtils.chainDotsString(maker, cls.getCanonicalName()), maker.toName("class"));
    }

    protected static CGExpression chainDots(JavaCompilerObject node, String elem1, String elem2, String ... elems) {
        return ElementUtils.chainDots(node, -1, elem1, elem2, elems);
    }

    protected static CGExpression chainDots(JavaCompilerObject node, String[] elems) {
        return ElementUtils.chainDots(node, -1, null, null, elems);
    }

    protected static CGExpression chainDots(JavaCompilerObject node, int pos, String elem1, String elem2, String ... elems) {
        TreeMaker maker = TreeMaker.create();
        if (pos != -1) {
            maker = maker.at(pos);
        }
        CGIdent e = null;
        if (elem1 != null) {
            e = maker.Ident(node.toName(elem1));
        }
        if (elem2 != null) {
            e = e == null ? maker.Ident(node.toName(elem2)) : maker.Select((CGExpression)e, node.toName(elem2));
        }
        for (String elem : elems) {
            e = e == null ? maker.Ident(node.toName(elem)) : maker.Select((CGExpression)e, node.toName(elem));
        }
        assert (e != null);
        return e;
    }

    public static CGExpression chainDotsString(String elems) {
        return ElementUtils.chainDots((JavaCompilerObject)TreeMaker.create(), null, null, elems.split("\\."));
    }

    public static CGExpression chainDotsString(JavaCompilerObject node, String elems) {
        return ElementUtils.chainDots(node, null, null, elems.split("\\."));
    }

    public static String getSymbolFullName(Element element) {
        CGSymbol symbol = new CGSymbol(element);
        if (symbol.is(CGClassSymbol.theClass())) {
            return symbol.asClassSymbol().getQualifiedName().toString();
        }
        if (symbol.is(CGVarSymbol.theClass())) {
            return symbol.asVarSymbol().getVariableType();
        }
        return element.getSimpleName().toString();
    }

    public static CGExpression classToExpression(Class<?> cls) {
        TreeMaker maker = TreeMaker.create();
        if (cls.isPrimitive()) {
            CGTypeTag tag = switch (cls.getName()) {
                case "byte" -> CGTypeTag.BYTE;
                case "char" -> CGTypeTag.CHAR;
                case "short" -> CGTypeTag.SHORT;
                case "long" -> CGTypeTag.LONG;
                case "float" -> CGTypeTag.FLOAT;
                case "int" -> CGTypeTag.INT;
                case "double" -> CGTypeTag.DOUBLE;
                case "boolean" -> CGTypeTag.BOOLEAN;
                case "void" -> CGTypeTag.VOID;
                default -> throw new IllegalStateException("Unexpected value: " + cls.getName());
            };
            return maker.TypeIdent(tag);
        }
        if (cls.isArray()) {
            return maker.TypeArray(ElementUtils.classToExpression(cls.getComponentType()));
        }
        return maker.QualIdent(maker.getSymbol(cls.getCanonicalName()));
    }
}

