/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.base;

import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.JavacElements;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaCompilerObject {
    private static final Logger log = LoggerFactory.getLogger(JavaCompilerObject.class);
    protected final ProcessingEnvironment env = (ProcessingEnvironment)CodeFactory.create(ProcessingEnvironment.class, (Object[])new Object[]{Helpers.lookup.getProcessingEnvironment()});
    protected Object instance;
    protected Object context = Reflection.invoke((String)"getContext", (Object)this.env, (Object[])new Object[0]);
    protected Class cls;

    protected JavaCompilerObject() {
        if (Objects.isNull(this.context)) {
            log.error("Unable to get context from {}!", this.env.getClass());
        }
        this.init();
    }

    protected abstract void init();

    public Class getCls() {
        return this.cls;
    }

    public Object getInstance() {
        return this.instance;
    }

    public CGName toName(String name) {
        return JavacElements.create().getName(name);
    }

    public boolean is(Class cls) {
        if (JavaCompilerObject.class.isAssignableFrom(cls)) {
            return this.getClass().equals(cls);
        }
        return this.instance.getClass().equals(cls);
    }

    public String toString() {
        return this.instance.toString();
    }
}

