/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler;

import com.sun.source.util.Trees;
import java.util.Objects;
import javax.lang.model.element.Element;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGModifiers;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CGDeclaration
extends JavaCompilerObject {
    private static final Logger log = LoggerFactory.getLogger(CGDeclaration.class);
    protected CGModifiers modifiers;

    public CGDeclaration(Trees trees, Element element) {
        this.instance = trees.getTree(element);
        if (!this.cls.isAssignableFrom(this.instance.getClass())) {
            log.error("Unable to get class declaration!");
        }
    }

    public CGDeclaration(Object instance) {
        this.instance = instance;
        if (!this.cls.isAssignableFrom(instance.getClass())) {
            log.error("Unable to get class declaration!");
        }
    }

    public CGModifiers getModifiers() {
        if (Objects.isNull(this.modifiers)) {
            this.modifiers = new CGModifiers(this);
        }
        return this.modifiers;
    }

    public CGList<JavaCompilerObject> getDefs() {
        return new CGList<JavaCompilerObject>(Reflection.getFieldValue((Object)this.instance, (String)"defs"), this::onDefsModify, JavaCompilerObject.class);
    }

    public CGName getName() {
        return new CGName((String)Reflection.getFieldValue((Object)this.instance, (String)"name"));
    }

    private <T extends JavaCompilerObject> void onDefsModify(CGList<T> list) {
        Reflection.setFieldValue((Object)this.instance, (String)"defs", (Object)list.getInstance());
    }

    public CGSymbol getSymbol() {
        return new CGSymbol(Reflection.getFieldValue((Object)this.instance, (String)"sym"));
    }
}

