/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.Arrays;
import java.util.Objects;
import net.binis.codegen.enrich.OpenApiEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.options.Options;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;

public class OpenApiEnricherHandler
extends BaseEnricher
implements OpenApiEnricher {
    protected static final boolean IS_OPENAPI_AVAILABLE = Objects.nonNull(Reflection.loadClass((String)"io.swagger.v3.oas.annotations.media.Schema"));

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public int order() {
        return -2147478648;
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        if (this.generate(description)) {
            ClassOrInterfaceDeclaration intf = description.getInterface();
            intf.findCompilationUnit().ifPresent(unit -> {
                unit.addImport("io.swagger.v3.oas.annotations.media", false, true);
                description.getFields().forEach(this::enrichField);
            });
        }
    }

    protected void enrichField(PrototypeField field) {
        MethodDeclaration getter = field.forceGenerateInterfaceGetter();
        if (Objects.nonNull(getter)) {
            NormalAnnotationExpr ann = getter.addAndGetAnnotation("Schema");
            ann.addPair("name", "\"" + field.getName() + "\"");
            if (Objects.nonNull(field.getDescription().getAnnotationByName("ValidateNull"))) {
                ann.addPair("required", "true");
            }
            if (Objects.nonNull(field.getPrototype()) && field.getPrototype().isCodeEnum()) {
                ArrayInitializerExpr exp = new ArrayInitializerExpr();
                field.getPrototype().getDeclaration().asEnumDeclaration().getEntries().forEach(e -> exp.getValues().add((Node)new StringLiteralExpr(e.getNameAsString())));
                ann.addPair("allowableValues", (Expression)exp);
                ann.addPair("type", (Expression)new StringLiteralExpr("string"));
            } else {
                Tools.with(Reflection.loadClass((String)field.getFullType()), cls -> {
                    if (cls.isEnum()) {
                        ArrayInitializerExpr exp = new ArrayInitializerExpr();
                        Arrays.stream(cls.getEnumConstants()).forEach(e -> exp.getValues().add((Node)new StringLiteralExpr(e.toString())));
                        ann.addPair("allowableValues", (Expression)exp);
                    }
                });
            }
        }
    }

    protected boolean generate(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        return description.hasOption(Options.GENERATE_OPENAPI_ALWAYS) || IS_OPENAPI_AVAILABLE && description.hasOption(Options.GENERATE_OPENAPI_IF_AVAILABLE);
    }
}

