/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGList<T extends JavaCompilerObject>
extends JavaCompilerObject
implements Iterable<T> {
    private static final Logger log = LoggerFactory.getLogger(CGList.class);
    protected final Consumer<CGList<T>> onModify;
    protected Class<T> containedClass;
    protected static Method mAppend;
    protected static Method mGet;
    protected static Method mLast;

    public static Class theClass() {
        return Reflection.loadClass((String)"com.sun.tools.javac.util.List");
    }

    public CGList(Object instance, Consumer<CGList<T>> onModify, Class<T> containedClass) {
        this.instance = instance;
        this.onModify = onModify;
        this.containedClass = containedClass;
    }

    public static <T extends JavaCompilerObject> CGList<T> nil(Class<T> cls) {
        return new CGList<T>(Reflection.invokeStatic((String)"nil", (Class)CGList.theClass(), (Object[])new Object[0]), null, cls);
    }

    @Override
    protected void init() {
        this.cls = CGList.theClass();
    }

    public CGList<T> append(T value) {
        if (Objects.isNull(mAppend)) {
            mAppend = Reflection.findMethod((String)"append", (Class)this.cls, (Class[])new Class[]{Object.class});
        }
        this.instance = Reflection.invoke((Method)mAppend, (Object)this.instance, (Object[])new Object[]{((JavaCompilerObject)value).getInstance()});
        if (Objects.nonNull(this.onModify)) {
            this.onModify.accept(this);
        }
        return this;
    }

    public static <T extends JavaCompilerObject> CGList<T> from(T[] array, Class<T> cls) {
        Method method = Reflection.findMethod((String)"from", (Class)CGList.theClass(), (Class[])new Class[]{Object[].class});
        Object[] params = Arrays.stream(array).map(JavaCompilerObject::getInstance).toArray();
        return new CGList<T>(Reflection.invokeStatic((Method)method, (Object[])new Object[]{params}), null, cls);
    }

    public static <T extends JavaCompilerObject> CGList<T> from(List<T> list, Class<T> cls) {
        CGList<T> result = CGList.nil(cls);
        list.forEach(result::append);
        return result;
    }

    public int size() {
        return (Integer)Reflection.invoke((String)"size", (Object)this.instance, (Object[])new Object[0]);
    }

    public T get(int index) {
        Object inst;
        if (Objects.isNull(mGet)) {
            mGet = Reflection.findMethod((String)"get", (Class)this.cls, (Class[])new Class[]{Integer.TYPE});
        }
        if (Objects.nonNull(inst = Reflection.invoke((Method)mGet, (Object)this.instance, (Object[])new Object[]{index}))) {
            if (this.containedClass.equals(JavaCompilerObject.class)) {
                return (T)((JavaCompilerObject)Tools.nullCheck(CodeFactory.create(inst.getClass(), (Object[])new Object[]{inst}), inst));
            }
            return (T)((JavaCompilerObject)CodeFactory.create(this.containedClass, (Object[])new Object[]{inst}));
        }
        return null;
    }

    public T last() {
        if (Objects.isNull(mLast)) {
            mLast = Reflection.findMethod((String)"last", (Class)this.cls, (Class[])new Class[0]);
        }
        return (T)Tools.withRes(Reflection.invoke((Method)mLast, (Object)this.instance, (Object[])new Object[0]), inst -> (JavaCompilerObject)(this.containedClass.equals(JavaCompilerObject.class) ? CodeFactory.create(inst.getClass(), (Object[])new Object[]{inst}) : CodeFactory.create(this.containedClass, (Object[])new Object[]{inst})));
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return new ProxyIterator((Iterator)Reflection.invoke((String)"iterator", (Object)this.instance, (Object[])new Object[0]), this.containedClass);
    }

    protected static class ProxyIterator
    implements Iterator {
        protected Iterator iterator;
        protected Constructor constructor;
        protected Function<Object, Object> func;

        public ProxyIterator(Iterator iterator, Class cls) {
            this.iterator = iterator;
            if (JavaCompilerObject.class.equals((Object)cls)) {
                this.func = inst -> Tools.nullCheck(CodeFactory.create(inst.getClass(), (Object[])new Object[]{inst}), inst);
            } else {
                this.constructor = Reflection.findConstructor((Class)cls, (Object[])new Object[]{Object.class});
                this.func = inst -> {
                    try {
                        return this.constructor.newInstance(inst);
                    }
                    catch (Exception e) {
                        throw new GenericCodeGenException(e);
                    }
                };
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.func.apply(this.iterator.next());
        }
    }
}

