/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import net.binis.codegen.compiler.CGClassSymbol;
import net.binis.codegen.compiler.CGMethodSymbol;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.compiler.utils.ElementUtils;
import net.binis.codegen.generation.core.CollectionsHandler;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;

public class EnrichHelpers {
    public static CompilationUnit unit(Node node) {
        return (CompilationUnit)node.findCompilationUnit().get();
    }

    public static BlockStmt block(String code) {
        return (BlockStmt)Helpers.lookup.getParser().parseBlock(code).getResult().get();
    }

    public static BlockStmt returnBlock(String variable) {
        return EnrichHelpers.block("{return " + variable + ";}");
    }

    public static Statement statement(String code) {
        return (Statement)Helpers.lookup.getParser().parseStatement(code).getResult().get();
    }

    public static Expression expression(String code) {
        return (Expression)Helpers.lookup.getParser().parseExpression(code).getResult().get();
    }

    public static AnnotationExpr annotation(String code) {
        return (AnnotationExpr)Helpers.lookup.getParser().parseAnnotation(code).getResult().get();
    }

    public static MethodDeclaration method(String code) {
        return (MethodDeclaration)Helpers.lookup.getParser().parseMethodDeclaration(code).getResult().get();
    }

    public static PrototypeField addField(PrototypeDescription<ClassOrInterfaceDeclaration> description, String name, String type) {
        return EnrichHelpers.addField(description, name, (Type)new ClassOrInterfaceType(null, type));
    }

    public static String calcBlock(String value) {
        if (Objects.nonNull(value)) {
            StringBuilder result = new StringBuilder().append('{').append(value);
            if (!value.isEmpty() && result.charAt(result.length() - 1) != ';') {
                result.append(';');
            }
            result.append('}');
            return result.toString();
        }
        return "{}";
    }

    public static PrototypeField addField(PrototypeDescription<ClassOrInterfaceDeclaration> description, String name, Type type) {
        FieldDeclaration field = description.getImplementation().addField(type, name, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
        MethodDeclaration desc = ((MethodDeclaration)new MethodDeclaration().setName(name)).setType(type);
        Helpers.envelopWithDummyClass(desc);
        Structures.FieldData result = Structures.FieldData.builder().parsed((Structures.Parsed)description).declaration(field).description(desc).name(name).fullType(Helpers.getExternalClassNameIfExists((Node)description.getDeclarationUnit(), type.asString())).type(type).collection(CollectionsHandler.isCollection(type)).ignores(Structures.Ignores.builder().build()).custom(true).build();
        description.getFields().add(result);
        return result;
    }

    public static PrototypeField addField(PrototypeDescription<ClassOrInterfaceDeclaration> description, String name, Class<?> type) {
        PrototypeField field = EnrichHelpers.addField(description, name, type.getSimpleName());
        field.getDescription().findCompilationUnit().ifPresent(unit -> unit.addImport(type));
        if (!type.isPrimitive() && !type.getPackageName().equals("java.lang")) {
            description.getDeclarationUnit().addImport(type);
        }
        return field;
    }

    public static List<JavaCompilerObject> deepFindElementList(Node node, PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        if (node.getParentNode().isEmpty() || node.getParentNode().get() instanceof CompilationUnit) {
            String string;
            if (node instanceof ClassOrInterfaceDeclaration) {
                ClassOrInterfaceDeclaration decl = (ClassOrInterfaceDeclaration)node;
                string = decl.getFullyQualifiedName().orElse(decl.getNameAsString());
            } else {
                string = Helpers.getNodeName(node);
            }
            String name = string;
            return Helpers.lookup.getRoundEnvironment().getRootElements().stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).filter(e -> e.getQualifiedName().isEmpty() ? e.getSimpleName().toString().equals(name) : e.getQualifiedName().toString().equals(name)).map(CGClassSymbol::new).toList();
        }
        List<JavaCompilerObject> result = EnrichHelpers.deepFindElementList((Node)node.getParentNode().get(), parsed);
        if (Objects.nonNull(result)) {
            if (node instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)node;
                ArrayList<JavaCompilerObject> res = new ArrayList<JavaCompilerObject>();
                String name = method.getNameAsString();
                result.stream().filter(CGClassSymbol.class::isInstance).map(CGClassSymbol.class::cast).forEach(t -> {
                    Iterator<CGSymbol> it = t.members().getSymbolsByName(name);
                    while (it.hasNext()) {
                        res.add(it.next());
                    }
                });
                result = res;
            } else if (node instanceof Parameter) {
                Parameter param = (Parameter)node;
                ArrayList<JavaCompilerObject> res = new ArrayList<JavaCompilerObject>();
                String name = param.getNameAsString();
                String type = Helpers.getExternalClassName((Node)param, param.getTypeAsString());
                result.stream().filter(CGMethodSymbol.class::isInstance).map(CGMethodSymbol.class::cast).forEach(m -> m.params().forEach(p -> {
                    if ("ErrorType".equals(p.getType().getInstance().getClass().getSimpleName())) {
                        if (p.getName().equals(name) && p.getVariableType().toString().equals(param.getTypeAsString())) {
                            res.add((JavaCompilerObject)p);
                        }
                    } else if (p.getName().equals(name) && p.getVariableType().toString().equals(type)) {
                        res.add((JavaCompilerObject)p);
                    }
                }));
                result = res;
            }
        }
        return result;
    }

    public static Element deepFindElement(Node node, PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        if (Objects.nonNull(Helpers.lookup.getRoundEnvironment())) {
            ElementUtils.init();
            List<JavaCompilerObject> result = EnrichHelpers.deepFindElementList(node, parsed);
            if (Objects.nonNull(result) && !result.isEmpty()) {
                return (Element)result.get(0).getInstance();
            }
        }
        return null;
    }

    private EnrichHelpers() {
    }
}

