/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import net.binis.codegen.enrich.HibernateEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.generation.core.EnrichHelpers;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateEnricherHandler
extends BaseEnricher
implements HibernateEnricher {
    private static final Logger log = LoggerFactory.getLogger(HibernateEnricherHandler.class);
    protected static final Method EQUALS = HibernateEnricherHandler.initEqualsMethod();
    protected static final Method HASH_CODE = HibernateEnricherHandler.initHashCode();
    protected static final String TYPE = "org.hibernate.annotations.Type";

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        description.getFields().stream().filter(field -> {
            if (field.isCollection()) return true;
            if (Objects.nonNull(field.getPrototype())) {
                if (field.getPrototype().isCodeEnum()) return true;
            }
            if (Objects.nonNull(this.lookup.findEnum(field.getFullType()))) return true;
            if (Tools.withRes(Reflection.loadClass((String)field.getFullType()), CodeEnum.class::isAssignableFrom, false) == false) return false;
            return true;
        }).filter(field -> !Helpers.hasAnnotation(field.getDeclaration(), TYPE)).forEach(this::processField);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processField(PrototypeField field) {
        Optional declUnit = field.getDeclaration().findCompilationUnit();
        if (field.isCollection()) {
            NodeList types = field.getType().asClassOrInterfaceType().getTypeArguments().orElse(null);
            if (!Objects.nonNull(types)) return;
            if (types.size() == 1) {
                PrototypeDescription<ClassOrInterfaceDeclaration> proto;
                String type = ((Type)types.get(0)).toString();
                PrototypeDescription<ClassOrInterfaceDeclaration> prototypeDescription = proto = Objects.nonNull(field.getTypePrototypes()) ? field.getTypePrototypes().get(type) : null;
                if ((!Objects.nonNull(proto) || !proto.isCodeEnum()) && !Tools.withRes(this.lookup.findGenerated(Helpers.getExternalClassName((Node)declUnit.get(), type)), PrototypeDescription::isCodeEnum, false).booleanValue()) return;
                declUnit.ifPresent(unit -> unit.addImport("jakarta.persistence.ElementCollection"));
                field.getDeclaration().addAnnotation(EnrichHelpers.annotation("@ElementCollection"));
            } else {
                log.warn("Collection type has more than one type argument, case not implemented!");
                return;
            }
        }
        declUnit.ifPresent(unit -> unit.addImport(TYPE));
        field.getDeclaration().addAnnotation(EnrichHelpers.annotation("@Type(net.binis.codegen.hibernate.CodeEnumType.class)"));
        Tools.with(field.getPrototype(), prototype -> {
            ClassOrInterfaceDeclaration intf = prototype.getInterface();
            if (!Helpers.methodExists(intf, EQUALS, false)) {
                ((MethodDeclaration)intf.addMethod("equals", new Modifier.Keyword[0]).setType((Type)PrimitiveType.booleanType()).addParameter("Object", "o")).setBody(null);
            }
            if (!Helpers.methodExists(intf, HASH_CODE, false)) {
                intf.addMethod("hashCode", new Modifier.Keyword[0]).setType((Type)PrimitiveType.intType()).setBody(null);
            }
        });
    }

    @Override
    public int order() {
        return 0;
    }

    private static Method initEqualsMethod() {
        try {
            return Object.class.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new GenericCodeGenException((Exception)e);
        }
    }

    private static Method initHashCode() {
        try {
            return Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new GenericCodeGenException((Exception)e);
        }
    }
}

