/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import java.util.Map;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.interfaces.ElementDescription;
import net.binis.codegen.tools.Interpolator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorEnricher
extends BaseEnricher {
    private static final Logger log = LoggerFactory.getLogger(ValidatorEnricher.class);
    public static final String TEMPLATE = "    package ${package};\n    import net.binis.codegen.annotation.CodeAnnotation;\n    import net.binis.codegen.validation.annotation.ValidateLambda;\n\n    import java.lang.annotation.ElementType;\n    import java.lang.annotation.Target;\n\n    @CodeAnnotation\n    @Target({ElementType.METHOD, ElementType.TYPE_USE})\n    @ValidateLambda(\"${class}::${methodName}\")\n    public @interface ${name} {\n        String message() default \"${message}\";\n    }\n";
    public static final String DEFAULT_MESSAGE = "({field}) Invalid value!";
    protected static Interpolator interpolator = Interpolator.build('$', "    package ${package};\n    import net.binis.codegen.annotation.CodeAnnotation;\n    import net.binis.codegen.validation.annotation.ValidateLambda;\n\n    import java.lang.annotation.ElementType;\n    import java.lang.annotation.Target;\n\n    @CodeAnnotation\n    @Target({ElementType.METHOD, ElementType.TYPE_USE})\n    @ValidateLambda(\"${class}::${methodName}\")\n    public @interface ${name} {\n        String message() default \"${message}\";\n    }\n");

    @Override
    public void enrichElement(ElementDescription description) {
        MethodDeclaration method;
        Node node = description.getNode();
        if (node instanceof MethodDeclaration && (method = (MethodDeclaration)node).isStatic() && "boolean".equals(method.getType().asString()) && method.getParameters().size() == 1) {
            String string;
            ClassOrInterfaceDeclaration parent = (ClassOrInterfaceDeclaration)method.getParentNode().get();
            String pack = ((PackageDeclaration)((CompilationUnit)parent.findCompilationUnit().get()).getPackageDeclaration().get()).getNameAsString() + ".annotation.validation";
            String name = "Validate" + StringUtils.capitalize((String)method.getNameAsString());
            String string2 = method.getNameAsString();
            AnnotationExpr annotationExpr = description.getPrototype();
            if (annotationExpr instanceof NormalAnnotationExpr) {
                NormalAnnotationExpr exp = (NormalAnnotationExpr)annotationExpr;
                string = exp.getPairs().stream().filter(p -> p.getNameAsString().equals("message")).map(p -> p.getValue().asStringLiteralExpr().asString()).findFirst().orElse(DEFAULT_MESSAGE);
            } else {
                string = DEFAULT_MESSAGE;
            }
            String cls = interpolator.params(Map.of("methodName", string2, "name", name, "message", string, "class", ((ClassOrInterfaceDeclaration)method.getParentNode().get()).getFullyQualifiedName().get(), "package", pack)).interpolate();
            CompilationUnit unit = (CompilationUnit)this.lookup.getParser().parse(cls).getResult().get();
            description.getDescription().addCustomFile(pack + "." + name).setJavaClass(unit.getType(0));
        } else {
            String string;
            Node node2 = description.getNode();
            if (node2 instanceof NodeWithSimpleName) {
                NodeWithSimpleName name = (NodeWithSimpleName)node2;
                string = name.getNameAsString();
            } else {
                string = "Element is not valid @Validator target! (example 'public static boolean method(Type value)')";
            }
            this.error(string, description.getElement());
        }
    }

    @Override
    public int order() {
        return 0;
    }
}

