/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.discoverer;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.binis.codegen.discovery.Discoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationDiscoverer
extends Discoverer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationDiscoverer.class);
    private static InputStream read;
    private static OutputStream write;
    private static final SortedSet<String> allServices;

    private static void loadDefault(List<Discoverer.DiscoveredService> list) {
        list.add(Discoverer.DiscoveredService.builder().type("template").name("net.binis.codegen.annotation.CodePrototype").build());
        list.add(Discoverer.DiscoveredService.builder().type("template").name("net.binis.codegen.annotation.EnumPrototype").build());
        list.add(Discoverer.DiscoveredService.builder().type("template").name("net.binis.codegen.annotation.builder.CodeBuilder").build());
        list.add(Discoverer.DiscoveredService.builder().type("template").name("net.binis.codegen.spring.annotation.builder.CodeQueryBuilder").build());
        list.add(Discoverer.DiscoveredService.builder().type("template").name("net.binis.codegen.annotation.builder.CodeValidationBuilder").build());
        list.add(Discoverer.DiscoveredService.builder().type("template").name("net.binis.codegen.annotation.builder.CodeRequest").build());
    }

    public static List<Discoverer.DiscoveredService> findAnnotations() {
        ArrayList<Discoverer.DiscoveredService> result = new ArrayList<Discoverer.DiscoveredService>();
        try {
            AnnotationDiscoverer.loadResources((String)"binis/annotations", (ClassLoader)Discoverer.class.getClassLoader()).forEach(s -> Discoverer.processResource((InputStream)s, (List)result));
        }
        catch (Exception e) {
            log.error("Unable to discover annotations!");
            AnnotationDiscoverer.loadDefault(result);
        }
        return result;
    }

    public static List<Discoverer.DiscoveredService> findAnnotations(File file) {
        ArrayList<Discoverer.DiscoveredService> result = new ArrayList<Discoverer.DiscoveredService>();
        try (FileInputStream stream = new FileInputStream(file);){
            Discoverer.processResource((BufferedReader)new BufferedReader(new InputStreamReader(stream)), result, (boolean)false, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void writeTemplate(Filer filer, String className) {
        AnnotationDiscoverer.writeEntry("template", filer, className);
    }

    public static void writeConfig(Filer filer, String className) {
        AnnotationDiscoverer.writeEntry("config", filer, className);
    }

    public static void writeEntry(String type, Filer filer, String className) {
        try {
            if (Objects.isNull(read)) {
                try {
                    FileObject file = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "binis/annotations");
                    read = file.openInputStream();
                    Set oldServices = AnnotationDiscoverer.readServiceFile((InputStream)read);
                    allServices.addAll(oldServices);
                }
                catch (IOException file) {
                    // empty catch block
                }
            }
            String service = type + ":" + className;
            allServices.add(service);
            if (Objects.isNull(write)) {
                write = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "binis/annotations", new Element[0]).openOutputStream();
            }
            AnnotationDiscoverer.writeService(service, write);
        }
        catch (IOException e) {
            log.error("Failed to write annotations resource!", (Throwable)e);
        }
    }

    protected static void writeServiceFile(Collection<String> services, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        for (String service : services) {
            writer.write(service);
            writer.newLine();
        }
        writer.flush();
    }

    protected static void writeService(String service, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        writer.write(service);
        writer.newLine();
        writer.flush();
    }

    static {
        allServices = Sets.newTreeSet();
    }
}

