/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.StringEscapeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import net.binis.codegen.annotation.validation.AliasFor;
import net.binis.codegen.annotation.validation.AsCode;
import net.binis.codegen.annotation.validation.Execute;
import net.binis.codegen.annotation.validation.Sanitize;
import net.binis.codegen.annotation.validation.Validate;
import net.binis.codegen.enrich.Enrichers;
import net.binis.codegen.enrich.ValidationEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.EnrichHelpers;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeConstant;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.generation.core.types.ModifierType;
import net.binis.codegen.options.Options;
import net.binis.codegen.tools.CollectionUtils;
import net.binis.codegen.tools.ContextInterpolator;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationEnricherHandler
extends BaseEnricher
implements ValidationEnricher {
    private static final Logger log = LoggerFactory.getLogger(ValidationEnricherHandler.class);
    protected static final String VALUE = "value";
    protected static final String PARAMS = "params";
    protected static final String MESSAGE = "message";
    protected static final String MESSAGES = "messages";
    protected static final String AS_CODE = "asCode";
    protected static final String TARGETS = "targets";
    protected static final Class<?> TARGETS_AWARE = Reflection.loadClass((String)"net.binis.codegen.validation.consts.ValidationTargets$TargetsAware");

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        StringBuilder form = new StringBuilder();
        description.getFields().forEach(f -> this.handleField(description, (PrototypeField)f, form, false));
        if (Objects.nonNull(description.getMixIn())) {
            description.getMixIn().getFields().forEach(f -> this.handleField(description, (PrototypeField)f, form, true));
        }
        if (description.hasOption(Options.VALIDATION_FORM)) {
            this.buildValidationForm(description, form);
        }
    }

    @Override
    public int order() {
        return 0;
    }

    protected void handleField(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, StringBuilder code, boolean mixIn) {
        MethodDeclaration form = description.hasOption(Options.VALIDATION_FORM) ? this.formMethod(field) : null;
        field.getDescription().getAnnotations().stream().filter(this::isValidationAnnotation).forEach(a -> this.processAnnotation(description, field, (AnnotationExpr)a, form, false, mixIn));
        if (field.isCollection()) {
            field.getDescription().getType().asClassOrInterfaceType().getTypeArguments().ifPresent(args -> args.forEach(type -> type.getAnnotations().stream().filter(this::isValidationAnnotation).forEach(a -> this.processAnnotation(description, field, (AnnotationExpr)a, form, true, mixIn))));
        }
        if (Objects.nonNull(form)) {
            boolean isChild = this.hasChildren(field);
            String exp = ((BlockStmt)form.getBody().get()).getStatement(0).toString();
            if (exp.length() > field.getName().length() + 5) {
                code.append("e -> ").append(exp.replace(".start(", ".start(e, "));
                code.setLength(code.length() - 1);
                if (isChild) {
                    code.insert(code.lastIndexOf(".perform("), ".child()");
                }
                code.append(",\n");
            } else if (isChild) {
                code.append("e -> Validation.start(e, this.getClass(), \"").append(field.getName()).append("\", ").append(field.getName()).append(").child(),\n");
            }
        }
    }

    protected boolean hasChildren(PrototypeField field) {
        boolean result = this.hasForm(field.getPrototype());
        if (!result && CollectionUtils.isNotEmpty(field.getTypePrototypes())) {
            result = field.getTypePrototypes().values().stream().anyMatch(this::hasForm);
        }
        return result;
    }

    protected boolean hasForm(PrototypeDescription<?> desc) {
        return Objects.nonNull(desc) && desc.hasEnricher(Enrichers.VALIDATION) && desc.hasOption(Options.VALIDATION_FORM);
    }

    protected void processAnnotation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, MethodDeclaration form, boolean collection, boolean mixIn) {
        String name = Helpers.getExternalClassNameIfExists((Node)EnrichHelpers.unit((Node)annotation), annotation.getNameAsString());
        Class cls = Reflection.loadClass((String)name);
        if (Objects.nonNull(cls)) {
            if (Validate.class.equals((Object)cls) || cls.isAnnotationPresent(Validate.class)) {
                this.generateValidation(description, field, annotation, cls, form, collection, mixIn);
            } else if (Sanitize.class.equals((Object)cls) || cls.isAnnotationPresent(Sanitize.class)) {
                this.generateSanitization(description, field, annotation, cls, form, collection, mixIn);
            } else if (Execute.class.equals((Object)cls) || cls.isAnnotationPresent(Execute.class)) {
                this.generateExecution(description, field, annotation, cls, collection, mixIn);
            }
        } else {
            Tools.notNull(this.lookup.findExternal(name), d -> this.handleAnnotationFromSource(description, d.getDeclaration().asAnnotationDeclaration(), field, annotation, form, collection, mixIn));
        }
        ClassOrInterfaceDeclaration mod = description.getRegisteredClass("EmbeddedModifier");
        if (Objects.isNull(mod)) {
            mod = description.getRegisteredClass("Modifier");
        }
        if (Objects.nonNull(mod)) {
            Helpers.addSuppressWarningsUnchecked((NodeWithAnnotations)mod);
        }
        if (Objects.nonNull(field.getImplementationSetter())) {
            Helpers.addSuppressWarningsUnchecked((NodeWithAnnotations)description.getImplementation());
        }
    }

    protected void handleAnnotationFromSource(PrototypeDescription<ClassOrInterfaceDeclaration> description, AnnotationDeclaration decl, PrototypeField field, AnnotationExpr annotation, MethodDeclaration form, boolean collection, boolean mixIn) {
        Optional ann = decl.getAnnotationByClass(Validate.class);
        if (ann.isPresent()) {
            this.generateValidation(description, field, annotation, (AnnotationExpr)ann.get(), decl, form, collection, mixIn);
        } else {
            ann = decl.getAnnotationByClass(Sanitize.class);
            if (ann.isPresent()) {
                this.generateSanitization(description, field, annotation, (AnnotationExpr)ann.get(), decl, form, collection, mixIn);
            } else {
                decl.getAnnotationByClass(Execute.class).ifPresent(annotationExpr -> this.generateExecution(description, field, annotation, (AnnotationExpr)annotationExpr, decl, collection, mixIn));
            }
        }
    }

    protected void generateSanitization(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass, MethodDeclaration form, boolean collection, boolean mixIn) {
        Params params = this.getSanitizationParams(field, annotation, ann, annotationClass);
        field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(Helpers.getExternalClassName((Node)annotationClass.findCompilationUnit().get(), params.getCls())));
        this.generateSanitization(description, field, params, form, collection, mixIn);
    }

    protected void generateSanitization(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass, MethodDeclaration form, boolean collection, boolean mixIn) {
        this.generateSanitization(description, field, this.getSanitizationParams(field, annotation, annotationClass), form, collection, mixIn);
    }

    protected void generateSanitization(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, Params params, MethodDeclaration form, boolean collection, boolean mixIn) {
        if (!mixIn && Objects.nonNull(field.getImplementationSetter())) {
            this.addSanitization(field, field.getImplementationSetter(), params, ModifierType.MAIN, collection);
        }
        field.getModifiers().stream().filter(m -> !mixIn || m.getOrigin().equals(description)).forEach(modifier -> this.addSanitization(field, modifier.getModifier(), params, modifier.getType(), collection));
        if (!mixIn && description.hasOption(Options.VALIDATION_FORM)) {
            this.addSanitization(field, form, params, ModifierType.FORM, collection);
        }
    }

    protected Params getSanitizationParams(PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        this.handleSanitizationAnnotation(ann, params);
        return this.checkTargets(params.build(), field);
    }

    protected Params getSanitizationParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        String cls = null;
        Params.ParamsBuilder params = Params.builder();
        if (!Sanitize.class.equals(annotationClass)) {
            Sanitize ann = annotationClass.getDeclaredAnnotation(Sanitize.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params())).targets(this.processTargetsClass(ann.targets()));
            cls = ann.value().getCanonicalName();
            ((CompilationUnit)field.getDeclaration().findCompilationUnit().get()).addImport(cls);
            this.handleAliases(field, annotation, annotationClass, params);
        } else {
            this.handleSanitizationAnnotation(annotation, params);
        }
        Params result = this.checkTargets(params.build(), field);
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass(Objects.isNull(cls) ? Helpers.getExternalClassName((Node)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    protected void handleSanitizationAnnotation(AnnotationExpr annotation, Params.ParamsBuilder params) {
        for (Node node : annotation.getChildNodes()) {
            if (node instanceof ClassExpr) {
                ClassExpr exp = (ClassExpr)node;
                params.cls(exp.getTypeAsString());
                continue;
            }
            if (!(node instanceof MemberValuePair)) continue;
            MemberValuePair pair = (MemberValuePair)node;
            switch (pair.getNameAsString()) {
                case "value": {
                    String cls = pair.getValue().asClassExpr().getTypeAsString();
                    params.cls(cls).full(Helpers.getExternalClassName((Node)pair, cls));
                    break;
                }
                case "targets": {
                    params.targets(this.processTargets(pair.getValue()));
                    break;
                }
                case "params": {
                    params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                    break;
                }
                case "asCode": {
                    params.asCode(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
            }
        }
    }

    protected Params getValidationParams(PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        this.handleValidationAnnotation(ann, params);
        return this.checkTargets(params.build(), field);
    }

    protected Params getValidationParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        String cls = null;
        if (!Validate.class.equals(annotationClass)) {
            Validate ann = annotationClass.getDeclaredAnnotation(Validate.class);
            cls = ann.value().getCanonicalName();
            params.cls(ann.value().getSimpleName()).full(cls).params(Arrays.asList(ann.params())).message(ann.message()).targets(this.processTargetsClass(ann.targets()));
            this.handleAliases(field, annotation, annotationClass, params);
        } else {
            this.handleValidationAnnotation(annotation, params);
        }
        Params result = this.checkTargets(params.build(), field);
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass((String)(Objects.isNull(cls) ? Helpers.getExternalClassName((Node)EnrichHelpers.unit(field.getParsed().getDeclaration()), result.getCls()) : cls)), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    protected void handleValidationAnnotation(AnnotationExpr annotation, Params.ParamsBuilder params) {
        for (Node node : annotation.getChildNodes()) {
            if (node instanceof ClassExpr) {
                ClassExpr exp = (ClassExpr)node;
                params.cls(exp.getTypeAsString()).full(Helpers.getExternalClassName((Node)exp, exp.getTypeAsString()));
                continue;
            }
            if (!(node instanceof MemberValuePair)) continue;
            MemberValuePair pair = (MemberValuePair)node;
            switch (pair.getNameAsString()) {
                case "value": {
                    String cls = pair.getValue().asClassExpr().getTypeAsString();
                    params.cls(cls).full(Helpers.getExternalClassName((Node)pair, cls));
                    break;
                }
                case "message": {
                    params.message(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
                case "messages": {
                    params.messages(pair.getValue().asArrayInitializerExpr().getValues().stream().map(e -> e.asStringLiteralExpr().asString()).collect(Collectors.toList()));
                    break;
                }
                case "params": {
                    if (pair.getValue().isArrayInitializerExpr()) {
                        params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                        break;
                    }
                    params.params(List.of(pair.getValue())).annotation(EnrichHelpers.unit((Node)annotation));
                    break;
                }
                case "asCode": {
                    params.asCode(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
                case "targets": {
                    params.targets(this.processTargets(pair.getValue()));
                    break;
                }
            }
        }
    }

    protected void handleAliases(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass, Params.ParamsBuilder params) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<ParamHolder> parOrder = Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).filter(a -> a.annotationType().isAssignableFrom(AliasFor.class)).map(AliasFor.class::cast).anyMatch(a -> PARAMS.equals(a.value()))).map(m -> ParamHolder.builder().name(m.getName()).value(m.getDefaultValue()).annotation(m.getDeclaredAnnotation(AsCode.class)).order(m.getDeclaredAnnotation(AliasFor.class).order()).alt(m.getDeclaredAnnotation(AliasFor.class).alternative()).build()).sorted(Comparator.comparing(this::paramHolderOrder)).toList();
        Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> MESSAGE.equals(m.getName())).filter(m -> m.getReturnType().equals(String.class)).filter(m -> Objects.isNull(m.getDeclaredAnnotation(AliasFor.class))).findFirst().ifPresent(m -> params.message((String)m.getDefaultValue()));
        Holder messages = Holder.blank();
        Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> MESSAGES.equals(m.getName())).filter(m -> m.getReturnType().equals(String[].class)).filter(m -> Objects.isNull(m.getDeclaredAnnotation(AliasFor.class))).findFirst().ifPresent(m -> messages.set(List.of((String[])m.getDefaultValue())));
        if (messages.isEmpty()) {
            Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getReturnType().equals(String.class)).filter(m -> Tools.nullCheck(m.getDeclaredAnnotation(AliasFor.class), a -> MESSAGES.equals(a.value()), false)).forEach(m -> {
                int order = m.getDeclaredAnnotation(AliasFor.class).order();
                if (messages.isEmpty()) {
                    messages.set(new ArrayList());
                }
                String value = Objects.nonNull(m.getDefaultValue()) ? m.getDefaultValue().toString() : "(%s) Invalid value!";
                List msgs = (List)messages.get();
                for (int i = msgs.size(); i <= order; ++i) {
                    msgs.add(null);
                }
                msgs.set(order, value);
            });
        }
        Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> TARGETS.equals(m.getName())).filter(m -> m.getReturnType().equals(Class[].class)).filter(m -> Objects.isNull(m.getDeclaredAnnotation(AliasFor.class))).findFirst().ifPresent(m -> params.targets(this.processTargetsClass((Class[])m.getDefaultValue())));
        parOrder.stream().filter(p -> !p.alt).forEach(p -> list.add(this.checkAsCode(p.getValue(), p.getAnnotation())));
        int msgs = 0;
        for (Node node : annotation.getChildNodes()) {
            if (node instanceof Name) continue;
            if (node instanceof MemberValuePair) {
                MemberValuePair pair = (MemberValuePair)node;
                switch (Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getName().equals(pair.getNameAsString())).map(m -> m.getDeclaredAnnotation(AliasFor.class)).filter(Objects::nonNull).map(AliasFor::value).findFirst().orElseGet(() -> ((MemberValuePair)pair).getNameAsString())) {
                    case "value": {
                        params.cls(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                    case "message": {
                        params.message(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "messages": {
                        if (pair.getValue().isArrayInitializerExpr()) {
                            params.messages(pair.getValue().asArrayInitializerExpr().getValues().stream().map(e -> e.asStringLiteralExpr().asString()).collect(Collectors.toList()));
                            break;
                        }
                        if (pair.getValue().isStringLiteralExpr()) {
                            String msg = pair.getValue().asStringLiteralExpr().asString();
                            if (messages.isEmpty()) {
                                messages.set(new ArrayList());
                            }
                            if (msgs < ((List)messages.get()).size()) {
                                ((List)messages.get()).set(msgs, msg);
                            } else {
                                ((List)messages.get()).add(msg);
                            }
                            ++msgs;
                            break;
                        }
                        if (pair.getValue().isBinaryExpr()) {
                            if (messages.isEmpty()) {
                                messages.set(new ArrayList());
                            }
                            if (msgs < ((List)messages.get()).size()) {
                                ((List)messages.get()).set(msgs, pair.getValue());
                            } else {
                                ((List)messages.get()).add(pair.getValue());
                            }
                            ++msgs;
                            break;
                        }
                        log.warn("Unhandled expression ({}) in {}", (Object)pair.getValue(), (Object)field.getParsed().getPrototypeClassName());
                        break;
                    }
                    case "asCode": {
                        params.asCode(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "targets": {
                        params.targets(this.processTargets(pair.getValue()));
                        break;
                    }
                    case "params": {
                        if (pair.getValue().isArrayInitializerExpr()) {
                            list.addAll(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).toList());
                            break;
                        }
                        int idx = this.getParamIndex(parOrder, pair.getNameAsString());
                        if (idx != -1) {
                            ParamHolder triple = parOrder.get(idx);
                            if (triple.isAlt()) {
                                list.set(triple.getOrder(), this.checkAsCode(this.getParamValue(pair.getValue()), triple.getAnnotation()));
                                break;
                            }
                            list.set(idx, this.checkAsCode(this.getParamValue(pair.getValue()), triple.getAnnotation()));
                            break;
                        }
                        throw new GenericCodeGenException("Invalid annotation params! " + annotation);
                    }
                }
                continue;
            }
            if (node instanceof LiteralExpr) {
                LiteralExpr exp = (LiteralExpr)node;
                this.handleExpression(annotation, annotationClass, params, list, parOrder, this.getParamValue((Expression)exp));
                continue;
            }
            if (node instanceof NameExpr) {
                NameExpr exp = (NameExpr)node;
                this.handleExpression(annotation, annotationClass, params, list, parOrder, node);
                annotation.findCompilationUnit().flatMap(unit -> Helpers.getStaticImportIfExists(unit, exp.getNameAsString())).ifPresent(i -> field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(i, true, false)));
                continue;
            }
            if (node instanceof FieldAccessExpr) {
                FieldAccessExpr exp = (FieldAccessExpr)node;
                annotation.findCompilationUnit().flatMap(unit -> Optional.ofNullable(Helpers.getExternalClassNameIfExists((Node)unit, exp.getScope().toString()))).ifPresent(cls -> Tools.with(Helpers.lookup.findParsed((String)cls), p -> {
                    PrototypeConstant c = p.getConstants().get(exp.getNameAsString());
                    if (Objects.nonNull(c)) {
                        field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport((String)c.getDestination().getFullyQualifiedName().get()));
                        Expression e = EnrichHelpers.expression(c.getDestination().getNameAsString() + "." + c.getName());
                        this.handleExpression(annotation, annotationClass, params, list, parOrder, e);
                    } else {
                        log.warn("Unknown constant {} on class {}", (Object)exp.getNameAsString(), cls);
                    }
                }, () -> {
                    field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(cls));
                    this.handleExpression(annotation, annotationClass, params, list, parOrder, exp);
                }));
                continue;
            }
            if (node instanceof BinaryExpr) {
                this.handleExpression(annotation, annotationClass, params, list, parOrder, node);
                continue;
            }
            log.warn("Unhandled expression ({}) in {}", (Object)node.toString(), (Object)field.getParsed().getPrototypeClassName());
        }
        if (!list.isEmpty()) {
            params.params(list);
        }
        params.messages = this.convert((List)messages.get(), parOrder);
        params.message = (String)this.convert(params.message, parOrder);
    }

    private List<Object> convert(List<Object> messages, List<ParamHolder> params) {
        if (Objects.nonNull(messages)) {
            messages.replaceAll(message -> this.convert(message, params));
        }
        return messages;
    }

    private Object convert(Object message, List<ParamHolder> params) {
        if (message instanceof String) {
            String s = (String)message;
            return ContextInterpolator.of(param -> params.stream().filter(p -> !VALUE.equals(p.getName())).filter(p -> p.getName().equals(param)).findFirst().map(paramHolder -> "param[" + paramHolder.getOrder() + "]").orElse(param)).interpolate(s);
        }
        return message;
    }

    protected int paramHolderOrder(ParamHolder obj) {
        return obj.getOrder() * 10 + (obj.alt ? 1 : 0);
    }

    protected void handleExpression(AnnotationExpr annotation, Class<?> annotationClass, Params.ParamsBuilder params, ArrayList<Object> list, List<ParamHolder> parOrder, Object exp) {
        switch (Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getName().equals(VALUE)).map(m -> m.getDeclaredAnnotation(AliasFor.class)).filter(Objects::nonNull).map(AliasFor::value).findFirst().orElse(VALUE)) {
            case "value": {
                params.cls(exp.toString());
                break;
            }
            case "message": {
                params.message(exp.toString());
                break;
            }
            case "asCode": {
                params.asCode(exp.toString());
                break;
            }
            case "params": {
                int idx = this.getParamIndex(parOrder, VALUE);
                if (idx != -1) {
                    ParamHolder triple = parOrder.get(idx);
                    if (Objects.nonNull(triple.getAnnotation())) {
                        if (triple.isAlt()) {
                            list.set(triple.getOrder(), this.checkAsCode(exp, triple.getAnnotation()));
                            break;
                        }
                        list.set(idx, this.checkAsCode(exp, triple.getAnnotation()));
                        break;
                    }
                    if (triple.isAlt()) {
                        list.set(triple.getOrder(), exp);
                        break;
                    }
                    list.set(idx, exp);
                    break;
                }
                throw new GenericCodeGenException("Invalid annotation params! " + annotation);
            }
        }
    }

    protected Object checkAsCode(Object value, AsCode code) {
        if (Objects.nonNull(code)) {
            return AsCodeHolder.builder().value((String)value).format(code.value()).build();
        }
        return value;
    }

    protected Object getParamValue(Expression value) {
        if (value.isStringLiteralExpr()) {
            return value.asStringLiteralExpr().asString();
        }
        if (value.isIntegerLiteralExpr()) {
            return value.asIntegerLiteralExpr().asNumber();
        }
        if (value.isDoubleLiteralExpr()) {
            return value.asDoubleLiteralExpr().asDouble();
        }
        if (value.isBooleanLiteralExpr()) {
            return value.asBooleanLiteralExpr().getValue();
        }
        if (value.isBinaryExpr()) {
            return value;
        }
        return null;
    }

    protected int getParamIndex(List<ParamHolder> list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(list.get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    protected void generateValidation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass, MethodDeclaration form, boolean collection, boolean mixIn) {
        Params params = this.getValidationParams(field, annotation, ann, annotationClass);
        field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(Helpers.getExternalClassName((Node)annotationClass.findCompilationUnit().get(), params.getCls())));
        this.generateValidation(description, field, params, form, collection, mixIn);
    }

    protected void generateValidation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass, MethodDeclaration form, boolean collection, boolean mixIn) {
        this.generateValidation(description, field, this.getValidationParams(field, annotation, annotationClass), form, collection, mixIn);
    }

    protected void generateValidation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, Params params, MethodDeclaration form, boolean collection, boolean mixIn) {
        if (!mixIn && Objects.nonNull(field.getImplementationSetter())) {
            this.addValidation(field, field.getImplementationSetter(), params, ModifierType.MAIN, collection);
        }
        field.getModifiers().stream().filter(m -> collection || !ModifierType.COLLECTION.equals((Object)m.getType())).filter(m -> !mixIn || m.getOrigin().equals(description)).forEach(modifier -> this.addValidation(field, modifier.getModifier(), params, modifier.getType(), collection && !modifier.getType().equals((Object)ModifierType.COLLECTION)));
        if (!mixIn && description.hasOption(Options.VALIDATION_FORM)) {
            this.addValidation(field, form, params, ModifierType.FORM, collection);
        }
    }

    protected void addValidation(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier, boolean collection) {
        this.handleImport(field, params);
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        Statement start = this.findStart((Node)block);
        if (Objects.isNull(start)) {
            StringBuilder exp = new StringBuilder("Validation.start(this.getClass(), \"").append(field.getName()).append("\", ").append(ModifierType.COLLECTION.equals((Object)modifier) ? VALUE : field.getName()).append(").validate").append(Objects.nonNull(params.getMessages()) ? "WithMessages" : "").append(collection ? "Collection(" : "(").append(params.getCls()).append(".class, ").append(this.calcMessage(params)).append(this.buildParamsStr(params, field, modifier, collection)).append(")");
            ValidationEnricherHandler.handleStartingExpression(modifier, block, exp);
        } else {
            this.handleChainExpression(field, params, modifier, collection, start.asExpressionStmt(), "validate");
        }
        if (Objects.nonNull(params.annotation)) {
            Helpers.handleImports((Node)params.annotation, field.getParsed().getImplementation());
        }
    }

    protected void handleImport(PrototypeField field, Params params) {
        PrototypeDescription<ClassOrInterfaceDeclaration> parsed = field.getParsed();
        CompilationUnit u = parsed.getImplementationUnit();
        if (Objects.nonNull(parsed.getMixIn())) {
            u = parsed.getMixIn().getImplementationUnit();
        } else if (parsed.isNested()) {
            PrototypeDescription<ClassOrInterfaceDeclaration> parent;
            while (Objects.nonNull(parsed.getParentClassName()) && Objects.nonNull(parent = this.lookup.findParsed(parsed.getParentClassName()))) {
                u = parent.getImplementationUnit();
                parsed = parent;
            }
        }
        u.addImport("net.binis.codegen.validation.flow.Validation").addImport(params.getFull());
    }

    protected void addSanitization(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier, boolean collection) {
        this.handleImport(field, params);
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        Statement start = this.findStart((Node)block);
        if (Objects.isNull(start)) {
            StringBuilder exp = new StringBuilder("Validation.start(this.getClass(), \"").append(field.getName()).append("\", ").append(ModifierType.COLLECTION.equals((Object)modifier) ? VALUE : field.getName()).append(").sanitize").append(collection ? "Collection(" : "(").append(params.getCls()).append(".class").append(this.buildParamsStr(params, field, modifier, collection)).append(")");
            ValidationEnricherHandler.handleStartingExpression(modifier, block, exp);
        } else {
            this.handleChainExpression(field, params, modifier, collection, start.asExpressionStmt(), "sanitize");
        }
        if (Objects.nonNull(params.annotation)) {
            Helpers.handleImports((Node)params.annotation, field.getParsed().getImplementation());
        }
    }

    protected void generateExecution(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass, boolean collection, boolean mixIn) {
        Params params = this.getExecutionParams(field, annotation, ann, annotationClass);
        field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(Helpers.getExternalClassName((Node)annotationClass.findCompilationUnit().get(), params.getCls())));
        this.generateExecution(description, field, params, collection, mixIn);
    }

    protected void generateExecution(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass, boolean collection, boolean mixIn) {
        this.generateExecution(description, field, this.getExecutionParams(field, annotation, annotationClass), collection, mixIn);
    }

    protected void generateExecution(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, Params params, boolean collection, boolean mixIn) {
        if (!mixIn && Objects.nonNull(field.getImplementationSetter())) {
            this.addExecution(field, field.getImplementationSetter(), params, ModifierType.MAIN, collection);
        }
        field.getModifiers().stream().filter(m -> !mixIn || m.getOrigin().equals(description)).forEach(modifier -> this.addExecution(field, modifier.getModifier(), params, modifier.getType(), collection));
    }

    protected void addExecution(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier, boolean collection) {
        this.handleImport(field, params);
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        Statement start = this.findStart((Node)block);
        if (Objects.isNull(start)) {
            StringBuilder exp = new StringBuilder("Validation.start(this.getClass(), \"").append(field.getName()).append("\", ").append(field.getName()).append(").execute").append(collection ? "Collection(" : "(").append(params.getCls()).append(".class, ").append(this.calcMessage(params)).append(this.buildParamsStr(params, field, modifier, collection)).append(")");
            ValidationEnricherHandler.handleStartingExpression(modifier, block, exp);
        } else {
            this.handleChainExpression(field, params, modifier, collection, start.asExpressionStmt(), "execute");
        }
        if (Objects.nonNull(params.annotation)) {
            Helpers.handleImports((Node)params.annotation, field.getParsed().getImplementation());
        }
    }

    protected Params getExecutionParams(PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        this.handleExecutionAnnotation(ann, params);
        return this.checkTargets(params.build(), field);
    }

    protected Params getExecutionParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        String cls = null;
        if (!Execute.class.equals(annotationClass)) {
            Execute ann = annotationClass.getDeclaredAnnotation(Execute.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params())).targets(this.processTargetsClass(ann.targets()));
            cls = ann.value().getCanonicalName();
            EnrichHelpers.unit((Node)field.getDeclaration()).addImport(cls);
            this.handleAliases(field, annotation, annotationClass, params);
        } else {
            this.handleExecutionAnnotation(annotation, params);
        }
        Params result = this.checkTargets(params.build(), field);
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass(Objects.isNull(cls) ? Helpers.getExternalClassName((Node)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    protected void handleExecutionAnnotation(AnnotationExpr annotation, Params.ParamsBuilder params) {
        for (Node node : annotation.getChildNodes()) {
            if (node instanceof ClassExpr) {
                ClassExpr exp = (ClassExpr)node;
                params.cls(exp.getTypeAsString());
                continue;
            }
            if (!(node instanceof MemberValuePair)) continue;
            MemberValuePair pair = (MemberValuePair)node;
            switch (pair.getNameAsString()) {
                case "value": {
                    String cls = pair.getValue().asClassExpr().getTypeAsString();
                    params.cls(cls).full(Helpers.getExternalClassName((Node)pair, cls));
                    break;
                }
                case "message": {
                    params.message(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
                case "targets": {
                    params.targets(this.processTargets(pair.getValue()));
                    break;
                }
                case "params": {
                    params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                    break;
                }
                case "asCode": {
                    params.asCode(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
            }
        }
    }

    protected void handleChainExpression(PrototypeField field, Params params, ModifierType modifier, boolean collection, ExpressionStmt start, String method) {
        Expression chain;
        MethodCallExpr mCall = start.getExpression().asMethodCallExpr();
        if (!ModifierType.COLLECTION.equals((Object)modifier)) {
            chain = (Expression)mCall.getScope().get();
            mCall.removeScope();
        } else {
            chain = null;
        }
        MethodCallExpr m = (MethodCallExpr)new MethodCallExpr(chain, method + (Objects.nonNull(params.getMessages()) && "validate".equals(method) ? "WithMessages" : "") + (collection ? "Collection" : "")).addArgument(params.getCls() + ".class");
        if (!"sanitize".equals(method)) {
            m.addArgument(this.calcMessage(params));
        }
        Tools.notNull(params.getParams(), p -> p.forEach(param -> m.addArgument(this.buildParamsStr(param, params, field, modifier, collection))));
        if (!ModifierType.COLLECTION.equals((Object)modifier)) {
            mCall.setScope((Expression)m);
        } else {
            m.setScope((Expression)mCall);
            start.setExpression((Expression)m);
        }
    }

    protected static void handleStartingExpression(ModifierType modifier, BlockStmt block, StringBuilder exp) {
        if (ModifierType.COLLECTION.equals((Object)modifier)) {
            ReturnStmt ret = (ReturnStmt)block.findFirst(ReturnStmt.class).get();
            String s = ((NameExpr)ret.findFirst(NameExpr.class).get()).toString();
            exp.insert(0, ", value -> ").insert(0, s.substring(0, s.length() - 1)).append(");");
            Statement expr = EnrichHelpers.statement(exp.toString());
            ret.setExpression(((ExpressionStmt)expr).getExpression());
        } else {
            exp.append(".perform(v -> this.map = v);");
            Statement expr = EnrichHelpers.statement(exp.toString());
            Statement original = (Statement)block.getStatements().remove(0);
            ((ExpressionStmt)original).getExpression().asAssignExpr().setValue((Expression)new NameExpr("v"));
            MethodCallExpr mCall = expr.asExpressionStmt().getExpression().asMethodCallExpr();
            ((LambdaExpr)mCall.getChildNodes().get(mCall.getChildNodes().size() - 1)).setBody(original);
            block.getStatements().add(0, (Node)expr);
        }
    }

    protected Statement findStart(Node node) {
        Optional lambda = node.findFirst(LambdaExpr.class);
        if (lambda.isPresent() && ((LambdaExpr)lambda.get()).getExpressionBody().isPresent() && Objects.nonNull(this.findStartMethod((Node)((LambdaExpr)lambda.get()).getExpressionBody().get()))) {
            return ((LambdaExpr)lambda.get()).getBody();
        }
        return node.findAll(ExpressionStmt.class).stream().filter(s -> Objects.nonNull(this.findStartMethod((Node)s))).findFirst().orElse(null);
    }

    protected MethodCallExpr findStartMethod(Node node) {
        MethodCallExpr result = null;
        List list = node.findAll(MethodCallExpr.class);
        for (MethodCallExpr m : list) {
            Optional scope = m.getScope();
            if (!scope.isPresent()) continue;
            if (m.getNameAsString().equals("start") && ((Expression)scope.get()).isNameExpr() && ((Expression)scope.get()).asNameExpr().getNameAsString().equals("Validation")) {
                return m;
            }
            result = this.findStartMethod((Node)scope.get());
            if (!Objects.nonNull(result)) continue;
            break;
        }
        return result;
    }

    protected String calcMessage(Params params) {
        if (Objects.nonNull(params.getMessages())) {
            return "new String[] {" + params.messages.stream().map(s -> {
                Object object;
                if (s instanceof String) {
                    String str = (String)s;
                    object = "\"" + StringEscapeUtils.escapeJava((String)str) + "\"";
                } else {
                    object = s.toString();
                }
                return object;
            }).collect(Collectors.joining(", ")) + "}";
        }
        return Objects.isNull(params.getMessage()) ? "null" : "\"" + StringEscapeUtils.escapeJava((String)params.getMessage()) + "\"";
    }

    protected String buildParamsStr(Params params, PrototypeField field, ModifierType modifier, boolean collection) {
        List<Object> list = params.getParams();
        if (Objects.isNull(list) || list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (Objects.nonNull(params.getAsCode()) && list.size() == 1 && list.get(0) instanceof String) {
            this.formatCode(field, modifier, result, (String)list.get(0), params.getAsCode(), collection);
        } else {
            for (Object param : list) {
                if (param instanceof String) {
                    String p = (String)param;
                    result.append(", \"").append(StringEscapeUtils.escapeJava((String)p)).append("\"");
                    continue;
                }
                if (param instanceof AsCodeHolder) {
                    AsCodeHolder holder = (AsCodeHolder)param;
                    String format = "%s".equals(holder.getFormat()) && !StringUtils.isBlank((CharSequence)params.getAsCode()) ? params.getAsCode() : holder.getFormat();
                    this.formatCode(field, modifier, result, holder.getValue(), format, collection);
                    continue;
                }
                result.append(", ").append(Objects.nonNull(param) ? param.toString() : "null");
            }
        }
        return result.toString();
    }

    protected void formatCode(PrototypeField field, ModifierType modifier, StringBuilder result, String value, String format, boolean collection) {
        Optional args;
        Type type = field.getDeclaration().getVariable(0).getType();
        if ((collection || ModifierType.COLLECTION.equals((Object)modifier)) && type.isClassOrInterfaceType() && (args = type.asClassOrInterfaceType().getTypeArguments()).isPresent() && !((NodeList)args.get()).isEmpty()) {
            type = (Type)((NodeList)args.get()).get(0);
        }
        result.append(", ").append(String.format(format.replaceAll("\\{type}", type.toString()), value.replaceAll("\\{type}", type.toString()).replaceAll("\\{entity}", (String)(ModifierType.MODIFIER.equals((Object)modifier) ? "(" + ((ClassOrInterfaceDeclaration)field.getDeclaration().findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).get()).getNameAsString() + ")" : "") + modifier.getValue())));
    }

    protected String buildParamsStr(Object param, Params params, PrototypeField field, ModifierType modifier, boolean collection) {
        if (param instanceof String) {
            String p = (String)param;
            return "\"" + StringEscapeUtils.escapeJava((String)p) + "\"";
        }
        if (param instanceof AsCodeHolder) {
            Optional args;
            AsCodeHolder holder = (AsCodeHolder)param;
            String format = "%s".equals(holder.getFormat()) && !StringUtils.isBlank((CharSequence)params.getAsCode()) ? params.getAsCode() : holder.getFormat();
            Type type = field.getDeclaration().getVariable(0).getType();
            if ((collection || ModifierType.COLLECTION.equals((Object)modifier)) && type.isClassOrInterfaceType() && (args = type.asClassOrInterfaceType().getTypeArguments()).isPresent() && !((NodeList)args.get()).isEmpty()) {
                type = (Type)((NodeList)args.get()).get(0);
            }
            return String.format(format.replaceAll("\\{type}", type.toString()), holder.getValue());
        }
        return Objects.nonNull(param) ? param.toString() : "null";
    }

    protected boolean isValidationAnnotation(AnnotationExpr annotation) {
        String name = Helpers.getExternalClassNameIfExists((Node)annotation.findCompilationUnit().get(), annotation.getNameAsString());
        PrototypeDescription<ClassOrInterfaceDeclaration> external = this.lookup.findExternal(name);
        if (Objects.nonNull(external)) {
            return Tools.withRes(external.getDeclaration(), decl -> decl.isAnnotationPresent(Validate.class) || decl.isAnnotationPresent(Sanitize.class) || decl.isAnnotationPresent(Execute.class));
        }
        return Tools.withRes(Reflection.loadClass((String)name), cls -> Validate.class.equals(cls) || cls.isAnnotationPresent(Validate.class) || Sanitize.class.equals(cls) || cls.isAnnotationPresent(Sanitize.class) || Execute.class.equals(cls) || cls.isAnnotationPresent(Execute.class), false);
    }

    protected void buildValidationForm(PrototypeDescription<ClassOrInterfaceDeclaration> description, StringBuilder form) {
        if (form.length() > 0) {
            form.setLength(form.lastIndexOf(","));
            form.append("); }");
            if (description.hasOption(Options.EXPOSE_VALIDATE_METHOD)) {
                description.getInterface().addExtendedType("Validatable");
                description.getInterface().findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.Validatable"));
            } else {
                description.getImplementation().addImplementedType("Validatable");
                description.getImplementation().findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.Validatable"));
            }
            description.getImplementation().findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.flow.Validation"));
            description.getImplementation().addMethod("validate", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setBody(EnrichHelpers.block("{ Validation.form(this.getClass(), " + form));
            Helpers.addSuppressWarningsUnchecked((NodeWithAnnotations)description.getImplementation());
        }
    }

    protected MethodDeclaration formMethod(PrototypeField field) {
        MethodDeclaration result = new MethodDeclaration();
        result.setBody(EnrichHelpers.block("{ " + field.getName() + " = v; }"));
        return result;
    }

    protected List<String> processTargets(Expression value) {
        if (value instanceof ClassExpr) {
            ClassExpr expr = (ClassExpr)value;
            return List.of(Helpers.getExternalClassName((Node)expr, expr.getType().asString()));
        }
        if (value instanceof ArrayInitializerExpr) {
            ArrayInitializerExpr expr = (ArrayInitializerExpr)value;
            return expr.getValues().stream().filter(ClassExpr.class::isInstance).map(ClassExpr.class::cast).map(e -> Helpers.getExternalClassName((Node)e, e.getType().asString())).toList();
        }
        return List.of();
    }

    protected List<String> processTargetsClass(Class[] value) {
        ArrayList<String> result = new ArrayList<String>();
        for (Class cls : value) {
            if (Objects.nonNull(TARGETS_AWARE) && TARGETS_AWARE.isAssignableFrom(cls)) {
                Tools.with(CodeFactory.create((Class)cls, (Object[])new Object[0]), inst -> Arrays.stream((Class[])Reflection.invoke((String)TARGETS, (Object)inst, (Object[])new Object[0])).map(Class::getCanonicalName).forEach(result::add));
                continue;
            }
            result.add(cls.getCanonicalName());
        }
        return result;
    }

    protected Params checkTargets(Params params, PrototypeField field) {
        if (Objects.nonNull(params.getTargets()) && !params.getTargets().isEmpty()) {
            Holder cls = Holder.of((Object)field.getFullType());
            if (field.isCollection()) {
                cls.set((Object)Helpers.getExternalClassName((Node)field.getDescription(), ((Type)((NodeList)field.getType().asClassOrInterfaceType().getTypeArguments().get()).get(0)).toString()));
            }
            if (params.getTargets().stream().noneMatch(c -> c.equals(cls.get()))) {
                Element element = field.getParsed().findElement(field.getParsed().getPrototypeElement(), field.getName(), ElementKind.METHOD);
                this.error("Target '" + cls + "' is not in the list of allowed targets for '" + params.getCls() + "': " + params.getTargets(), element);
            }
        }
        return params;
    }

    protected static class Params {
        protected String full;
        protected String cls;
        protected String message;
        protected List<Object> messages;
        protected List<Object> params;
        protected List<String> targets;
        protected String asCode;
        protected CompilationUnit annotation;

        Params(String full, String cls, String message, List<Object> messages, List<Object> params, List<String> targets, String asCode, CompilationUnit annotation) {
            this.full = full;
            this.cls = cls;
            this.message = message;
            this.messages = messages;
            this.params = params;
            this.targets = targets;
            this.asCode = asCode;
            this.annotation = annotation;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public String getFull() {
            return this.full;
        }

        public String getCls() {
            return this.cls;
        }

        public String getMessage() {
            return this.message;
        }

        public List<Object> getMessages() {
            return this.messages;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public List<String> getTargets() {
            return this.targets;
        }

        public String getAsCode() {
            return this.asCode;
        }

        public CompilationUnit getAnnotation() {
            return this.annotation;
        }

        public void setFull(String full) {
            this.full = full;
        }

        public void setCls(String cls) {
            this.cls = cls;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setMessages(List<Object> messages) {
            this.messages = messages;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }

        public void setTargets(List<String> targets) {
            this.targets = targets;
        }

        public void setAsCode(String asCode) {
            this.asCode = asCode;
        }

        public void setAnnotation(CompilationUnit annotation) {
            this.annotation = annotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Params)) {
                return false;
            }
            Params other = (Params)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$full = this.getFull();
            String other$full = other.getFull();
            if (this$full == null ? other$full != null : !this$full.equals(other$full)) {
                return false;
            }
            String this$cls = this.getCls();
            String other$cls = other.getCls();
            if (this$cls == null ? other$cls != null : !this$cls.equals(other$cls)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            List<Object> this$messages = this.getMessages();
            List<Object> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            List<Object> this$params = this.getParams();
            List<Object> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            List<String> this$targets = this.getTargets();
            List<String> other$targets = other.getTargets();
            if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
                return false;
            }
            String this$asCode = this.getAsCode();
            String other$asCode = other.getAsCode();
            if (this$asCode == null ? other$asCode != null : !this$asCode.equals(other$asCode)) {
                return false;
            }
            CompilationUnit this$annotation = this.getAnnotation();
            CompilationUnit other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Params;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $full = this.getFull();
            result = result * 59 + ($full == null ? 43 : $full.hashCode());
            String $cls = this.getCls();
            result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            List<Object> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            List<Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            List<String> $targets = this.getTargets();
            result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
            String $asCode = this.getAsCode();
            result = result * 59 + ($asCode == null ? 43 : $asCode.hashCode());
            CompilationUnit $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.Params(full=" + this.getFull() + ", cls=" + this.getCls() + ", message=" + this.getMessage() + ", messages=" + this.getMessages() + ", params=" + this.getParams() + ", targets=" + this.getTargets() + ", asCode=" + this.getAsCode() + ", annotation=" + this.getAnnotation() + ")";
        }

        public static class ParamsBuilder {
            private String full;
            private String cls;
            private String message;
            private List<Object> messages;
            private List<Object> params;
            private List<String> targets;
            private String asCode;
            private CompilationUnit annotation;

            ParamsBuilder() {
            }

            public ParamsBuilder full(String full) {
                this.full = full;
                return this;
            }

            public ParamsBuilder cls(String cls) {
                this.cls = cls;
                return this;
            }

            public ParamsBuilder message(String message) {
                this.message = message;
                return this;
            }

            public ParamsBuilder messages(List<Object> messages) {
                this.messages = messages;
                return this;
            }

            public ParamsBuilder params(List<Object> params) {
                this.params = params;
                return this;
            }

            public ParamsBuilder targets(List<String> targets) {
                this.targets = targets;
                return this;
            }

            public ParamsBuilder asCode(String asCode) {
                this.asCode = asCode;
                return this;
            }

            public ParamsBuilder annotation(CompilationUnit annotation) {
                this.annotation = annotation;
                return this;
            }

            public Params build() {
                return new Params(this.full, this.cls, this.message, this.messages, this.params, this.targets, this.asCode, this.annotation);
            }

            public String toString() {
                return "ValidationEnricherHandler.Params.ParamsBuilder(full=" + this.full + ", cls=" + this.cls + ", message=" + this.message + ", messages=" + this.messages + ", params=" + this.params + ", targets=" + this.targets + ", asCode=" + this.asCode + ", annotation=" + this.annotation + ")";
            }
        }
    }

    protected static class ParamHolder {
        protected String name;
        protected Object value;
        protected AsCode annotation;
        protected int order;
        protected boolean alt;

        ParamHolder(String name, Object value, AsCode annotation, int order, boolean alt) {
            this.name = name;
            this.value = value;
            this.annotation = annotation;
            this.order = order;
            this.alt = alt;
        }

        public static ParamHolderBuilder builder() {
            return new ParamHolderBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public AsCode getAnnotation() {
            return this.annotation;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isAlt() {
            return this.alt;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setAnnotation(AsCode annotation) {
            this.annotation = annotation;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setAlt(boolean alt) {
            this.alt = alt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamHolder)) {
                return false;
            }
            ParamHolder other = (ParamHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            if (this.isAlt() != other.isAlt()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            AsCode this$annotation = this.getAnnotation();
            AsCode other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParamHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOrder();
            result = result * 59 + (this.isAlt() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            AsCode $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.ParamHolder(name=" + this.getName() + ", value=" + this.getValue() + ", annotation=" + this.getAnnotation() + ", order=" + this.getOrder() + ", alt=" + this.isAlt() + ")";
        }

        public static class ParamHolderBuilder {
            private String name;
            private Object value;
            private AsCode annotation;
            private int order;
            private boolean alt;

            ParamHolderBuilder() {
            }

            public ParamHolderBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ParamHolderBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public ParamHolderBuilder annotation(AsCode annotation) {
                this.annotation = annotation;
                return this;
            }

            public ParamHolderBuilder order(int order) {
                this.order = order;
                return this;
            }

            public ParamHolderBuilder alt(boolean alt) {
                this.alt = alt;
                return this;
            }

            public ParamHolder build() {
                return new ParamHolder(this.name, this.value, this.annotation, this.order, this.alt);
            }

            public String toString() {
                return "ValidationEnricherHandler.ParamHolder.ParamHolderBuilder(name=" + this.name + ", value=" + this.value + ", annotation=" + this.annotation + ", order=" + this.order + ", alt=" + this.alt + ")";
            }
        }
    }

    protected static class AsCodeHolder {
        protected String value;
        protected String format;

        AsCodeHolder(String value, String format) {
            this.value = value;
            this.format = format;
        }

        public static AsCodeHolderBuilder builder() {
            return new AsCodeHolderBuilder();
        }

        public String getValue() {
            return this.value;
        }

        public String getFormat() {
            return this.format;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsCodeHolder)) {
                return false;
            }
            AsCodeHolder other = (AsCodeHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsCodeHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.AsCodeHolder(value=" + this.getValue() + ", format=" + this.getFormat() + ")";
        }

        public static class AsCodeHolderBuilder {
            private String value;
            private String format;

            AsCodeHolderBuilder() {
            }

            public AsCodeHolderBuilder value(String value) {
                this.value = value;
                return this;
            }

            public AsCodeHolderBuilder format(String format) {
                this.format = format;
                return this;
            }

            public AsCodeHolder build() {
                return new AsCodeHolder(this.value, this.format);
            }

            public String toString() {
                return "ValidationEnricherHandler.AsCodeHolder.AsCodeHolderBuilder(value=" + this.value + ", format=" + this.format + ")";
            }
        }
    }
}

