/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.utils;

import java.util.List;
import javax.lang.model.element.Element;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGFieldAccess;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGMethodDeclaration;
import net.binis.codegen.compiler.CGMethodInvocation;
import net.binis.codegen.compiler.CGVariableDecl;
import net.binis.codegen.compiler.TreeMaker;
import net.binis.codegen.compiler.base.JavaCompilerObject;
import net.binis.codegen.compiler.utils.ElementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementMethodUtils
extends ElementUtils {
    private static final Logger log = LoggerFactory.getLogger(ElementMethodUtils.class);

    public static CGExpression createStaticMethodInvocation(Class<?> cls, String methodName, CGExpression ... params) {
        return ElementMethodUtils.createStaticMethodInvocation(cls.getCanonicalName(), methodName, params);
    }

    public static CGExpression createStaticMethodInvocation(String cls, String methodName, CGExpression ... params) {
        TreeMaker maker = TreeMaker.create();
        CGExpression method = ElementMethodUtils.chainDotsString(maker, cls + "." + methodName);
        return maker.Apply(CGList.nil(CGExpression.class), method, CGList.from((JavaCompilerObject[])params, CGExpression.class));
    }

    public static CGMethodInvocation createClassMethodInvocation(Class<?> cls, String methodName, CGExpression ... params) {
        TreeMaker maker = TreeMaker.create();
        CGFieldAccess method = maker.Select((CGExpression)ElementMethodUtils.toType(cls), maker.toName(methodName));
        return maker.Apply(CGList.nil(CGExpression.class), method, CGList.from((JavaCompilerObject[])params, CGExpression.class));
    }

    public static CGMethodInvocation createClassMethodInvocation(String cls, String methodName, CGExpression ... params) {
        TreeMaker maker = TreeMaker.create();
        CGExpression method = ElementMethodUtils.chainDotsString(maker, cls + ".class." + methodName);
        return maker.Apply(CGList.nil(CGExpression.class), method, CGList.from((JavaCompilerObject[])params, CGExpression.class));
    }

    public static boolean paramsMatch(Element e, List<String> list) {
        CGMethodDeclaration decl;
        CGList<CGVariableDecl> params;
        CGDeclaration cGDeclaration = ElementMethodUtils.getDeclaration(e);
        if (cGDeclaration instanceof CGMethodDeclaration && (params = (decl = (CGMethodDeclaration)cGDeclaration).getParameters()).size() == list.size()) {
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i).getFullVariableType().equals(list.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

