/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.test;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.test.BaseCodeTest;
import net.binis.codegen.test.TestClassLoader;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCodeGenTest
extends BaseCodeTest {
    private static final Logger log = LoggerFactory.getLogger(BaseCodeGenTest.class);

    @Override
    @BeforeEach
    public void beforeEach() {
        Helpers.cleanUp();
        CodeFactory.registerType(BaseCodeGenTest.class, () -> this);
    }

    @AfterEach
    public void afterEach() {
        CodeFactory.unregisterType(BaseCodeGenTest.class);
    }

    protected void generate() {
        ArrayList<PrototypeDescription<ClassOrInterfaceDeclaration>> parsed = new ArrayList<PrototypeDescription<ClassOrInterfaceDeclaration>>(Helpers.lookup.parsed());
        for (PrototypeDescription<ClassOrInterfaceDeclaration> entry : parsed) {
            if (entry.isProcessed()) continue;
            Generator.generateCodeForClass((CompilationUnit)entry.getDeclaration().findCompilationUnit().get(), entry);
        }
        Helpers.lookup.calcPrototypeMaps();
        Tools.with(Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).sorted(Helpers::sortForEnrich).toList(), list -> {
            list.forEach(Helpers::handleEnrichers);
            list.forEach(Helpers::finalizeEnrichers);
            list.forEach(Helpers::postProcessEnrichers);
        });
    }

    protected void compare(CompilationUnit unit, String resource) {
        if (Objects.nonNull(resource)) {
            Assertions.assertEquals((Object)this.resourceAsString(resource), (Object)this.getAsString(unit), (String)resource);
        }
    }

    protected void compare(CompilationUnit unit, TypeDeclaration type) {
        if (Objects.nonNull(type)) {
            Assertions.assertEquals((Object)this.getAsString((CompilationUnit)type.findCompilationUnit().get()), (Object)this.getAsString(unit), (String)type.getFullyQualifiedName().get().toString());
        }
    }

    protected TestClassLoader testSingleExecute(String prototype, String resClass, String resInterface, String resExecute) {
        return this.testSingleExecute(prototype, resClass, resInterface, null, 1, resExecute, false, false, false, new String[0]);
    }

    protected TestClassLoader testSingleExecute(String prototype, String resClass, String resInterface, int expected, String resExecute) {
        return this.testSingleExecute(prototype, resClass, resInterface, null, expected, resExecute, false, false, false, new String[0]);
    }

    protected TestClassLoader testSingleImplementation(String prototype, String resClass, int expected) {
        return this.testSingleExecute(prototype, resClass, null, null, expected, null, false, true, false, new String[0]);
    }

    protected TestClassLoader testSingleImplementation(String prototype, String resClass) {
        return this.testSingleExecute(prototype, resClass, null, null, 1, null, false, true, false, new String[0]);
    }

    protected TestClassLoader testSingle(String prototype, String resClass, String resInterface) {
        return this.testSingle(prototype, resClass, resInterface, null, 1);
    }

    protected TestClassLoader testSingleWithCustom(String prototype, String resClass, String resInterface, String ... custom) {
        return this.testSingleExecute(prototype, resClass, resInterface, null, 1, null, false, false, false, custom);
    }

    protected TestClassLoader testSingle(String prototype, String resClass, String resInterface, String pathToSave) {
        return this.testSingle(prototype, resClass, resInterface, pathToSave, 1);
    }

    protected TestClassLoader testSingle(String prototype, String resClass, String resInterface, int expected) {
        return this.testSingle(prototype, resClass, resInterface, null, expected);
    }

    protected TestClassLoader testSingleSkip(String prototype, String resClass, String resInterface, boolean skipPrototype, boolean skipCompilation) {
        return this.testSingleSkip(prototype, resClass, resInterface, 1, skipPrototype, skipCompilation);
    }

    protected TestClassLoader testSingleSkip(String prototype, String resClass, String resInterface, int expected, boolean skipPrototype, boolean skipCompilation) {
        return this.testSingleExecute(prototype, resClass, resInterface, null, expected, null, skipCompilation, false, skipPrototype, new String[0]);
    }

    protected TestClassLoader testSingle(String prototype, String resClass, String resInterface, int expected, boolean skipCompilation) {
        return this.testSingleExecute(prototype, resClass, resInterface, null, expected, null, skipCompilation, false, false, new String[0]);
    }

    protected TestClassLoader testSingle(String prototype, String resClass, String resInterface, String pathToSave, int expected) {
        return this.testSingleExecute(prototype, resClass, resInterface, pathToSave, expected, null, false, false, false, new String[0]);
    }

    protected TestClassLoader testSingleExecute(String prototype, String resClass, String resInterface, String pathToSave, int expected, String resExecute, boolean skipCompilation, boolean includePrototype, boolean skipPrototypeCompilation, String ... custom) {
        List<Pair<String, String>> list = this.newList();
        this.load(list, prototype);
        TestClassLoader protoLoader = null;
        if (!skipPrototypeCompilation) {
            protoLoader = new TestClassLoader();
            Assertions.assertTrue((boolean)this.compile(protoLoader, list, null, true, new String[0]));
        }
        this.generate();
        Assertions.assertEquals((int)expected, (int)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list2 = this.newList();
        if (includePrototype) {
            list2.add(list.get(0));
        }
        Map<String, TypeDeclaration> customTypes = this.loadCustom(custom);
        Helpers.lookup.parsed().forEach(p -> p.getCustomFiles().forEach((name, file) -> {
            if (Objects.nonNull(file.getJavaClass())) {
                String className = file.getJavaClass().getFullyQualifiedName().get().toString();
                TypeDeclaration type = (TypeDeclaration)customTypes.get(className);
                if (Objects.nonNull(type)) {
                    this.compare((CompilationUnit)file.getJavaClass().findCompilationUnit().get(), type);
                    list2.add(Pair.of((Object)className, (Object)this.getAsString((CompilationUnit)file.getJavaClass().findCompilationUnit().get())));
                } else {
                    Assertions.fail((String)("Can't find generated class: \n" + this.getAsString((CompilationUnit)file.getJavaClass().findCompilationUnit().get())));
                }
            }
        }));
        Stream<PrototypeDescription<ClassOrInterfaceDeclaration>> stream = Helpers.lookup.generated().stream();
        if (Helpers.lookup.generated().isEmpty()) {
            stream = Helpers.lookup.custom().stream();
        }
        stream.sorted((o1, o2) -> Boolean.compare(Objects.isNull(o1.getCompiled()), Objects.isNull(o2.getCompiled()))).forEach(parsed -> {
            if (Objects.isNull(parsed.getCompiled()) && (!parsed.isNested() || Objects.isNull(parsed.getParentClassName())) && !parsed.isExternal()) {
                if (Objects.nonNull(pathToSave)) {
                    this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                    this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
                }
                this.compare(parsed.getFiles().get(1), resInterface);
                this.compare(parsed.getFiles().get(0), resClass);
            }
            if (!parsed.isNested() || Objects.isNull(parsed.getParentClassName())) {
                if (!Helpers.classExists(parsed.getInterfaceFullName())) {
                    Tools.with(parsed.getFiles().get(1), file -> list2.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString((CompilationUnit)file))));
                }
                if (!Helpers.classExists(parsed.getParsedFullName())) {
                    Tools.with(parsed.getFiles().get(0), file -> list2.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString((CompilationUnit)file))));
                }
            }
        });
        if (!skipCompilation) {
            TestClassLoader loader = new TestClassLoader();
            Assertions.assertTrue((boolean)this.compile(loader, list2, resExecute, true, new String[0]));
            return loader;
        }
        return protoLoader;
    }

    protected Map<String, TypeDeclaration> loadCustom(String ... custom) {
        HashMap<String, TypeDeclaration> result = new HashMap<String, TypeDeclaration>();
        for (String file : custom) {
            String source = this.resourceAsString(file);
            Helpers.lookup.getParser().parse(source).ifSuccessful(unit -> result.put((String)unit.getType(0).getFullyQualifiedName().get(), unit.getType(0)));
        }
        return result;
    }

    protected TestClassLoader testMultiPass(List<Pair<List<Triple<String, String, String>>, Integer>> passes) {
        return this.testMultiPassExecute(passes, null, null);
    }

    protected TestClassLoader testMulti(List<Triple<String, String, String>> files) {
        return this.testMulti(files, null);
    }

    protected TestClassLoader testMulti(List<Triple<String, String, String>> files, int expected) {
        return this.testMultiExecute(files, expected, null, null, false);
    }

    protected TestClassLoader testMulti(List<Triple<String, String, String>> files, String pathToSave) {
        return this.testMultiExecute(files, files.size(), pathToSave, null, false);
    }

    protected TestClassLoader testMultiImplementation(List<Triple<String, String, String>> files) {
        return this.testMultiExecute(files, files.size(), null, null, true);
    }

    protected TestClassLoader testMultiExecute(List<Triple<String, String, String>> files, String resExecute) {
        return this.testMultiExecute(files, files.size(), null, resExecute, false);
    }

    protected TestClassLoader testMultiExecute(List<Triple<String, String, String>> files, int expected, String pathToSave, String resExecute, boolean includePrototype) {
        List<Pair<String, String>> list = this.newList();
        files.forEach(t -> this.load(list, (String)t.getLeft()));
        Assertions.assertTrue((boolean)this.compile(new TestClassLoader(), list, null, false, new String[0]));
        Helpers.lookup.registerExternalLookup(s -> list.stream().filter(e -> ((String)e.getLeft()).equals(s)).map(Pair::getRight).findFirst().orElse(null));
        this.generate();
        Assertions.assertEquals((int)expected, (int)Helpers.lookup.parsed().size());
        ArrayList<Pair<String, String>> compileList = new ArrayList<Pair<String, String>>();
        if (includePrototype) {
            compileList.addAll(list);
        }
        files.forEach(f -> Helpers.lookup.findGeneratedByFileName((String)f.getLeft()).forEach(parsed -> {
            block5: {
                block4: {
                    this.compare(parsed.getFiles().get(1), (String)f.getRight());
                    this.compare(parsed.getFiles().get(0), (String)f.getMiddle());
                    if (Objects.nonNull(pathToSave)) {
                        if (Objects.isNull(parsed.getMixIn())) {
                            this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                        }
                        this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
                    }
                    if (!Objects.isNull(parsed.getMixIn())) break block4;
                    if (parsed.isNested() && !Objects.isNull(parsed.getParentClassName())) break block5;
                    if (Objects.nonNull(parsed.getFiles().get(1))) {
                        compileList.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
                    }
                    compileList.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
                    break block5;
                }
                for (int i = 0; i < compileList.size(); ++i) {
                    if (!((String)((Pair)compileList.get(i)).getKey()).equals(parsed.getMixIn().getParsedFullName())) continue;
                    compileList.add(i, Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
                    break;
                }
            }
        }));
        TestClassLoader loader = new TestClassLoader();
        Assertions.assertTrue((boolean)this.compile(loader, compileList, resExecute, false, new String[0]));
        return loader;
    }

    protected TestClassLoader testMultiPassExecute(List<Pair<List<Triple<String, String, String>>, Integer>> passes, String pathToSave, String resExecute) {
        TestClassLoader loader = new TestClassLoader();
        List<Pair<String, String>> list = this.newList();
        ArrayList compileList = new ArrayList();
        passes.forEach(pass -> {
            List files = (List)pass.getKey();
            int expected = (Integer)pass.getValue();
            files.forEach(t -> this.load(list, (String)t.getLeft()));
            Assertions.assertTrue((boolean)this.compile(loader, list, null, false, new String[0]));
            this.generate();
            Assertions.assertEquals((int)expected, (int)Helpers.lookup.parsed().size());
            files.forEach(f -> Helpers.lookup.findGeneratedByFileName((String)f.getLeft()).forEach(parsed -> {
                block4: {
                    block3: {
                        this.compare(parsed.getFiles().get(1), (String)f.getRight());
                        this.compare(parsed.getFiles().get(0), (String)f.getMiddle());
                        if (Objects.nonNull(pathToSave)) {
                            if (Objects.isNull(parsed.getMixIn())) {
                                this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                            }
                            this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
                        }
                        if (!Objects.isNull(parsed.getMixIn())) break block3;
                        if (parsed.isNested() && !Objects.isNull(parsed.getParentClassName())) break block4;
                        Pair intf = Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1)));
                        compileList.add(intf);
                        list.add(intf);
                        compileList.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
                        break block4;
                    }
                    for (int i = 0; i < compileList.size(); ++i) {
                        if (!((String)((Pair)compileList.get(i)).getKey()).equals(parsed.getMixIn().getParsedFullName())) continue;
                        Pair intf = Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1)));
                        compileList.add(intf);
                        list.add(intf);
                        break;
                    }
                }
            }));
            Assertions.assertTrue((boolean)this.compile(loader, compileList, resExecute, false, new String[0]));
        });
        return loader;
    }

    protected void save(String name, CompilationUnit unit, String pathToSave) {
        String fileName = pathToSave + "/" + name + ".java";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            writer.write(this.getAsString(unit));
        }
        log.info("Saving - {}", (Object)fileName);
    }

    protected TestClassLoader testSingleWithBase(String basePrototype, String baseClassName, String prototype, String className, String baseClass, String baseInterface, String resClass, String resInterface) {
        List<Pair<String, String>> src = this.newList();
        this.load(src, basePrototype);
        this.load(src, prototype);
        TestClassLoader loader = new TestClassLoader();
        Assertions.assertTrue((boolean)this.compile(loader, src, null, false, new String[0]));
        this.generate();
        Assertions.assertEquals((int)2, (int)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list = this.newList();
        Tools.with(Helpers.lookup.findGenerated(baseClassName), parsed -> {
            this.compare(parsed.getFiles().get(0), baseClass);
            this.compare(parsed.getFiles().get(1), baseInterface);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        });
        Tools.with(Helpers.lookup.findGenerated(className), parsed -> {
            this.compare(parsed.getFiles().get(0), resClass);
            this.compare(parsed.getFiles().get(1), resInterface);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        });
        Assertions.assertTrue((boolean)this.compile(new TestClassLoader(), list, null, false, new String[0]));
        return loader;
    }

    protected TestClassLoader testSingleWithMixIn(String basePrototype, String baseClassName, String prototype, String className, String baseClass, String baseInterface, String mixInInterface) {
        List<Pair<String, String>> src = this.newList();
        this.load(src, basePrototype);
        this.load(src, prototype);
        Assertions.assertTrue((boolean)this.compile(new TestClassLoader(), src, null, false, new String[0]));
        this.generate();
        Assertions.assertEquals((int)2, (int)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list = this.newList();
        Tools.with(Helpers.lookup.findGenerated(baseClassName), parsed -> Tools.with(Helpers.lookup.findGenerated(className), parsedMixIn -> {
            this.compare(parsed.getFiles().get(1), baseInterface);
            this.compare(parsedMixIn.getFiles().get(1), mixInInterface);
            this.compare(parsed.getFiles().get(0), baseClass);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsedMixIn.getInterfaceFullName(), (Object)this.getAsString(parsedMixIn.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        }));
        TestClassLoader loader = new TestClassLoader();
        Assertions.assertTrue((boolean)this.compile(loader, list, null, false, new String[0]));
        return loader;
    }

    protected UnaryOperator<String> testSourcesLookup() {
        return s -> {
            try {
                return Files.readString(Path.of("./src/test/java/" + s.replace('.', '/') + ".java", new String[0]));
            }
            catch (Exception e) {
                return null;
            }
        };
    }
}

