/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;

public class EnrichHelpers {
    public static CompilationUnit unit(Node node) {
        return (CompilationUnit)node.findCompilationUnit().get();
    }

    public static BlockStmt block(String code) {
        return (BlockStmt)Helpers.lookup.getParser().parseBlock(code).getResult().get();
    }

    public static BlockStmt returnBlock(String variable) {
        return EnrichHelpers.block("{return " + variable + ";}");
    }

    public static Statement statement(String code) {
        return (Statement)Helpers.lookup.getParser().parseStatement(code).getResult().get();
    }

    public static Expression expression(String code) {
        return (Expression)Helpers.lookup.getParser().parseExpression(code).getResult().get();
    }

    public static AnnotationExpr annotation(String code) {
        return (AnnotationExpr)Helpers.lookup.getParser().parseAnnotation(code).getResult().get();
    }

    public static PrototypeField addField(PrototypeDescription<ClassOrInterfaceDeclaration> description, String name, String type) {
        return EnrichHelpers.addField(description, name, (Type)new ClassOrInterfaceType(type));
    }

    public static PrototypeField addField(PrototypeDescription<ClassOrInterfaceDeclaration> description, String name, Type type) {
        FieldDeclaration field = description.getImplementation().addField(type, name, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
        MethodDeclaration desc = ((MethodDeclaration)new MethodDeclaration().setName(name)).setType(type);
        Helpers.envelopWithDummyClass(desc);
        Structures.FieldData result = Structures.FieldData.builder().parsed((Structures.Parsed)description).declaration(field).description(desc).name(name).fullType(Helpers.getExternalClassNameIfExists((Node)description.getDeclarationUnit(), type.asString())).type(type).ignores(Structures.Ignores.builder().build()).build();
        description.getFields().add(result);
        return result;
    }

    public static PrototypeField addField(PrototypeDescription<ClassOrInterfaceDeclaration> description, String name, Class<?> type) {
        PrototypeField field = EnrichHelpers.addField(description, name, type.getSimpleName());
        field.getDescription().findCompilationUnit().ifPresent(unit -> unit.addImport(type));
        if (!type.isPrimitive() && !type.getPackageName().equals("java.lang")) {
            description.getDeclarationUnit().addImport(type);
        }
        return field;
    }

    private EnrichHelpers() {
    }
}

