/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import net.binis.codegen.annotation.type.GenerationStrategy;
import net.binis.codegen.discoverer.AnnotationDiscoverer;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.generation.core.ErrorHelpers;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Parsables;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.tools.CollectionUtils;
import net.binis.codegen.tools.Tools;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGen {
    private static final Logger log = LoggerFactory.getLogger(CodeGen.class);
    public static final String NONE = "<none>";
    public static final String SOURCE = "source";
    public static final String DESTINATION = "destination";
    public static final String CLASS_DESTINATION = "output";
    public static final String IMPL_DESTINATION = "idestination";
    public static final String FILTER = "filter";

    public static void main(String[] args) throws IOException {
        log.info("Class path: {}", (Object)System.getProperty("java.class.path"));
        AnnotationDiscoverer.findAnnotations().forEach(a -> Structures.registerTemplate(a.getCls()));
        CommandLine cmd = CodeGen.handleArgs(args);
        if (Objects.nonNull(cmd.getOptionValue(CLASS_DESTINATION))) {
            CodeGen.addGenerationFile(cmd.getOptionValue(CLASS_DESTINATION));
        }
        ArrayList<Path> files = new ArrayList<Path>();
        CodeGen.addTree(Paths.get(cmd.getOptionValue(SOURCE), new String[0]), files, cmd.getOptionValue(FILTER));
        CodeGen.processFiles(files);
        CompilationUnit constants = Generator.generateCodeForConstants();
        if (Objects.nonNull(constants)) {
            CodeGen.saveFile(cmd.getOptionValue(DESTINATION), constants);
        }
        String destination = cmd.getOptionValue(DESTINATION);
        String impl_destination = cmd.getOptionValue(IMPL_DESTINATION);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isProcessed).filter(p -> !p.isNested() || Objects.isNull(p.getParentClassName())).forEach(p -> CodeGen.saveParsed(destination, impl_destination, p));
        Helpers.lookup.custom().forEach(p -> CodeGen.saveParsed(destination, impl_destination, p));
    }

    private static void saveParsed(String destination, String impl_destination, PrototypeDescription<ClassOrInterfaceDeclaration> p) {
        if (p.getProperties().isGenerateImplementation() && Objects.isNull(p.getProperties().getMixInClass()) && Objects.isNull(p.getCompiled())) {
            CodeGen.saveFile(Tools.nullCheck(CodeGen.getBasePath(impl_destination, p.getProperties(), true), destination), p.getFiles().get(0));
        }
        if (p.getProperties().isGenerateInterface() && Objects.isNull(p.getCompiled())) {
            CodeGen.saveFile(CodeGen.getBasePath(destination, p.getProperties(), false), p.getFiles().get(1));
        }
    }

    public static void processFiles(List<Path> files) {
        JavaParser parser = Helpers.lookup.getParser();
        for (Path file : files) {
            try {
                String fileName = file.toAbsolutePath().toString();
                ParseResult parse = parser.parse(file);
                log.info("Parsed {} - {}", (Object)fileName, (Object)parse.toString());
                parse.getResult().ifPresent(u -> u.getTypes().forEach(t -> CodeGen.handleType(parser, t, fileName, null)));
            }
            catch (IOException e2) {
                log.error("Unable to parse {}", (Object)file.getFileName(), (Object)e2);
            }
        }
        Optional<PrototypeDescription> entry = Helpers.lookup.parsed().stream().filter(e -> !e.isProcessed() && !e.isInvalid()).findFirst();
        while (entry.isPresent()) {
            Generator.generateCodeForClass((CompilationUnit)entry.get().getDeclaration().findCompilationUnit().get(), entry.get());
            entry = Helpers.lookup.parsed().stream().filter(e -> !e.isProcessed() && !e.isInvalid()).findFirst();
        }
        Helpers.recursiveExpr.forEach(pair -> ((ClassExpr)pair.getRight()).setType(Helpers.findProperType((PrototypeDescription)pair.getLeft(), (CompilationUnit)pair.getMiddle(), (ClassExpr)pair.getRight())));
        Helpers.lookup.calcPrototypeMaps();
        Tools.with(Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).sorted(Helpers::sortForEnrich).toList(), list -> {
            list.forEach(Helpers::handleEnrichers);
            list.forEach(Helpers::finalizeEnrichers);
            list.forEach(Helpers::postProcessEnrichers);
        });
    }

    public static void processSources(Parsables files) {
        JavaParser parser = Helpers.lookup.getParser();
        for (Map.Entry<String, Parsables.Entry> file : files) {
            try {
                ParseResult parse = parser.parse(file.getKey());
                if (parse.getProblems().isEmpty()) {
                    CompilationUnit unit = (CompilationUnit)parse.getResult().get();
                    PackageDeclaration pack = (PackageDeclaration)unit.getPackageDeclaration().orElseThrow(() -> new GenericCodeGenException("'" + ((Parsables.Entry)file.getValue()).getFileName() + "' have no package declaration!"));
                    String fileName = pack.getNameAsString().replace('.', '/') + "/" + unit.getType(0).getNameAsString();
                    log.info("Parsed {} - {}", (Object)fileName, (Object)parse);
                    parse.getResult().ifPresent(u -> u.getTypes().forEach(t -> CodeGen.handleType(parser, t, fileName, ((Parsables.Entry)file.getValue()).getElements())));
                    continue;
                }
                log.warn("Unable to parse file {}! Some BinisCodeGen features might not be available!", (Object)file.getValue().getFileName());
            }
            catch (Exception e) {
                log.error("Unable to parse {}", (Object)file.getValue().getFileName(), (Object)e);
            }
        }
        for (PrototypeDescription entry : CollectionUtils.copyList(Helpers.lookup.parsed())) {
            if (entry.isProcessed()) continue;
            Generator.generateCodeForClass((CompilationUnit)entry.getDeclaration().findCompilationUnit().get(), entry);
        }
        Helpers.recursiveExpr.forEach(pair -> ((ClassExpr)pair.getRight()).setType(Helpers.findProperType((PrototypeDescription)pair.getLeft(), (CompilationUnit)pair.getMiddle(), (ClassExpr)pair.getRight())));
        Helpers.lookup.calcPrototypeMaps();
        Tools.with(Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).sorted(Helpers::sortForEnrich).toList(), list -> {
            list.forEach(Helpers::handleEnrichers);
            list.forEach(Helpers::finalizeEnrichers);
            list.forEach(Helpers::postProcessEnrichers);
        });
    }

    public static void handleType(JavaParser parser, TypeDeclaration<?> t, String fileName, List<Parsables.Entry.Bag> elements) {
        PackageDeclaration pack = (PackageDeclaration)((CompilationUnit)t.findCompilationUnit().get()).getPackageDeclaration().orElseThrow(() -> new GenericCodeGenException("'" + fileName + "' have no package declaration!"));
        String className = pack.getNameAsString() + "." + t.getNameAsString();
        if (t.getAnnotationByName("ConstantPrototype").isPresent()) {
            Helpers.constantParsed.put(Helpers.getClassName(t.asClassOrInterfaceDeclaration()), Structures.Parsed.builder().declaration(t.asTypeDeclaration()).declarationUnit(t.findCompilationUnit().orElse(null)).prototypeFileName(fileName).prototypeClassName(className).parser(parser).rawElements(elements).build());
        } else {
            String name = Helpers.getClassName(t);
            CodeGen.checkForNestedClasses(t.asTypeDeclaration(), fileName, parser, elements);
            Helpers.lookup.registerParsed(name, Structures.Parsed.builder().declaration(t.asTypeDeclaration()).declarationUnit(t.findCompilationUnit().orElse(null)).prototypeFileName(fileName).prototypeClassName(className).parser(parser).rawElements(elements).build());
        }
    }

    public static void checkForNestedClasses(TypeDeclaration<?> type, String fileName, JavaParser parser, List<Parsables.Entry.Bag> elements) {
        block2: {
            block3: {
                if (!type.isClassOrInterfaceDeclaration()) break block2;
                Optional<PrototypeData> properties = Generator.getCodeAnnotationProperties(type.asClassOrInterfaceDeclaration());
                if (properties.isEmpty()) break block3;
                if (GenerationStrategy.PROTOTYPE.equals((Object)properties.get().getStrategy())) break block2;
            }
            type.getChildNodes().stream().filter(ClassOrInterfaceDeclaration.class::isInstance).map(ClassOrInterfaceDeclaration.class::cast).forEach(nested -> {
                Optional<List<Pair<AnnotationExpr, Structures.PrototypeDataHandler>>> ann = Generator.getCodeAnnotations(nested);
                if (ann.isPresent()) {
                    if (nested.asClassOrInterfaceDeclaration().isInterface()) {
                        CompilationUnit parent = (CompilationUnit)type.findCompilationUnit().get();
                        String pack = ((PackageDeclaration)parent.getPackageDeclaration().get()).getNameAsString();
                        CompilationUnit unit = new CompilationUnit().setPackageDeclaration(pack + "." + type.getNameAsString());
                        ClassOrInterfaceDeclaration nestedType = nested.clone();
                        parent.getImports().forEach(arg_0 -> ((CompilationUnit)unit).addImport(arg_0));
                        unit.addType((TypeDeclaration)nestedType);
                        String cName = Helpers.getClassName(nestedType);
                        Helpers.lookup.registerParsed(cName, Structures.Parsed.builder().declaration(nestedType.asTypeDeclaration()).declarationUnit(unit).prototypeFileName(fileName).prototypeClassName(cName).parser(parser).nested(true).parentPackage(pack).build());
                    } else {
                        ann.get().forEach(prototype -> Tools.with(ErrorHelpers.calculatePrototypeAnnotationError(nested.asClassOrInterfaceDeclaration(), (PrototypeData)prototype.getValue()), message -> Helpers.lookup.error((String)message, Tools.withRes(elements, el -> el.stream().map(Parsables.Entry.Bag::getElement).filter(e -> ElementKind.CLASS.equals((Object)e.getKind()) && e.getSimpleName().toString().equals(nested.getNameAsString())).findFirst().orElse(null)))));
                    }
                }
            });
        }
    }

    private static void saveFile(String baseDir, CompilationUnit file) {
        CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
        Helpers.sortImports(file);
        if (file.getType(0).isClassOrInterfaceDeclaration()) {
            Helpers.sortClass(file.getType(0).asClassOrInterfaceDeclaration());
        }
        file.getPackageDeclaration().ifPresent(p -> {
            String fileName = baseDir + "/" + p.getNameAsString().replace(".", "/") + "/" + file.getType(0).getNameAsString() + ".java";
            log.info("Writing file - {}", (Object)fileName);
            File f = new File(fileName);
            if (f.getParentFile().exists() || f.getParentFile().mkdirs()) {
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                    writer.write(printer.print((Node)file));
                    writer.close();
                }
                catch (IOException e) {
                    log.error("Unable to open for write file {}", (Object)fileName);
                }
            } else {
                log.error("Unable to write file {}", (Object)fileName);
            }
        });
    }

    private static void addTree(Path directory, final Collection<Path> all, String filter) throws IOException {
        final PathMatcher pm = FileSystems.getDefault().getPathMatcher("glob:" + Tools.nullCheck(filter, "**"));
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!file.toFile().isDirectory() && pm.matches(file)) {
                    all.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static CommandLine handleArgs(String[] args) {
        Options options = new Options();
        Option input = new Option("s", SOURCE, true, "Sources root folder");
        input.setRequired(true);
        options.addOption(input);
        Option output = new Option("d", DESTINATION, true, "Destination folder");
        output.setRequired(true);
        options.addOption(output);
        Option iOutput = new Option("id", IMPL_DESTINATION, true, "Implementations Destination folder");
        iOutput.setRequired(false);
        options.addOption(iOutput);
        Option filter = new Option("f", FILTER, true, "File pattern filter");
        filter.setRequired(false);
        options.addOption(filter);
        Option clsOutput = new Option("o", CLASS_DESTINATION, true, "Classes output folder");
        clsOutput.setRequired(false);
        options.addOption(clsOutput);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            log.info("source: " + Tools.nullCheck(cmd.getOptionValue(SOURCE), NONE));
            log.info("destination: " + Tools.nullCheck(cmd.getOptionValue(DESTINATION), NONE));
            log.info("implementations destination: " + Tools.nullCheck(cmd.getOptionValue(IMPL_DESTINATION), "<destination>"));
            if (Objects.nonNull(cmd.getOptionValue(CLASS_DESTINATION))) {
                log.info("classes output: " + cmd.getOptionValue(CLASS_DESTINATION));
            }
            log.info("filter: " + Tools.nullCheck(cmd.getOptionValue(FILTER), NONE));
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            formatter.printHelp("CodeGen", options);
            System.exit(1);
        }
        return cmd;
    }

    private static String getBasePath(String defaultPath, PrototypeData properties, boolean implementation) {
        String result = defaultPath;
        if (StringUtils.isNotBlank((CharSequence)properties.getBasePath())) {
            result = properties.getBasePath();
        }
        if (implementation) {
            if (StringUtils.isNotBlank((CharSequence)properties.getImplementationPath())) {
                result = properties.getImplementationPath();
            }
        } else if (StringUtils.isNotBlank((CharSequence)properties.getInterfacePath())) {
            result = properties.getInterfacePath();
        }
        return result;
    }

    private static void addGenerationFile(String folder) {
        try (FileWriter myWriter = new FileWriter(folder + "/codegen.info");){
            myWriter.write("CodeGen generation started at " + String.valueOf(LocalDateTime.now()));
        }
        catch (Exception e) {
            log.error("Can't create marker file!");
        }
    }

    public static void processTemplate(String name, CompilationUnit unit) {
        log.info("Processing template: {}", (Object)name);
        unit.getTypes().forEach(CodeGen::handleTemplate);
    }

    public static void handleTemplate(TypeDeclaration<?> t) {
        if (t instanceof AnnotationDeclaration) {
            Structures.registerTemplate(t.asAnnotationDeclaration());
        } else {
            log.error("Invalid template declaration!");
        }
    }
}

