/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import java.lang.annotation.Annotation;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import lombok.Generated;
import lombok.Getter;
import lombok.Setter;
import net.binis.codegen.annotation.CodeAnnotation;
import net.binis.codegen.annotation.CodeFieldAnnotations;
import net.binis.codegen.annotation.CodePrototypeTemplate;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.annotation.DefaultString;
import net.binis.codegen.annotation.EnumPrototype;
import net.binis.codegen.annotation.ForInterface;
import net.binis.codegen.annotation.Ignore;
import net.binis.codegen.annotation.type.GenerationStrategy;
import net.binis.codegen.compiler.CGMethodSymbol;
import net.binis.codegen.compiler.utils.ElementUtils;
import net.binis.codegen.enrich.Enricher;
import net.binis.codegen.enrich.PrototypeEnricher;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.CollectionsHandler;
import net.binis.codegen.generation.core.CompiledPrototypesHandler;
import net.binis.codegen.generation.core.EnrichHelpers;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.MethodDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.options.CodeOption;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    public static final String MIX_IN_EXTENSION = "$MixIn";
    private static final List<Pair<PrototypeData, PrototypeDescription<ClassOrInterfaceDeclaration>>> notProcessed = new ArrayList<Pair<PrototypeData, PrototypeDescription<ClassOrInterfaceDeclaration>>>();

    private Generator() {
    }

    public static void generateCodeForClass(CompilationUnit parser) {
        Generator.generateCodeForClass(parser, null);
    }

    public static void generateCodeForClass(CompilationUnit parser, PrototypeDescription<ClassOrInterfaceDeclaration> prsd) {
        Holder processed = Holder.of((Object)0);
        for (TypeDeclaration type : parser.getTypes()) {
            if (type.isClassOrInterfaceDeclaration()) {
                Generator.getCodeAnnotation(type).ifPresentOrElse(prototype -> {
                    type.asClassOrInterfaceDeclaration().getMethods().forEach(method -> Generator.getCodeAnnotation(method).ifPresent(proto -> Generator.generateCodeForMethod(parser, prsd, method, proto)));
                    if (type.asClassOrInterfaceDeclaration().isInterface()) {
                        Generator.generateCodeForPrototype(parser, prsd, type, prototype);
                        processed.set((Object)((Integer)processed.get() + 1));
                    } else if (Generator.processForClass(parser, prsd, type, prototype)) {
                        processed.set((Object)((Integer)processed.get() + 1));
                    }
                }, () -> type.asClassOrInterfaceDeclaration().getMethods().forEach(method -> Generator.getCodeAnnotation(method).ifPresent(prototype -> Generator.generateCodeForMethod(parser, prsd, method, prototype))));
            } else if (type.isEnumDeclaration()) {
                Generator.getCodeAnnotation(type).ifPresent(prototype -> {
                    Generator.generateCodeForEnum(parser, prsd, type, prototype);
                    processed.set((Object)((Integer)processed.get() + 1));
                });
            }
            Generator.generateCodeForMethods(prsd);
        }
        if (!notProcessed.isEmpty()) {
            Iterator<Pair<PrototypeData, PrototypeDescription<ClassOrInterfaceDeclaration>>> i = notProcessed.iterator();
            while (i.hasNext()) {
                Pair<PrototypeData, PrototypeDescription<ClassOrInterfaceDeclaration>> item = i.next();
                if (!((PrototypeDescription)item.getValue()).isProcessed()) continue;
                Structures.Parsed parse = (Structures.Parsed)Helpers.lookup.findParsed(((PrototypeData)item.getKey()).getPrototypeFullName());
                parse.getDeclaration().asClassOrInterfaceDeclaration().getExtendedTypes().stream().filter(t -> t.getNameAsString().equals(((PrototypeDescription)item.getValue()).getDeclaration().asClassOrInterfaceDeclaration().getNameAsString())).forEach(t -> Generator.handleParsedExtendedType(parse, (PrototypeDescription)item.getValue(), parse.getImplementation(), parse.getInterface(), parse.getProperties(), t));
                i.remove();
            }
        }
        if (prsd != null && (Integer)processed.get() == 0) {
            ((Structures.Parsed)prsd).setInvalid(true);
        }
    }

    private static void generateCodeForMethod(CompilationUnit unit, PrototypeDescription<ClassOrInterfaceDeclaration> prsd, MethodDeclaration method, AnnotationExpr prototype) {
        if (!prsd.getMethods().containsKey(method.getNameAsString())) {
            prsd.getMethods().put(method.getNameAsString(), Structures.ParsedMethodDescription.builder().method(method).element(Generator.findElement(method, prsd.getElement())).prototype(prototype).properties(Generator.getProperties(prototype)).description(prsd).build());
        }
    }

    private static Element findElement(MethodDeclaration method, Element element) {
        if (Objects.nonNull(element) && ElementKind.CLASS.equals((Object)element.getKind())) {
            for (Element element2 : element.getEnclosedElements()) {
                CGMethodSymbol m;
                if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !element2.getSimpleName().toString().equals(method.getNameAsString()) || (m = new CGMethodSymbol(element2)).params().size() != method.getParameters().size()) continue;
                return element2;
            }
        }
        return null;
    }

    private static boolean processForClass(CompilationUnit parser, PrototypeDescription<ClassOrInterfaceDeclaration> prsd, TypeDeclaration<?> type, AnnotationExpr prototype) {
        ClassOrInterfaceDeclaration typeDeclaration = type.asClassOrInterfaceDeclaration();
        Structures.PrototypeDataHandler properties = Generator.getProperties(prototype);
        if (GenerationStrategy.NONE.equals((Object)properties.getStrategy())) {
            log.info("Processing - {}", (Object)typeDeclaration.getNameAsString());
            Helpers.handleEnrichersSetup(properties);
            Generator.handleNoneStrategy(prsd, type, typeDeclaration, properties);
            return true;
        }
        return false;
    }

    public static void generateCodeForPrototype(CompilationUnit parser, PrototypeDescription<ClassOrInterfaceDeclaration> prsd, TypeDeclaration<?> type, AnnotationExpr prototype) {
        ClassOrInterfaceDeclaration typeDeclaration = type.asClassOrInterfaceDeclaration();
        log.info("Processing - {}", (Object)typeDeclaration.getNameAsString());
        Structures.PrototypeDataHandler properties = Objects.nonNull(prsd) && Objects.nonNull(prsd.getCompiled()) ? (Structures.PrototypeDataHandler)prsd.getProperties() : Generator.getProperties(prototype);
        properties.setPrototypeName(typeDeclaration.getNameAsString());
        properties.setPrototypeFullName((String)typeDeclaration.getFullyQualifiedName().orElseThrow());
        Helpers.addProcessingType(typeDeclaration.getNameAsString(), properties.getInterfacePackage(), properties.getInterfaceName(), properties.getClassPackage(), properties.getClassName());
        Generator.ensureParsedParents(typeDeclaration, properties);
        Helpers.handleEnrichersSetup(properties);
        Structures.Parsed parse = switch (properties.getStrategy()) {
            default -> throw new IncompatibleClassChangeError();
            case GenerationStrategy.CLASSIC -> Generator.handleClassicStrategy(prsd, type, typeDeclaration, properties);
            case GenerationStrategy.IMPLEMENTATION -> Generator.handleImplementationStrategy(prsd, type, typeDeclaration, properties);
            case GenerationStrategy.PLAIN -> Generator.handlePlainStrategy(prsd, type, typeDeclaration, properties);
            case GenerationStrategy.METHOD, GenerationStrategy.NONE -> Generator.handleNoneStrategy(prsd, type, typeDeclaration, properties);
        };
        Helpers.processingTypes.remove(typeDeclaration.getNameAsString());
        parse.setProcessed(true);
        if (Objects.nonNull(prsd.getElement())) {
            ElementUtils.addOrReplaceClassAnnotation(prsd.getElement(), Generated.class, Map.of());
        }
    }

    private static Structures.Parsed handleClassicStrategy(PrototypeDescription<ClassOrInterfaceDeclaration> prsd, TypeDeclaration<?> type, ClassOrInterfaceDeclaration typeDeclaration, Structures.PrototypeDataHandler properties) {
        CompilationUnit unit = new CompilationUnit();
        unit.addImport("javax.annotation.processing.Generated");
        ClassOrInterfaceDeclaration spec = unit.addClass(properties.getClassName());
        unit.setPackageDeclaration(properties.getClassPackage());
        spec.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        if (properties.isGenerateConstructor()) {
            spec.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        }
        CompilationUnit iUnit = new CompilationUnit();
        iUnit.addImport("javax.annotation.processing.Generated");
        ClassOrInterfaceDeclaration intf = iUnit.addClass(properties.getInterfaceName()).setInterface(true);
        iUnit.setPackageDeclaration(properties.getInterfacePackage());
        intf.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        Structures.Parsed parse = (Structures.Parsed)Helpers.lookup.findParsed(Helpers.getClassName(typeDeclaration));
        parse.setProperties(properties);
        parse.setImplementation(spec);
        parse.setInterface(intf);
        if (Objects.isNull(prsd) || !prsd.isNested() || Objects.isNull(prsd.getParentClassName())) {
            spec.addAnnotation((AnnotationExpr)parse.getParser().parseAnnotation("@Generated(value=\"" + properties.getPrototypeFullName() + "\", comments=\"" + properties.getInterfaceName() + "\")").getResult().get());
            intf.addAnnotation((AnnotationExpr)parse.getParser().parseAnnotation("@Generated(value=\"" + properties.getPrototypeFullName() + "\", comments=\"" + properties.getClassName() + "\")").getResult().get());
        }
        Generator.adjustNestedPrototypes(parse);
        typeDeclaration.getExtendedTypes().forEach(t -> {
            PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.getParsed(t);
            if (Objects.nonNull(parsed) && parsed.isProcessed() && parsed.getProperties().isBase()) {
                properties.setBaseClassName(parsed.getParsedName());
                if (!Objects.isNull(parse.getBase())) {
                    throw new GenericCodeGenException(parse.getDeclaration().getNameAsString() + " can't have more that one base class!");
                }
                parse.setBase((Structures.Parsed)parsed);
                unit.addImport(parsed.getParsedFullName());
                spec.addExtendedType(parsed.getParsedName());
                ClassOrInterfaceType eType = (ClassOrInterfaceType)spec.getExtendedTypes().getLast().get();
                t.getTypeArguments().ifPresent(args -> args.forEach(tt -> {
                    if (eType.getTypeArguments().isEmpty()) {
                        eType.setTypeArguments(new NodeList());
                    }
                    String arg = Generator.handleType((CompilationUnit)parse.getDeclaration().findCompilationUnit().get(), (CompilationUnit)spec.findCompilationUnit().get(), tt);
                    ((NodeList)eType.getTypeArguments().get()).add((Node)((com.github.javaparser.ast.type.Type)parsed.getParser().parseClassOrInterfaceType(arg).getResult().get()));
                }));
                if (parsed.getProperties().isGenerateConstructor() && properties.isGenerateConstructor()) {
                    spec.findFirst(ConstructorDeclaration.class).ifPresent(c -> c.getBody().addStatement("super();"));
                }
            }
        });
        Generator.handleClassGenerics(parse);
        typeDeclaration.getExtendedTypes().forEach(t -> {
            PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.getParsed(t);
            if (Objects.nonNull(parsed)) {
                if (parsed.isProcessed()) {
                    Generator.handleParsedExtendedType(parse, parsed, spec, intf, properties, t);
                }
            } else {
                Generator.handleExternalInterface(parse, typeDeclaration, spec, intf, t);
            }
        });
        if (Objects.nonNull(properties.getMixInClass()) && Objects.isNull(parse.getMixIn())) {
            throw new GenericCodeGenException("Mix in Class " + properties.getPrototypeName() + " must inherit " + properties.getMixInClass());
        }
        if (properties.isGenerateInterface()) {
            ClassOrInterfaceType im = (ClassOrInterfaceType)((ClassOrInterfaceDeclaration)spec.addImplementedType(properties.getInterfaceName())).getImplementedTypes().getLast().get();
            unit.addImport(Helpers.getClassName(intf));
            spec.getTypeParameters().forEach(t -> {
                if (im.getTypeArguments().isEmpty()) {
                    im.setTypeArguments(new NodeList());
                }
                ((NodeList)im.getTypeArguments().get()).add((Node)t.clone().setTypeBound(new NodeList()));
            });
        }
        for (BodyDeclaration member : type.getMembers()) {
            if (member.isMethodDeclaration()) {
                MethodDeclaration declaration = member.asMethodDeclaration();
                if (!declaration.isDefault()) {
                    Structures.Ignores ignore = Helpers.getIgnores(member);
                    PrototypeField field = Structures.FieldData.builder().parsed(parse).build();
                    if (!ignore.isForField()) {
                        field = Generator.addField(parse, typeDeclaration, spec, declaration, null);
                    }
                    if (!ignore.isForClass()) {
                        if (properties.isClassGetters()) {
                            Generator.addGetter(typeDeclaration, spec, declaration, true, field);
                        }
                        if (properties.isClassSetters()) {
                            Generator.addSetter(typeDeclaration, spec, declaration, true, field);
                        }
                    }
                    if (ignore.isForInterface()) continue;
                    Generator.addGetter(typeDeclaration, intf, declaration, false, field);
                    if (!properties.isInterfaceSetters()) continue;
                    Generator.addSetter(typeDeclaration, intf, declaration, false, field);
                    continue;
                }
                Generator.handleDefaultMethod(parse, spec, intf, declaration);
                continue;
            }
            if (member.isClassOrInterfaceDeclaration()) {
                Generator.processInnerClass(parse, typeDeclaration, spec, member.asClassOrInterfaceDeclaration());
                continue;
            }
            if (member.isFieldDeclaration()) {
                Generator.processConstant(parse, typeDeclaration, spec, intf, member.asFieldDeclaration());
                continue;
            }
            log.error("Can't process method " + member);
        }
        unit.setComment((Comment)new BlockComment("Generated code by Binis' code generator."));
        iUnit.setComment((Comment)new BlockComment("Generated code by Binis' code generator."));
        Helpers.lookup.registerGenerated(Helpers.getClassName(spec), parse);
        Generator.cleanUpInterface(typeDeclaration, intf);
        Generator.handleClassAnnotations(typeDeclaration, spec, intf);
        Generator.checkForDeclaredConstants((Node)spec);
        Generator.checkForDeclaredConstants((Node)intf);
        Generator.checkForClassExpressions((Node)spec, typeDeclaration);
        Generator.checkForClassExpressions((Node)intf, typeDeclaration);
        Generator.handleInitializations(parse);
        Generator.handleMixin(parse);
        Generator.mergeNestedPrototypes(parse);
        Helpers.handleImports((Node)typeDeclaration, spec);
        Helpers.handleImports((Node)typeDeclaration, intf);
        return parse;
    }

    private static Structures.Parsed handleImplementationStrategy(PrototypeDescription<ClassOrInterfaceDeclaration> prsd, TypeDeclaration<?> type, ClassOrInterfaceDeclaration typeDeclaration, Structures.PrototypeDataHandler properties) {
        CompilationUnit unit = new CompilationUnit();
        unit.addImport("javax.annotation.processing.Generated");
        ClassOrInterfaceDeclaration spec = unit.addClass(properties.getClassName());
        unit.setPackageDeclaration(properties.getClassPackage());
        spec.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        spec.addImplementedType(prsd.getDeclaration().getNameAsString());
        prsd.getDeclaration().getFullyQualifiedName().ifPresent(arg_0 -> ((CompilationUnit)unit).addImport(arg_0));
        if (properties.isGenerateConstructor()) {
            spec.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        }
        Structures.Parsed parse = (Structures.Parsed)Helpers.lookup.findParsed(Helpers.getClassName(typeDeclaration));
        parse.setInterfaceName(type.getNameAsString());
        parse.setInterfaceFullName((String)type.getFullyQualifiedName().get());
        parse.setProperties(properties);
        parse.setImplementation(spec);
        if (!prsd.isNested() || Objects.isNull(prsd.getParentClassName())) {
            spec.addAnnotation((AnnotationExpr)parse.getParser().parseAnnotation("@Generated(value=\"" + properties.getPrototypeFullName() + "\", comments=\"" + properties.getInterfaceName() + "\")").getResult().get());
        }
        Generator.handleClassGenerics(parse);
        for (BodyDeclaration member : type.getMembers()) {
            if (!member.isMethodDeclaration()) continue;
            MethodDeclaration method = (MethodDeclaration)member.asMethodDeclaration().clone().setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            spec.addMember((BodyDeclaration)method.setBody(Generator.getDefaultReturnBody(method.getType())));
        }
        typeDeclaration.getExtendedTypes().forEach(t -> {
            PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.getParsed(t);
            if (Objects.nonNull(parsed)) {
                if (parsed.isProcessed()) {
                    // empty if block
                }
            } else {
                Generator.handleExternalInterface(parse, typeDeclaration, spec, null, t);
            }
        });
        unit.setComment((Comment)new BlockComment("Generated code by Binis' code generator."));
        Helpers.lookup.registerGenerated(Helpers.getClassName(spec), parse);
        Generator.checkForDeclaredConstants((Node)spec);
        Generator.checkForClassExpressions((Node)spec, typeDeclaration);
        Generator.mergeNestedPrototypes(parse);
        Helpers.handleImports((Node)typeDeclaration, spec);
        return parse;
    }

    private static Structures.Parsed handlePlainStrategy(PrototypeDescription<ClassOrInterfaceDeclaration> prsd, TypeDeclaration<?> type, ClassOrInterfaceDeclaration typeDeclaration, Structures.PrototypeDataHandler properties) {
        throw new NotImplementedException();
    }

    private static Structures.Parsed handleNoneStrategy(PrototypeDescription<ClassOrInterfaceDeclaration> prsd, TypeDeclaration<?> type, ClassOrInterfaceDeclaration typeDeclaration, Structures.PrototypeDataHandler properties) {
        Structures.Parsed parse = (Structures.Parsed)prsd;
        parse.setProperties(properties);
        return parse;
    }

    private static BlockStmt getDefaultReturnBody(com.github.javaparser.ast.type.Type type) {
        if (type.isVoidType()) {
            return new BlockStmt();
        }
        if (type.isPrimitiveType()) {
            String result = switch (type.asString()) {
                case "boolean" -> "false";
                case "long" -> "0L";
                case "float" -> "0.0f";
                case "double" -> "0.0";
                default -> "0";
            };
            return EnrichHelpers.returnBlock(result);
        }
        return EnrichHelpers.returnBlock("null");
    }

    private static void handleParsedExtendedType(Structures.Parsed<ClassOrInterfaceDeclaration> parse, PrototypeDescription<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, PrototypeData properties, ClassOrInterfaceType type) {
        if (!parsed.getProperties().isBase() && !parsed.getProperties().getPrototypeName().equals(parse.getProperties().getMixInClass())) {
            parsed.getFields().forEach(field -> {
                MethodDeclaration method = field.getDescription().clone();
                CompilationUnit dummy = Generator.envelopWithDummyClass(method);
                field.getDescription().findCompilationUnit().ifPresent(u -> u.getImports().forEach(arg_0 -> ((CompilationUnit)dummy).addImport(arg_0)));
                Generator.addField(parse, parsed.getDeclaration().asClassOrInterfaceDeclaration(), spec, method, Objects.nonNull(field.getGenerics()) ? field.getGenerics().values().iterator().next() : Helpers.buildGeneric(field.getType(), type, parsed.getDeclaration().asClassOrInterfaceDeclaration()));
            });
        }
        if (Objects.isNull(properties.getMixInClass()) || !properties.getMixInClass().equals(type.toString())) {
            if (!parsed.getProperties().isBase()) {
                Generator.implementPrototype(parse, spec, parsed, Helpers.buildGenerics(type, parsed.getDeclaration().asClassOrInterfaceDeclaration()), false);
            }
            if (StringUtils.isNotBlank((CharSequence)parsed.getInterfaceName())) {
                intf.findCompilationUnit().ifPresent(u -> u.addImport(parsed.getInterfaceFullName()));
                if (Objects.nonNull(properties.getMixInClass())) {
                    intf.addExtendedType(parsed.getInterfaceName() + MIX_IN_EXTENSION);
                } else {
                    intf.addExtendedType(parsed.getInterfaceName());
                    ClassOrInterfaceType eType = (ClassOrInterfaceType)intf.getExtendedTypes().getLast().get();
                    type.getTypeArguments().ifPresent(args -> args.forEach(tt -> {
                        if (eType.getTypeArguments().isEmpty()) {
                            eType.setTypeArguments(new NodeList());
                        }
                        String arg = Generator.handleType((CompilationUnit)parse.getDeclaration().findCompilationUnit().get(), (CompilationUnit)intf.findCompilationUnit().get(), tt);
                        ((NodeList)eType.getTypeArguments().get()).add((Node)((com.github.javaparser.ast.type.Type)parsed.getParser().parseClassOrInterfaceType(arg).getResult().get()));
                    }));
                }
            }
        } else {
            parse.setMixIn((Structures.Parsed)parsed);
        }
    }

    private static void adjustNestedPrototypes(Structures.Parsed<ClassOrInterfaceDeclaration> parse) {
        Helpers.lookup.parsed().stream().filter(p -> p.isNested() && Objects.nonNull(p.getParentClassName()) && p.getParentClassName().equals(parse.getPrototypeClassName())).map(Structures.Parsed.class::cast).forEach(p -> {
            p.setInterfaceName(parse.getInterfaceName() + "." + p.getInterfaceName());
            p.getProperties().setInterfacePackage(parse.getProperties().getInterfacePackage() + "." + parse.getInterfaceName());
            p.setInterfaceFullName(parse.getProperties().getInterfacePackage() + "." + p.getInterfaceName());
            p.setParsedName(parse.getParsedName() + "." + p.getParsedName());
            p.getProperties().setClassPackage(parse.getProperties().getClassPackage() + "." + parse.getParsedName());
            p.setParsedFullName(parse.getProperties().getClassPackage() + "." + p.getParsedName());
        });
    }

    private static void mergeNestedPrototypes(Structures.Parsed<ClassOrInterfaceDeclaration> parse) {
        Helpers.lookup.parsed().stream().filter(p -> p.isNested() && Objects.nonNull(p.getParentClassName()) && p.getParentClassName().equals(parse.getPrototypeClassName())).forEach(p -> {
            parse.getImplementation().addMember((BodyDeclaration)p.getImplementation().addModifier(new Modifier.Keyword[]{Modifier.Keyword.STATIC}));
            Helpers.mergeImports((CompilationUnit)p.getImplementation().findCompilationUnit().get(), (CompilationUnit)parse.getImplementation().findCompilationUnit().get());
            parse.getInterface().addMember((BodyDeclaration)p.getInterface());
            Helpers.mergeImports((CompilationUnit)p.getInterface().findCompilationUnit().get(), (CompilationUnit)parse.getInterface().findCompilationUnit().get());
        });
    }

    private static void handleClassGenerics(Structures.Parsed<ClassOrInterfaceDeclaration> parse) {
        CompilationUnit unit = (CompilationUnit)parse.getDeclaration().findCompilationUnit().get();
        parse.getDeclaration().asClassOrInterfaceDeclaration().getTypeParameters().forEach(t -> {
            parse.getImplementation().addTypeParameter(t);
            Tools.with(parse.getInterface(), intf -> intf.addTypeParameter(t));
            t.getTypeBound().forEach(tb -> {
                Generator.handleType(unit, (CompilationUnit)parse.getImplementation().findCompilationUnit().get(), (com.github.javaparser.ast.type.Type)tb);
                Tools.with(parse.getInterface(), intf -> Generator.handleType(unit, (CompilationUnit)intf.findCompilationUnit().get(), (com.github.javaparser.ast.type.Type)tb));
            });
        });
    }

    private static void handleInitializations(Structures.Parsed<ClassOrInterfaceDeclaration> parse) {
        List<AnnotationExpr> list = parse.getDeclaration().getAnnotations().stream().filter(a -> "Initialize".equals(a.getNameAsString())).toList();
        ConstructorDeclaration constructor = parse.getImplementation().getDefaultConstructor().orElseGet(() -> parse.getImplementation().addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setBody(Objects.nonNull(parse.getBase()) ? (BlockStmt)new BlockStmt().addStatement("super();") : new BlockStmt()));
        CompilationUnit unit = (CompilationUnit)parse.getImplementation().findCompilationUnit().get();
        list.forEach(ann -> {
            Holder statement = Holder.of((Object)"");
            ann.getChildNodes().stream().filter(MemberValuePair.class::isInstance).map(MemberValuePair.class::cast).forEach(pair -> {
                switch (pair.getNameAsString()) {
                    case "field": {
                        statement.set((Object)("this." + pair.getValue().asStringLiteralExpr().asString() + " = " + (String)statement.get()));
                        break;
                    }
                    case "expression": {
                        statement.set((Object)((String)statement.get() + pair.getValue().asStringLiteralExpr().asString() + ";"));
                        break;
                    }
                    case "imports": {
                        pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).forEach(i -> unit.addImport(i.asString()));
                        break;
                    }
                    default: {
                        log.warn("Invalid @Initialize member {}", (Object)pair.getNameAsString());
                    }
                }
            });
            constructor.getBody().addStatement((String)statement.get());
        });
    }

    public static Optional<AnnotationExpr> getCodeAnnotation(BodyDeclaration<?> type) {
        for (String name : Structures.defaultProperties.keySet()) {
            Optional<AnnotationExpr> ann = Helpers.getAnnotationByFullName(type, name);
            if (!ann.isPresent()) continue;
            return ann;
        }
        return Optional.empty();
    }

    private static void cleanUpInterface(Class<?> cls, ClassOrInterfaceDeclaration intf) {
        ArrayList<MethodDeclaration> toRemove = new ArrayList<MethodDeclaration>();
        Arrays.stream(cls.getInterfaces()).forEach(i -> Generator.cleanUpInterface(i, intf));
        Arrays.stream(cls.getDeclaredMethods()).forEach(mtd -> intf.getMethods().stream().filter(m -> m.getNameAsString().equals(mtd.getName()) && m.getParameters().size() == mtd.getParameterCount()).forEach(toRemove::add));
        toRemove.forEach(arg_0 -> ((ClassOrInterfaceDeclaration)intf).remove(arg_0));
    }

    private static void cleanUpInterface(ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration intf) {
        declaration.findCompilationUnit().ifPresent(unit -> intf.getExtendedTypes().forEach(t -> Tools.notNull(Helpers.getExternalClassName((Node)unit, t.getNameAsString()), className -> Tools.notNull(Reflection.loadClass((String)className), cls -> Generator.cleanUpInterface(cls, intf)))));
    }

    private static void handleDefaultMethod(Structures.Parsed<ClassOrInterfaceDeclaration> parse, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, MethodDeclaration declaration) {
        CompilationUnit unit = (CompilationUnit)declaration.findCompilationUnit().get();
        Structures.Ignores ignores = Helpers.getIgnores(declaration);
        MethodDeclaration method = (MethodDeclaration)declaration.clone().removeModifier(new Modifier.Keyword[]{Modifier.Keyword.DEFAULT});
        method.getAnnotationByClass(Ignore.class).ifPresent(arg_0 -> ((MethodDeclaration)method).remove(arg_0));
        if (!ignores.isForInterface()) {
            if (ignores.isForClass()) {
                declaration.getBody().ifPresent(b -> {
                    BlockStmt body = b.clone();
                    Generator.handleDefaultInterfaceMethodBody(parse, (Node)body, false);
                    method.setBody(body).addModifier(new Modifier.Keyword[]{Modifier.Keyword.DEFAULT});
                    intf.addMember((BodyDeclaration)Generator.handleForAnnotations(unit, method, false));
                });
            } else {
                if (Helpers.methodExists(intf, method, false)) {
                    intf.getChildNodes().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(m -> m.getNameAsString().equals(method.getNameAsString())).findFirst().ifPresent(arg_0 -> ((ClassOrInterfaceDeclaration)intf).remove(arg_0));
                }
                intf.addMember((BodyDeclaration)Generator.handleForAnnotations(unit, method.clone(), false).setBody(null));
            }
        }
        if (!ignores.isForClass()) {
            method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            declaration.getBody().ifPresent(b -> {
                BlockStmt body = b.clone();
                Generator.handleDefaultMethodBody(parse, (Node)body, false);
                method.setBody(body);
            });
            if (Helpers.methodExists(spec, method, false)) {
                spec.getChildNodes().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(m -> m.getNameAsString().equals(method.getNameAsString())).findFirst().ifPresent(arg_0 -> ((ClassOrInterfaceDeclaration)spec).remove(arg_0));
            }
            spec.addMember((BodyDeclaration)Generator.handleForAnnotations(unit, method, true));
        }
    }

    private static MethodDeclaration handleForAnnotations(CompilationUnit unit, MethodDeclaration method, boolean isClass) {
        int i;
        String chk = isClass ? "ForInterface" : "ForImplementation";
        for (i = method.getAnnotations().size() - 1; i > 0; --i) {
            if (!chk.equals(method.getAnnotation(i - 1).getNameAsString())) continue;
            method.remove((Node)method.getAnnotation(i));
        }
        for (i = method.getAnnotations().size() - 1; i >= 0; --i) {
            AnnotationExpr ann = method.getAnnotation(i);
            Tools.notNull(Helpers.getExternalClassName((Node)unit, method.getAnnotation(i).getNameAsString()), className -> Tools.notNull(Reflection.loadClass((String)className), cls -> {
                if (cls.isAnnotationPresent(CodeAnnotation.class)) {
                    method.remove((Node)ann);
                }
            }));
        }
        return method;
    }

    private static boolean handleDefaultMethodBody(PrototypeDescription<ClassOrInterfaceDeclaration> parse, Node node, boolean isGetter) {
        TypeDeclaration<ClassOrInterfaceDeclaration> typeDeclaration = parse.getDeclaration();
        if (isGetter && node.getParentNode().isPresent() && ((Node)node.getParentNode().get()).getChildNodes().size() == 2 && ((Node)node.getParentNode().get()).getChildNodes().get(1) instanceof SimpleName) {
            SimpleName name = (SimpleName)((Node)node.getParentNode().get()).getChildNodes().get(1);
            Optional<PrototypeField> parent = parse.findField(name.toString());
            if (parent.isEmpty() && Objects.nonNull(parse.getBase())) {
                parent = parse.getBase().findField(name.toString());
            }
            if (parent.isPresent()) {
                name.setIdentifier(Helpers.getGetterName(name.asString(), ""));
            }
        } else {
            for (int i = 0; i < node.getChildNodes().size(); ++i) {
                Node n = (Node)node.getChildNodes().get(i);
                if (n instanceof MethodCallExpr) {
                    MethodCallExpr method = (MethodCallExpr)n;
                    Optional<PrototypeField> parent = parse.findField(method.getNameAsString());
                    if (parent.isEmpty() && Objects.nonNull(parse.getBase())) {
                        parent = parse.getBase().findField(method.getNameAsString());
                    }
                    if (parent.isPresent()) {
                        Tools.notNull(parent.get().getPrototype(), p -> Generator.handleDefaultMethodBody(p, n, true));
                        return node.replace((Node)method, (Node)new FieldAccessExpr().setName(method.getName()));
                    }
                    if (!Generator.handleDefaultMethodBody(parse, n, false)) continue;
                    Generator.handleDefaultMethodBody(parse, node, false);
                    continue;
                }
                if (!Generator.handleDefaultMethodBody(parse, n, isGetter)) continue;
                Generator.handleDefaultMethodBody(parse, node, isGetter);
            }
        }
        return false;
    }

    private static boolean handleDefaultInterfaceMethodBody(PrototypeDescription<ClassOrInterfaceDeclaration> parse, Node node, boolean isGetter) {
        TypeDeclaration<ClassOrInterfaceDeclaration> typeDeclaration = parse.getDeclaration();
        if (isGetter && node.getParentNode().isPresent() && ((Node)node.getParentNode().get()).getChildNodes().size() == 2 && ((Node)node.getParentNode().get()).getChildNodes().get(1) instanceof SimpleName) {
            SimpleName name = (SimpleName)((Node)node.getParentNode().get()).getChildNodes().get(1);
            Optional<PrototypeField> parent = parse.findField(name.toString());
            if (parent.isEmpty() && Objects.nonNull(parse.getBase())) {
                parent = parse.getBase().findField(name.toString());
            }
            if (parent.isPresent()) {
                name.setIdentifier(Helpers.getGetterName(name.asString(), ""));
            }
        } else {
            for (int i = 0; i < node.getChildNodes().size(); ++i) {
                Node n = (Node)node.getChildNodes().get(i);
                if (n instanceof MethodCallExpr) {
                    MethodCallExpr method = (MethodCallExpr)n;
                    Optional<PrototypeField> parent = parse.findField(method.getNameAsString());
                    if (parent.isEmpty() && Objects.nonNull(parse.getBase())) {
                        parent = parse.getBase().findField(method.getNameAsString());
                    }
                    if (parent.isPresent()) {
                        Tools.notNull(Helpers.lookup.findParsed(Helpers.getExternalClassName((Node)typeDeclaration.findCompilationUnit().get(), parent.get().getType())), p -> Generator.handleDefaultInterfaceMethodBody(p, n, true));
                        if (Objects.nonNull(parent.get().getInterfaceGetter())) {
                            method.setName(parent.get().getInterfaceGetter().getName());
                        }
                        return true;
                    }
                    if (!Generator.handleDefaultInterfaceMethodBody(parse, n, false)) continue;
                    Generator.handleDefaultInterfaceMethodBody(parse, node, false);
                    continue;
                }
                if (!Generator.handleDefaultInterfaceMethodBody(parse, n, isGetter)) continue;
                Generator.handleDefaultInterfaceMethodBody(parse, node, isGetter);
            }
        }
        return false;
    }

    private static void checkForDeclaredConstants(Node type) {
        for (Node node : type.getChildNodes()) {
            FieldAccessExpr expr;
            if (node instanceof FieldAccessExpr && (expr = (FieldAccessExpr)node).getChildNodes().size() > 1 && expr.getChildNodes().get(0) instanceof NameExpr && expr.getChildNodes().get(1) instanceof SimpleName) {
                NameExpr namespace = (NameExpr)expr.getChildNodes().get(0);
                String name = ((SimpleName)expr.getChildNodes().get(1)).asString();
                List<Pair<String, String>> decl = Helpers.declaredConstants.get(namespace.getNameAsString());
                if (Objects.nonNull(decl)) {
                    decl.stream().filter(p -> ((String)p.getValue()).equals(name)).findFirst().ifPresent(c -> namespace.setName((String)c.getKey()));
                }
            }
            Generator.checkForDeclaredConstants(node);
        }
    }

    private static void checkForClassExpressions(Node type, ClassOrInterfaceDeclaration declaration) {
        declaration.findCompilationUnit().ifPresent(unit -> {
            for (Node node : type.getChildNodes()) {
                if (node instanceof ClassExpr) {
                    ClassExpr expr = (ClassExpr)node;
                    Tools.notNull(Helpers.lookup.findParsed(Helpers.getExternalClassName((Node)unit, expr.getTypeAsString())), p -> {
                        if (Objects.isNull(p.getMixIn())) {
                            expr.setType(Helpers.findProperType(p, unit, expr));
                        } else {
                            expr.setType(Helpers.findProperType(p.getMixIn(), unit, expr));
                        }
                    });
                }
                Generator.checkForClassExpressions(node, declaration);
            }
        });
    }

    private static void processConstant(Structures.Parsed parse, ClassOrInterfaceDeclaration prototype, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, FieldDeclaration field) {
        Structures.Constants consts = Helpers.getConstants(field);
        FieldDeclaration f = field.clone();
        String name = field.getVariable(0).getNameAsString();
        Structures.ConstantData.ConstantDataBuilder data = Structures.ConstantData.builder().name(name).field(f);
        f.getAnnotationByName("CodeConstant").ifPresent(arg_0 -> ((FieldDeclaration)f).remove(arg_0));
        if (consts.isForInterface()) {
            intf.addMember((BodyDeclaration)f);
            Helpers.addDeclaredConstant(prototype.getNameAsString(), intf.getNameAsString(), name);
            data.destination(intf);
        } else {
            spec.addMember((BodyDeclaration)((FieldDeclaration)((FieldDeclaration)f.addModifier(new Modifier.Keyword[]{consts.isForPublic() ? Modifier.Keyword.PUBLIC : ("serialVersionUID".equals(name) ? Modifier.Keyword.PRIVATE : Modifier.Keyword.PROTECTED)})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.STATIC})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.FINAL}));
            Helpers.addDeclaredConstant(prototype.getNameAsString(), spec.getNameAsString(), name);
            data.destination(spec);
        }
        parse.getConstants().put(name, data.build());
    }

    private static Structures.PrototypeDataHandler getProperties(AnnotationExpr prototype) {
        BodyDeclaration type = (BodyDeclaration)prototype.getParentNode().get();
        Holder iName = Holder.of((Object)"");
        Object cName = "";
        if (type.isClassOrInterfaceDeclaration()) {
            iName.set((Object)Helpers.defaultInterfaceName((ClassOrInterfaceDeclaration)type));
            cName = Helpers.defaultClassName((ClassOrInterfaceDeclaration)type);
        }
        String prototypeClass = Helpers.getExternalClassName((Node)prototype, prototype.getNameAsString());
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.builder(prototypeClass);
        Tools.nullCheck(Reflection.loadClass((String)prototypeClass), cls -> builder.prototypeAnnotation((Class<? extends Annotation>)cls));
        prototype.getChildNodes().forEach(node -> {
            block53: {
                block52: {
                    String name;
                    if (!(node instanceof MemberValuePair)) break block52;
                    MemberValuePair pair = (MemberValuePair)node;
                    switch (name = pair.getNameAsString()) {
                        case "name": {
                            String value = pair.getValue().asStringLiteralExpr().asString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                String intf = value.replace("Entity", "");
                                builder.name(value).className(value).interfaceName(intf).longModifierName(intf + ".Modify");
                                break;
                            }
                            break block53;
                        }
                        case "generateConstructor": {
                            builder.generateConstructor(pair.getValue().asBooleanLiteralExpr().getValue());
                            break;
                        }
                        case "generateImplementation": {
                            builder.generateImplementation(pair.getValue().asBooleanLiteralExpr().getValue());
                            break;
                        }
                        case "generateInterface": {
                            builder.generateInterface(pair.getValue().asBooleanLiteralExpr().getValue());
                            break;
                        }
                        case "interfaceName": {
                            String value = pair.getValue().asStringLiteralExpr().asString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                iName.set((Object)pair.getValue().asStringLiteralExpr().asString());
                                break;
                            }
                            break block53;
                        }
                        case "classGetters": {
                            builder.classGetters(pair.getValue().asBooleanLiteralExpr().getValue());
                            break;
                        }
                        case "classSetters": {
                            builder.classSetters(pair.getValue().asBooleanLiteralExpr().getValue());
                            break;
                        }
                        case "interfaceSetters": {
                            builder.interfaceSetters(pair.getValue().asBooleanLiteralExpr().getValue());
                            break;
                        }
                        case "base": {
                            builder.base(pair.getValue().asBooleanLiteralExpr().getValue());
                            break;
                        }
                        case "baseModifierClass": {
                            String value = pair.getValue().asClassExpr().getTypeAsString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                builder.baseModifierClass(value);
                                break;
                            }
                            break block53;
                        }
                        case "mixInClass": {
                            String value = pair.getValue().asClassExpr().getTypeAsString();
                            if (StringUtils.isNotBlank((CharSequence)value) && !"void".equals(value)) {
                                builder.mixInClass(value);
                                break;
                            }
                            break block53;
                        }
                        case "implementationPackage": {
                            String value = pair.getValue().asStringLiteralExpr().asString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                builder.classPackage(value);
                                break;
                            }
                            break block53;
                        }
                        case "strategy": {
                            String value = pair.getValue().asFieldAccessExpr().getNameAsString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                builder.strategy(GenerationStrategy.valueOf((String)value));
                                break;
                            }
                            break block53;
                        }
                        case "basePath": {
                            String value = pair.getValue().asStringLiteralExpr().asString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                builder.basePath(value);
                                break;
                            }
                            break block53;
                        }
                        case "interfacePath": {
                            String value = pair.getValue().asStringLiteralExpr().asString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                builder.interfacePath(value);
                                break;
                            }
                            break block53;
                        }
                        case "implementationPath": {
                            String value = pair.getValue().asStringLiteralExpr().asString();
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                builder.implementationPath(value);
                                break;
                            }
                            break block53;
                        }
                        case "enrichers": {
                            Generator.checkEnrichers(builder::enrichers, Generator.handleInitializerAnnotation(pair));
                            break;
                        }
                        case "inheritedEnrichers": {
                            Generator.checkEnrichers(builder::inheritedEnrichers, Generator.handleInitializerAnnotation(pair));
                            break;
                        }
                        case "options": {
                            Generator.checkOptions(builder::options, Generator.handleInitializerAnnotation(pair));
                            break;
                        }
                        default: {
                            builder.custom(name, Helpers.getExpressionValue((Node)pair.getValue()));
                            break;
                        }
                    }
                    break block53;
                }
                if (!(node instanceof Name)) {
                    builder.custom("value", Helpers.getExpressionValue(node));
                }
            }
        });
        if (((String)cName).equals(iName.get())) {
            cName = (String)iName.get() + "Impl";
        }
        builder.className((String)cName).interfaceName((String)iName.get()).longModifierName((String)iName.get() + ".Modify");
        Structures.PrototypeDataHandler result = builder.build();
        if (Objects.isNull(result.getClassPackage()) && type.isClassOrInterfaceDeclaration()) {
            result.setClassPackage(Helpers.defaultClassPackage((ClassOrInterfaceDeclaration)type));
        }
        if (Objects.isNull(result.getInterfacePackage()) && type.isClassOrInterfaceDeclaration()) {
            result.setInterfacePackage(Helpers.defaultInterfacePackage((ClassOrInterfaceDeclaration)type));
        }
        if (Objects.isNull(result.getEnrichers())) {
            result.setEnrichers(new ArrayList<PrototypeEnricher>());
        }
        if (Objects.isNull(result.getInheritedEnrichers())) {
            result.setInheritedEnrichers(new ArrayList<PrototypeEnricher>());
        }
        Tools.notNull(result.getPredefinedEnrichers(), list -> list.forEach(e -> Generator.checkEnrichers(result.getEnrichers(), e)));
        Tools.notNull(result.getPredefinedInheritedEnrichers(), list -> list.forEach(e -> Generator.checkEnrichers(result.getInheritedEnrichers(), e)));
        return result;
    }

    private static ArrayInitializerExpr handleInitializerAnnotation(MemberValuePair pair) {
        Expression expression = pair.getValue();
        if (expression.isClassExpr()) {
            ArrayInitializerExpr expr = new ArrayInitializerExpr();
            expr.getValues().add((Node)expression);
            pair.setValue((Expression)expr);
            return expr;
        }
        return expression.asArrayInitializerExpr();
    }

    private static void checkEnrichers(Consumer<List<PrototypeEnricher>> consumer, ArrayInitializerExpr expression) {
        HashMap map = new HashMap();
        expression.getValues().stream().filter(Expression::isClassExpr).map(e -> Reflection.loadClass((String)Helpers.getExternalClassName((Node)expression.findCompilationUnit().get(), e.asClassExpr().getType().asString()))).filter(Objects::nonNull).filter(Enricher.class::isAssignableFrom).forEach(enricher -> Generator.initEnricher(enricher, map));
        consumer.accept(new ArrayList(map.values()));
    }

    private static void initEnricher(Class enricher, Map<Class<? extends Enricher>, PrototypeEnricher> map) {
        Optional.of(enricher).map(x$0 -> CodeFactory.create((Class)x$0, (Object[])new Object[0])).filter(Objects::nonNull).filter(i -> PrototypeEnricher.class.isAssignableFrom(i.getClass())).ifPresent(e -> Tools.with((PrototypeEnricher)e, enr -> {
            enr.init(Helpers.lookup);
            map.put((Class<? extends Enricher>)enr.getClass(), (PrototypeEnricher)enr);
            enr.dependencies().forEach(d -> Generator.initEnricher(d, map));
        }));
    }

    private static void checkOptions(Consumer<Set<Class<? extends CodeOption>>> consumer, ArrayInitializerExpr expression) {
        HashSet set = new HashSet();
        expression.getValues().stream().filter(Expression::isClassExpr).map(e -> Reflection.loadClass((String)Helpers.getExternalClassName((Node)expression.findCompilationUnit().get(), e.asClassExpr().getType().asString()))).filter(Objects::nonNull).filter(CodeOption.class::isAssignableFrom).forEach(o -> set.add(o));
        consumer.accept(set);
    }

    private static void checkEnrichers(List<PrototypeEnricher> list, Class enricher) {
        Object e2;
        if (list.stream().noneMatch(e -> enricher.isAssignableFrom(e.getClass())) && (e2 = CodeFactory.create((Class)enricher, (Object[])new Object[0])) instanceof PrototypeEnricher) {
            PrototypeEnricher en = (PrototypeEnricher)e2;
            en.init(Helpers.lookup);
            list.add(en);
            en.dependencies().forEach(d -> Generator.checkEnrichers(list, d));
        }
    }

    private static void ensureParsedParents(ClassOrInterfaceDeclaration declaration, PrototypeData properties) {
        for (ClassOrInterfaceType extended : declaration.getExtendedTypes()) {
            PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.getParsed(extended);
            if (Objects.nonNull(parsed)) {
                if (!parsed.isProcessed()) {
                    Generator.generateCodeForClass((CompilationUnit)parsed.getDeclaration().findCompilationUnit().get(), parsed);
                    continue;
                }
                if (parsed.isProcessed()) continue;
                notProcessed.add((Pair<PrototypeData, PrototypeDescription<ClassOrInterfaceDeclaration>>)Pair.of((Object)properties, parsed));
                continue;
            }
            CompiledPrototypesHandler.handleCompiledPrototype(Helpers.getExternalClassName((Node)declaration.findCompilationUnit().get(), extended.getNameAsString()));
        }
        Tools.notNull(properties.getMixInClass(), c -> Tools.notNull(Helpers.getExternalClassName((Node)declaration.findCompilationUnit().get(), c), name -> Tools.notNull(Helpers.lookup.findParsed((String)name), parse -> Tools.condition(!parse.isProcessed(), () -> Generator.generateCodeForClass((CompilationUnit)parse.getDeclaration().findCompilationUnit().get(), parse)))));
        declaration.getChildNodes().stream().filter(ClassOrInterfaceDeclaration.class::isInstance).map(ClassOrInterfaceDeclaration.class::cast).forEach(cls -> Generator.getCodeAnnotation(cls).ifPresent(ann -> {
            String clsName = Helpers.getClassName(cls);
            Helpers.lookup.registerParsed(clsName, Structures.Parsed.builder().declaration(cls.asTypeDeclaration()).declarationUnit(cls.findCompilationUnit().orElse(null)).parser(Helpers.lookup.getParser()).nested(true).parentClassName(Helpers.getClassName(declaration)).parent(declaration).build());
            Tools.notNull(Helpers.lookup.findParsed(clsName), parse -> Tools.condition(!parse.isProcessed(), () -> Generator.generateCodeForPrototype((CompilationUnit)declaration.findCompilationUnit().get(), parse, cls, ann)));
        }));
    }

    private static void ensureParsedParents(EnumDeclaration declaration, PrototypeDescription<?> parse) {
        if (Objects.nonNull(parse) && Objects.isNull(parse.getCompiled()) && !parse.isProcessed()) {
            if (parse.getDeclaration().isEnumDeclaration()) {
                Generator.generateCodeForEnum((CompilationUnit)parse.getDeclaration().findCompilationUnit().get(), parse, parse.getDeclaration(), parse.getDeclaration().getAnnotationByClass(EnumPrototype.class).orElse(null));
            } else {
                throw new GenericCodeGenException("Class '" + (String)parse.getDeclaration().getFullyQualifiedName().get() + "' is not enum!");
            }
        }
    }

    private static void implementPrototype(Structures.Parsed<ClassOrInterfaceDeclaration> parse, ClassOrInterfaceDeclaration spec, PrototypeDescription<ClassOrInterfaceDeclaration> declaration, Map<String, com.github.javaparser.ast.type.Type> generic, boolean external) {
        Structures.PrototypeDataHandler properties = parse.getProperties();
        for (MethodDeclaration method : declaration.getImplementation().getMethods()) {
            PrototypeField field;
            if (declaration.isValid()) {
                if (declaration.getDeclaration().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).anyMatch(m -> m.getNameAsString().equals(method.getNameAsString()))) {
                    spec.addMember((BodyDeclaration)method.clone());
                    continue;
                }
            }
            if (method.getNameAsString().startsWith("get") || method.getNameAsString().startsWith("is")) {
                if (external) {
                    if (!parse.getDeclaration().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).noneMatch(m -> m.isDefault() && m.getNameAsString().equals(method.getNameAsString()) && m.getTypeAsString().equals(method.getTypeAsString()))) continue;
                }
                if (!Objects.nonNull(field = Generator.addFieldFromGetter(parse, spec, method, generic, external)) || !properties.isClassGetters()) continue;
                Generator.addGetterFromGetter(spec, method, true, generic, field);
                continue;
            }
            if (!method.getNameAsString().startsWith("set")) continue;
            if (external) {
                if (!parse.getDeclaration().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).noneMatch(m -> m.isDefault() && m.getNameAsString().equals(method.getNameAsString()) && m.getTypeAsString().equals(method.getTypeAsString()))) continue;
            }
            if ((!Objects.nonNull(field = Generator.addFieldFromSetter(parse, spec, method, generic, external)) || !properties.isClassSetters()) && !declaration.getProperties().isInterfaceSetters()) continue;
            Generator.addSetterFromSetter(spec, method, true, generic, field);
        }
        Helpers.handleImports((Node)declaration.getImplementation(), spec);
    }

    private static boolean handleExternalInterface(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, ClassOrInterfaceType type) {
        String className = Helpers.getExternalClassName((Node)declaration.findCompilationUnit().get(), type.getNameAsString());
        if (Objects.nonNull(className)) {
            Class cls = Reflection.loadClass((String)className);
            if (Objects.nonNull(cls)) {
                if (cls.isInterface()) {
                    Type[] generics = cls.getGenericInterfaces();
                    Class<?>[] interfaces = cls.getInterfaces();
                    Map<String, com.github.javaparser.ast.type.Type> typeArguments = null;
                    if (type.getTypeArguments().isPresent()) {
                        typeArguments = Helpers.processGenerics(cls, (NodeList<com.github.javaparser.ast.type.Type>)((NodeList)type.getTypeArguments().get()));
                    }
                    for (int i = 0; i < interfaces.length; ++i) {
                        Type[] types = null;
                        if (generics[i] instanceof ParameterizedType) {
                            types = ((ParameterizedType)generics[i]).getActualTypeArguments();
                        }
                        Generator.handleExternalInterface(parsed, declaration, spec, interfaces[i], typeArguments, types);
                    }
                    Generator.handleExternalInterface(parsed, declaration, spec, cls, typeArguments, null);
                    if (Objects.nonNull(intf)) {
                        intf.addExtendedType(Generator.handleType((CompilationUnit)declaration.findCompilationUnit().get(), (CompilationUnit)intf.findCompilationUnit().get(), (com.github.javaparser.ast.type.Type)type));
                    } else if (spec.getImplementedTypes().stream().noneMatch(arg_0 -> ((ClassOrInterfaceType)type).equals(arg_0))) {
                        spec.addImplementedType(Generator.handleType((CompilationUnit)declaration.findCompilationUnit().get(), (CompilationUnit)spec.findCompilationUnit().get(), (com.github.javaparser.ast.type.Type)type));
                    }
                } else {
                    log.error("{} is not interface!", (Object)className);
                }
            } else {
                ClassOrInterfaceDeclaration ext;
                PrototypeDescription<ClassOrInterfaceDeclaration> external = Helpers.lookup.findExternal(className);
                if (Objects.nonNull(external) && external.getDeclaration().isClassOrInterfaceDeclaration() && (ext = external.getDeclaration().asClassOrInterfaceDeclaration()).isInterface()) {
                    Map<String, com.github.javaparser.ast.type.Type> generics = Helpers.buildGenerics(type, ext);
                    ClassOrInterfaceDeclaration org = external.getImplementation();
                    ((Structures.Parsed)external).setImplementation(((CompilationUnit)org.findCompilationUnit().get()).clone().getType(0).asClassOrInterfaceDeclaration());
                    Generator.implementPrototype(parsed, spec, external, generics, true);
                    ((Structures.Parsed)external).setImplementation(org);
                    if (Objects.nonNull(intf)) {
                        intf.addExtendedType(external.getDeclaration().getNameAsString());
                        ClassOrInterfaceType eType = (ClassOrInterfaceType)intf.getExtendedTypes().getLast().get();
                        type.getTypeArguments().ifPresent(args -> args.forEach(tt -> {
                            if (eType.getTypeArguments().isEmpty()) {
                                eType.setTypeArguments(new NodeList());
                            }
                            String arg = Generator.handleType((CompilationUnit)parsed.getDeclaration().findCompilationUnit().get(), (CompilationUnit)intf.findCompilationUnit().get(), tt);
                            ((NodeList)eType.getTypeArguments().get()).add((Node)((com.github.javaparser.ast.type.Type)parsed.getParser().parseClassOrInterfaceType(arg).getResult().get()));
                        }));
                        ((CompilationUnit)intf.findCompilationUnit().get()).addImport((String)external.getDeclaration().getFullyQualifiedName().get());
                    }
                    return true;
                }
            }
        } else {
            log.error("Can't process interface {} cause can't find its type!", (Object)type.getNameAsString());
        }
        return false;
    }

    private static void handleExternalInterface(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, Class<?> cls, Map<String, com.github.javaparser.ast.type.Type> generics, Type[] generics2) {
        Map<String, com.github.javaparser.ast.type.Type> generic = Objects.nonNull(generics2) ? Helpers.processGenerics(cls, generics, generics2) : generics;
        Type[] genericIntf = cls.getGenericInterfaces();
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Type[] types = null;
            Type type = genericIntf[i];
            if (type instanceof ParameterizedType) {
                ParameterizedType type2 = (ParameterizedType)type;
                types = type2.getActualTypeArguments();
            }
            Generator.handleExternalInterface(parsed, declaration, spec, interfaces[i], generic, types);
        }
        switch (parsed.getProperties().getStrategy()) {
            case CLASSIC: {
                Generator.handleExternalMethodClassicStrategy(parsed, declaration, spec, cls, generic);
                break;
            }
            case IMPLEMENTATION: {
                Generator.handleExternalMethodImplementationStrategy(parsed, declaration, spec, cls, generic);
            }
        }
    }

    private static void handleExternalMethodClassicStrategy(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, Class<?> cls, Map<String, com.github.javaparser.ast.type.Type> generic) {
        Structures.PrototypeDataHandler properties = parsed.getProperties();
        for (Method method : cls.getDeclaredMethods()) {
            PrototypeField field;
            if (java.lang.reflect.Modifier.isStatic(method.getModifiers()) || method.isDefault() || Helpers.defaultMethodExists(declaration, method)) continue;
            if (method.getParameterCount() == 0 && method.getName().startsWith("get") || method.getName().startsWith("is") && method.getReturnType().getCanonicalName().equals("boolean")) {
                field = Generator.addFieldFromGetter(parsed, spec, method, generic);
                if (!Objects.nonNull(field) || !properties.isClassGetters()) continue;
                Generator.addGetterFromGetter(spec, method, true, generic, field);
                continue;
            }
            if (method.getParameterCount() == 1 && method.getName().startsWith("set") && method.getReturnType().getCanonicalName().equals("void")) {
                field = Generator.addFieldFromSetter(parsed, spec, method, generic);
                if (!Objects.nonNull(field) || !properties.isClassSetters()) continue;
                Generator.addSetterFromSetter(spec, method, true, generic, field);
                continue;
            }
            log.error("Method {} of {} is nor getter or setter. Not implemented!", (Object)method.getName(), (Object)cls.getCanonicalName());
        }
    }

    private static void handleExternalMethodImplementationStrategy(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, Class<?> cls, Map<String, com.github.javaparser.ast.type.Type> generic) {
        for (Method method : cls.getDeclaredMethods()) {
            if (java.lang.reflect.Modifier.isStatic(method.getModifiers()) || method.isDefault() || Helpers.defaultMethodExists(declaration, method)) continue;
            MethodDeclaration mtd = (MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(method.getName())).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            if (generic.containsKey(method.getGenericReturnType().getTypeName())) {
                mtd.setType(generic.get(method.getGenericReturnType().getTypeName()));
            } else {
                mtd.setType(method.getReturnType());
            }
            for (java.lang.reflect.Parameter p : method.getParameters()) {
                if (generic.containsKey(p.getParameterizedType().getTypeName())) {
                    mtd.addParameter(p.getParameterizedType().getTypeName(), p.getName());
                    continue;
                }
                mtd.addParameter(p.getType(), p.getName());
            }
            if (Helpers.methodExists(spec, mtd, false)) continue;
            mtd.setBody(Generator.getDefaultReturnBody(mtd.getType()));
            spec.addMember((BodyDeclaration)mtd);
        }
    }

    private static void handleMixin(PrototypeDescription<ClassOrInterfaceDeclaration> parse) {
        PrototypeDescription<ClassOrInterfaceDeclaration> parent;
        if (Objects.nonNull(parse.getProperties().getMixInClass()) && (parent = Helpers.lookup.findParsed(Helpers.getExternalClassName((Node)parse.getDeclaration().findCompilationUnit().get(), parse.getProperties().getMixInClass()))) != null) {
            ClassOrInterfaceDeclaration spec = parse.getImplementation();
            ClassOrInterfaceDeclaration intf = parse.getInterface();
            ClassOrInterfaceDeclaration parentSpec = parent.getImplementation();
            ClassOrInterfaceDeclaration parentIntf = parent.getInterface();
            ((CompilationUnit)intf.findCompilationUnit().get()).addImport((String)parentIntf.getFullyQualifiedName().get());
            ((CompilationUnit)parentSpec.findCompilationUnit().get()).addImport((String)intf.getFullyQualifiedName().get());
            parentSpec.addImplementedType(intf.getNameAsString());
            Generator.mergeTypes(parent, spec, parentSpec, m -> true, a -> a);
            intf.getExtendedTypes().forEach(t -> Tools.condition(t.getNameAsString().endsWith(MIX_IN_EXTENSION), () -> (ClassOrInterfaceType)t.setName(t.getNameAsString().replace(MIX_IN_EXTENSION, ""))));
            if (intf.getExtendedTypes().stream().noneMatch(t -> t.getNameAsString().equals(parentIntf.getNameAsString()))) {
                intf.addExtendedType(parentIntf.getNameAsString());
            }
            Helpers.handleImports((Node)parse.getDeclaration().asClassOrInterfaceDeclaration(), intf);
            Helpers.handleImports((Node)parent.getDeclaration().asClassOrInterfaceDeclaration(), intf);
            Helpers.handleImports((Node)parse.getDeclaration().asClassOrInterfaceDeclaration(), parentSpec);
        }
    }

    public static String handleType(ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination, com.github.javaparser.ast.type.Type type) {
        return Generator.handleType(source, destination, type, null);
    }

    public static String handleType(ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination, com.github.javaparser.ast.type.Type type, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        return Generator.handleType((CompilationUnit)source.findCompilationUnit().get(), (CompilationUnit)destination.findCompilationUnit().get(), type, prototypeMap);
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, com.github.javaparser.ast.type.Type type) {
        return Generator.handleType(source, destination, type, null);
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, com.github.javaparser.ast.type.Type type, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        List<String> generic;
        Object result;
        Object object = result = type.isClassOrInterfaceType() ? type.asClassOrInterfaceType().getNameAsString() : type.toString();
        if (type.isClassOrInterfaceType() && !ObjectUtils.isEmpty(generic = Generator.handleGenericTypes(source, destination, type.asClassOrInterfaceType(), prototypeMap))) {
            result = type.asClassOrInterfaceType().getNameAsString() + "<" + String.join((CharSequence)",", generic) + ">";
        }
        return Generator.handleType(source, destination, (String)result, false);
    }

    public static List<String> handleGenericTypes(CompilationUnit source, CompilationUnit destination, ClassOrInterfaceType type, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        ArrayList<String> result = new ArrayList<String>();
        Optional arguments = type.getTypeArguments();
        if (arguments.isEmpty() || ((NodeList)arguments.get()).isEmpty()) {
            return result;
        }
        return ((NodeList)arguments.get()).stream().map(n -> Generator.handleType(source, destination, Helpers.typeToString(n), true, prototypeMap)).toList();
    }

    public static List<Pair<String, Boolean>> getGenericsList(CompilationUnit source, CompilationUnit destination, ClassOrInterfaceType type, boolean isCollection) {
        Optional arguments = type.getTypeArguments();
        if (arguments.isEmpty() || ((NodeList)arguments.get()).isEmpty()) {
            return Collections.singletonList(Pair.of((Object)"Object", (Object)false));
        }
        return ((NodeList)arguments.get()).stream().map(n -> Generator.handleType(source, destination, Helpers.typeToString(n), true)).map(t -> Pair.of((Object)t, (Object)Helpers.lookup.parsed().stream().anyMatch(p -> Helpers.getExternalClassName((Node)destination, t).equals(p.getInterfaceFullName())))).toList();
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, String type, boolean embedded) {
        return Generator.handleType(source, destination, type, embedded, null);
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, String type, boolean embedded, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        String full = Helpers.getExternalClassName((Node)source, type);
        PrototypeDescription<ClassOrInterfaceDeclaration> parse = Helpers.lookup.findParsed(full);
        if (Objects.nonNull(parse)) {
            Structures.ProcessingType processing = Helpers.processingTypes.get(type);
            if (embedded && Objects.nonNull(prototypeMap)) {
                prototypeMap.put(parse.getDeclaration().getNameAsString(), parse);
                Helpers.lookup.addPrototypeMap(parse, prototypeMap);
            }
            if (Objects.isNull(processing)) {
                if (!parse.isProcessed()) {
                    Generator.generateCodeForClass((CompilationUnit)parse.getDeclaration().findCompilationUnit().get(), parse);
                }
                destination.addImport((String)parse.getInterface().getFullyQualifiedName().get());
                return parse.getInterfaceName();
            }
            destination.addImport(processing.getInterfacePackage() + "." + processing.getInterfaceName());
            return processing.getInterfaceName();
        }
        if (!Helpers.isJavaType(type)) {
            if (CompiledPrototypesHandler.handleCompiledPrototype(full)) {
                return Generator.handleType(source, destination, type, embedded, prototypeMap);
            }
            if (!full.contains(".prototype.")) {
                destination.findCompilationUnit().ifPresent(u -> u.addImport(full));
            }
        }
        return type;
    }

    private static void handleFieldAnnotations(CompilationUnit unit, FieldDeclaration field, MethodDeclaration method, boolean compiledAnnotations, PrototypeField proto) {
        Holder next = Holder.of((Object)false);
        method.getAnnotations().forEach(a -> Tools.notNull(Helpers.getExternalClassName((Node)unit, a.getNameAsString()), name -> {
            Class ann = Reflection.loadClass((String)name);
            if (Objects.nonNull(ann)) {
                if (ForInterface.class.equals((Object)ann)) {
                    next.set((Object)true);
                    return;
                }
                if (Objects.isNull(ann.getAnnotation(CodeAnnotation.class)) && Objects.isNull(ann.getAnnotation(CodePrototypeTemplate.class))) {
                    Target target = ann.getAnnotation(Target.class);
                    if (((Boolean)next.get()).booleanValue()) {
                        if (target == null || target.toString().contains("METHOD")) {
                            Generator.handleAnnotation(unit, proto.generateInterfaceGetter(), a);
                        }
                    } else if (target == null || target.toString().contains("FIELD")) {
                        Generator.handleAnnotation(unit, field, a);
                    }
                } else if (CodeFieldAnnotations.class.isAssignableFrom(ann)) {
                    a.getChildNodes().stream().filter(ArrayInitializerExpr.class::isInstance).findFirst().ifPresent(e -> e.getChildNodes().forEach(n -> field.addAnnotation(((StringLiteralExpr)n).asStringLiteralExpr().asString())));
                } else if (Default.class.isAssignableFrom(ann)) {
                    if (a.isSingleMemberAnnotationExpr()) {
                        ((VariableDeclarator)field.getVariables().iterator().next()).setInitializer(a.asSingleMemberAnnotationExpr().getMemberValue().asStringLiteralExpr().asString());
                    } else if (a.isNormalAnnotationExpr()) {
                        a.asNormalAnnotationExpr().getPairs().forEach(p -> {
                            if ("value".equals(p.getName().asString())) {
                                ((VariableDeclarator)field.getVariables().iterator().next()).setInitializer(p.getValue().asStringLiteralExpr().asString());
                            }
                        });
                    }
                } else if (DefaultString.class.isAssignableFrom(ann)) {
                    if (a.isSingleMemberAnnotationExpr()) {
                        ((VariableDeclarator)field.getVariables().iterator().next()).setInitializer("\"" + a.asSingleMemberAnnotationExpr().getMemberValue().asStringLiteralExpr().asString() + "\"");
                    } else if (a.isNormalAnnotationExpr()) {
                        a.asNormalAnnotationExpr().getPairs().forEach(p -> {
                            if ("value".equals(p.getName().asString())) {
                                ((VariableDeclarator)field.getVariables().iterator().next()).setInitializer("\"" + p.getValue().asStringLiteralExpr().asString() + "\"");
                            }
                        });
                    }
                }
            } else {
                PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.lookup.findExternal((String)name);
                if (Objects.nonNull(parsed) && parsed.getDeclaration().isAnnotationDeclaration()) {
                    if (parsed.getDeclaration().getAnnotationByClass(CodeAnnotation.class).isEmpty() && parsed.getDeclaration().getAnnotationByClass(CodePrototypeTemplate.class).isEmpty()) {
                        if (((Boolean)next.get()).booleanValue()) {
                            if (Helpers.annotationHasTarget(parsed, "ElementType.METHOD")) {
                                Generator.handleAnnotation(unit, proto.generateInterfaceGetter(), a);
                            } else {
                                log.warn("Invalid annotation target {}", name);
                            }
                        } else if (Helpers.annotationHasTarget(parsed, "ElementType.FIELD")) {
                            Generator.handleAnnotation(unit, field, a);
                        } else {
                            log.warn("Invalid annotation target {}", name);
                        }
                    }
                } else if (compiledAnnotations) {
                    if (((Boolean)next.get()).booleanValue()) {
                        Generator.handleMissingAnnotation(unit, proto.generateInterfaceGetter(), a);
                    } else {
                        Generator.handleMissingAnnotation(unit, field, a);
                    }
                } else {
                    log.warn("Can't process annotation {}", name);
                }
            }
            next.set((Object)false);
        }));
    }

    private static void handleAnnotation(CompilationUnit unit, BodyDeclaration<?> body, AnnotationExpr ann) {
        body.getAnnotations().stream().filter(a -> a.getNameAsString().equals(ann.getNameAsString())).findFirst().ifPresent(a -> body.getAnnotations().remove((Node)a));
        body.addAnnotation(ann);
        Tools.notNull(Helpers.getExternalClassNameIfExists((Node)unit, ann.getNameAsString()), i -> body.findCompilationUnit().ifPresent(u -> u.addImport(Helpers.sanitizeImport(i))));
    }

    private static void handleMissingAnnotation(CompilationUnit unit, BodyDeclaration<?> body, AnnotationExpr ann) {
        Optional<AnnotationExpr> existing = body.getAnnotations().stream().filter(a -> a.getNameAsString().equals(ann.getNameAsString())).findFirst();
        if (existing.isEmpty()) {
            body.addAnnotation(ann);
            Tools.notNull(Helpers.getExternalClassNameIfExists((Node)unit, ann.getNameAsString()), i -> body.findCompilationUnit().ifPresent(u -> u.addImport(Helpers.sanitizeImport(i))));
        }
    }

    private static void handleAnnotation(CompilationUnit unit, MethodDeclaration method, AnnotationExpr ann, CompilationUnit destinationUnit) {
        method.getAnnotations().stream().filter(a -> a.getNameAsString().equals(ann.getNameAsString())).findFirst().ifPresent(a -> method.getAnnotations().remove((Node)a));
        method.addAnnotation(ann);
        Tools.notNull(Helpers.getExternalClassNameIfExists((Node)unit, ann.getNameAsString()), arg_0 -> ((CompilationUnit)destinationUnit).addImport(arg_0));
    }

    private static void handleMethodAnnotations(MethodDeclaration method, MethodDeclaration declaration, PrototypeField field) {
        declaration.getAnnotations().forEach(a -> Tools.notNull(Helpers.getExternalClassName((Node)declaration.findCompilationUnit().get(), a.getNameAsString()), name -> {
            Target target;
            Class ann = Reflection.loadClass((String)name);
            if (Objects.nonNull(ann) && !ann.isAnnotationPresent(CodeAnnotation.class) && !field.getDeclaration().isAnnotationPresent(ann) && (target = ann.getAnnotation(Target.class)) != null && target.toString().contains("METHOD")) {
                method.addAnnotation(a);
            }
        }));
    }

    private static void handleClassAnnotations(ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf) {
        Holder next = Holder.of((Object)false);
        declaration.findCompilationUnit().ifPresent(unit -> declaration.getAnnotations().forEach(a -> Tools.notNull(Helpers.getExternalClassName((Node)unit, a.getNameAsString()), name -> {
            Class ann = Reflection.loadClass((String)name);
            if (Objects.nonNull(ann)) {
                Target target;
                if (ForInterface.class.equals((Object)ann)) {
                    next.set((Object)true);
                    return;
                }
                if (Objects.isNull(ann.getAnnotation(CodeAnnotation.class)) && Objects.isNull(ann.getAnnotation(CodePrototypeTemplate.class)) && (target = ann.getAnnotation(Target.class)) != null && !target.toString().equals("TYPE")) {
                    if (((Boolean)next.get()).booleanValue()) {
                        intf.addAnnotation(a);
                    } else {
                        spec.addAnnotation(a);
                    }
                }
            } else {
                PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.lookup.findExternal((String)name);
                if (Objects.nonNull(parsed) && parsed.getDeclaration().isAnnotationDeclaration()) {
                    if (parsed.getDeclaration().stream().filter(AnnotationExpr.class::isInstance).map(AnnotationExpr.class::cast).filter(an -> "java.lang.annotation.Target".equals(Helpers.getExternalClassName((Node)parsed.getDeclaration().findCompilationUnit().get(), an.getNameAsString()))).findFirst().map(t -> t.stream().filter(ArrayInitializerExpr.class::isInstance).map(ArrayInitializerExpr.class::cast).findFirst().map(arr -> arr.getValues().stream().map(Object::toString).anyMatch("ElementType.TYPE"::equals)).orElse(false)).orElse(true).booleanValue()) {
                        if (parsed.getDeclaration().getAnnotationByClass(CodePrototypeTemplate.class).isEmpty()) {
                            spec.addAnnotation(a);
                        }
                    } else {
                        log.warn("Invalid annotation target {}", name);
                    }
                } else {
                    log.warn("Can't process annotation {}", name);
                }
            }
            next.set((Object)false);
        })));
    }

    public static <T> T findInheritanceProperty(ClassOrInterfaceDeclaration spec, PrototypeData properties, BiFunction<ClassOrInterfaceDeclaration, PrototypeData, T> func) {
        T data;
        block1: {
            ClassOrInterfaceType type;
            PrototypeDescription<ClassOrInterfaceDeclaration> parse;
            data = func.apply(spec, properties);
            if (!Objects.isNull(data)) break block1;
            Iterator iterator = spec.getExtendedTypes().iterator();
            while (!(!iterator.hasNext() || Objects.nonNull(parse = Helpers.lookup.findGenerated(Helpers.getClassName(type = (ClassOrInterfaceType)iterator.next()))) && Objects.nonNull(data = Generator.findInheritanceProperty(parse.getDeclaration().asClassOrInterfaceDeclaration(), parse.getProperties(), func)))) {
            }
        }
        return data;
    }

    private static void processInnerClass(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration cls) {
        cls.getImplementedTypes().forEach(t -> {
            if (Generator.handleExternalInterface(parsed, declaration, spec, null, t)) {
                Generator.handleType(cls, spec, (com.github.javaparser.ast.type.Type)t);
                spec.addImplementedType(t);
            }
        });
        cls.getAnnotationByName("CodeClassAnnotations").ifPresent(a -> cls.getAnnotations().forEach(ann -> {
            if (!"CodeClassAnnotations".equals(ann.getNameAsString())) {
                spec.addAnnotation(ann.clone());
            }
        }));
    }

    private static PrototypeField addField(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration type, ClassOrInterfaceDeclaration spec, MethodDeclaration method, com.github.javaparser.ast.type.Type generic) {
        boolean compiledAnnotations = false;
        PrototypeField result = null;
        String fieldName = method.getNameAsString();
        PrototypeField fieldProto = Helpers.findField(parsed, fieldName);
        FieldDeclaration field = Objects.nonNull(fieldProto) ? fieldProto.getDeclaration() : null;
        CompilationUnit unit = (CompilationUnit)type.findCompilationUnit().get();
        if (Objects.isNull(field)) {
            boolean genericMethod = !method.getTypeParameters().isEmpty() && method.getTypeAsString().equals(method.getTypeParameter(0).getNameAsString());
            HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
            field = Objects.nonNull(generic) ? spec.addField(generic, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : (method.getTypeParameters().isEmpty() || !method.getType().asString().equals(method.getTypeParameter(0).asString()) ? spec.addField(Generator.handleType(type, spec, method.getType(), prototypeMap), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : spec.addField("Object", fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}));
            boolean collection = CollectionsHandler.isCollection(field.getVariable(0).getType());
            result = Structures.FieldData.builder().parsed(parsed).name(fieldName).description(method).declaration(field).collection(collection).ignores(Helpers.getIgnores(method)).genericMethod(genericMethod).genericField(Generator.isGenericType(method.getType(), parsed.getDeclaration())).generics(Objects.nonNull(generic) ? Map.of(generic.asString(), generic) : null).prototype(collection ? prototypeMap.get(CollectionsHandler.getCollectionType(method.getType())) : (Objects.isNull(generic) ? Helpers.lookup.findParsed(Helpers.getExternalClassName((Node)unit, method.getType().asString())) : null)).typePrototypes(!prototypeMap.isEmpty() ? prototypeMap : null).type(field.getElementType().asString()).fullType(Helpers.getExternalClassNameIfExists((Node)spec.findCompilationUnit().get(), field.getElementType().asString())).parent(Objects.nonNull(parsed.getBase()) ? Helpers.findField(parsed.getBase(), fieldName) : null).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
                Generator.handleType(type, spec, method.getType());
                ((Structures.FieldData)result).setPrototype(Objects.isNull(generic) ? Helpers.lookup.findParsed(Helpers.getExternalClassName((Node)unit, method.getType().asString())) : null);
                Generator.mergeAnnotations(method, result.getDescription());
            } else {
                result = fieldProto;
                HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
                field = Objects.nonNull(generic) ? spec.addField(generic, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : (method.getTypeParameters().isEmpty() || !method.getType().asString().equals(method.getTypeParameter(0).asString()) ? spec.addField(Generator.handleType(type, spec, method.getType(), prototypeMap), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : spec.addField("Object", fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}));
                method = method.clone();
                Generator.mergeAnnotations(result.getDescription(), unit, method);
                compiledAnnotations = true;
                unit = (CompilationUnit)fieldProto.getDescription().findCompilationUnit().get();
            }
        }
        Generator.handleFieldAnnotations(unit, field, method, compiledAnnotations, result);
        return result;
    }

    private static boolean isGenericType(com.github.javaparser.ast.type.Type type, TypeDeclaration<ClassOrInterfaceDeclaration> declaration) {
        return declaration.asClassOrInterfaceDeclaration().getTypeParameters().stream().anyMatch(p -> p.getNameAsString().equals(type.asString()));
    }

    private static PrototypeField addFieldFromGetter(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, MethodDeclaration method, Map<String, com.github.javaparser.ast.type.Type> generic, boolean external) {
        PrototypeField result = null;
        boolean genericMethod = !method.getTypeParameters().isEmpty() && method.getTypeAsString().equals(method.getTypeParameter(0).getNameAsString());
        String fieldName = Helpers.getFieldName(method.getNameAsString());
        if (!Helpers.fieldExists(parsed, fieldName)) {
            FieldDeclaration field = Objects.nonNull(generic) && !generic.isEmpty() ? spec.addField(generic.get(method.getTypeAsString()), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : (genericMethod ? spec.addField("Object", fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : spec.addField(method.getType(), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}));
            result = Structures.FieldData.builder().parsed(parsed).name(fieldName).description(method).declaration(field).ignores(Helpers.getIgnores(method)).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).generics(Objects.nonNull(generic) && !generic.isEmpty() ? generic : null).genericMethod(genericMethod).fullType(genericMethod ? null : Helpers.getExternalClassNameIfExists((Node)spec.findCompilationUnit().get(), field.getElementType().asString())).type(genericMethod ? method.getTypeParameter(0).getNameAsString() : field.getElementType().asString()).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
            }
        }
        return result;
    }

    private static PrototypeField addFieldFromSetter(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, MethodDeclaration method, Map<String, com.github.javaparser.ast.type.Type> generic, boolean external) {
        PrototypeField result = null;
        String fieldName = Helpers.getFieldName(method.getNameAsString());
        if (!Helpers.fieldExists(parsed, fieldName)) {
            FieldDeclaration field = Objects.nonNull(generic) ? spec.addField(generic.get(Helpers.parseMethodSignature(method)), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : spec.addField(method.getParameter(0).getType(), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
            result = Structures.FieldData.builder().parsed(parsed).name(fieldName).description(method).declaration(field).ignores(Helpers.getIgnores(method)).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).generics(generic).genericMethod(false).fullType(Helpers.getExternalClassNameIfExists((Node)spec.findCompilationUnit().get(), field.getElementType().asString())).type(field.getElementType().asString()).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
            }
        }
        return result;
    }

    private static PrototypeField addFieldFromGetter(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, Method method, Map<String, com.github.javaparser.ast.type.Type> generic) {
        PrototypeField result = null;
        String fieldName = Helpers.getFieldName(method.getName());
        boolean genericMethod = false;
        if (!Helpers.fieldExists(parsed, fieldName)) {
            MethodDeclaration description;
            FieldDeclaration field;
            PrototypeDescription<ClassOrInterfaceDeclaration> prototype = null;
            if (Objects.nonNull(generic)) {
                String sig = Helpers.parseMethodSignature(method);
                Object type = generic.get(sig);
                if (Objects.isNull(type)) {
                    type = Helpers.isPrimitiveType(sig) ? new PrimitiveType().setType(PrimitiveType.Primitive.valueOf((String)sig.toUpperCase())) : (com.github.javaparser.ast.type.Type)new ClassOrInterfaceType().setName(sig);
                }
                Generator.handleType(parsed.getDeclaration().asClassOrInterfaceDeclaration(), spec, type);
                prototype = Helpers.lookup.findParsed(Helpers.getExternalClassName((Node)parsed.getDeclaration().findCompilationUnit().get(), type.asString()));
                if (Objects.nonNull(prototype)) {
                    type = (com.github.javaparser.ast.type.Type)new ClassOrInterfaceType().setName(prototype.getInterfaceName());
                }
                field = spec.addField(type, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
                description = ((MethodDeclaration)new MethodDeclaration().setName(fieldName)).setType(type);
            } else {
                genericMethod = !method.getReturnType().getCanonicalName().equals(Helpers.parseMethodSignature(method));
                field = spec.addField(method.getReturnType(), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
                description = (MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(fieldName)).setType(method.getReturnType());
                if (!method.getReturnType().isPrimitive() && !method.getReturnType().getCanonicalName().startsWith("java.lang.")) {
                    ((CompilationUnit)spec.findCompilationUnit().get()).addImport(method.getReturnType().getCanonicalName());
                }
            }
            CompilationUnit dummy = Generator.envelopWithDummyClass(description);
            if (method.getDeclaredAnnotations().length > 0) {
                for (Annotation ann : method.getDeclaredAnnotations()) {
                    description.addAnnotation(ann.annotationType());
                    dummy.addImport(ann.annotationType().getPackageName());
                    field.addAnnotation(ann.annotationType());
                }
            }
            result = Structures.FieldData.builder().parsed(parsed).description(description).name(fieldName).declaration(field).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).ignores(Structures.Ignores.builder().build()).generics(generic).genericMethod(genericMethod).fullType(genericMethod ? null : Helpers.getExternalClassNameIfExists((Node)spec.findCompilationUnit().get(), field.getElementType().asString())).type(genericMethod ? Helpers.parseMethodSignature(method) : field.getElementType().asString()).prototype(prototype).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
            }
        }
        return result;
    }

    private static PrototypeField addFieldFromSetter(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, Method method, Map<String, com.github.javaparser.ast.type.Type> generic) {
        PrototypeField result = null;
        String fieldName = Helpers.getFieldName(method.getName());
        boolean genericMethod = false;
        if (!Helpers.fieldExists(parsed, fieldName)) {
            MethodDeclaration description;
            FieldDeclaration field;
            if (Objects.nonNull(generic)) {
                type = generic.get(Helpers.parseMethodSignature(method));
                field = spec.addField((com.github.javaparser.ast.type.Type)type, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
                description = ((MethodDeclaration)new MethodDeclaration().setName(fieldName)).setType((com.github.javaparser.ast.type.Type)type);
                Generator.handleType(parsed.getDeclaration().asClassOrInterfaceDeclaration(), spec, (com.github.javaparser.ast.type.Type)type);
            } else {
                type = method.getParameters()[0].getType();
                genericMethod = !type.equals(method.getGenericParameterTypes()[0]);
                field = spec.addField((Class)type, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
                description = (MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(fieldName)).setType((Class)type);
                if (!((Class)type).isPrimitive() && !((Class)type).getCanonicalName().startsWith("java.lang.")) {
                    ((CompilationUnit)spec.findCompilationUnit().get()).addImport(((Class)type).getCanonicalName());
                }
            }
            CompilationUnit dummy = Generator.envelopWithDummyClass(description);
            for (Annotation ann : method.getDeclaredAnnotations()) {
                description.addAnnotation(ann.annotationType());
                dummy.addImport(ann.annotationType().getPackageName());
                field.addAnnotation(ann.annotationType());
            }
            result = Structures.FieldData.builder().parsed(parsed).description(description).name(fieldName).declaration(field).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).ignores(Structures.Ignores.builder().build()).generics(generic).genericMethod(genericMethod).fullType(genericMethod ? null : Helpers.getExternalClassNameIfExists((Node)spec.findCompilationUnit().get(), field.getElementType().asString())).type(genericMethod ? Helpers.parseMethodSignature(method) : field.getElementType().asString()).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
            }
        }
        return result;
    }

    private static CompilationUnit envelopWithDummyClass(MethodDeclaration description) {
        CompilationUnit dummy = new CompilationUnit();
        dummy.setPackageDeclaration("dummy");
        dummy.addClass("Dummy").addMember((BodyDeclaration)description);
        return dummy;
    }

    public static void addGetter(ClassOrInterfaceDeclaration type, ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        String name = Helpers.getGetterName(declaration.getNameAsString(), declaration.getType().asString());
        if (!Helpers.methodExists(spec, declaration, name, isClass)) {
            String rType = declaration.getTypeParameters().isEmpty() ? Generator.handleType(type, spec, declaration.getType()) : declaration.getType().asString();
            MethodDeclaration method = (MethodDeclaration)spec.addMethod(name, new Modifier.Keyword[0]).setType(rType);
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName(declaration.getName()))));
                ((Structures.FieldData)field).setImplementationGetter(method);
                Generator.handleMethodAnnotations(method, declaration, field);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    method.setType("Object");
                }
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceGetter(method);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    declaration.getTypeParameters().forEach(arg_0 -> ((MethodDeclaration)method).addTypeParameter(arg_0));
                }
            }
        }
    }

    private static void addGetterFromGetter(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        Generator.addGetterFromGetter(spec, declaration, isClass, null, field);
    }

    private static void addGetterFromGetter(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, Map<String, com.github.javaparser.ast.type.Type> generic, PrototypeField field) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            MethodDeclaration method = spec.addMethod(declaration.getNameAsString(), new Modifier.Keyword[0]);
            if (Objects.nonNull(generic)) {
                method.setType(generic.get(declaration.getType().asString()));
            } else {
                method.setType(declaration.getType());
            }
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName(Helpers.getFieldName(declaration.getNameAsString())))));
                ((Structures.FieldData)field).setImplementationGetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceGetter(method);
            }
        }
    }

    private static void addGetterFromGetter(ClassOrInterfaceDeclaration spec, Method declaration, boolean isClass, Map<String, com.github.javaparser.ast.type.Type> generic, PrototypeField field) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            MethodDeclaration method = spec.addMethod(declaration.getName(), new Modifier.Keyword[0]);
            if (Objects.nonNull(generic)) {
                method.setType(generic.get(Helpers.parseMethodSignature(declaration)));
            } else {
                method.setType(declaration.getReturnType());
            }
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName(Helpers.getFieldName(declaration.getName())))));
                ((Structures.FieldData)field).setImplementationGetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceGetter(method);
            }
        }
    }

    public static void addSetter(ClassOrInterfaceDeclaration type, ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        MethodDeclaration method;
        String fieldName = Objects.nonNull(field.getName()) ? field.getName() : declaration.getNameAsString();
        String name = Helpers.getSetterName(fieldName);
        String returnType = null;
        if (Objects.nonNull(field.getType())) {
            returnType = field.getType();
        } else if (Objects.nonNull(field.getGenerics())) {
            returnType = field.getGenerics().get(declaration.getType().asString()).asString();
        }
        if (Objects.isNull(returnType)) {
            Generator.handleType(type, spec, declaration.getType());
        }
        if (!Helpers.methodExists(spec, method = (MethodDeclaration)((MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(name)).setType("void")).addParameter((Parameter)((Parameter)new Parameter().setName(fieldName)).setType(returnType)), name, isClass)) {
            spec.addMember((BodyDeclaration)method);
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this." + fieldName)).setValue((Expression)new NameExpr().setName(fieldName))));
                ((Structures.FieldData)field).setImplementationSetter(method);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    method.getParameter(0).setType("Object");
                }
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceSetter(method);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    declaration.getTypeParameters().forEach(arg_0 -> ((MethodDeclaration)method).addTypeParameter(arg_0));
                }
            }
        }
    }

    private static void addSetterFromSetter(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        Generator.addSetterFromSetter(spec, declaration, isClass, null, field);
    }

    private static void addSetterFromSetter(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, Map<String, com.github.javaparser.ast.type.Type> generic, PrototypeField field) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            MethodDeclaration method = spec.addMethod(declaration.getNameAsString(), new Modifier.Keyword[0]);
            if (Objects.nonNull(generic)) {
                method.addParameter(((Parameter)new Parameter().setName(field.getName())).setType(generic.get(declaration.getParameter(0).getType().asString())));
            } else {
                method.addParameter(((Parameter)new Parameter().setName(field.getName())).setType(declaration.getParameter(0).getType()));
            }
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this." + Helpers.getFieldName(declaration.getNameAsString()))).setValue((Expression)new NameExpr().setName(Helpers.getFieldName(declaration.getNameAsString())))));
                ((Structures.FieldData)field).setImplementationSetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceSetter(method);
            }
        }
    }

    private static void addSetterFromSetter(ClassOrInterfaceDeclaration spec, Method declaration, boolean isClass, Map<String, com.github.javaparser.ast.type.Type> generic, PrototypeField proto) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            String field = Helpers.getFieldName(declaration.getName());
            MethodDeclaration method = spec.addMethod(declaration.getName(), new Modifier.Keyword[0]);
            if (Objects.nonNull(generic)) {
                method.addParameter(((Parameter)new Parameter().setName(field)).setType(generic.get(Helpers.parseMethodSignature(declaration))));
            } else {
                method.addParameter((Parameter)((Parameter)new Parameter().setName(field)).setType(declaration.getParameterTypes()[0]));
            }
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this." + field)).setValue((Expression)new NameExpr().setName(field))));
                ((Structures.FieldData)proto).setImplementationSetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)proto).setInterfaceSetter(method);
            }
        }
    }

    public static void addMethod(ClassOrInterfaceDeclaration spec, Method declaration, Map<String, String> signature) {
        if (!Helpers.methodExists(spec, declaration, false)) {
            CompilationUnit unit = (CompilationUnit)spec.findCompilationUnit().get();
            MethodDeclaration method = spec.addMethod(declaration.getName(), new Modifier.Keyword[0]);
            method.setType(Helpers.mapGenericMethodSignature(declaration, signature));
            String[] names = Helpers.getParameterNames(declaration);
            for (int i = 0; i < declaration.getParameterCount(); ++i) {
                java.lang.reflect.Parameter param = declaration.getParameters()[i];
                if (declaration.getGenericParameterTypes()[i] instanceof ParameterizedType) {
                    method.addParameter(Helpers.mapGenericSignature(declaration.getGenericParameterTypes()[i], signature), names[i]);
                    continue;
                }
                Helpers.importClass(unit, param.getType());
                method.addParameter(param.getType().getSimpleName(), names[i]);
            }
            method.setBody(null);
        }
    }

    private static void mergeTypes(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination, Predicate<BodyDeclaration<?>> filter, UnaryOperator<MethodDeclaration> adjuster) {
        for (BodyDeclaration member : source.getMembers()) {
            MethodDeclaration method;
            if (!filter.test(member)) continue;
            if (member instanceof FieldDeclaration) {
                PrototypeField field = Helpers.findField(parsed, member.asFieldDeclaration().getVariable(0).getNameAsString());
                if (!Objects.isNull(field)) continue;
                destination.addMember(member.clone());
                continue;
            }
            if (!(member instanceof MethodDeclaration) || !Objects.isNull(method = Helpers.findMethod(destination, member.asMethodDeclaration().getNameAsString()))) continue;
            destination.addMember((BodyDeclaration)adjuster.apply((MethodDeclaration)member.clone()));
        }
    }

    private static void mergeAnnotations(MethodDeclaration source, MethodDeclaration destination) {
        source.findCompilationUnit().ifPresent(unit -> {
            for (AnnotationExpr ann : source.getAnnotations()) {
                Generator.handleAnnotation(unit, destination, ann);
            }
        });
    }

    private static void mergeAnnotations(MethodDeclaration source, CompilationUnit destinationUnit, MethodDeclaration destination) {
        source.findCompilationUnit().ifPresent(unit -> {
            for (AnnotationExpr ann : destination.getAnnotations()) {
                Tools.notNull(Helpers.getExternalClassNameIfExists((Node)destinationUnit, ann.getNameAsString()), arg_0 -> ((CompilationUnit)unit).addImport(arg_0));
            }
            for (AnnotationExpr ann : source.getAnnotations()) {
                Generator.handleAnnotation(unit, destination, ann, destinationUnit);
            }
        });
    }

    private static void mergeAnnotations(FieldDeclaration source, FieldDeclaration destination) {
        source.findCompilationUnit().ifPresent(unit -> {
            for (AnnotationExpr ann : source.getAnnotations()) {
                Generator.handleAnnotation(unit, destination, ann);
            }
        });
    }

    public static void generateCodeForEnum(CompilationUnit declarationUnit, PrototypeDescription<?> prsd, TypeDeclaration<?> type, AnnotationExpr prototype) {
        if (type.isEnumDeclaration()) {
            EnumDeclaration typeDeclaration = type.asEnumDeclaration();
            log.info("Processing - {}", (Object)typeDeclaration.getNameAsString());
            Structures.PrototypeDataHandler properties = Generator.getEnumProperties(prototype);
            properties.setPrototypeName(typeDeclaration.getNameAsString());
            properties.setPrototypeFullName((String)typeDeclaration.getFullyQualifiedName().orElseThrow());
            Helpers.handleEnrichersSetup(properties);
            PrototypeDescription mixIn = Tools.withRes(properties.getMixInClass(), c -> Tools.withRes(Helpers.getExternalClassName((Node)declarationUnit.findCompilationUnit().get(), c), Generator::findEnum));
            Generator.ensureParsedParents(typeDeclaration, mixIn);
            CompilationUnit iUnit = new CompilationUnit();
            iUnit.addImport("javax.annotation.processing.Generated");
            ClassOrInterfaceDeclaration intf = iUnit.addClass(properties.getInterfaceName()).setInterface(true);
            iUnit.setPackageDeclaration(properties.getInterfacePackage());
            intf.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            iUnit.addImport("net.binis.codegen.objects.base.enumeration.CodeEnum");
            intf.addExtendedType("CodeEnum");
            iUnit.addImport(CodeFactory.class);
            CompilationUnit unit = new CompilationUnit();
            unit.addImport("javax.annotation.processing.Generated");
            ClassOrInterfaceDeclaration spec = unit.addClass(properties.getClassName());
            unit.setPackageDeclaration(properties.getClassPackage());
            spec.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            unit.addImport("net.binis.codegen.objects.base.enumeration.CodeEnumImpl");
            spec.addExtendedType("CodeEnumImpl");
            spec.addImplementedType(intf.getNameAsString());
            Structures.Parsed parse = (Structures.Parsed)Helpers.lookup.findParsed(Helpers.getClassName(typeDeclaration));
            parse.setProperties(properties);
            parse.setImplementation(spec);
            parse.setInterface(intf);
            parse.setCodeEnum(true);
            if (Objects.isNull(prsd) || !prsd.isNested() || Objects.isNull(prsd.getParentClassName())) {
                spec.addAnnotation((AnnotationExpr)parse.getParser().parseAnnotation("@Generated(value=\"" + properties.getPrototypeFullName() + "\", comments=\"" + properties.getInterfaceName() + "\")").getResult().get());
                intf.addAnnotation((AnnotationExpr)parse.getParser().parseAnnotation("@Generated(value=\"" + properties.getPrototypeFullName() + "\", comments=\"" + (Objects.nonNull(mixIn) ? mixIn.getProperties().getClassName() : properties.getClassName()) + "\")").getResult().get());
            }
            unit.setComment((Comment)new BlockComment("Generated code by Binis' code generator."));
            iUnit.setComment((Comment)new BlockComment("Generated code by Binis' code generator."));
            Generator.processEntries(typeDeclaration, intf, mixIn, properties.getOrdinalOffset());
            Generator.processEnumImplementation(typeDeclaration, spec);
            Helpers.handleImports((Node)typeDeclaration, spec);
            Helpers.lookup.registerGenerated(Helpers.getClassName(spec), parse);
            if (Objects.isNull(mixIn)) {
                Helpers.addDefaultCreation(parse, mixIn);
            } else {
                iUnit.addImport(mixIn.getInterfaceFullName());
            }
            Helpers.handleImports((Node)typeDeclaration, intf);
            Helpers.processingTypes.remove(typeDeclaration.getNameAsString());
            if (Objects.nonNull(prsd.getElement())) {
                ElementUtils.addOrReplaceClassAnnotation(prsd.getElement(), Generated.class, Map.of());
            }
            parse.setProcessed(true);
        }
    }

    private static PrototypeDescription<?> findEnum(String cls) {
        PrototypeDescription<ClassOrInterfaceDeclaration> result = Helpers.lookup.findParsed(cls);
        if (Objects.isNull(result)) {
            if (CompiledPrototypesHandler.handleCompiledEnumPrototype(cls)) {
                result = Helpers.lookup.findParsed(cls);
            } else {
                throw new GenericCodeGenException("Can't find class '" + cls + "' or it isn't enum class!");
            }
        }
        return result;
    }

    private static void processEnumImplementation(EnumDeclaration declaration, ClassOrInterfaceDeclaration spec) {
        ConstructorDeclaration constructor = ((ConstructorDeclaration)((ConstructorDeclaration)spec.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter(Integer.TYPE, "$ordinal")).addParameter(String.class, "$name")).setBody((BlockStmt)new BlockStmt().addStatement("super($ordinal, $name);"));
        List constructors = declaration.getConstructors();
        if (!constructors.isEmpty()) {
            if (constructors.size() > 1) {
                throw new GenericCodeGenException("Enums with more than one constructors are unsupported!");
            }
            ConstructorDeclaration con = (ConstructorDeclaration)constructors.get(0);
            con.getParameters().forEach(arg_0 -> ((ConstructorDeclaration)constructor).addParameter(arg_0));
            con.getBody().getStatements().forEach(s -> constructor.getBody().addStatement(s));
        }
        declaration.getMethods().forEach(arg_0 -> ((ClassOrInterfaceDeclaration)spec).addMember(arg_0));
        declaration.getFields().forEach(arg_0 -> ((ClassOrInterfaceDeclaration)spec).addMember(arg_0));
    }

    private static void processEntries(EnumDeclaration declaration, ClassOrInterfaceDeclaration intf, PrototypeDescription<?> mixIn, long offset) {
        String name;
        String string = name = Objects.nonNull(mixIn) ? mixIn.getInterfaceName() : intf.getNameAsString();
        if (Objects.nonNull(mixIn) && offset == 0L) {
            offset = mixIn.getProperties().getOrdinalOffset() + mixIn.getDeclaration().asEnumDeclaration().getEntries().size();
        }
        for (int i = 0; i < declaration.getEntries().size(); ++i) {
            EnumConstantDeclaration entry2 = (EnumConstantDeclaration)declaration.getEntries().get(i);
            StringBuilder expression = new StringBuilder("CodeFactory.initializeEnumValue(").append(name).append(".class, \"").append(entry2.getNameAsString()).append("\", ").append(offset + (long)i);
            for (Expression arg : entry2.getArguments()) {
                expression.append(", ").append(arg.toString());
            }
            expression.append(")");
            intf.addFieldWithInitializer(name, entry2.getNameAsString(), EnrichHelpers.expression(expression.toString()), new Modifier.Keyword[]{Modifier.Keyword.STATIC, Modifier.Keyword.FINAL});
        }
        declaration.getFields().stream().filter(f -> f.getModifiers().contains((Node)Modifier.publicModifier()) && f.getModifiers().contains((Node)Modifier.staticModifier()) && f.getModifiers().contains((Node)Modifier.finalModifier())).forEach(f -> {
            FieldDeclaration field = f.clone();
            field.getModifiers().remove((Node)Modifier.publicModifier());
            intf.addMember((BodyDeclaration)field);
        });
        declaration.getMethods().forEach(m -> {
            MethodDeclaration method = m.clone().setBody(null);
            method.getModifiers().remove((Node)Modifier.publicModifier());
            intf.addMember((BodyDeclaration)method);
        });
        declaration.getFields().stream().filter(f -> f.isAnnotationPresent(Getter.class)).forEach(f -> intf.addMethod(Helpers.getGetterName(f.getVariable(0).getNameAsString(), f.getVariable(0).getType()), new Modifier.Keyword[0]).setType(f.getVariable(0).getType()).setBody(null));
        declaration.getFields().stream().filter(f -> f.isAnnotationPresent(Setter.class)).forEach(f -> intf.addMethod(Helpers.getSetterName(f.getVariable(0).getNameAsString()), new Modifier.Keyword[0]).setBody(null));
        ((MethodDeclaration)((MethodDeclaration)intf.addMethod("valueOf", new Modifier.Keyword[]{Modifier.Keyword.STATIC}).addParameter("String", "name")).setType(name)).setBody((BlockStmt)new BlockStmt().addStatement("return CodeFactory.enumValueOf(" + name + ".class, name);"));
        ((MethodDeclaration)((MethodDeclaration)intf.addMethod("valueOf", new Modifier.Keyword[]{Modifier.Keyword.STATIC}).addParameter("int", "ordinal")).setType(name)).setBody((BlockStmt)new BlockStmt().addStatement("return CodeFactory.enumValueOf(" + name + ".class, ordinal);"));
        ((MethodDeclaration)intf.addMethod("values", new Modifier.Keyword[]{Modifier.Keyword.STATIC}).setType(name + "[]")).setBody((BlockStmt)new BlockStmt().addStatement("return CodeFactory.enumValues(" + name + ".class);"));
        if (Objects.nonNull(mixIn)) {
            mixIn.getDeclaration().asEnumDeclaration().getEntries().forEach(entry -> intf.addFieldWithInitializer(name, entry.getNameAsString(), EnrichHelpers.expression(name + "." + entry.getNameAsString()), new Modifier.Keyword[]{Modifier.Keyword.STATIC, Modifier.Keyword.FINAL}));
        }
    }

    private static Structures.PrototypeDataHandler getEnumProperties(AnnotationExpr prototype) {
        EnumDeclaration type = (EnumDeclaration)prototype.getParentNode().get();
        Holder iName = Holder.of((Object)Helpers.defaultInterfaceName(type));
        Object cName = Helpers.defaultClassName(type);
        String prototypeClass = Helpers.getExternalClassName((Node)prototype, prototype.getNameAsString());
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.builder(prototypeClass).classPackage(Helpers.defaultClassPackage(type)).interfacePackage(Helpers.defaultInterfacePackage(type));
        Tools.nullCheck(Reflection.loadClass((String)Helpers.getExternalClassName((Node)prototype, prototype.getNameAsString())), cls -> builder.prototypeAnnotation((Class<? extends Annotation>)cls));
        prototype.getChildNodes().forEach(node -> {
            if (node instanceof MemberValuePair) {
                String name;
                MemberValuePair pair = (MemberValuePair)node;
                switch (name = pair.getNameAsString()) {
                    case "name": {
                        builder.name(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "mixIn": {
                        builder.mixInClass(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                    case "ordinalOffset": {
                        builder.ordinalOffset(pair.getValue().asIntegerLiteralExpr().asNumber().intValue());
                        break;
                    }
                    case "enrichers": {
                        Generator.checkEnrichers(builder::enrichers, Generator.handleInitializerAnnotation(pair));
                        break;
                    }
                }
            }
        });
        if (((String)cName).equals(iName.get())) {
            cName = (String)iName.get() + "Impl";
        }
        builder.className((String)cName).interfaceName((String)iName.get());
        Structures.PrototypeDataHandler result = builder.build();
        if (Objects.isNull(result.getEnrichers())) {
            result.setEnrichers(new ArrayList<PrototypeEnricher>());
        }
        if (Objects.isNull(result.getInheritedEnrichers())) {
            result.setInheritedEnrichers(new ArrayList<PrototypeEnricher>());
        }
        Tools.notNull(result.getPredefinedEnrichers(), list -> list.forEach(e -> Generator.checkEnrichers(result.getEnrichers(), e)));
        Tools.notNull(result.getPredefinedInheritedEnrichers(), list -> list.forEach(e -> Generator.checkEnrichers(result.getInheritedEnrichers(), e)));
        return result;
    }

    private static Structures.PrototypeDataHandler getConstantProperties(AnnotationExpr prototype) {
        ClassOrInterfaceDeclaration type = (ClassOrInterfaceDeclaration)prototype.getParentNode().get();
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.PrototypeDataHandler.builder().className(Helpers.defaultClassName(type)).classPackage(Helpers.defaultPackage(type, null));
        prototype.getChildNodes().forEach(node -> {
            if (node instanceof MemberValuePair) {
                String name;
                MemberValuePair pair = (MemberValuePair)node;
                switch (name = pair.getNameAsString()) {
                    case "mixIn": {
                        builder.mixInClass(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                }
            }
        });
        return builder.build();
    }

    public static CompilationUnit generateCodeForConstants() {
        if (!Helpers.constantParsed.isEmpty()) {
            CompilationUnit result = new CompilationUnit();
            ClassOrInterfaceDeclaration parent = result.addClass("Constants");
            parent.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            for (Map.Entry<String, PrototypeDescription<ClassOrInterfaceDeclaration>> entry : Helpers.constantParsed.entrySet()) {
                TypeDeclaration<ClassOrInterfaceDeclaration> type = entry.getValue().getDeclaration();
                if (!type.isClassOrInterfaceDeclaration()) continue;
                type.getAnnotationByName("ConstantPrototype").ifPresent(prototype -> {
                    ClassOrInterfaceDeclaration cls;
                    ClassOrInterfaceDeclaration typeDeclaration = type.asClassOrInterfaceDeclaration();
                    log.info("Processing - {}", prototype);
                    Structures.PrototypeDataHandler properties = Generator.getConstantProperties(prototype);
                    Holder name = Holder.of((Object)Helpers.defaultClassName(((PrototypeDescription)entry.getValue()).getDeclaration()));
                    if (Objects.nonNull(properties.getMixInClass())) {
                        name.set((Object)Helpers.defaultClassName(properties.getMixInClass()));
                    }
                    if (Objects.isNull(cls = (ClassOrInterfaceDeclaration)parent.getMembers().stream().filter(c -> c.isClassOrInterfaceDeclaration() && c.asClassOrInterfaceDeclaration().getNameAsString().equals(name.get())).findFirst().orElse(null))) {
                        cls = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration().setName((String)name.get())).setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
                        cls.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
                        parent.addMember((BodyDeclaration)cls);
                    }
                    Generator.mergeConstants(typeDeclaration, cls);
                });
            }
            return result;
        }
        return null;
    }

    public static void generateCodeForMethods(PrototypeDescription<ClassOrInterfaceDeclaration> prsd) {
        for (MethodDescription method : prsd.getMethods().values()) {
            Helpers.handleEnrichersSetup(method.getProperties());
            Helpers.handleEnrichers(method);
        }
    }

    private static void mergeConstants(ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination) {
    }
}

