/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import net.binis.codegen.enrich.CustomDescription;
import net.binis.codegen.enrich.PrototypeLookup;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeLookupHandler
implements PrototypeLookup {
    private static final Logger log = LoggerFactory.getLogger(PrototypeLookupHandler.class);
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> parsed = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> generated = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, TypeDeclaration> generatedClasses = new HashMap<String, TypeDeclaration>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> generatedInterfaces = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> external = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> enums = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, CustomDescription> custom = new HashMap<String, CustomDescription>();
    private final List<Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>> prototypeMaps = new ArrayList<Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>>();
    private final JavaParser parser = new JavaParser();
    private UnaryOperator<String> externalLookup;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;

    @Override
    public void registerParsed(String prototype, PrototypeDescription<?> parsed) {
        this.parsed.put(prototype, parsed);
        if (parsed.isCodeEnum()) {
            this.enums.put(parsed.getInterfaceFullName(), parsed);
        }
    }

    @Override
    public void registerGenerated(String prototype, PrototypeDescription<ClassOrInterfaceDeclaration> generated) {
        this.generated.put(prototype, generated);
        if (Objects.nonNull(generated.getInterface())) {
            this.generatedInterfaces.put(generated.getInterfaceFullName(), generated);
            this.generatedClasses.put(generated.getInterfaceFullName(), (TypeDeclaration)generated.getInterface());
        } else if (Objects.nonNull(generated.getImplementation())) {
            this.generatedClasses.put(generated.getImplementorFullName(), (TypeDeclaration)generated.getImplementation());
        }
    }

    @Override
    public void registerGeneratedClass(String prototype, TypeDeclaration generated) {
        this.generatedClasses.put(prototype, generated);
    }

    @Override
    public void registerExternalLookup(UnaryOperator<String> lookup) {
        this.externalLookup = lookup;
    }

    @Override
    public CustomDescription createCustomDescription(String id) {
        return this.custom.computeIfAbsent(id, k -> Structures.CustomParsed.bldr().id(id).properties(Structures.defaultBuilder().build()).build());
    }

    @Override
    public CustomDescription getCustomDescription(String id) {
        return this.custom.get(id);
    }

    @Override
    public Collection<CustomDescription> custom() {
        return this.custom.values();
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findParsed(String prototype) {
        PrototypeDescription<ClassOrInterfaceDeclaration> result = this.parsed.get(prototype);
        if (Objects.isNull(result)) {
            this.handleExternal(prototype);
        }
        return result;
    }

    private void handleExternal(String prototype) {
        Optional res;
        String code;
        if (Objects.nonNull(this.externalLookup) && !this.external.containsKey(prototype) && Objects.nonNull(code = (String)this.externalLookup.apply(prototype)) && (res = this.parser.parse(code).getResult()).isPresent() && ((CompilationUnit)res.get()).getType(0).isTypeDeclaration()) {
            this.external.put(prototype, Structures.Parsed.builder().declaration(((CompilationUnit)res.get()).getType(0).asTypeDeclaration()).declarationUnit((CompilationUnit)res.get()).spec(((CompilationUnit)res.get()).getType(0).isClassOrInterfaceDeclaration() ? ((CompilationUnit)res.get()).getType(0).asClassOrInterfaceDeclaration() : null).build());
        }
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findGenerated(String prototype) {
        PrototypeDescription<ClassOrInterfaceDeclaration> result = this.generated.get(prototype);
        if (Objects.isNull(result)) {
            result = this.generatedInterfaces.get(prototype);
        }
        return result;
    }

    @Override
    public TypeDeclaration findGeneratedClass(String name) {
        return this.generatedClasses.get(name);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findExternal(String prototype) {
        this.handleExternal(prototype);
        return this.external.get(prototype);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findByInterfaceName(String name) {
        return this.parsed.values().stream().filter(p -> p.getInterfaceName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findEnum(String generated) {
        return this.enums.get(generated);
    }

    @Override
    public Optional<PrototypeField> findField(String prototype, String name) {
        return (Optional)((Object)Tools.nullCheck(this.findParsed(prototype), parsed -> parsed.findField(name)));
    }

    @Override
    public boolean isParsed(String prototype) {
        return this.parsed.containsKey(prototype);
    }

    @Override
    public boolean isGenerated(String prototype) {
        return this.generated.containsKey(prototype);
    }

    @Override
    public boolean isExternal(String prototype) {
        this.handleExternal(prototype);
        return this.external.containsKey(prototype);
    }

    @Override
    public Collection<PrototypeDescription<ClassOrInterfaceDeclaration>> parsed() {
        return this.parsed.values();
    }

    @Override
    public Collection<PrototypeDescription<ClassOrInterfaceDeclaration>> generated() {
        return this.generated.values();
    }

    @Override
    public void addPrototypeMap(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        this.prototypeMaps.add((Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>)Pair.of(prototypeMap, parsed));
    }

    @Override
    public void calcPrototypeMaps() {
        this.prototypeMaps.forEach(p -> ((Map)p.getLeft()).put(((PrototypeDescription)p.getRight()).getInterfaceName(), (PrototypeDescription)p.getRight()));
    }

    @Override
    public List<PrototypeDescription<ClassOrInterfaceDeclaration>> findGeneratedByFileName(String fileName) {
        return this.generated.values().stream().filter(g -> fileName.equals(g.getPrototypeFileName())).collect(Collectors.toList());
    }

    public void clean() {
        this.parsed.clear();
        this.generated.clear();
        this.enums.clear();
        this.external.clear();
        this.prototypeMaps.clear();
    }

    @Override
    public JavaParser getParser() {
        return this.parser;
    }

    @Override
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    @Override
    public void setProcessingEnvironment(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    @Override
    public RoundEnvironment getRoundEnvironment() {
        return this.roundEnvironment;
    }

    @Override
    public void setRoundEnvironment(RoundEnvironment roundEnvironment) {
        this.roundEnvironment = roundEnvironment;
    }
}

