/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.Element;
import net.binis.codegen.compiler.CGAnnotation;
import net.binis.codegen.compiler.CGAssign;
import net.binis.codegen.compiler.CGClassDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.compiler.CGTypeTag;
import net.binis.codegen.compiler.Name;
import net.binis.codegen.compiler.TreeMaker;

public class ElementUtils {
    public static void addClassAnnotation(Element element, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        TreeMaker maker = TreeMaker.create();
        CGClassDeclaration decl = CGClassDeclaration.create(maker.getTrees(), element);
        CGList<CGExpression> list = CGList.nil();
        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
            list = list.append(maker.Assign(maker.Ident(Name.create(attr.getKey())), ElementUtils.calcExpression(maker, attr.getValue())));
        }
        CGAnnotation ann = maker.Annotation(maker.QualIdent(maker.getSymbol(annotation.getCanonicalName())), list);
        decl.getModifiers().getAnnotations().append(ann);
    }

    public static void removeClassAnnotation(Element element, Class<? extends Annotation> annotation) {
        TreeMaker maker = TreeMaker.create();
        CGClassDeclaration decl = CGClassDeclaration.create(maker.getTrees(), element);
        CGList<CGAnnotation> list = CGList.nil();
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (ann.getAnnotationType().getType().toString().equals(annotation.getCanonicalName())) continue;
            list = list.append(ann);
        }
        decl.getModifiers().setAnnotations(list);
    }

    public static void addClassAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name, Object value) {
        TreeMaker maker = TreeMaker.create();
        CGClassDeclaration decl = CGClassDeclaration.create(maker.getTrees(), element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.getAnnotationType().getType().toString().equals(annotation.getCanonicalName())) continue;
            ann.getArguments().append(maker.Assign(maker.Ident(Name.create(name)), ElementUtils.calcExpression(maker, value)));
            break;
        }
    }

    public static void removeClassAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name) {
        TreeMaker maker = TreeMaker.create();
        CGClassDeclaration decl = CGClassDeclaration.create(maker.getTrees(), element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.getAnnotationType().getType().toString().equals(annotation.getCanonicalName())) continue;
            CGList<CGExpression> list = CGList.nil();
            Iterator<CGExpression> iter = ann.getArguments().iterator(CGExpression.class);
            while (iter.hasNext()) {
                CGExpression attr = iter.next();
                if (attr.getInstance().getClass().equals(CGAssign.theClass())) {
                    CGAssign assign = new CGAssign(attr.getInstance());
                    if (assign.getVariable().getInstance().toString().equals(name)) continue;
                    list.append(attr);
                    continue;
                }
                list.append(attr);
            }
            ann.setArguments(list);
            break;
        }
    }

    public static void replaceClassAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name, Object value) {
        TreeMaker maker = TreeMaker.create();
        CGClassDeclaration decl = CGClassDeclaration.create(maker.getTrees(), element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.getAnnotationType().getType().toString().equals(annotation.getCanonicalName())) continue;
            CGList<CGExpression> list = CGList.nil();
            Iterator<CGExpression> iter = ann.getArguments().iterator(CGExpression.class);
            while (iter.hasNext()) {
                CGExpression attr = iter.next();
                if (attr.getInstance().getClass().equals(CGAssign.theClass())) {
                    CGAssign assign = new CGAssign(attr.getInstance());
                    if (!assign.getVariable().getInstance().toString().equals(name)) {
                        list.append(attr);
                        continue;
                    }
                    list.append(maker.Assign(maker.Ident(Name.create(name)), ElementUtils.calcExpression(maker, value)));
                    continue;
                }
                list.append(attr);
            }
            ann.setArguments(list);
            break;
        }
    }

    protected static CGExpression calcExpression(TreeMaker maker, Object value) {
        if (value instanceof String) {
            return maker.Literal(CGTypeTag.CLASS, value);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return maker.Literal(CGTypeTag.BOOLEAN, b != false ? 1 : 0);
        }
        if (value instanceof Long) {
            return maker.Literal(CGTypeTag.LONG, value);
        }
        if (value instanceof Integer) {
            return maker.Literal(CGTypeTag.INT, value);
        }
        if (value instanceof Double) {
            return maker.Literal(CGTypeTag.DOUBLE, value);
        }
        if (value instanceof Float) {
            return maker.Literal(CGTypeTag.FLOAT, value);
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return maker.Literal(CGTypeTag.CHAR, c.charValue());
        }
        if (value instanceof Short) {
            return maker.TypeCast(maker.TypeIdent(CGTypeTag.SHORT), maker.Literal(CGTypeTag.INT, value));
        }
        if (value instanceof Byte) {
            return maker.TypeCast(maker.TypeIdent(CGTypeTag.BYTE), maker.Literal(CGTypeTag.INT, value));
        }
        if (value instanceof Enum) {
            CGSymbol symbol = maker.getSymbol(value.getClass().getCanonicalName());
            return maker.Select(maker.QualIdent(symbol), Name.create(value.toString()));
        }
        if (value instanceof Class) {
            Class c = (Class)value;
            CGSymbol symbol = maker.getSymbol(c.getCanonicalName());
            return maker.Select(maker.QualIdent(symbol), Name.create("class"));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            CGList<CGExpression> list = CGList.nil();
            for (int i = 0; i < length; ++i) {
                list.append(ElementUtils.calcExpression(maker, Array.get(value, i)));
            }
            return maker.NewArray(null, CGList.nil(), list);
        }
        return ElementUtils.classIdent(maker, value.toString());
    }

    protected static CGExpression classIdent(TreeMaker maker, String className) {
        String[] strings = className.split("\\.");
        CGExpression classNameIdent = maker.Ident(Name.create(strings[0]));
        for (int i = 1; i < strings.length; ++i) {
            classNameIdent = maker.Select(classNameIdent, Name.create(strings[i]));
        }
        return classNameIdent;
    }
}

