/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.binis.codegen.annotation.type.EmbeddedModifierType;
import net.binis.codegen.annotation.type.GenerationStrategy;
import net.binis.codegen.enrich.CustomDescription;
import net.binis.codegen.enrich.Enricher;
import net.binis.codegen.enrich.GeneratedFile;
import net.binis.codegen.enrich.PrototypeEnricher;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeConstant;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.options.CodeOption;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Structures {
    private static final Logger log = LoggerFactory.getLogger(Structures.class);
    public static final String VALUE = "value";
    public static final Map<String, Supplier<PrototypeDataHandler.PrototypeDataHandlerBuilder>> defaultProperties = new HashMap<String, Supplier<PrototypeDataHandler.PrototypeDataHandlerBuilder>>();

    public static PrototypeDataHandler.PrototypeDataHandlerBuilder builder(String type) {
        Supplier<PrototypeDataHandler.PrototypeDataHandlerBuilder> result = defaultProperties.get(type);
        if (Objects.isNull(result)) {
            return Structures.defaultBuilder();
        }
        return result.get();
    }

    public static PrototypeDataHandler.PrototypeDataHandlerBuilder defaultBuilder() {
        return PrototypeDataHandler.builder().strategy(GenerationStrategy.CLASSIC).generateConstructor(true).generateInterface(true).generateImplementation(true).classGetters(true).classSetters(true).interfaceSetters(true).modifierName("Modify");
    }

    public static void registerTemplate(Class<?> ann) {
        if (Annotation.class.isAssignableFrom(ann)) {
            defaultProperties.put(ann.getSimpleName(), () -> {
                PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.defaultBuilder();
                for (Annotation a : ann.getAnnotations()) {
                    if (!defaultProperties.containsKey(a.annotationType().getSimpleName())) continue;
                    Structures.readAnnotation(a, a.annotationType(), builder, Structures::readAnnotationValue);
                }
                Structures.readAnnotation(null, ann, builder, (method, annotation) -> method.getDefaultValue());
                return builder;
            });
        } else {
            log.warn("Can't register template '{}' because it isn't annotation!", (Object)ann.getCanonicalName());
        }
    }

    public static void registerTemplate(AnnotationDeclaration template) {
        defaultProperties.put(template.getNameAsString(), () -> {
            PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.defaultBuilder();
            template.getAnnotations().stream().filter(a -> defaultProperties.containsKey(a.getNameAsString())).forEach(a -> Structures.readAnnotation(a, builder));
            template.getMembers().stream().filter(BodyDeclaration::isAnnotationMemberDeclaration).map(BodyDeclaration::asAnnotationMemberDeclaration).filter(m -> m.getDefaultValue().isPresent()).forEach(member -> {
                switch (member.getNameAsString()) {
                    case "base": {
                        builder.base(Structures.handleBooleanExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "name": {
                        builder.name(Structures.handleStringExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "generateConstructor": {
                        builder.generateConstructor(Structures.handleBooleanExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "options": {
                        builder.options(Structures.handleClassExpression((Expression)member.getDefaultValue().get(), Set.class));
                        break;
                    }
                    case "interfaceName": {
                        builder.interfaceName(Structures.handleStringExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "implementationPath": {
                        builder.implementationPath(Structures.handleStringExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "enrichers": {
                        builder.predefinedEnrichers(Structures.handleClassExpression((Expression)member.getDefaultValue().get(), List.class));
                        break;
                    }
                    case "inheritedEnrichers": {
                        builder.predefinedInheritedEnrichers(Structures.handleClassExpression((Expression)member.getDefaultValue().get(), List.class));
                        break;
                    }
                    case "interfaceSetters": {
                        builder.interfaceSetters(Structures.handleBooleanExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "classGetters": {
                        builder.classGetters(Structures.handleBooleanExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "classSetters": {
                        builder.classSetters(Structures.handleBooleanExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "baseModifierClass": {
                        builder.baseModifierClass(Structures.handleClassExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "mixInClass": {
                        builder.mixInClass(Structures.handleClassExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "interfacePath": {
                        builder.interfacePath(Structures.handleStringExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "generateInterface": {
                        builder.generateInterface(Structures.handleBooleanExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "basePath": {
                        builder.basePath(Structures.handleStringExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "generateImplementation": {
                        builder.generateImplementation(Structures.handleBooleanExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "implementationPackage": {
                        builder.classPackage(Structures.handleStringExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    case "strategy": {
                        builder.strategy((GenerationStrategy)Structures.handleEnumExpression((Expression)member.getDefaultValue().get()));
                        break;
                    }
                    default: {
                        builder.custom(member.getNameAsString(), member.getDefaultValue().get());
                    }
                }
            });
            return builder;
        });
    }

    private static void readAnnotation(AnnotationExpr ann, PrototypeDataHandler.PrototypeDataHandlerBuilder builder) {
        ann.getChildNodes().forEach(node -> {
            if (node instanceof MemberValuePair) {
                String name;
                MemberValuePair pair = (MemberValuePair)node;
                switch (name = pair.getNameAsString()) {
                    case "name": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        String intf = value.replace("Entity", "");
                        builder.name(value).className(value).interfaceName(intf).longModifierName(intf + ".Modify");
                        break;
                    }
                    case "generateConstructor": {
                        builder.generateConstructor(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "generateImplementation": {
                        builder.generateImplementation(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "generateInterface": {
                        builder.generateInterface(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "interfaceName": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        break;
                    }
                    case "classGetters": {
                        builder.classGetters(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "classSetters": {
                        builder.classSetters(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "interfaceSetters": {
                        builder.interfaceSetters(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "base": {
                        builder.base(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "baseModifierClass": {
                        String value = pair.getValue().asClassExpr().getTypeAsString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.baseModifierClass(value);
                        break;
                    }
                    case "mixInClass": {
                        String value = pair.getValue().asClassExpr().getTypeAsString();
                        if (!StringUtils.isNotBlank((CharSequence)value) || "void".equals(value)) break;
                        builder.mixInClass(value);
                        break;
                    }
                    case "implementationPackage": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.classPackage(value);
                        break;
                    }
                    case "strategy": {
                        String value = pair.getValue().asFieldAccessExpr().getNameAsString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.strategy(GenerationStrategy.valueOf((String)value));
                        break;
                    }
                    case "basePath": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.basePath(value);
                        break;
                    }
                    case "interfacePath": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.interfacePath(value);
                        break;
                    }
                    case "implementationPath": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.implementationPath(value);
                        break;
                    }
                    case "enrichers": {
                        builder.predefinedEnrichers(Structures.handleClassExpression(pair.getValue(), List.class));
                        break;
                    }
                    case "inheritedEnrichers": {
                        builder.predefinedInheritedEnrichers(Structures.handleClassExpression(pair.getValue(), List.class));
                        break;
                    }
                    case "options": {
                        builder.options(Structures.handleClassExpression(pair.getValue(), Set.class));
                        break;
                    }
                }
            } else if (!(node instanceof Name)) {
                builder.custom(VALUE, node);
            }
        });
    }

    private static void readAnnotation(Annotation ann, Class<?> cls, PrototypeDataHandler.PrototypeDataHandlerBuilder builder, BiFunction<Method, Annotation, Object> func) {
        block42: for (Method method : cls.getDeclaredMethods()) {
            switch (method.getName()) {
                case "base": {
                    builder.base((Boolean)func.apply(method, ann));
                    continue block42;
                }
                case "name": {
                    builder.name(Structures.handleString(func.apply(method, ann)));
                    continue block42;
                }
                case "generateConstructor": {
                    builder.generateConstructor((Boolean)func.apply(method, ann));
                    continue block42;
                }
                case "options": {
                    builder.options(Arrays.stream((Class[])func.apply(method, ann)).collect(Collectors.toSet()));
                    continue block42;
                }
                case "interfaceName": {
                    builder.interfaceName(Structures.handleString(func.apply(method, ann)));
                    continue block42;
                }
                case "implementationPath": {
                    builder.implementationPath(Structures.handleString(func.apply(method, ann)));
                    continue block42;
                }
                case "enrichers": {
                    builder.predefinedEnrichers(Arrays.stream((Class[])func.apply(method, ann)).toList());
                    continue block42;
                }
                case "inheritedEnrichers": {
                    builder.predefinedInheritedEnrichers(Arrays.stream((Class[])func.apply(method, ann)).toList());
                    continue block42;
                }
                case "interfaceSetters": {
                    builder.interfaceSetters((Boolean)func.apply(method, ann));
                    continue block42;
                }
                case "classGetters": {
                    builder.classGetters((Boolean)func.apply(method, ann));
                    continue block42;
                }
                case "classSetters": {
                    builder.classSetters((Boolean)func.apply(method, ann));
                    continue block42;
                }
                case "baseModifierClass": {
                    builder.baseModifierClass(Structures.handleClass(func.apply(method, ann)));
                    continue block42;
                }
                case "mixInClass": {
                    builder.mixInClass(Structures.handleClass(func.apply(method, ann)));
                    continue block42;
                }
                case "interfacePath": {
                    builder.interfacePath(Structures.handleString(func.apply(method, ann)));
                    continue block42;
                }
                case "generateInterface": {
                    builder.generateInterface((Boolean)func.apply(method, ann));
                    continue block42;
                }
                case "basePath": {
                    builder.basePath(Structures.handleString(func.apply(method, ann)));
                    continue block42;
                }
                case "generateImplementation": {
                    builder.generateImplementation((Boolean)func.apply(method, ann));
                    continue block42;
                }
                case "implementationPackage": {
                    builder.classPackage(Structures.handleString(func.apply(method, ann)));
                    continue block42;
                }
                case "strategy": {
                    builder.strategy((GenerationStrategy)func.apply(method, ann));
                    continue block42;
                }
                default: {
                    builder.custom(method.getName(), func.apply(method, ann));
                }
            }
        }
    }

    private static Object readAnnotationValue(Method method, Annotation ann) {
        try {
            return method.invoke((Object)ann, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Unable to read value for {}() of annotation {}", (Object)method.getName(), (Object)ann.annotationType().getCanonicalName());
            return null;
        }
    }

    private static <T extends Collection> T handleClassExpression(Expression value, Class<T> cls) {
        AbstractCollection result;
        AbstractCollection abstractCollection = result = Set.class.equals(cls) ? new HashSet() : new ArrayList();
        if (value.isArrayInitializerExpr()) {
            value.asArrayInitializerExpr().getValues().forEach(v -> Tools.with(Structures.handleClassExpression(v), r -> Tools.with(Reflection.loadClass((String)r), c -> result.add(c))));
        } else if (value.isClassExpr()) {
            Tools.with(Structures.handleClassExpression(value), r -> Tools.with(Reflection.loadClass((String)r), c -> result.add(c)));
        } else {
            log.warn("Class expression not implemented: {}", (Object)value.getClass().getCanonicalName());
        }
        return (T)result;
    }

    private static String handleClassExpression(Expression value) {
        if (value.isClassExpr()) {
            return Helpers.getExternalClassNameIfExists((CompilationUnit)value.findCompilationUnit().get(), value.asClassExpr().getType().toString());
        }
        log.warn("Class expression not implemented: {}", (Object)value.getClass().getCanonicalName());
        return null;
    }

    private static String handleStringExpression(Expression expression) {
        if (expression.isStringLiteralExpr()) {
            return expression.asStringLiteralExpr().getValue();
        }
        log.warn("String expression not implemented: {}", (Object)expression.getClass().getCanonicalName());
        return null;
    }

    private static Enum handleEnumExpression(Expression expression) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static boolean handleBooleanExpression(Expression expression) {
        if (expression.isBooleanLiteralExpr()) {
            return expression.asBooleanLiteralExpr().getValue();
        }
        log.warn("Boolean expression not implemented: {}", (Object)expression.getClass().getCanonicalName());
        return false;
    }

    private static String handleString(Object value) {
        String val = (String)value;
        return StringUtils.isBlank((CharSequence)val) ? null : val;
    }

    private static String handleClass(Object value) {
        Class val = (Class)value;
        return Void.TYPE.equals(val) ? null : val.getCanonicalName();
    }

    public static class PrototypeDataHandler
    implements PrototypeData {
        private String prototypeName;
        private String prototypeFullName;
        private String name;
        private String className;
        private String classPackage;
        private boolean classGetters;
        private boolean classSetters;
        private String interfaceName;
        private String interfacePackage;
        private boolean interfaceSetters;
        private String modifierName;
        private String longModifierName;
        private String modifierPackage;
        private String baseClassName;
        private boolean generateConstructor;
        private boolean generateInterface;
        private boolean generateImplementation;
        private boolean base;
        private String baseModifierClass;
        private String mixInClass;
        private String basePath;
        private String interfacePath;
        private String implementationPath;
        private GenerationStrategy strategy;
        private int ordinalOffset;
        private List<PrototypeEnricher> enrichers;
        private List<PrototypeEnricher> inheritedEnrichers;
        private Set<Class<? extends CodeOption>> options;
        private Map<String, Object> custom;
        private List<Class<? extends Enricher>> predefinedEnrichers;
        private List<Class<? extends Enricher>> predefinedInheritedEnrichers;

        PrototypeDataHandler(String prototypeName, String prototypeFullName, String name, String className, String classPackage, boolean classGetters, boolean classSetters, String interfaceName, String interfacePackage, boolean interfaceSetters, String modifierName, String longModifierName, String modifierPackage, String baseClassName, boolean generateConstructor, boolean generateInterface, boolean generateImplementation, boolean base, String baseModifierClass, String mixInClass, String basePath, String interfacePath, String implementationPath, GenerationStrategy strategy, int ordinalOffset, List<PrototypeEnricher> enrichers, List<PrototypeEnricher> inheritedEnrichers, Set<Class<? extends CodeOption>> options, Map<String, Object> custom, List<Class<? extends Enricher>> predefinedEnrichers, List<Class<? extends Enricher>> predefinedInheritedEnrichers) {
            this.prototypeName = prototypeName;
            this.prototypeFullName = prototypeFullName;
            this.name = name;
            this.className = className;
            this.classPackage = classPackage;
            this.classGetters = classGetters;
            this.classSetters = classSetters;
            this.interfaceName = interfaceName;
            this.interfacePackage = interfacePackage;
            this.interfaceSetters = interfaceSetters;
            this.modifierName = modifierName;
            this.longModifierName = longModifierName;
            this.modifierPackage = modifierPackage;
            this.baseClassName = baseClassName;
            this.generateConstructor = generateConstructor;
            this.generateInterface = generateInterface;
            this.generateImplementation = generateImplementation;
            this.base = base;
            this.baseModifierClass = baseModifierClass;
            this.mixInClass = mixInClass;
            this.basePath = basePath;
            this.interfacePath = interfacePath;
            this.implementationPath = implementationPath;
            this.strategy = strategy;
            this.ordinalOffset = ordinalOffset;
            this.enrichers = enrichers;
            this.inheritedEnrichers = inheritedEnrichers;
            this.options = options;
            this.custom = custom;
            this.predefinedEnrichers = predefinedEnrichers;
            this.predefinedInheritedEnrichers = predefinedInheritedEnrichers;
        }

        public static PrototypeDataHandlerBuilder builder() {
            return new PrototypeDataHandlerBuilder();
        }

        @Override
        public String getPrototypeName() {
            return this.prototypeName;
        }

        @Override
        public String getPrototypeFullName() {
            return this.prototypeFullName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getClassPackage() {
            return this.classPackage;
        }

        @Override
        public boolean isClassGetters() {
            return this.classGetters;
        }

        @Override
        public boolean isClassSetters() {
            return this.classSetters;
        }

        @Override
        public String getInterfaceName() {
            return this.interfaceName;
        }

        @Override
        public String getInterfacePackage() {
            return this.interfacePackage;
        }

        @Override
        public boolean isInterfaceSetters() {
            return this.interfaceSetters;
        }

        @Override
        public String getModifierName() {
            return this.modifierName;
        }

        @Override
        public String getLongModifierName() {
            return this.longModifierName;
        }

        @Override
        public String getModifierPackage() {
            return this.modifierPackage;
        }

        @Override
        public String getBaseClassName() {
            return this.baseClassName;
        }

        @Override
        public boolean isGenerateConstructor() {
            return this.generateConstructor;
        }

        @Override
        public boolean isGenerateInterface() {
            return this.generateInterface;
        }

        @Override
        public boolean isGenerateImplementation() {
            return this.generateImplementation;
        }

        @Override
        public boolean isBase() {
            return this.base;
        }

        @Override
        public String getBaseModifierClass() {
            return this.baseModifierClass;
        }

        @Override
        public String getMixInClass() {
            return this.mixInClass;
        }

        @Override
        public String getBasePath() {
            return this.basePath;
        }

        @Override
        public String getInterfacePath() {
            return this.interfacePath;
        }

        @Override
        public String getImplementationPath() {
            return this.implementationPath;
        }

        public GenerationStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        public int getOrdinalOffset() {
            return this.ordinalOffset;
        }

        @Override
        public List<PrototypeEnricher> getEnrichers() {
            return this.enrichers;
        }

        @Override
        public List<PrototypeEnricher> getInheritedEnrichers() {
            return this.inheritedEnrichers;
        }

        @Override
        public Set<Class<? extends CodeOption>> getOptions() {
            return this.options;
        }

        @Override
        public Map<String, Object> getCustom() {
            return this.custom;
        }

        public List<Class<? extends Enricher>> getPredefinedEnrichers() {
            return this.predefinedEnrichers;
        }

        public List<Class<? extends Enricher>> getPredefinedInheritedEnrichers() {
            return this.predefinedInheritedEnrichers;
        }

        public void setPrototypeName(String prototypeName) {
            this.prototypeName = prototypeName;
        }

        public void setPrototypeFullName(String prototypeFullName) {
            this.prototypeFullName = prototypeFullName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setClassPackage(String classPackage) {
            this.classPackage = classPackage;
        }

        @Override
        public void setClassGetters(boolean classGetters) {
            this.classGetters = classGetters;
        }

        @Override
        public void setClassSetters(boolean classSetters) {
            this.classSetters = classSetters;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public void setInterfacePackage(String interfacePackage) {
            this.interfacePackage = interfacePackage;
        }

        @Override
        public void setInterfaceSetters(boolean interfaceSetters) {
            this.interfaceSetters = interfaceSetters;
        }

        public void setModifierName(String modifierName) {
            this.modifierName = modifierName;
        }

        public void setLongModifierName(String longModifierName) {
            this.longModifierName = longModifierName;
        }

        public void setModifierPackage(String modifierPackage) {
            this.modifierPackage = modifierPackage;
        }

        public void setBaseClassName(String baseClassName) {
            this.baseClassName = baseClassName;
        }

        @Override
        public void setGenerateConstructor(boolean generateConstructor) {
            this.generateConstructor = generateConstructor;
        }

        @Override
        public void setGenerateInterface(boolean generateInterface) {
            this.generateInterface = generateInterface;
        }

        @Override
        public void setGenerateImplementation(boolean generateImplementation) {
            this.generateImplementation = generateImplementation;
        }

        public void setBase(boolean base) {
            this.base = base;
        }

        public void setBaseModifierClass(String baseModifierClass) {
            this.baseModifierClass = baseModifierClass;
        }

        public void setMixInClass(String mixInClass) {
            this.mixInClass = mixInClass;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setInterfacePath(String interfacePath) {
            this.interfacePath = interfacePath;
        }

        public void setImplementationPath(String implementationPath) {
            this.implementationPath = implementationPath;
        }

        public void setStrategy(GenerationStrategy strategy) {
            this.strategy = strategy;
        }

        public void setOrdinalOffset(int ordinalOffset) {
            this.ordinalOffset = ordinalOffset;
        }

        public void setEnrichers(List<PrototypeEnricher> enrichers) {
            this.enrichers = enrichers;
        }

        public void setInheritedEnrichers(List<PrototypeEnricher> inheritedEnrichers) {
            this.inheritedEnrichers = inheritedEnrichers;
        }

        public void setOptions(Set<Class<? extends CodeOption>> options) {
            this.options = options;
        }

        public void setCustom(Map<String, Object> custom) {
            this.custom = custom;
        }

        public void setPredefinedEnrichers(List<Class<? extends Enricher>> predefinedEnrichers) {
            this.predefinedEnrichers = predefinedEnrichers;
        }

        public void setPredefinedInheritedEnrichers(List<Class<? extends Enricher>> predefinedInheritedEnrichers) {
            this.predefinedInheritedEnrichers = predefinedInheritedEnrichers;
        }

        public static class PrototypeDataHandlerBuilder {
            private String prototypeName;
            private String prototypeFullName;
            private String name;
            private String className;
            private String classPackage;
            private boolean classGetters;
            private boolean classSetters;
            private String interfaceName;
            private String interfacePackage;
            private boolean interfaceSetters;
            private String modifierName;
            private String longModifierName;
            private String modifierPackage;
            private String baseClassName;
            private boolean generateConstructor;
            private boolean generateInterface;
            private boolean generateImplementation;
            private boolean base;
            private String baseModifierClass;
            private String mixInClass;
            private String basePath;
            private String interfacePath;
            private String implementationPath;
            private GenerationStrategy strategy;
            private int ordinalOffset;
            private List<PrototypeEnricher> enrichers;
            private List<PrototypeEnricher> inheritedEnrichers;
            private Set<Class<? extends CodeOption>> options;
            private Map<String, Object> custom;
            private List<Class<? extends Enricher>> predefinedEnrichers;
            private List<Class<? extends Enricher>> predefinedInheritedEnrichers;

            public PrototypeDataHandlerBuilder custom(String name, Object value) {
                if (Objects.isNull(this.custom)) {
                    this.custom = new HashMap<String, Object>();
                }
                this.custom.put(name, value);
                return this;
            }

            PrototypeDataHandlerBuilder() {
            }

            public PrototypeDataHandlerBuilder prototypeName(String prototypeName) {
                this.prototypeName = prototypeName;
                return this;
            }

            public PrototypeDataHandlerBuilder prototypeFullName(String prototypeFullName) {
                this.prototypeFullName = prototypeFullName;
                return this;
            }

            public PrototypeDataHandlerBuilder name(String name) {
                this.name = name;
                return this;
            }

            public PrototypeDataHandlerBuilder className(String className) {
                this.className = className;
                return this;
            }

            public PrototypeDataHandlerBuilder classPackage(String classPackage) {
                this.classPackage = classPackage;
                return this;
            }

            public PrototypeDataHandlerBuilder classGetters(boolean classGetters) {
                this.classGetters = classGetters;
                return this;
            }

            public PrototypeDataHandlerBuilder classSetters(boolean classSetters) {
                this.classSetters = classSetters;
                return this;
            }

            public PrototypeDataHandlerBuilder interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public PrototypeDataHandlerBuilder interfacePackage(String interfacePackage) {
                this.interfacePackage = interfacePackage;
                return this;
            }

            public PrototypeDataHandlerBuilder interfaceSetters(boolean interfaceSetters) {
                this.interfaceSetters = interfaceSetters;
                return this;
            }

            public PrototypeDataHandlerBuilder modifierName(String modifierName) {
                this.modifierName = modifierName;
                return this;
            }

            public PrototypeDataHandlerBuilder longModifierName(String longModifierName) {
                this.longModifierName = longModifierName;
                return this;
            }

            public PrototypeDataHandlerBuilder modifierPackage(String modifierPackage) {
                this.modifierPackage = modifierPackage;
                return this;
            }

            public PrototypeDataHandlerBuilder baseClassName(String baseClassName) {
                this.baseClassName = baseClassName;
                return this;
            }

            public PrototypeDataHandlerBuilder generateConstructor(boolean generateConstructor) {
                this.generateConstructor = generateConstructor;
                return this;
            }

            public PrototypeDataHandlerBuilder generateInterface(boolean generateInterface) {
                this.generateInterface = generateInterface;
                return this;
            }

            public PrototypeDataHandlerBuilder generateImplementation(boolean generateImplementation) {
                this.generateImplementation = generateImplementation;
                return this;
            }

            public PrototypeDataHandlerBuilder base(boolean base) {
                this.base = base;
                return this;
            }

            public PrototypeDataHandlerBuilder baseModifierClass(String baseModifierClass) {
                this.baseModifierClass = baseModifierClass;
                return this;
            }

            public PrototypeDataHandlerBuilder mixInClass(String mixInClass) {
                this.mixInClass = mixInClass;
                return this;
            }

            public PrototypeDataHandlerBuilder basePath(String basePath) {
                this.basePath = basePath;
                return this;
            }

            public PrototypeDataHandlerBuilder interfacePath(String interfacePath) {
                this.interfacePath = interfacePath;
                return this;
            }

            public PrototypeDataHandlerBuilder implementationPath(String implementationPath) {
                this.implementationPath = implementationPath;
                return this;
            }

            public PrototypeDataHandlerBuilder strategy(GenerationStrategy strategy) {
                this.strategy = strategy;
                return this;
            }

            public PrototypeDataHandlerBuilder ordinalOffset(int ordinalOffset) {
                this.ordinalOffset = ordinalOffset;
                return this;
            }

            public PrototypeDataHandlerBuilder enrichers(List<PrototypeEnricher> enrichers) {
                this.enrichers = enrichers;
                return this;
            }

            public PrototypeDataHandlerBuilder inheritedEnrichers(List<PrototypeEnricher> inheritedEnrichers) {
                this.inheritedEnrichers = inheritedEnrichers;
                return this;
            }

            public PrototypeDataHandlerBuilder options(Set<Class<? extends CodeOption>> options) {
                this.options = options;
                return this;
            }

            public PrototypeDataHandlerBuilder predefinedEnrichers(List<Class<? extends Enricher>> predefinedEnrichers) {
                this.predefinedEnrichers = predefinedEnrichers;
                return this;
            }

            public PrototypeDataHandlerBuilder predefinedInheritedEnrichers(List<Class<? extends Enricher>> predefinedInheritedEnrichers) {
                this.predefinedInheritedEnrichers = predefinedInheritedEnrichers;
                return this;
            }

            public PrototypeDataHandler build() {
                return new PrototypeDataHandler(this.prototypeName, this.prototypeFullName, this.name, this.className, this.classPackage, this.classGetters, this.classSetters, this.interfaceName, this.interfacePackage, this.interfaceSetters, this.modifierName, this.longModifierName, this.modifierPackage, this.baseClassName, this.generateConstructor, this.generateInterface, this.generateImplementation, this.base, this.baseModifierClass, this.mixInClass, this.basePath, this.interfacePath, this.implementationPath, this.strategy, this.ordinalOffset, this.enrichers, this.inheritedEnrichers, this.options, this.custom, this.predefinedEnrichers, this.predefinedInheritedEnrichers);
            }

            public String toString() {
                return "Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder(prototypeName=" + this.prototypeName + ", prototypeFullName=" + this.prototypeFullName + ", name=" + this.name + ", className=" + this.className + ", classPackage=" + this.classPackage + ", classGetters=" + this.classGetters + ", classSetters=" + this.classSetters + ", interfaceName=" + this.interfaceName + ", interfacePackage=" + this.interfacePackage + ", interfaceSetters=" + this.interfaceSetters + ", modifierName=" + this.modifierName + ", longModifierName=" + this.longModifierName + ", modifierPackage=" + this.modifierPackage + ", baseClassName=" + this.baseClassName + ", generateConstructor=" + this.generateConstructor + ", generateInterface=" + this.generateInterface + ", generateImplementation=" + this.generateImplementation + ", base=" + this.base + ", baseModifierClass=" + this.baseModifierClass + ", mixInClass=" + this.mixInClass + ", basePath=" + this.basePath + ", interfacePath=" + this.interfacePath + ", implementationPath=" + this.implementationPath + ", strategy=" + this.strategy + ", ordinalOffset=" + this.ordinalOffset + ", enrichers=" + this.enrichers + ", inheritedEnrichers=" + this.inheritedEnrichers + ", options=" + this.options + ", custom=" + this.custom + ", predefinedEnrichers=" + this.predefinedEnrichers + ", predefinedInheritedEnrichers=" + this.predefinedInheritedEnrichers + ")";
            }
        }
    }

    public static class ProcessingType {
        private String interfacePackage;
        private String interfaceName;
        private String classPackage;
        private String className;

        ProcessingType(String interfacePackage, String interfaceName, String classPackage, String className) {
            this.interfacePackage = interfacePackage;
            this.interfaceName = interfaceName;
            this.classPackage = classPackage;
            this.className = className;
        }

        public static ProcessingTypeBuilder builder() {
            return new ProcessingTypeBuilder();
        }

        public String getInterfacePackage() {
            return this.interfacePackage;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getClassPackage() {
            return this.classPackage;
        }

        public String getClassName() {
            return this.className;
        }

        public void setInterfacePackage(String interfacePackage) {
            this.interfacePackage = interfacePackage;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public void setClassPackage(String classPackage) {
            this.classPackage = classPackage;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessingType)) {
                return false;
            }
            ProcessingType other = (ProcessingType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$interfacePackage = this.getInterfacePackage();
            String other$interfacePackage = other.getInterfacePackage();
            if (this$interfacePackage == null ? other$interfacePackage != null : !this$interfacePackage.equals(other$interfacePackage)) {
                return false;
            }
            String this$interfaceName = this.getInterfaceName();
            String other$interfaceName = other.getInterfaceName();
            if (this$interfaceName == null ? other$interfaceName != null : !this$interfaceName.equals(other$interfaceName)) {
                return false;
            }
            String this$classPackage = this.getClassPackage();
            String other$classPackage = other.getClassPackage();
            if (this$classPackage == null ? other$classPackage != null : !this$classPackage.equals(other$classPackage)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            return !(this$className == null ? other$className != null : !this$className.equals(other$className));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessingType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $interfacePackage = this.getInterfacePackage();
            result = result * 59 + ($interfacePackage == null ? 43 : $interfacePackage.hashCode());
            String $interfaceName = this.getInterfaceName();
            result = result * 59 + ($interfaceName == null ? 43 : $interfaceName.hashCode());
            String $classPackage = this.getClassPackage();
            result = result * 59 + ($classPackage == null ? 43 : $classPackage.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            return result;
        }

        public String toString() {
            return "Structures.ProcessingType(interfacePackage=" + this.getInterfacePackage() + ", interfaceName=" + this.getInterfaceName() + ", classPackage=" + this.getClassPackage() + ", className=" + this.getClassName() + ")";
        }

        public static class ProcessingTypeBuilder {
            private String interfacePackage;
            private String interfaceName;
            private String classPackage;
            private String className;

            ProcessingTypeBuilder() {
            }

            public ProcessingTypeBuilder interfacePackage(String interfacePackage) {
                this.interfacePackage = interfacePackage;
                return this;
            }

            public ProcessingTypeBuilder interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public ProcessingTypeBuilder classPackage(String classPackage) {
                this.classPackage = classPackage;
                return this;
            }

            public ProcessingTypeBuilder className(String className) {
                this.className = className;
                return this;
            }

            public ProcessingType build() {
                return new ProcessingType(this.interfacePackage, this.interfaceName, this.classPackage, this.className);
            }

            public String toString() {
                return "Structures.ProcessingType.ProcessingTypeBuilder(interfacePackage=" + this.interfacePackage + ", interfaceName=" + this.interfaceName + ", classPackage=" + this.classPackage + ", className=" + this.className + ")";
            }
        }
    }

    public static class Constants {
        private boolean forPublic;
        private boolean forClass;
        private boolean forInterface;

        Constants(boolean forPublic, boolean forClass, boolean forInterface) {
            this.forPublic = forPublic;
            this.forClass = forClass;
            this.forInterface = forInterface;
        }

        public static ConstantsBuilder builder() {
            return new ConstantsBuilder();
        }

        public boolean isForPublic() {
            return this.forPublic;
        }

        public boolean isForClass() {
            return this.forClass;
        }

        public boolean isForInterface() {
            return this.forInterface;
        }

        public void setForPublic(boolean forPublic) {
            this.forPublic = forPublic;
        }

        public void setForClass(boolean forClass) {
            this.forClass = forClass;
        }

        public void setForInterface(boolean forInterface) {
            this.forInterface = forInterface;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constants)) {
                return false;
            }
            Constants other = (Constants)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isForPublic() != other.isForPublic()) {
                return false;
            }
            if (this.isForClass() != other.isForClass()) {
                return false;
            }
            return this.isForInterface() == other.isForInterface();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Constants;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isForPublic() ? 79 : 97);
            result = result * 59 + (this.isForClass() ? 79 : 97);
            result = result * 59 + (this.isForInterface() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "Structures.Constants(forPublic=" + this.isForPublic() + ", forClass=" + this.isForClass() + ", forInterface=" + this.isForInterface() + ")";
        }

        public static class ConstantsBuilder {
            private boolean forPublic;
            private boolean forClass;
            private boolean forInterface;

            ConstantsBuilder() {
            }

            public ConstantsBuilder forPublic(boolean forPublic) {
                this.forPublic = forPublic;
                return this;
            }

            public ConstantsBuilder forClass(boolean forClass) {
                this.forClass = forClass;
                return this;
            }

            public ConstantsBuilder forInterface(boolean forInterface) {
                this.forInterface = forInterface;
                return this;
            }

            public Constants build() {
                return new Constants(this.forPublic, this.forClass, this.forInterface);
            }

            public String toString() {
                return "Structures.Constants.ConstantsBuilder(forPublic=" + this.forPublic + ", forClass=" + this.forClass + ", forInterface=" + this.forInterface + ")";
            }
        }
    }

    public static class Ignores {
        private boolean forField;
        private boolean forClass;
        private boolean forInterface;
        private boolean forModifier;
        private boolean forQuery;

        Ignores(boolean forField, boolean forClass, boolean forInterface, boolean forModifier, boolean forQuery) {
            this.forField = forField;
            this.forClass = forClass;
            this.forInterface = forInterface;
            this.forModifier = forModifier;
            this.forQuery = forQuery;
        }

        public static IgnoresBuilder builder() {
            return new IgnoresBuilder();
        }

        public boolean isForField() {
            return this.forField;
        }

        public boolean isForClass() {
            return this.forClass;
        }

        public boolean isForInterface() {
            return this.forInterface;
        }

        public boolean isForModifier() {
            return this.forModifier;
        }

        public boolean isForQuery() {
            return this.forQuery;
        }

        public void setForField(boolean forField) {
            this.forField = forField;
        }

        public void setForClass(boolean forClass) {
            this.forClass = forClass;
        }

        public void setForInterface(boolean forInterface) {
            this.forInterface = forInterface;
        }

        public void setForModifier(boolean forModifier) {
            this.forModifier = forModifier;
        }

        public void setForQuery(boolean forQuery) {
            this.forQuery = forQuery;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ignores)) {
                return false;
            }
            Ignores other = (Ignores)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isForField() != other.isForField()) {
                return false;
            }
            if (this.isForClass() != other.isForClass()) {
                return false;
            }
            if (this.isForInterface() != other.isForInterface()) {
                return false;
            }
            if (this.isForModifier() != other.isForModifier()) {
                return false;
            }
            return this.isForQuery() == other.isForQuery();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ignores;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isForField() ? 79 : 97);
            result = result * 59 + (this.isForClass() ? 79 : 97);
            result = result * 59 + (this.isForInterface() ? 79 : 97);
            result = result * 59 + (this.isForModifier() ? 79 : 97);
            result = result * 59 + (this.isForQuery() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "Structures.Ignores(forField=" + this.isForField() + ", forClass=" + this.isForClass() + ", forInterface=" + this.isForInterface() + ", forModifier=" + this.isForModifier() + ", forQuery=" + this.isForQuery() + ")";
        }

        public static class IgnoresBuilder {
            private boolean forField;
            private boolean forClass;
            private boolean forInterface;
            private boolean forModifier;
            private boolean forQuery;

            IgnoresBuilder() {
            }

            public IgnoresBuilder forField(boolean forField) {
                this.forField = forField;
                return this;
            }

            public IgnoresBuilder forClass(boolean forClass) {
                this.forClass = forClass;
                return this;
            }

            public IgnoresBuilder forInterface(boolean forInterface) {
                this.forInterface = forInterface;
                return this;
            }

            public IgnoresBuilder forModifier(boolean forModifier) {
                this.forModifier = forModifier;
                return this;
            }

            public IgnoresBuilder forQuery(boolean forQuery) {
                this.forQuery = forQuery;
                return this;
            }

            public Ignores build() {
                return new Ignores(this.forField, this.forClass, this.forInterface, this.forModifier, this.forQuery);
            }

            public String toString() {
                return "Structures.Ignores.IgnoresBuilder(forField=" + this.forField + ", forClass=" + this.forClass + ", forInterface=" + this.forInterface + ", forModifier=" + this.forModifier + ", forQuery=" + this.forQuery + ")";
            }
        }
    }

    public static class ConstantData
    implements PrototypeConstant {
        protected ClassOrInterfaceDeclaration destination;
        protected FieldDeclaration field;
        protected String name;

        ConstantData(ClassOrInterfaceDeclaration destination, FieldDeclaration field, String name) {
            this.destination = destination;
            this.field = field;
            this.name = name;
        }

        public static ConstantDataBuilder builder() {
            return new ConstantDataBuilder();
        }

        public String toString() {
            return "Structures.ConstantData(destination=" + this.getDestination() + ", field=" + this.getField() + ", name=" + this.getName() + ")";
        }

        @Override
        public ClassOrInterfaceDeclaration getDestination() {
            return this.destination;
        }

        @Override
        public FieldDeclaration getField() {
            return this.field;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setDestination(ClassOrInterfaceDeclaration destination) {
            this.destination = destination;
        }

        public void setField(FieldDeclaration field) {
            this.field = field;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstantData)) {
                return false;
            }
            ConstantData other = (ConstantData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClassOrInterfaceDeclaration this$destination = this.getDestination();
            ClassOrInterfaceDeclaration other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
                return false;
            }
            FieldDeclaration this$field = this.getField();
            FieldDeclaration other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConstantData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassOrInterfaceDeclaration $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            FieldDeclaration $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public static class ConstantDataBuilder {
            private ClassOrInterfaceDeclaration destination;
            private FieldDeclaration field;
            private String name;

            ConstantDataBuilder() {
            }

            public ConstantDataBuilder destination(ClassOrInterfaceDeclaration destination) {
                this.destination = destination;
                return this;
            }

            public ConstantDataBuilder field(FieldDeclaration field) {
                this.field = field;
                return this;
            }

            public ConstantDataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ConstantData build() {
                return new ConstantData(this.destination, this.field, this.name);
            }

            public String toString() {
                return "Structures.ConstantData.ConstantDataBuilder(destination=" + this.destination + ", field=" + this.field + ", name=" + this.name + ")";
            }
        }
    }

    public static class GeneratedFileHandler
    implements GeneratedFile {
        protected String id;
        protected String path;
        protected String content;

        GeneratedFileHandler(String id, String path, String content) {
            this.id = id;
            this.path = path;
            this.content = content;
        }

        public static GeneratedFileHandlerBuilder builder() {
            return new GeneratedFileHandlerBuilder();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratedFileHandler)) {
                return false;
            }
            GeneratedFileHandler other = (GeneratedFileHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GeneratedFileHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "Structures.GeneratedFileHandler(id=" + this.getId() + ", path=" + this.getPath() + ", content=" + this.getContent() + ")";
        }

        public static class GeneratedFileHandlerBuilder {
            private String id;
            private String path;
            private String content;

            GeneratedFileHandlerBuilder() {
            }

            public GeneratedFileHandlerBuilder id(String id) {
                this.id = id;
                return this;
            }

            public GeneratedFileHandlerBuilder path(String path) {
                this.path = path;
                return this;
            }

            public GeneratedFileHandlerBuilder content(String content) {
                this.content = content;
                return this;
            }

            public GeneratedFileHandler build() {
                return new GeneratedFileHandler(this.id, this.path, this.content);
            }

            public String toString() {
                return "Structures.GeneratedFileHandler.GeneratedFileHandlerBuilder(id=" + this.id + ", path=" + this.path + ", content=" + this.content + ")";
            }
        }
    }

    public static class CustomParsed
    extends Parsed<ClassOrInterfaceDeclaration>
    implements CustomDescription {
        protected String id;

        public CustomParsed(String id, boolean processed, boolean invalid, JavaParser parser, Class<?> compiled, String prototypeFileName, String prototypeClassName, PrototypeDataHandler properties, String parsedName, String parsedFullName, String interfaceName, String interfaceFullName, Map<String, PrototypeConstant> constants, TypeDeclaration<ClassOrInterfaceDeclaration> declaration, List<CompilationUnit> files, Map<String, GeneratedFileHandler> custom, Parsed<ClassOrInterfaceDeclaration> base, Parsed<ClassOrInterfaceDeclaration> mixIn, boolean nested, boolean codeEnum, String parentClassName, EmbeddedModifierType embeddedModifierType, Map<String, ClassOrInterfaceDeclaration> classes, List<PrototypeField> fields, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers, List<Consumer<BlockStmt>> customInitializers, List<Runnable> postProcessActions) {
            super(processed, invalid, parser, compiled, prototypeFileName, prototypeClassName, properties, parsedName, parsedFullName, interfaceName, interfaceFullName, constants, declaration, files, custom, base, mixIn, nested, codeEnum, parentClassName, embeddedModifierType, classes, fields, spec, intf, initializers, customInitializers, postProcessActions);
            this.id = id;
            this.files = CustomParsed.initFiles();
        }

        @Override
        public void setProperties(PrototypeData properties) {
            this.properties = (PrototypeDataHandler)properties;
        }

        public static CustomParsedBuilder bldr() {
            return new CustomParsedBuilder();
        }

        public String getId() {
            return this.id;
        }

        public static class CustomParsedBuilder {
            private String id;
            private boolean processed;
            private boolean invalid;
            private JavaParser parser;
            private Class<?> compiled;
            private String prototypeFileName;
            private String prototypeClassName;
            private PrototypeDataHandler properties;
            private String parsedName;
            private String parsedFullName;
            private String interfaceName;
            private String interfaceFullName;
            private Map<String, PrototypeConstant> constants;
            private TypeDeclaration<ClassOrInterfaceDeclaration> declaration;
            private List<CompilationUnit> files;
            private Map<String, GeneratedFileHandler> custom;
            private Parsed<ClassOrInterfaceDeclaration> base;
            private Parsed<ClassOrInterfaceDeclaration> mixIn;
            private boolean nested;
            private boolean codeEnum;
            private String parentClassName;
            private EmbeddedModifierType embeddedModifierType;
            private Map<String, ClassOrInterfaceDeclaration> classes;
            private List<PrototypeField> fields;
            private ClassOrInterfaceDeclaration spec;
            private ClassOrInterfaceDeclaration intf;
            private List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers;
            private List<Consumer<BlockStmt>> customInitializers;
            private List<Runnable> postProcessActions;

            CustomParsedBuilder() {
            }

            public CustomParsedBuilder id(String id) {
                this.id = id;
                return this;
            }

            public CustomParsedBuilder processed(boolean processed) {
                this.processed = processed;
                return this;
            }

            public CustomParsedBuilder invalid(boolean invalid) {
                this.invalid = invalid;
                return this;
            }

            public CustomParsedBuilder parser(JavaParser parser) {
                this.parser = parser;
                return this;
            }

            public CustomParsedBuilder compiled(Class<?> compiled) {
                this.compiled = compiled;
                return this;
            }

            public CustomParsedBuilder prototypeFileName(String prototypeFileName) {
                this.prototypeFileName = prototypeFileName;
                return this;
            }

            public CustomParsedBuilder prototypeClassName(String prototypeClassName) {
                this.prototypeClassName = prototypeClassName;
                return this;
            }

            public CustomParsedBuilder properties(PrototypeDataHandler properties) {
                this.properties = properties;
                return this;
            }

            public CustomParsedBuilder parsedName(String parsedName) {
                this.parsedName = parsedName;
                return this;
            }

            public CustomParsedBuilder parsedFullName(String parsedFullName) {
                this.parsedFullName = parsedFullName;
                return this;
            }

            public CustomParsedBuilder interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public CustomParsedBuilder interfaceFullName(String interfaceFullName) {
                this.interfaceFullName = interfaceFullName;
                return this;
            }

            public CustomParsedBuilder constants(Map<String, PrototypeConstant> constants) {
                this.constants = constants;
                return this;
            }

            public CustomParsedBuilder declaration(TypeDeclaration<ClassOrInterfaceDeclaration> declaration) {
                this.declaration = declaration;
                return this;
            }

            public CustomParsedBuilder files(List<CompilationUnit> files) {
                this.files = files;
                return this;
            }

            public CustomParsedBuilder custom(Map<String, GeneratedFileHandler> custom) {
                this.custom = custom;
                return this;
            }

            public CustomParsedBuilder base(Parsed<ClassOrInterfaceDeclaration> base) {
                this.base = base;
                return this;
            }

            public CustomParsedBuilder mixIn(Parsed<ClassOrInterfaceDeclaration> mixIn) {
                this.mixIn = mixIn;
                return this;
            }

            public CustomParsedBuilder nested(boolean nested) {
                this.nested = nested;
                return this;
            }

            public CustomParsedBuilder codeEnum(boolean codeEnum) {
                this.codeEnum = codeEnum;
                return this;
            }

            public CustomParsedBuilder parentClassName(String parentClassName) {
                this.parentClassName = parentClassName;
                return this;
            }

            public CustomParsedBuilder embeddedModifierType(EmbeddedModifierType embeddedModifierType) {
                this.embeddedModifierType = embeddedModifierType;
                return this;
            }

            public CustomParsedBuilder classes(Map<String, ClassOrInterfaceDeclaration> classes) {
                this.classes = classes;
                return this;
            }

            public CustomParsedBuilder fields(List<PrototypeField> fields) {
                this.fields = fields;
                return this;
            }

            public CustomParsedBuilder spec(ClassOrInterfaceDeclaration spec) {
                this.spec = spec;
                return this;
            }

            public CustomParsedBuilder intf(ClassOrInterfaceDeclaration intf) {
                this.intf = intf;
                return this;
            }

            public CustomParsedBuilder initializers(List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers) {
                this.initializers = initializers;
                return this;
            }

            public CustomParsedBuilder customInitializers(List<Consumer<BlockStmt>> customInitializers) {
                this.customInitializers = customInitializers;
                return this;
            }

            public CustomParsedBuilder postProcessActions(List<Runnable> postProcessActions) {
                this.postProcessActions = postProcessActions;
                return this;
            }

            public CustomParsed build() {
                return new CustomParsed(this.id, this.processed, this.invalid, this.parser, this.compiled, this.prototypeFileName, this.prototypeClassName, this.properties, this.parsedName, this.parsedFullName, this.interfaceName, this.interfaceFullName, this.constants, this.declaration, this.files, this.custom, this.base, this.mixIn, this.nested, this.codeEnum, this.parentClassName, this.embeddedModifierType, this.classes, this.fields, this.spec, this.intf, this.initializers, this.customInitializers, this.postProcessActions);
            }

            public String toString() {
                return "Structures.CustomParsed.CustomParsedBuilder(id=" + this.id + ", processed=" + this.processed + ", invalid=" + this.invalid + ", parser=" + this.parser + ", compiled=" + this.compiled + ", prototypeFileName=" + this.prototypeFileName + ", prototypeClassName=" + this.prototypeClassName + ", properties=" + this.properties + ", parsedName=" + this.parsedName + ", parsedFullName=" + this.parsedFullName + ", interfaceName=" + this.interfaceName + ", interfaceFullName=" + this.interfaceFullName + ", constants=" + this.constants + ", declaration=" + this.declaration + ", files=" + this.files + ", custom=" + this.custom + ", base=" + this.base + ", mixIn=" + this.mixIn + ", nested=" + this.nested + ", codeEnum=" + this.codeEnum + ", parentClassName=" + this.parentClassName + ", embeddedModifierType=" + this.embeddedModifierType + ", classes=" + this.classes + ", fields=" + this.fields + ", spec=" + this.spec + ", intf=" + this.intf + ", initializers=" + this.initializers + ", customInitializers=" + this.customInitializers + ", postProcessActions=" + this.postProcessActions + ")";
            }
        }
    }

    public static class Parsed<T extends TypeDeclaration<T>>
    implements PrototypeDescription<T> {
        protected boolean processed;
        protected boolean invalid;
        protected JavaParser parser;
        protected Class<?> compiled;
        protected String prototypeFileName;
        protected String prototypeClassName;
        protected PrototypeDataHandler properties;
        protected String parsedName;
        protected String parsedFullName;
        protected String interfaceName;
        protected String interfaceFullName;
        private Map<String, PrototypeConstant> constants;
        protected TypeDeclaration<T> declaration;
        protected List<CompilationUnit> files;
        protected Map<String, GeneratedFileHandler> custom;
        protected Parsed<T> base;
        protected Parsed<T> mixIn;
        protected boolean nested;
        protected boolean codeEnum;
        protected String parentClassName;
        protected EmbeddedModifierType embeddedModifierType;
        protected Map<String, ClassOrInterfaceDeclaration> classes;
        protected List<PrototypeField> fields;
        protected ClassOrInterfaceDeclaration spec;
        protected ClassOrInterfaceDeclaration intf;
        protected List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers;
        protected List<Consumer<BlockStmt>> customInitializers;
        protected List<Runnable> postProcessActions;

        @Override
        public String getImplementorFullName() {
            if (Objects.nonNull(this.mixIn)) {
                return this.mixIn.parsedFullName;
            }
            return this.parsedFullName;
        }

        public void setIntf(ClassOrInterfaceDeclaration intf) {
            this.intf = intf;
            this.interfaceName = intf.getNameAsString();
            this.interfaceFullName = intf.getFullyQualifiedName().orElse(null);
            intf.findCompilationUnit().ifPresent(u -> this.files.set(1, (CompilationUnit)u));
        }

        public void setSpec(ClassOrInterfaceDeclaration spec) {
            this.spec = spec;
            this.parsedName = spec.getNameAsString();
            this.parsedFullName = spec.getFullyQualifiedName().orElse(null);
            spec.findCompilationUnit().ifPresent(u -> this.files.set(0, (CompilationUnit)u));
        }

        @Override
        public void registerClass(String key, ClassOrInterfaceDeclaration declaration) {
            this.classes.put(key, declaration);
        }

        @Override
        public ClassOrInterfaceDeclaration getRegisteredClass(String key) {
            return this.classes.get(key);
        }

        @Override
        public void registerPostProcessAction(Runnable task) {
            this.postProcessActions.add(task);
        }

        @Override
        public void processActions() {
            this.postProcessActions.forEach(Runnable::run);
        }

        @Override
        public boolean isValid() {
            return Objects.nonNull(this.properties);
        }

        @Override
        public Optional<PrototypeField> findField(String name) {
            Optional<PrototypeField> result = this.fields.stream().filter(f -> f.getName().equals(name)).findFirst();
            if (result.isEmpty() && Objects.nonNull(this.getBase())) {
                result = ((Parsed)this.getBase()).getFields().stream().filter(f -> f.getName().equals(name)).findFirst();
            }
            return result;
        }

        @Override
        public void addEmbeddedModifier(EmbeddedModifierType type) {
            if (!type.equals((Object)this.embeddedModifierType) && !EmbeddedModifierType.BOTH.equals((Object)this.embeddedModifierType)) {
                switch (type) {
                    case SINGLE: 
                    case COLLECTION: {
                        if (EmbeddedModifierType.NONE.equals((Object)this.embeddedModifierType)) {
                            this.embeddedModifierType = type;
                            break;
                        }
                        this.embeddedModifierType = EmbeddedModifierType.BOTH;
                        break;
                    }
                    case BOTH: {
                        this.embeddedModifierType = type;
                        break;
                    }
                }
            }
        }

        @Override
        public void setEmbeddedModifier(EmbeddedModifierType type) {
            this.embeddedModifierType = type;
        }

        @Override
        public boolean hasOption(Class<? extends CodeOption> option) {
            return Objects.nonNull(this.getProperties().getOptions()) && this.getProperties().getOptions().contains(option);
        }

        @Override
        public boolean hasEnricher(Class<? extends Enricher> enricher) {
            return this.getProperties().enrichers.stream().anyMatch(e -> enricher.isAssignableFrom(e.getClass())) || this.getProperties().inheritedEnrichers.stream().anyMatch(e -> enricher.isAssignableFrom(e.getClass()));
        }

        public GeneratedFileHandler addCustomFile(String id) {
            return this.custom.computeIfAbsent(id, k -> GeneratedFileHandler.builder().id(id).build());
        }

        public GeneratedFileHandler getCustomFile(String id) {
            return this.custom.get(id);
        }

        protected static List<CompilationUnit> initFiles() {
            ArrayList<CompilationUnit> list = new ArrayList<CompilationUnit>(2);
            list.add(null);
            list.add(null);
            return list;
        }

        private static <T extends TypeDeclaration<T>> Map<String, PrototypeConstant> $default$constants() {
            return new HashMap<String, PrototypeConstant>();
        }

        private static <T extends TypeDeclaration<T>> List<CompilationUnit> $default$files() {
            return Parsed.initFiles();
        }

        private static <T extends TypeDeclaration<T>> Map<String, GeneratedFileHandler> $default$custom() {
            return new HashMap<String, GeneratedFileHandler>();
        }

        private static <T extends TypeDeclaration<T>> EmbeddedModifierType $default$embeddedModifierType() {
            return EmbeddedModifierType.NONE;
        }

        private static <T extends TypeDeclaration<T>> Map<String, ClassOrInterfaceDeclaration> $default$classes() {
            return new HashMap<String, ClassOrInterfaceDeclaration>();
        }

        private static <T extends TypeDeclaration<T>> List<PrototypeField> $default$fields() {
            return new ArrayList<PrototypeField>();
        }

        private static <T extends TypeDeclaration<T>> List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> $default$initializers() {
            return new ArrayList<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>>();
        }

        private static <T extends TypeDeclaration<T>> List<Consumer<BlockStmt>> $default$customInitializers() {
            return new ArrayList<Consumer<BlockStmt>>();
        }

        private static <T extends TypeDeclaration<T>> List<Runnable> $default$postProcessActions() {
            return new ArrayList<Runnable>();
        }

        Parsed(boolean processed, boolean invalid, JavaParser parser, Class<?> compiled, String prototypeFileName, String prototypeClassName, PrototypeDataHandler properties, String parsedName, String parsedFullName, String interfaceName, String interfaceFullName, Map<String, PrototypeConstant> constants, TypeDeclaration<T> declaration, List<CompilationUnit> files, Map<String, GeneratedFileHandler> custom, Parsed<T> base, Parsed<T> mixIn, boolean nested, boolean codeEnum, String parentClassName, EmbeddedModifierType embeddedModifierType, Map<String, ClassOrInterfaceDeclaration> classes, List<PrototypeField> fields, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers, List<Consumer<BlockStmt>> customInitializers, List<Runnable> postProcessActions) {
            Helpers.registerKnownEnrichers();
            this.processed = processed;
            this.invalid = invalid;
            this.parser = parser;
            this.compiled = compiled;
            this.prototypeFileName = prototypeFileName;
            this.prototypeClassName = prototypeClassName;
            this.properties = properties;
            this.parsedName = parsedName;
            this.parsedFullName = parsedFullName;
            this.interfaceName = interfaceName;
            this.interfaceFullName = interfaceFullName;
            this.constants = constants;
            this.declaration = declaration;
            this.files = files;
            this.custom = custom;
            this.base = base;
            this.mixIn = mixIn;
            this.nested = nested;
            this.codeEnum = codeEnum;
            this.parentClassName = parentClassName;
            this.embeddedModifierType = embeddedModifierType;
            this.classes = classes;
            this.fields = fields;
            this.spec = spec;
            this.intf = intf;
            this.initializers = initializers;
            this.customInitializers = customInitializers;
            this.postProcessActions = postProcessActions;
        }

        public static <T extends TypeDeclaration<T>> ParsedBuilder<T> builder() {
            return new ParsedBuilder();
        }

        @Override
        public boolean isProcessed() {
            return this.processed;
        }

        @Override
        public boolean isInvalid() {
            return this.invalid;
        }

        @Override
        public JavaParser getParser() {
            return this.parser;
        }

        @Override
        public Class<?> getCompiled() {
            return this.compiled;
        }

        @Override
        public String getPrototypeFileName() {
            return this.prototypeFileName;
        }

        @Override
        public String getPrototypeClassName() {
            return this.prototypeClassName;
        }

        @Override
        public PrototypeDataHandler getProperties() {
            return this.properties;
        }

        @Override
        public String getParsedName() {
            return this.parsedName;
        }

        @Override
        public String getParsedFullName() {
            return this.parsedFullName;
        }

        @Override
        public String getInterfaceName() {
            return this.interfaceName;
        }

        @Override
        public String getInterfaceFullName() {
            return this.interfaceFullName;
        }

        @Override
        public Map<String, PrototypeConstant> getConstants() {
            return this.constants;
        }

        @Override
        public TypeDeclaration<T> getDeclaration() {
            return this.declaration;
        }

        @Override
        public List<CompilationUnit> getFiles() {
            return this.files;
        }

        public Map<String, GeneratedFileHandler> getCustom() {
            return this.custom;
        }

        @Override
        public Parsed<T> getBase() {
            return this.base;
        }

        @Override
        public Parsed<T> getMixIn() {
            return this.mixIn;
        }

        @Override
        public boolean isNested() {
            return this.nested;
        }

        @Override
        public boolean isCodeEnum() {
            return this.codeEnum;
        }

        @Override
        public String getParentClassName() {
            return this.parentClassName;
        }

        @Override
        public EmbeddedModifierType getEmbeddedModifierType() {
            return this.embeddedModifierType;
        }

        public Map<String, ClassOrInterfaceDeclaration> getClasses() {
            return this.classes;
        }

        @Override
        public List<PrototypeField> getFields() {
            return this.fields;
        }

        @Override
        public ClassOrInterfaceDeclaration getSpec() {
            return this.spec;
        }

        @Override
        public ClassOrInterfaceDeclaration getIntf() {
            return this.intf;
        }

        @Override
        public List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> getInitializers() {
            return this.initializers;
        }

        @Override
        public List<Consumer<BlockStmt>> getCustomInitializers() {
            return this.customInitializers;
        }

        public List<Runnable> getPostProcessActions() {
            return this.postProcessActions;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public void setInvalid(boolean invalid) {
            this.invalid = invalid;
        }

        public void setParser(JavaParser parser) {
            this.parser = parser;
        }

        public void setCompiled(Class<?> compiled) {
            this.compiled = compiled;
        }

        public void setPrototypeFileName(String prototypeFileName) {
            this.prototypeFileName = prototypeFileName;
        }

        public void setPrototypeClassName(String prototypeClassName) {
            this.prototypeClassName = prototypeClassName;
        }

        public void setProperties(PrototypeDataHandler properties) {
            this.properties = properties;
        }

        public void setParsedName(String parsedName) {
            this.parsedName = parsedName;
        }

        public void setParsedFullName(String parsedFullName) {
            this.parsedFullName = parsedFullName;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public void setInterfaceFullName(String interfaceFullName) {
            this.interfaceFullName = interfaceFullName;
        }

        public void setConstants(Map<String, PrototypeConstant> constants) {
            this.constants = constants;
        }

        public void setDeclaration(TypeDeclaration<T> declaration) {
            this.declaration = declaration;
        }

        public void setFiles(List<CompilationUnit> files) {
            this.files = files;
        }

        public void setCustom(Map<String, GeneratedFileHandler> custom) {
            this.custom = custom;
        }

        public void setBase(Parsed<T> base) {
            this.base = base;
        }

        public void setMixIn(Parsed<T> mixIn) {
            this.mixIn = mixIn;
        }

        public void setNested(boolean nested) {
            this.nested = nested;
        }

        public void setCodeEnum(boolean codeEnum) {
            this.codeEnum = codeEnum;
        }

        public void setParentClassName(String parentClassName) {
            this.parentClassName = parentClassName;
        }

        public void setEmbeddedModifierType(EmbeddedModifierType embeddedModifierType) {
            this.embeddedModifierType = embeddedModifierType;
        }

        public void setClasses(Map<String, ClassOrInterfaceDeclaration> classes) {
            this.classes = classes;
        }

        public void setFields(List<PrototypeField> fields) {
            this.fields = fields;
        }

        public void setInitializers(List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers) {
            this.initializers = initializers;
        }

        public void setCustomInitializers(List<Consumer<BlockStmt>> customInitializers) {
            this.customInitializers = customInitializers;
        }

        public void setPostProcessActions(List<Runnable> postProcessActions) {
            this.postProcessActions = postProcessActions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parsed)) {
                return false;
            }
            Parsed other = (Parsed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isProcessed() != other.isProcessed()) {
                return false;
            }
            if (this.isInvalid() != other.isInvalid()) {
                return false;
            }
            if (this.isNested() != other.isNested()) {
                return false;
            }
            if (this.isCodeEnum() != other.isCodeEnum()) {
                return false;
            }
            JavaParser this$parser = this.getParser();
            JavaParser other$parser = other.getParser();
            if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
                return false;
            }
            Class<?> this$compiled = this.getCompiled();
            Class<?> other$compiled = other.getCompiled();
            if (this$compiled == null ? other$compiled != null : !this$compiled.equals(other$compiled)) {
                return false;
            }
            String this$prototypeFileName = this.getPrototypeFileName();
            String other$prototypeFileName = other.getPrototypeFileName();
            if (this$prototypeFileName == null ? other$prototypeFileName != null : !this$prototypeFileName.equals(other$prototypeFileName)) {
                return false;
            }
            String this$prototypeClassName = this.getPrototypeClassName();
            String other$prototypeClassName = other.getPrototypeClassName();
            if (this$prototypeClassName == null ? other$prototypeClassName != null : !this$prototypeClassName.equals(other$prototypeClassName)) {
                return false;
            }
            PrototypeDataHandler this$properties = this.getProperties();
            PrototypeDataHandler other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
                return false;
            }
            String this$parsedName = this.getParsedName();
            String other$parsedName = other.getParsedName();
            if (this$parsedName == null ? other$parsedName != null : !this$parsedName.equals(other$parsedName)) {
                return false;
            }
            String this$parsedFullName = this.getParsedFullName();
            String other$parsedFullName = other.getParsedFullName();
            if (this$parsedFullName == null ? other$parsedFullName != null : !this$parsedFullName.equals(other$parsedFullName)) {
                return false;
            }
            String this$interfaceName = this.getInterfaceName();
            String other$interfaceName = other.getInterfaceName();
            if (this$interfaceName == null ? other$interfaceName != null : !this$interfaceName.equals(other$interfaceName)) {
                return false;
            }
            String this$interfaceFullName = this.getInterfaceFullName();
            String other$interfaceFullName = other.getInterfaceFullName();
            if (this$interfaceFullName == null ? other$interfaceFullName != null : !this$interfaceFullName.equals(other$interfaceFullName)) {
                return false;
            }
            TypeDeclaration<T> this$declaration = this.getDeclaration();
            TypeDeclaration<T> other$declaration = other.getDeclaration();
            if (this$declaration == null ? other$declaration != null : !this$declaration.equals(other$declaration)) {
                return false;
            }
            List<CompilationUnit> this$files = this.getFiles();
            List<CompilationUnit> other$files = other.getFiles();
            if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
                return false;
            }
            Map<String, GeneratedFileHandler> this$custom = this.getCustom();
            Map<String, GeneratedFileHandler> other$custom = other.getCustom();
            if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
                return false;
            }
            PrototypeDescription this$base = this.getBase();
            PrototypeDescription other$base = other.getBase();
            if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
                return false;
            }
            PrototypeDescription this$mixIn = this.getMixIn();
            PrototypeDescription other$mixIn = other.getMixIn();
            if (this$mixIn == null ? other$mixIn != null : !this$mixIn.equals(other$mixIn)) {
                return false;
            }
            String this$parentClassName = this.getParentClassName();
            String other$parentClassName = other.getParentClassName();
            if (this$parentClassName == null ? other$parentClassName != null : !this$parentClassName.equals(other$parentClassName)) {
                return false;
            }
            EmbeddedModifierType this$embeddedModifierType = this.getEmbeddedModifierType();
            EmbeddedModifierType other$embeddedModifierType = other.getEmbeddedModifierType();
            if (this$embeddedModifierType == null ? other$embeddedModifierType != null : !this$embeddedModifierType.equals(other$embeddedModifierType)) {
                return false;
            }
            ClassOrInterfaceDeclaration this$spec = this.getSpec();
            ClassOrInterfaceDeclaration other$spec = other.getSpec();
            if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
                return false;
            }
            ClassOrInterfaceDeclaration this$intf = this.getIntf();
            ClassOrInterfaceDeclaration other$intf = other.getIntf();
            if (this$intf == null ? other$intf != null : !this$intf.equals(other$intf)) {
                return false;
            }
            List<Runnable> this$postProcessActions = this.getPostProcessActions();
            List<Runnable> other$postProcessActions = other.getPostProcessActions();
            return !(this$postProcessActions == null ? other$postProcessActions != null : !((Object)this$postProcessActions).equals(other$postProcessActions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parsed;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isProcessed() ? 79 : 97);
            result = result * 59 + (this.isInvalid() ? 79 : 97);
            result = result * 59 + (this.isNested() ? 79 : 97);
            result = result * 59 + (this.isCodeEnum() ? 79 : 97);
            JavaParser $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            Class<?> $compiled = this.getCompiled();
            result = result * 59 + ($compiled == null ? 43 : $compiled.hashCode());
            String $prototypeFileName = this.getPrototypeFileName();
            result = result * 59 + ($prototypeFileName == null ? 43 : $prototypeFileName.hashCode());
            String $prototypeClassName = this.getPrototypeClassName();
            result = result * 59 + ($prototypeClassName == null ? 43 : $prototypeClassName.hashCode());
            PrototypeDataHandler $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
            String $parsedName = this.getParsedName();
            result = result * 59 + ($parsedName == null ? 43 : $parsedName.hashCode());
            String $parsedFullName = this.getParsedFullName();
            result = result * 59 + ($parsedFullName == null ? 43 : $parsedFullName.hashCode());
            String $interfaceName = this.getInterfaceName();
            result = result * 59 + ($interfaceName == null ? 43 : $interfaceName.hashCode());
            String $interfaceFullName = this.getInterfaceFullName();
            result = result * 59 + ($interfaceFullName == null ? 43 : $interfaceFullName.hashCode());
            TypeDeclaration<T> $declaration = this.getDeclaration();
            result = result * 59 + ($declaration == null ? 43 : $declaration.hashCode());
            List<CompilationUnit> $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            Map<String, GeneratedFileHandler> $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            PrototypeDescription $base = this.getBase();
            result = result * 59 + ($base == null ? 43 : $base.hashCode());
            PrototypeDescription $mixIn = this.getMixIn();
            result = result * 59 + ($mixIn == null ? 43 : $mixIn.hashCode());
            String $parentClassName = this.getParentClassName();
            result = result * 59 + ($parentClassName == null ? 43 : $parentClassName.hashCode());
            EmbeddedModifierType $embeddedModifierType = this.getEmbeddedModifierType();
            result = result * 59 + ($embeddedModifierType == null ? 43 : $embeddedModifierType.hashCode());
            ClassOrInterfaceDeclaration $spec = this.getSpec();
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            ClassOrInterfaceDeclaration $intf = this.getIntf();
            result = result * 59 + ($intf == null ? 43 : $intf.hashCode());
            List<Runnable> $postProcessActions = this.getPostProcessActions();
            result = result * 59 + ($postProcessActions == null ? 43 : ((Object)$postProcessActions).hashCode());
            return result;
        }

        public String toString() {
            return "Structures.Parsed(processed=" + this.isProcessed() + ", invalid=" + this.isInvalid() + ", parser=" + this.getParser() + ", compiled=" + this.getCompiled() + ", prototypeFileName=" + this.getPrototypeFileName() + ", prototypeClassName=" + this.getPrototypeClassName() + ", properties=" + this.getProperties() + ", parsedName=" + this.getParsedName() + ", parsedFullName=" + this.getParsedFullName() + ", interfaceName=" + this.getInterfaceName() + ", interfaceFullName=" + this.getInterfaceFullName() + ", declaration=" + this.getDeclaration() + ", files=" + this.getFiles() + ", custom=" + this.getCustom() + ", base=" + (Parsed)this.getBase() + ", mixIn=" + (Parsed)this.getMixIn() + ", nested=" + this.isNested() + ", codeEnum=" + this.isCodeEnum() + ", parentClassName=" + this.getParentClassName() + ", embeddedModifierType=" + this.getEmbeddedModifierType() + ", spec=" + this.getSpec() + ", intf=" + this.getIntf() + ")";
        }

        public static class ParsedBuilder<T extends TypeDeclaration<T>> {
            private boolean processed;
            private boolean invalid;
            private JavaParser parser;
            private Class<?> compiled;
            private String prototypeFileName;
            private String prototypeClassName;
            private PrototypeDataHandler properties;
            private String parsedName;
            private String parsedFullName;
            private String interfaceName;
            private String interfaceFullName;
            private boolean constants$set;
            private Map<String, PrototypeConstant> constants$value;
            private TypeDeclaration<T> declaration;
            private boolean files$set;
            private List<CompilationUnit> files$value;
            private boolean custom$set;
            private Map<String, GeneratedFileHandler> custom$value;
            private Parsed<T> base;
            private Parsed<T> mixIn;
            private boolean nested;
            private boolean codeEnum;
            private String parentClassName;
            private boolean embeddedModifierType$set;
            private EmbeddedModifierType embeddedModifierType$value;
            private boolean classes$set;
            private Map<String, ClassOrInterfaceDeclaration> classes$value;
            private boolean fields$set;
            private List<PrototypeField> fields$value;
            private ClassOrInterfaceDeclaration spec;
            private ClassOrInterfaceDeclaration intf;
            private boolean initializers$set;
            private List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers$value;
            private boolean customInitializers$set;
            private List<Consumer<BlockStmt>> customInitializers$value;
            private boolean postProcessActions$set;
            private List<Runnable> postProcessActions$value;

            ParsedBuilder() {
            }

            public ParsedBuilder<T> processed(boolean processed) {
                this.processed = processed;
                return this;
            }

            public ParsedBuilder<T> invalid(boolean invalid) {
                this.invalid = invalid;
                return this;
            }

            public ParsedBuilder<T> parser(JavaParser parser) {
                this.parser = parser;
                return this;
            }

            public ParsedBuilder<T> compiled(Class<?> compiled) {
                this.compiled = compiled;
                return this;
            }

            public ParsedBuilder<T> prototypeFileName(String prototypeFileName) {
                this.prototypeFileName = prototypeFileName;
                return this;
            }

            public ParsedBuilder<T> prototypeClassName(String prototypeClassName) {
                this.prototypeClassName = prototypeClassName;
                return this;
            }

            public ParsedBuilder<T> properties(PrototypeDataHandler properties) {
                this.properties = properties;
                return this;
            }

            public ParsedBuilder<T> parsedName(String parsedName) {
                this.parsedName = parsedName;
                return this;
            }

            public ParsedBuilder<T> parsedFullName(String parsedFullName) {
                this.parsedFullName = parsedFullName;
                return this;
            }

            public ParsedBuilder<T> interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public ParsedBuilder<T> interfaceFullName(String interfaceFullName) {
                this.interfaceFullName = interfaceFullName;
                return this;
            }

            public ParsedBuilder<T> constants(Map<String, PrototypeConstant> constants) {
                this.constants$value = constants;
                this.constants$set = true;
                return this;
            }

            public ParsedBuilder<T> declaration(TypeDeclaration<T> declaration) {
                this.declaration = declaration;
                return this;
            }

            public ParsedBuilder<T> files(List<CompilationUnit> files) {
                this.files$value = files;
                this.files$set = true;
                return this;
            }

            public ParsedBuilder<T> custom(Map<String, GeneratedFileHandler> custom) {
                this.custom$value = custom;
                this.custom$set = true;
                return this;
            }

            public ParsedBuilder<T> base(Parsed<T> base) {
                this.base = base;
                return this;
            }

            public ParsedBuilder<T> mixIn(Parsed<T> mixIn) {
                this.mixIn = mixIn;
                return this;
            }

            public ParsedBuilder<T> nested(boolean nested) {
                this.nested = nested;
                return this;
            }

            public ParsedBuilder<T> codeEnum(boolean codeEnum) {
                this.codeEnum = codeEnum;
                return this;
            }

            public ParsedBuilder<T> parentClassName(String parentClassName) {
                this.parentClassName = parentClassName;
                return this;
            }

            public ParsedBuilder<T> embeddedModifierType(EmbeddedModifierType embeddedModifierType) {
                this.embeddedModifierType$value = embeddedModifierType;
                this.embeddedModifierType$set = true;
                return this;
            }

            public ParsedBuilder<T> classes(Map<String, ClassOrInterfaceDeclaration> classes) {
                this.classes$value = classes;
                this.classes$set = true;
                return this;
            }

            public ParsedBuilder<T> fields(List<PrototypeField> fields) {
                this.fields$value = fields;
                this.fields$set = true;
                return this;
            }

            public ParsedBuilder<T> spec(ClassOrInterfaceDeclaration spec) {
                this.spec = spec;
                return this;
            }

            public ParsedBuilder<T> intf(ClassOrInterfaceDeclaration intf) {
                this.intf = intf;
                return this;
            }

            public ParsedBuilder<T> initializers(List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers) {
                this.initializers$value = initializers;
                this.initializers$set = true;
                return this;
            }

            public ParsedBuilder<T> customInitializers(List<Consumer<BlockStmt>> customInitializers) {
                this.customInitializers$value = customInitializers;
                this.customInitializers$set = true;
                return this;
            }

            public ParsedBuilder<T> postProcessActions(List<Runnable> postProcessActions) {
                this.postProcessActions$value = postProcessActions;
                this.postProcessActions$set = true;
                return this;
            }

            public Parsed<T> build() {
                Map<String, PrototypeConstant> constants$value = this.constants$value;
                if (!this.constants$set) {
                    constants$value = Parsed.$default$constants();
                }
                List<CompilationUnit> files$value = this.files$value;
                if (!this.files$set) {
                    files$value = Parsed.$default$files();
                }
                Map<String, GeneratedFileHandler> custom$value = this.custom$value;
                if (!this.custom$set) {
                    custom$value = Parsed.$default$custom();
                }
                EmbeddedModifierType embeddedModifierType$value = this.embeddedModifierType$value;
                if (!this.embeddedModifierType$set) {
                    embeddedModifierType$value = Parsed.$default$embeddedModifierType();
                }
                Map<String, ClassOrInterfaceDeclaration> classes$value = this.classes$value;
                if (!this.classes$set) {
                    classes$value = Parsed.$default$classes();
                }
                List<PrototypeField> fields$value = this.fields$value;
                if (!this.fields$set) {
                    fields$value = Parsed.$default$fields();
                }
                List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> initializers$value = this.initializers$value;
                if (!this.initializers$set) {
                    initializers$value = Parsed.$default$initializers();
                }
                List<Consumer<BlockStmt>> customInitializers$value = this.customInitializers$value;
                if (!this.customInitializers$set) {
                    customInitializers$value = Parsed.$default$customInitializers();
                }
                List<Runnable> postProcessActions$value = this.postProcessActions$value;
                if (!this.postProcessActions$set) {
                    postProcessActions$value = Parsed.$default$postProcessActions();
                }
                return new Parsed<T>(this.processed, this.invalid, this.parser, this.compiled, this.prototypeFileName, this.prototypeClassName, this.properties, this.parsedName, this.parsedFullName, this.interfaceName, this.interfaceFullName, constants$value, this.declaration, files$value, custom$value, this.base, this.mixIn, this.nested, this.codeEnum, this.parentClassName, embeddedModifierType$value, classes$value, fields$value, this.spec, this.intf, initializers$value, customInitializers$value, postProcessActions$value);
            }

            public String toString() {
                return "Structures.Parsed.ParsedBuilder(processed=" + this.processed + ", invalid=" + this.invalid + ", parser=" + this.parser + ", compiled=" + this.compiled + ", prototypeFileName=" + this.prototypeFileName + ", prototypeClassName=" + this.prototypeClassName + ", properties=" + this.properties + ", parsedName=" + this.parsedName + ", parsedFullName=" + this.parsedFullName + ", interfaceName=" + this.interfaceName + ", interfaceFullName=" + this.interfaceFullName + ", constants$value=" + this.constants$value + ", declaration=" + this.declaration + ", files$value=" + this.files$value + ", custom$value=" + this.custom$value + ", base=" + this.base + ", mixIn=" + this.mixIn + ", nested=" + this.nested + ", codeEnum=" + this.codeEnum + ", parentClassName=" + this.parentClassName + ", embeddedModifierType$value=" + this.embeddedModifierType$value + ", classes$value=" + this.classes$value + ", fields$value=" + this.fields$value + ", spec=" + this.spec + ", intf=" + this.intf + ", initializers$value=" + this.initializers$value + ", customInitializers$value=" + this.customInitializers$value + ", postProcessActions$value=" + this.postProcessActions$value + ")";
            }
        }
    }

    public static class FieldData
    implements PrototypeField {
        Parsed<ClassOrInterfaceDeclaration> parsed;
        private String name;
        private FieldDeclaration declaration;
        private MethodDeclaration description;
        private String fullType;
        private String type;
        private boolean collection;
        private boolean external;
        private boolean genericMethod;
        private boolean genericField;
        private Ignores ignores;
        private PrototypeDescription<ClassOrInterfaceDeclaration> prototype;
        private Map<String, Type> generics;
        private Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes;
        private List<MethodDeclaration> modifiers;
        private PrototypeField parent;
        MethodDeclaration interfaceGetter;
        MethodDeclaration interfaceSetter;
        MethodDeclaration implementationGetter;
        MethodDeclaration implementationSetter;

        @Override
        public List<MethodDeclaration> getModifiers() {
            if (Objects.isNull(this.modifiers)) {
                this.modifiers = new ArrayList<MethodDeclaration>();
            }
            return this.modifiers;
        }

        @Override
        public void addModifier(MethodDeclaration modifier) {
            this.getModifiers().add(modifier);
        }

        @Override
        public MethodDeclaration generateGetter() {
            ClassOrInterfaceDeclaration cls = (ClassOrInterfaceDeclaration)this.declaration.getParentNode().get();
            Generator.addGetter(this.parsed.getDeclaration().asClassOrInterfaceDeclaration(), cls, this.description, true, this);
            return this.implementationGetter;
        }

        @Override
        public MethodDeclaration generateSetter() {
            ClassOrInterfaceDeclaration cls = (ClassOrInterfaceDeclaration)this.declaration.getParentNode().get();
            Generator.addSetter(this.parsed.getDeclaration().asClassOrInterfaceDeclaration(), cls, this.description, true, this);
            return this.implementationSetter;
        }

        @Override
        public MethodDeclaration generateInterfaceGetter() {
            Generator.addGetter(this.parsed.getDeclaration().asClassOrInterfaceDeclaration(), this.parsed.getIntf(), this.description, false, this);
            return this.interfaceGetter;
        }

        @Override
        public MethodDeclaration generateInterfaceSetter() {
            Generator.addSetter(this.parsed.getDeclaration().asClassOrInterfaceDeclaration(), this.parsed.getIntf(), this.description, false, this);
            return this.interfaceSetter;
        }

        FieldData(Parsed<ClassOrInterfaceDeclaration> parsed, String name, FieldDeclaration declaration, MethodDeclaration description, String fullType, String type, boolean collection, boolean external, boolean genericMethod, boolean genericField, Ignores ignores, PrototypeDescription<ClassOrInterfaceDeclaration> prototype, Map<String, Type> generics, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes, List<MethodDeclaration> modifiers, PrototypeField parent, MethodDeclaration interfaceGetter, MethodDeclaration interfaceSetter, MethodDeclaration implementationGetter, MethodDeclaration implementationSetter) {
            this.parsed = parsed;
            this.name = name;
            this.declaration = declaration;
            this.description = description;
            this.fullType = fullType;
            this.type = type;
            this.collection = collection;
            this.external = external;
            this.genericMethod = genericMethod;
            this.genericField = genericField;
            this.ignores = ignores;
            this.prototype = prototype;
            this.generics = generics;
            this.typePrototypes = typePrototypes;
            this.modifiers = modifiers;
            this.parent = parent;
            this.interfaceGetter = interfaceGetter;
            this.interfaceSetter = interfaceSetter;
            this.implementationGetter = implementationGetter;
            this.implementationSetter = implementationSetter;
        }

        public static FieldDataBuilder builder() {
            return new FieldDataBuilder();
        }

        public String toString() {
            return "Structures.FieldData(parsed=" + this.getParsed() + ", name=" + this.getName() + ", declaration=" + this.getDeclaration() + ", description=" + this.getDescription() + ", fullType=" + this.getFullType() + ", type=" + this.getType() + ", collection=" + this.isCollection() + ", external=" + this.isExternal() + ", genericMethod=" + this.isGenericMethod() + ", genericField=" + this.isGenericField() + ", ignores=" + this.getIgnores() + ", interfaceGetter=" + this.getInterfaceGetter() + ", interfaceSetter=" + this.getInterfaceSetter() + ", implementationGetter=" + this.getImplementationGetter() + ", implementationSetter=" + this.getImplementationSetter() + ")";
        }

        @Override
        public Parsed<ClassOrInterfaceDeclaration> getParsed() {
            return this.parsed;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public FieldDeclaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public MethodDeclaration getDescription() {
            return this.description;
        }

        @Override
        public String getFullType() {
            return this.fullType;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isCollection() {
            return this.collection;
        }

        @Override
        public boolean isExternal() {
            return this.external;
        }

        @Override
        public boolean isGenericMethod() {
            return this.genericMethod;
        }

        @Override
        public boolean isGenericField() {
            return this.genericField;
        }

        @Override
        public Ignores getIgnores() {
            return this.ignores;
        }

        @Override
        public PrototypeDescription<ClassOrInterfaceDeclaration> getPrototype() {
            return this.prototype;
        }

        @Override
        public Map<String, Type> getGenerics() {
            return this.generics;
        }

        @Override
        public Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> getTypePrototypes() {
            return this.typePrototypes;
        }

        @Override
        public PrototypeField getParent() {
            return this.parent;
        }

        @Override
        public MethodDeclaration getInterfaceGetter() {
            return this.interfaceGetter;
        }

        @Override
        public MethodDeclaration getInterfaceSetter() {
            return this.interfaceSetter;
        }

        @Override
        public MethodDeclaration getImplementationGetter() {
            return this.implementationGetter;
        }

        @Override
        public MethodDeclaration getImplementationSetter() {
            return this.implementationSetter;
        }

        public void setParsed(Parsed<ClassOrInterfaceDeclaration> parsed) {
            this.parsed = parsed;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDeclaration(FieldDeclaration declaration) {
            this.declaration = declaration;
        }

        public void setDescription(MethodDeclaration description) {
            this.description = description;
        }

        public void setFullType(String fullType) {
            this.fullType = fullType;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setCollection(boolean collection) {
            this.collection = collection;
        }

        public void setExternal(boolean external) {
            this.external = external;
        }

        public void setGenericMethod(boolean genericMethod) {
            this.genericMethod = genericMethod;
        }

        public void setGenericField(boolean genericField) {
            this.genericField = genericField;
        }

        public void setIgnores(Ignores ignores) {
            this.ignores = ignores;
        }

        public void setPrototype(PrototypeDescription<ClassOrInterfaceDeclaration> prototype) {
            this.prototype = prototype;
        }

        public void setGenerics(Map<String, Type> generics) {
            this.generics = generics;
        }

        public void setTypePrototypes(Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes) {
            this.typePrototypes = typePrototypes;
        }

        public void setModifiers(List<MethodDeclaration> modifiers) {
            this.modifiers = modifiers;
        }

        public void setParent(PrototypeField parent) {
            this.parent = parent;
        }

        public void setInterfaceGetter(MethodDeclaration interfaceGetter) {
            this.interfaceGetter = interfaceGetter;
        }

        public void setInterfaceSetter(MethodDeclaration interfaceSetter) {
            this.interfaceSetter = interfaceSetter;
        }

        public void setImplementationGetter(MethodDeclaration implementationGetter) {
            this.implementationGetter = implementationGetter;
        }

        public void setImplementationSetter(MethodDeclaration implementationSetter) {
            this.implementationSetter = implementationSetter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldData)) {
                return false;
            }
            FieldData other = (FieldData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCollection() != other.isCollection()) {
                return false;
            }
            if (this.isExternal() != other.isExternal()) {
                return false;
            }
            if (this.isGenericMethod() != other.isGenericMethod()) {
                return false;
            }
            if (this.isGenericField() != other.isGenericField()) {
                return false;
            }
            Parsed<ClassOrInterfaceDeclaration> this$parsed = this.getParsed();
            Parsed<ClassOrInterfaceDeclaration> other$parsed = other.getParsed();
            if (this$parsed == null ? other$parsed != null : !((Object)this$parsed).equals(other$parsed)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            FieldDeclaration this$declaration = this.getDeclaration();
            FieldDeclaration other$declaration = other.getDeclaration();
            if (this$declaration == null ? other$declaration != null : !this$declaration.equals(other$declaration)) {
                return false;
            }
            MethodDeclaration this$description = this.getDescription();
            MethodDeclaration other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$fullType = this.getFullType();
            String other$fullType = other.getFullType();
            if (this$fullType == null ? other$fullType != null : !this$fullType.equals(other$fullType)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Ignores this$ignores = this.getIgnores();
            Ignores other$ignores = other.getIgnores();
            if (this$ignores == null ? other$ignores != null : !((Object)this$ignores).equals(other$ignores)) {
                return false;
            }
            PrototypeDescription<ClassOrInterfaceDeclaration> this$prototype = this.getPrototype();
            PrototypeDescription<ClassOrInterfaceDeclaration> other$prototype = other.getPrototype();
            if (this$prototype == null ? other$prototype != null : !this$prototype.equals(other$prototype)) {
                return false;
            }
            Map<String, Type> this$generics = this.getGenerics();
            Map<String, Type> other$generics = other.getGenerics();
            if (this$generics == null ? other$generics != null : !((Object)this$generics).equals(other$generics)) {
                return false;
            }
            Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> this$typePrototypes = this.getTypePrototypes();
            Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> other$typePrototypes = other.getTypePrototypes();
            if (this$typePrototypes == null ? other$typePrototypes != null : !((Object)this$typePrototypes).equals(other$typePrototypes)) {
                return false;
            }
            List<MethodDeclaration> this$modifiers = this.getModifiers();
            List<MethodDeclaration> other$modifiers = other.getModifiers();
            if (this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers)) {
                return false;
            }
            PrototypeField this$parent = this.getParent();
            PrototypeField other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
                return false;
            }
            MethodDeclaration this$interfaceGetter = this.getInterfaceGetter();
            MethodDeclaration other$interfaceGetter = other.getInterfaceGetter();
            if (this$interfaceGetter == null ? other$interfaceGetter != null : !this$interfaceGetter.equals(other$interfaceGetter)) {
                return false;
            }
            MethodDeclaration this$interfaceSetter = this.getInterfaceSetter();
            MethodDeclaration other$interfaceSetter = other.getInterfaceSetter();
            if (this$interfaceSetter == null ? other$interfaceSetter != null : !this$interfaceSetter.equals(other$interfaceSetter)) {
                return false;
            }
            MethodDeclaration this$implementationGetter = this.getImplementationGetter();
            MethodDeclaration other$implementationGetter = other.getImplementationGetter();
            if (this$implementationGetter == null ? other$implementationGetter != null : !this$implementationGetter.equals(other$implementationGetter)) {
                return false;
            }
            MethodDeclaration this$implementationSetter = this.getImplementationSetter();
            MethodDeclaration other$implementationSetter = other.getImplementationSetter();
            return !(this$implementationSetter == null ? other$implementationSetter != null : !this$implementationSetter.equals(other$implementationSetter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCollection() ? 79 : 97);
            result = result * 59 + (this.isExternal() ? 79 : 97);
            result = result * 59 + (this.isGenericMethod() ? 79 : 97);
            result = result * 59 + (this.isGenericField() ? 79 : 97);
            Parsed<ClassOrInterfaceDeclaration> $parsed = this.getParsed();
            result = result * 59 + ($parsed == null ? 43 : ((Object)$parsed).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            FieldDeclaration $declaration = this.getDeclaration();
            result = result * 59 + ($declaration == null ? 43 : $declaration.hashCode());
            MethodDeclaration $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $fullType = this.getFullType();
            result = result * 59 + ($fullType == null ? 43 : $fullType.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Ignores $ignores = this.getIgnores();
            result = result * 59 + ($ignores == null ? 43 : ((Object)$ignores).hashCode());
            PrototypeDescription<ClassOrInterfaceDeclaration> $prototype = this.getPrototype();
            result = result * 59 + ($prototype == null ? 43 : $prototype.hashCode());
            Map<String, Type> $generics = this.getGenerics();
            result = result * 59 + ($generics == null ? 43 : ((Object)$generics).hashCode());
            Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> $typePrototypes = this.getTypePrototypes();
            result = result * 59 + ($typePrototypes == null ? 43 : ((Object)$typePrototypes).hashCode());
            List<MethodDeclaration> $modifiers = this.getModifiers();
            result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
            PrototypeField $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
            MethodDeclaration $interfaceGetter = this.getInterfaceGetter();
            result = result * 59 + ($interfaceGetter == null ? 43 : $interfaceGetter.hashCode());
            MethodDeclaration $interfaceSetter = this.getInterfaceSetter();
            result = result * 59 + ($interfaceSetter == null ? 43 : $interfaceSetter.hashCode());
            MethodDeclaration $implementationGetter = this.getImplementationGetter();
            result = result * 59 + ($implementationGetter == null ? 43 : $implementationGetter.hashCode());
            MethodDeclaration $implementationSetter = this.getImplementationSetter();
            result = result * 59 + ($implementationSetter == null ? 43 : $implementationSetter.hashCode());
            return result;
        }

        public static class FieldDataBuilder {
            private Parsed<ClassOrInterfaceDeclaration> parsed;
            private String name;
            private FieldDeclaration declaration;
            private MethodDeclaration description;
            private String fullType;
            private String type;
            private boolean collection;
            private boolean external;
            private boolean genericMethod;
            private boolean genericField;
            private Ignores ignores;
            private PrototypeDescription<ClassOrInterfaceDeclaration> prototype;
            private Map<String, Type> generics;
            private Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes;
            private List<MethodDeclaration> modifiers;
            private PrototypeField parent;
            private MethodDeclaration interfaceGetter;
            private MethodDeclaration interfaceSetter;
            private MethodDeclaration implementationGetter;
            private MethodDeclaration implementationSetter;

            FieldDataBuilder() {
            }

            public FieldDataBuilder parsed(Parsed<ClassOrInterfaceDeclaration> parsed) {
                this.parsed = parsed;
                return this;
            }

            public FieldDataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public FieldDataBuilder declaration(FieldDeclaration declaration) {
                this.declaration = declaration;
                return this;
            }

            public FieldDataBuilder description(MethodDeclaration description) {
                this.description = description;
                return this;
            }

            public FieldDataBuilder fullType(String fullType) {
                this.fullType = fullType;
                return this;
            }

            public FieldDataBuilder type(String type) {
                this.type = type;
                return this;
            }

            public FieldDataBuilder collection(boolean collection) {
                this.collection = collection;
                return this;
            }

            public FieldDataBuilder external(boolean external) {
                this.external = external;
                return this;
            }

            public FieldDataBuilder genericMethod(boolean genericMethod) {
                this.genericMethod = genericMethod;
                return this;
            }

            public FieldDataBuilder genericField(boolean genericField) {
                this.genericField = genericField;
                return this;
            }

            public FieldDataBuilder ignores(Ignores ignores) {
                this.ignores = ignores;
                return this;
            }

            public FieldDataBuilder prototype(PrototypeDescription<ClassOrInterfaceDeclaration> prototype) {
                this.prototype = prototype;
                return this;
            }

            public FieldDataBuilder generics(Map<String, Type> generics) {
                this.generics = generics;
                return this;
            }

            public FieldDataBuilder typePrototypes(Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes) {
                this.typePrototypes = typePrototypes;
                return this;
            }

            public FieldDataBuilder modifiers(List<MethodDeclaration> modifiers) {
                this.modifiers = modifiers;
                return this;
            }

            public FieldDataBuilder parent(PrototypeField parent) {
                this.parent = parent;
                return this;
            }

            public FieldDataBuilder interfaceGetter(MethodDeclaration interfaceGetter) {
                this.interfaceGetter = interfaceGetter;
                return this;
            }

            public FieldDataBuilder interfaceSetter(MethodDeclaration interfaceSetter) {
                this.interfaceSetter = interfaceSetter;
                return this;
            }

            public FieldDataBuilder implementationGetter(MethodDeclaration implementationGetter) {
                this.implementationGetter = implementationGetter;
                return this;
            }

            public FieldDataBuilder implementationSetter(MethodDeclaration implementationSetter) {
                this.implementationSetter = implementationSetter;
                return this;
            }

            public FieldData build() {
                return new FieldData(this.parsed, this.name, this.declaration, this.description, this.fullType, this.type, this.collection, this.external, this.genericMethod, this.genericField, this.ignores, this.prototype, this.generics, this.typePrototypes, this.modifiers, this.parent, this.interfaceGetter, this.interfaceSetter, this.implementationGetter, this.implementationSetter);
            }

            public String toString() {
                return "Structures.FieldData.FieldDataBuilder(parsed=" + this.parsed + ", name=" + this.name + ", declaration=" + this.declaration + ", description=" + this.description + ", fullType=" + this.fullType + ", type=" + this.type + ", collection=" + this.collection + ", external=" + this.external + ", genericMethod=" + this.genericMethod + ", genericField=" + this.genericField + ", ignores=" + this.ignores + ", prototype=" + this.prototype + ", generics=" + this.generics + ", typePrototypes=" + this.typePrototypes + ", modifiers=" + this.modifiers + ", parent=" + this.parent + ", interfaceGetter=" + this.interfaceGetter + ", interfaceSetter=" + this.interfaceSetter + ", implementationGetter=" + this.implementationGetter + ", implementationSetter=" + this.implementationSetter + ")";
            }
        }
    }
}

