/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.binis.codegen.enrich.QueryEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.CollectionsHandler;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.spring.annotation.Joinable;
import net.binis.codegen.spring.annotation.QueryFragment;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;

public class QueryEnricherHandler
extends BaseEnricher
implements QueryEnricher {
    private static final Logger log = LoggerFactory.getLogger(QueryEnricherHandler.class);
    public static final String OPERATION = "Operation";
    private static final String QUERY_START = "QueryStarter";
    private static final String QUERY_SELECT = "QuerySelect";
    private static final String QUERY_UPDATE = "QueryUpdate";
    private static final String QUERY_SELECT_OPERATION = "QuerySelectOperation";
    private static final String QUERY_ORDER = "QueryOrder";
    private static final String QUERY_ORDER_OPERATION = "QueryOrderOperation";
    private static final String QUERY_ORDER_START = "QueryOrderStart";
    private static final String QUERY_AGGREGATE = "QueryAggregate";
    private static final String QUERY_FIELDS_START = "QueryFieldsStart";
    private static final String QUERY_AGGREGATE_OPERATION = "QueryAggregateOperation";
    private static final String QUERY_JOIN_AGGREGATE_OPERATION = "QueryJoinAggregateOperation";
    private static final String QUERY_AGGREGATOR = "QueryAggregator";
    private static final String QUERY_PARAM = "QueryParam";
    private static final String QUERY_EXECUTE = "QueryExecute";
    private static final String QUERY_WHERE = "QueryWhere";
    private static final String QUERY_EXECUTOR = "QueryExecutor";
    private static final String QUERY_GENERIC = "QR";
    private static final String QUERY_SELECT_GENERIC = "QS";
    private static final String QUERY_ORDER_GENERIC = "QO";
    private static final String QUERY_AGGREGATE_GENERIC = "QA";
    private static final String QUERY_FETCH_GENERIC = "QF";
    private static final String QUERY_FUNCTIONS = "QueryFunctions";
    private static final String QUERY_COLLECTION_FUNCTIONS = "QueryCollectionFunctions";
    private static final String QUERY_JOIN_COLLECTION_FUNCTIONS = "QueryJoinCollectionFunctions";
    private static final String QUERY_FIELDS = "QueryFields";
    private static final String QUERY_OP_FIELDS = "QueryOperationFields";
    private static final String QUERY_FUNCS = "QueryFuncs";
    private static final String QUERY_FETCH = "QueryFetch";
    private static final String QUERY_NAME = "QueryName";
    private static final String QUERY_SCRIPT = "QueryScript";
    private static final String QUERY_BRACKET = "QueryBracket";
    private static final String QUERY_IMPL = "Impl";
    private static final String PRESET_PREFIX = "__";

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        ClassOrInterfaceDeclaration spec = description.getSpec();
        ClassOrInterfaceDeclaration intf = description.getIntf();
        Helpers.addSuppressWarningsUnchecked((NodeWithAnnotations)spec);
        Tools.with((CompilationUnit)intf.findCompilationUnit().get(), unit -> unit.addImport("java.util.List").addImport("net.binis.codegen.creator.EntityCreator").addImport("net.binis.codegen.spring.query.*").addImport("java.util.Optional"));
        Tools.with((CompilationUnit)spec.findCompilationUnit().get(), unit -> unit.addImport("java.util.List").addImport("net.binis.codegen.factory.CodeFactory").addImport("net.binis.codegen.creator.EntityCreator").addImport("net.binis.codegen.spring.query.*").addImport("net.binis.codegen.spring.query.executor.QueryExecutor").addImport("net.binis.codegen.spring.query.executor.QueryOrderer").addImport("net.binis.codegen.spring.query.base.BaseQueryNameImpl").addImport("java.util.Optional").addImport("java.util.function.Function"));
        this.addFindMethod(description, intf);
        this.addQuerySelectOrderName(description, intf, spec);
        this.addPresets(description, description.getDeclaration(), intf, spec);
        Helpers.addInitializer(description, intf, Objects.isNull(description.getMixIn()) ? spec : description.getMixIn().getSpec(), false);
    }

    @Override
    public int order() {
        return 500;
    }

    private void addQuerySelectOrderName(PrototypeDescription<ClassOrInterfaceDeclaration> description, ClassOrInterfaceDeclaration intf, ClassOrInterfaceDeclaration spec) {
        String entity = description.getProperties().getInterfaceName();
        ClassOrInterfaceDeclaration select = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_SELECT).addExtendedType("QueryExecute<QR>")).addExtendedType("QueryModifiers<" + entity + ".QueryName<" + entity + ".QuerySelect<QR>, " + entity + ".QueryOrder<QR>, QR, " + entity + ">>")).addExtendedType(entity + ".QueryFields<QuerySelectOperation<" + entity + ".QuerySelect<QR>, " + entity + ".QueryOrder<QR>, QR>>")).addExtendedType(entity + ".QueryFuncs<QuerySelectOperation<" + entity + ".QuerySelect<QR>, " + entity + ".QueryOrder<QR>, QR>>")).addExtendedType("QueryOrderStart<QueryOperationFields<QueryOrderOperation<" + entity + ".QueryOrder<QR>, QR>>>")).addExtendedType("QueryBracket<QuerySelect<QR>>")).addTypeParameter(QUERY_GENERIC);
        intf.addMember((BodyDeclaration)select);
        ClassOrInterfaceDeclaration impl = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), false, entity + "QueryExecutorImpl").addModifier(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.STATIC})).addExtendedType(QUERY_EXECUTOR)).addImplementedType(entity + ".QueryUpdate");
        ((MethodDeclaration)((MethodDeclaration)impl.addMethod("order", new Modifier.Keyword[0]).setType(entity + ".QueryOrder")).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("(" + entity + ".QueryOrder) orderStart(new " + entity + "QueryOrderImpl(this, " + entity + "QueryExecutorImpl.this::orderIdentifier))")));
        ((MethodDeclaration)((MethodDeclaration)impl.addMethod("aggregate", new Modifier.Keyword[0]).setType(QUERY_AGGREGATE_OPERATION)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("(QueryAggregateOperation) aggregateStart(new " + entity + "QueryOrderImpl(this, " + entity + "QueryExecutorImpl.this::aggregateIdentifier))")));
        spec.addMember((BodyDeclaration)impl);
        ClassOrInterfaceDeclaration qExecSelect = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), false, entity + "SelectQueryExecutorImpl").addModifier(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.STATIC})).addExtendedType(impl.getNameAsString())).addImplementedType(entity + ".QuerySelect");
        ClassOrInterfaceDeclaration qExecFields = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), false, entity + "FieldsQueryExecutorImpl").addModifier(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.STATIC})).addExtendedType(impl.getNameAsString())).addImplementedType(entity + ".QueryFieldsStart")).addImplementedType("EmbeddedFields");
        ClassOrInterfaceDeclaration orderImpl = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), false, entity + "QueryOrderImpl").addModifier(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED})).addExtendedType("QueryOrderer")).addImplementedType(entity + ".QueryOrder")).addImplementedType(entity + ".QueryAggregate");
        ((ConstructorDeclaration)((ConstructorDeclaration)orderImpl.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).addParameter(entity + "QueryExecutorImpl", "executor")).addParameter("Function<String, Object>", "func")).setBody((BlockStmt)new BlockStmt().addStatement("super(executor, func);"));
        impl.addMember((BodyDeclaration)orderImpl);
        ClassOrInterfaceDeclaration qName = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_NAME).addTypeParameter(QUERY_SELECT_GENERIC)).addTypeParameter(QUERY_ORDER_GENERIC)).addTypeParameter(QUERY_GENERIC)).addTypeParameter(QUERY_FETCH_GENERIC)).addExtendedType(entity + ".QueryFields<QuerySelectOperation<QS, QO, QR>>")).addExtendedType(entity + ".QueryFuncs<QuerySelectOperation<QS, QO, QR>>")).addExtendedType("QueryFetch<QuerySelectOperation<QS, QO, QR>, QF>");
        intf.addMember((BodyDeclaration)qName);
        ClassOrInterfaceDeclaration qNameImpl = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), false, entity + "QueryNameImpl").addModifier(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.STATIC})).addExtendedType("BaseQueryNameImpl")).addImplementedType(entity + ".QueryName")).addImplementedType("QueryEmbed");
        spec.addMember((BodyDeclaration)qNameImpl);
        ClassOrInterfaceDeclaration qFields = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_FIELDS).addExtendedType("QueryScript<QR>")).addTypeParameter(QUERY_GENERIC);
        intf.addMember((BodyDeclaration)qFields);
        ClassOrInterfaceDeclaration qOpFields = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_OP_FIELDS).addExtendedType("QueryScript<QR>")).addExtendedType("QuerySelf<QR>")).addTypeParameter(QUERY_GENERIC);
        intf.addMember((BodyDeclaration)qOpFields);
        ClassOrInterfaceDeclaration qFuncs = (ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_FUNCS).addTypeParameter(QUERY_GENERIC);
        intf.addMember((BodyDeclaration)qFuncs);
        ClassOrInterfaceDeclaration order = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_ORDER).addExtendedType("QueryOperationFields<QueryOrderOperation<" + entity + ".QueryOrder<QR>, QR>>")).addExtendedType("QueryExecute<QR>")).addTypeParameter(QUERY_GENERIC);
        intf.addMember((BodyDeclaration)order);
        String aggregateType = entity + ".QueryAggregate<" + entity + ", " + entity + ".QuerySelect<Number>>";
        ClassOrInterfaceDeclaration aggr = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_AGGREGATE).addExtendedType("QueryExecute<QR>")).addExtendedType("QueryAggregator<QA, QueryAggregateOperation<QueryOperationFields<" + aggregateType + ">>, " + aggregateType + ">")).addTypeParameter(QUERY_GENERIC)).addTypeParameter(QUERY_AGGREGATE_GENERIC);
        intf.addMember((BodyDeclaration)aggr);
        ClassOrInterfaceDeclaration fields = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_FIELDS_START).addExtendedType("QueryExecute<QR>")).addExtendedType("QueryWhere<QS>")).addExtendedType("QueryOperationFields<QueryFieldsStart<QR, QS>>")).addTypeParameter(QUERY_GENERIC)).addTypeParameter(QUERY_SELECT_GENERIC);
        intf.addMember((BodyDeclaration)fields);
        ClassOrInterfaceDeclaration update = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, QUERY_UPDATE).addExtendedType("QueryFields<QueryUpdate<QR, QS>>")).addExtendedType("QueryWhere<QS>")).addExtendedType("QueryScript<QueryUpdate<QR, QS>>")).addExtendedType("UpdatableQuery")).addTypeParameter(QUERY_GENERIC)).addTypeParameter(QUERY_SELECT_GENERIC);
        intf.addMember((BodyDeclaration)update);
        description.registerClass(QUERY_EXECUTOR, impl);
        description.registerClass("QueryExecutorSelect", qExecSelect);
        description.registerClass("QueryExecutorFields", qExecFields);
        description.registerClass("QuerySelectIntf", select);
        description.registerClass(QUERY_ORDER, orderImpl);
        description.registerClass("QueryQueryOrderIntf", order);
        description.registerClass(QUERY_NAME, qNameImpl);
        description.registerClass("QueryQueryNameIntf", qName);
        description.registerClass("QueryFieldsIntf", qFields);
        description.registerClass("QueryOperationFieldsIntf", qOpFields);
        description.registerClass("QueryFunctionsIntf", qFuncs);
        if (Helpers.hasAnnotation(description, Joinable.class)) {
            Helpers.addInitializer(description, description.getRegisteredClass("QueryQueryOrderIntf"), (LambdaExpr)description.getParser().parseExpression("() -> " + description.getIntf().getNameAsString() + ".find().aggregate()").getResult().get(), false);
        }
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        String entity = description.getProperties().getInterfaceName();
        ClassOrInterfaceDeclaration intf = description.getIntf();
        ClassOrInterfaceDeclaration impl = description.getRegisteredClass(QUERY_EXECUTOR);
        ClassOrInterfaceDeclaration qExecSelect = description.getRegisteredClass("QueryExecutorSelect");
        ClassOrInterfaceDeclaration qExecFields = description.getRegisteredClass("QueryExecutorFields");
        ClassOrInterfaceDeclaration select = description.getRegisteredClass("QuerySelectIntf");
        ClassOrInterfaceDeclaration orderImpl = description.getRegisteredClass(QUERY_ORDER);
        ClassOrInterfaceDeclaration order = description.getRegisteredClass("QueryQueryOrderIntf");
        ClassOrInterfaceDeclaration qNameImpl = description.getRegisteredClass(QUERY_NAME);
        ClassOrInterfaceDeclaration qName = description.getRegisteredClass("QueryQueryNameIntf");
        ClassOrInterfaceDeclaration qFields = description.getRegisteredClass("QueryFieldsIntf");
        ClassOrInterfaceDeclaration qOpFields = description.getRegisteredClass("QueryOperationFieldsIntf");
        ClassOrInterfaceDeclaration qFuncs = description.getRegisteredClass("QueryFunctionsIntf");
        ClassOrInterfaceDeclaration mFields = description.getRegisteredClass("ModifierFields");
        if (Objects.nonNull(mFields)) {
            qFields.addExtendedType(intf.getNameAsString() + "." + mFields.getNameAsString() + "<QR>");
        }
        HashSet declaredFields = new HashSet();
        Tools.with(description.getBase(), base -> base.getFields().forEach(desc -> this.declareField(declaredFields, description, entity, (PrototypeField)desc, select, impl, orderImpl, order, qName, qNameImpl, qFields, qOpFields, qFuncs, qExecSelect, qExecFields)));
        description.getFields().forEach(desc -> this.declareField(declaredFields, description, entity, (PrototypeField)desc, select, impl, orderImpl, order, qName, qNameImpl, qFields, qOpFields, qFuncs, qExecSelect, qExecFields));
        if (Objects.nonNull(description.getMixIn())) {
            Tools.with(description.getMixIn().getBase(), base -> base.getFields().forEach(desc -> this.declareField(declaredFields, description, entity, (PrototypeField)desc, select, impl, orderImpl, order, qName, qNameImpl, qFields, qOpFields, qFuncs, qExecSelect, qExecFields)));
            description.getMixIn().getFields().forEach(desc -> this.declareField(declaredFields, description, entity, (PrototypeField)desc, select, impl, orderImpl, order, qName, qNameImpl, qFields, qOpFields, qFuncs, qExecSelect, qExecFields));
        }
        if (Objects.nonNull(description.getMixIn())) {
            Tools.with(description.getMixIn().getSpec(), mixin -> ((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)mixin.addMember((BodyDeclaration)description.getRegisteredClass(QUERY_EXECUTOR))).addMember((BodyDeclaration)description.getRegisteredClass("QueryExecutorSelect"))).addMember((BodyDeclaration)description.getRegisteredClass("QueryExecutorFields")));
            this.combineQueryNames(description);
        } else {
            Helpers.addInitializer(description, description.getRegisteredClass("QueryQueryNameIntf"), description.getRegisteredClass(QUERY_NAME), false);
        }
        if (qExecFields.getMethods().isEmpty()) {
            qExecSelect.getMethods().forEach(arg_0 -> ((ClassOrInterfaceDeclaration)impl).addMember(arg_0));
            ((ClassOrInterfaceDeclaration)impl.addImplementedType(entity + ".QuerySelect")).addImplementedType(entity + ".QueryFieldsStart");
            String prefix = Objects.nonNull(description.getMixIn()) ? description.getMixIn().getInterfaceName() : description.getInterfaceName();
            impl.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).setBody((BlockStmt)new BlockStmt().addStatement("super(" + entity + ".class, () -> new " + prefix + "QueryNameImpl(), parent -> parent);"));
            Helpers.addInitializer(description, select, impl, false);
            Helpers.addInitializer(description, qOpFields, impl, false);
        } else {
            impl.addModifier(new Modifier.Keyword[]{Modifier.Keyword.ABSTRACT});
            impl.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).setBody((BlockStmt)new BlockStmt().addStatement("super(" + entity + ".class, () -> new " + (Objects.nonNull(description.getMixIn()) ? description.getMixIn().getInterfaceName() : entity) + "QueryNameImpl(), parent -> {                var result = new " + qExecFields.getNameAsString() + "();                result.parent = (QueryExecutor) parent;                return result;            });"));
            Helpers.addInitializer(description, select, qExecSelect, false);
            Helpers.addInitializer(description, qOpFields, qExecFields, false);
            description.getSpec().addMember((BodyDeclaration)qExecSelect);
            description.getSpec().addMember((BodyDeclaration)qExecFields);
        }
    }

    private void addFindMethod(PrototypeDescription<ClassOrInterfaceDeclaration> description, ClassOrInterfaceDeclaration intf) {
        Helpers.addDefaultCreation(description, null);
        String entity = intf.getNameAsString();
        Helpers.addSuppressWarningsUnchecked((NodeWithAnnotations)((MethodDeclaration)intf.addMethod("find", new Modifier.Keyword[]{Modifier.Keyword.STATIC}).setType("QueryStarter<" + entity + ", " + entity + ".QuerySelect<" + entity + ">, QueryAggregateOperation<QueryOperationFields<" + entity + ".QueryAggregate<Number, " + entity + ".QuerySelect<Number>>>>, QueryFieldsStart<" + entity + ", " + entity + ".QuerySelect<" + entity + ">>, QueryUpdate<" + entity + ", " + entity + ".QuerySelect<" + entity + ">>>")).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("(QueryStarter) EntityCreator.create(" + entity + ".QuerySelect.class)"))));
    }

    private void declareField(Set<String> declaredFields, PrototypeDescription<ClassOrInterfaceDeclaration> description, String entity, PrototypeField desc, ClassOrInterfaceDeclaration select, ClassOrInterfaceDeclaration impl, ClassOrInterfaceDeclaration orderImpl, ClassOrInterfaceDeclaration order, ClassOrInterfaceDeclaration qName, ClassOrInterfaceDeclaration qNameImpl, ClassOrInterfaceDeclaration fields, ClassOrInterfaceDeclaration opFields, ClassOrInterfaceDeclaration funcs, ClassOrInterfaceDeclaration qExecSelect, ClassOrInterfaceDeclaration qExecFields) {
        FieldDeclaration field = desc.getDeclaration();
        String fName = field.getVariable(0).getNameAsString();
        String name = Helpers.checkReserved(fName);
        Pair<Type, PrototypeDescription<ClassOrInterfaceDeclaration>> pair = Helpers.getFieldType(description, desc);
        Type type = (Type)pair.getKey();
        if (!desc.getIgnores().isForQuery() && !declaredFields.contains(name)) {
            boolean trans = this.isTransient(desc);
            if (desc.isCollection()) {
                if (!trans) {
                    String subType = CollectionsHandler.getCollectionType(type);
                    if (Objects.nonNull(desc.getTypePrototypes())) {
                        PrototypeDescription<ClassOrInterfaceDeclaration> prototype = desc.getTypePrototypes().get(subType);
                        if (Objects.nonNull(prototype)) {
                            subType = prototype.getInterfaceName();
                        }
                        String returnType = "QueryJoinCollectionFunctions<" + subType + ", QuerySelectOperation<" + entity + ".QuerySelect<QR>, QueryOperationFields<QueryOrderOperation<" + entity + ".QueryOrder<QR>, QR>>, QR>, QueryJoinAggregateOperation<" + subType + ".QueryOperationFields<" + subType + ".QueryAggregate<Number, " + subType + ".QuerySelect<Number>>>, " + subType + ".QuerySelect<Number>>>";
                        ((MethodDeclaration)select.addMethod(name, new Modifier.Keyword[0]).setType(returnType)).setBody(null);
                        ((MethodDeclaration)((MethodDeclaration)impl.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_JOIN_COLLECTION_FUNCTIONS)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("(QueryJoinCollectionFunctions) joinStart(\"" + fName + "\", " + subType + ".QueryOrder.class)")));
                        if (Objects.nonNull(prototype)) {
                            prototype.registerPostProcessAction(() -> Helpers.addInitializer(prototype, prototype.getRegisteredClass("QueryQueryOrderIntf"), (LambdaExpr)prototype.getParser().parseExpression("() -> " + prototype.getInterfaceName() + ".find().aggregate()").getResult().get(), false));
                        }
                    } else {
                        String returnType = "QueryCollectionFunctions<" + subType + ", QuerySelectOperation<" + entity + ".QuerySelect<QR>, QueryOperationFields<QueryOrderOperation<" + entity + ".QueryOrder<QR>, QR>>, QR>>";
                        ((MethodDeclaration)select.addMethod(name, new Modifier.Keyword[0]).setType(returnType)).setBody(null);
                        ((MethodDeclaration)((MethodDeclaration)impl.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_COLLECTION_FUNCTIONS)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("identifier(\"" + fName + "\")")));
                    }
                }
            } else {
                Helpers.importType(type, (CompilationUnit)fields.findCompilationUnit().get());
                ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)impl.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_SELECT_OPERATION)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).addParameter(type, fName)).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("identifier(\"" + fName + "\", " + fName + ")")));
                if (!trans) {
                    if (Objects.isNull(desc.getPrototype()) || Objects.isNull(desc.getPrototype().getRegisteredClass("QueryOperationFieldsIntf"))) {
                        ((MethodDeclaration)((MethodDeclaration)orderImpl.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_ORDER_OPERATION)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("(QueryOrderOperation) func.apply(\"" + fName + "\")")));
                        ((MethodDeclaration)opFields.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_GENERIC)).setBody(null);
                    } else {
                        PrototypeDescription<ClassOrInterfaceDeclaration> prototype = desc.getPrototype();
                        ((MethodDeclaration)((MethodDeclaration)orderImpl.addMethod(name, new Modifier.Keyword[0]).setType(desc.getPrototype().getInterfaceName() + ".QueryOperationFields")).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)((BlockStmt)((BlockStmt)new BlockStmt().addStatement("var result = EntityCreator.create(" + prototype.getInterfaceName() + ".QueryOperationFields.class, \"" + prototype.getImplementorFullName() + "\");")).addStatement("((QueryEmbed) result).setParent(\"" + fName + "\", executor);")).addStatement((Statement)new ReturnStmt("result")));
                        ((MethodDeclaration)opFields.addMethod(name, new Modifier.Keyword[0]).setType(prototype.getInterfaceName() + ".QueryOperationFields<QR>")).setBody(null);
                        ((MethodDeclaration)qExecFields.addMethod(name, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(desc.getPrototype().getInterfaceName() + ".QueryOperationFields")).setBody((BlockStmt)((BlockStmt)((BlockStmt)new BlockStmt().addStatement("var result = EntityCreator.create(" + prototype.getInterfaceName() + ".QueryOperationFields.class, \"" + prototype.getImplementorFullName() + "\");")).addStatement("((QueryEmbed) result).setParent(\"" + fName + "\", this);")).addStatement((Statement)new ReturnStmt("result")));
                    }
                }
                if (this.checkQueryName(desc)) {
                    ((MethodDeclaration)select.addMethod(name, new Modifier.Keyword[0]).setType(desc.getPrototype().getInterfaceName() + ".QueryName<" + entity + ".QuerySelect<QR>, " + entity + ".QueryOrder<QR>, QR, " + desc.getPrototype().getInterfaceName() + ">")).setBody(null);
                    ((MethodDeclaration)qExecSelect.addMethod(name, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(desc.getPrototype().getInterfaceName() + ".QueryName")).setBody((BlockStmt)((BlockStmt)((BlockStmt)new BlockStmt().addStatement("var result = EntityCreator.create(" + desc.getPrototype().getInterfaceName() + ".QueryName.class, \"" + desc.getPrototype().getImplementorFullName() + "\");")).addStatement("((QueryEmbed) result).setParent(\"" + fName + "\", this);")).addStatement((Statement)new ReturnStmt("result")));
                    ((MethodDeclaration)qName.addMethod(name, new Modifier.Keyword[0]).setType(desc.getPrototype().getInterfaceName() + ".QueryName<QS, QO, QR, " + desc.getPrototype().getInterfaceName() + ">")).setBody(null);
                    ((MethodDeclaration)qNameImpl.addMethod(name, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(desc.getPrototype().getInterfaceName() + ".QueryName")).setBody((BlockStmt)((BlockStmt)((BlockStmt)new BlockStmt().addStatement("var result = EntityCreator.create(" + desc.getPrototype().getInterfaceName() + ".QueryName.class, \"" + desc.getPrototype().getImplementorFullName() + "\");")).addStatement("((QueryEmbed) result).setParent(\"" + fName + "\", executor);")).addStatement((Statement)new ReturnStmt("result")));
                } else if (!trans) {
                    ((MethodDeclaration)funcs.addMethod(name, new Modifier.Keyword[0]).setType("QueryFunctions<" + Helpers.handleGenericPrimitiveType(type) + ",QR>")).setBody(null);
                    ((MethodDeclaration)impl.addMethod(name, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(QUERY_FUNCTIONS)).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("identifier(\"" + fName + "\")")));
                    ((MethodDeclaration)((MethodDeclaration)qNameImpl.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_FUNCTIONS)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("executor.identifier(\"" + fName + "\")")));
                }
                if (!Helpers.methodExists(fields, desc, false, type)) {
                    ((MethodDeclaration)fields.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_GENERIC)).setBody(null).addParameter(type, fName);
                }
                ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)qNameImpl.addMethod(name, new Modifier.Keyword[0]).setType(QUERY_SELECT_OPERATION)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).addParameter(type, fName)).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt("executor.identifier(\"" + fName + "\", " + fName + ")")));
                desc.getDescription().getAnnotations().forEach(a -> {
                    String cls = Helpers.getExternalClassNameIfExists((CompilationUnit)desc.getDescription().findCompilationUnit().get(), a.getNameAsString());
                    if ("jakarta.persistence.Id".equals(cls)) {
                        description.getCustomInitializers().add(b -> b.addStatement("CodeFactory.registerId(" + entity + ".class, \"" + fName + "\", " + field.getVariable(0).getType().asString() + ".class);"));
                    }
                });
            }
            declaredFields.add(name);
        }
    }

    private boolean isTransient(PrototypeField field) {
        for (AnnotationExpr ann : field.getDescription().getAnnotations()) {
            String name = ann.getNameAsString();
            if ("Transient".equals(name)) {
                name = Helpers.getExternalClassName((CompilationUnit)field.getDescription().findCompilationUnit().get(), name);
            }
            if (!"jakarta.persistence.Transient".equals(name) && !"org.springframework.data.annotation.Transient".equals(name)) continue;
            return true;
        }
        return false;
    }

    private void addPresets(PrototypeDescription<ClassOrInterfaceDeclaration> description, TypeDeclaration<ClassOrInterfaceDeclaration> declaration, ClassOrInterfaceDeclaration intf, ClassOrInterfaceDeclaration spec) {
        String entity = description.getProperties().getInterfaceName();
        String returnType = "QuerySelectOperation<" + entity + ".QuerySelect<QR>, " + entity + ".QueryOrder<QR>, QR>";
        String implReturnType = description.getInterfaceName() + "QueryExecutorImpl";
        ClassOrInterfaceDeclaration select = description.getRegisteredClass("QuerySelectIntf");
        ClassOrInterfaceDeclaration exec = description.getRegisteredClass(QUERY_EXECUTOR);
        declaration.getMembers().stream().filter(BodyDeclaration::isMethodDeclaration).map(BodyDeclaration::asMethodDeclaration).filter(MethodDeclaration::isDefault).filter(m -> m.isAnnotationPresent(QueryFragment.class)).forEach(method -> method.getBody().ifPresent(body -> {
            if (body.getStatements().size() == 1) {
                if (!Helpers.methodExists(select, method, this.calcPresetName(method.getNameAsString()), false)) {
                    if ("String".equals(method.getType().asString())) {
                        this.handleStringPreset(description, (MethodDeclaration)method, (BlockStmt)body, select, exec, returnType, implReturnType);
                    } else {
                        this.handlePreset(description, (MethodDeclaration)method, (BlockStmt)body, select, exec, returnType, implReturnType);
                    }
                }
            } else {
                log.error("Invalid Preset expression! Preset expression must be sole expression in method's body!");
            }
        }));
        declaration.asClassOrInterfaceDeclaration().getExtendedTypes().forEach(t -> Tools.notNull(this.lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)declaration.findCompilationUnit().get(), t.getNameAsString())), parsed -> {
            if (Objects.isNull(parsed.getCompiled())) {
                this.addPresets(description, parsed.getDeclaration(), intf, spec);
            } else {
                Arrays.stream(parsed.getCompiled().getDeclaredMethods()).filter(Method::isDefault).filter(m -> Objects.nonNull(m.getAnnotation(QueryFragment.class))).forEach(method -> {
                    if (!Helpers.methodExists(select, this.calcPresetName(method.getName()), method, false)) {
                        if (String.class.equals(method.getReturnType())) {
                            this.handleCompiledStringPreset(description, (Method)method, this.getCompiledPreset(parsed.getCompiled(), (Method)method), select, exec, returnType, implReturnType);
                        } else {
                            log.warn("Unsupported query preset type in compiled prototype for method '{}.{}'", (Object)parsed.getCompiled().getSimpleName(), (Object)method.getName());
                        }
                    }
                });
            }
        }));
    }

    private String getCompiledPreset(Class<?> cls, Method method) {
        String result = "Invalid method!";
        InvocationHandler handler = (proxy, mtd, args) -> {
            if (mtd.isDefault()) {
                return InvocationHandler.invokeDefault(proxy, mtd, args);
            }
            throw new IllegalStateException("Unable to find default method!");
        };
        try {
            Object proxy2 = cls.cast(Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, handler));
            Method mtd2 = Arrays.stream(proxy2.getClass().getDeclaredMethods()).filter(m -> m.getName().equals(method.getName())).filter(m -> m.getReturnType().equals(method.getReturnType())).filter(m -> this.compareParameterTypes((Method)m, method)).findFirst().get();
            result = (String)mtd2.invoke(proxy2, new Object[method.getParameterCount()]);
        }
        catch (Exception e) {
            log.error("Unable to get compiled preset for {}.{}", (Object)cls.getSimpleName(), (Object)method.getName());
        }
        return result;
    }

    private boolean compareParameterTypes(Method m, Method method) {
        if (m.getParameterCount() == method.getParameterCount()) {
            Parameter[] params = m.getParameters();
            Parameter[] params2 = method.getParameters();
            for (int i = 0; i < m.getParameterCount(); ++i) {
                if (params[i].getType().equals(params2[i].getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void handleStringPreset(PrototypeDescription<ClassOrInterfaceDeclaration> description, MethodDeclaration method, BlockStmt body, ClassOrInterfaceDeclaration select, ClassOrInterfaceDeclaration exec, String returnType, String implReturnType) {
        Statement statement = body.getStatement(0);
        if (statement.isReturnStmt() && statement.asReturnStmt().getExpression().isPresent() && ((Expression)statement.asReturnStmt().getExpression().get()).isStringLiteralExpr()) {
            String expression = ((Expression)statement.asReturnStmt().getExpression().get()).asStringLiteralExpr().asString();
            MethodDeclaration mtd = ((MethodDeclaration)select.addMethod(this.calcPresetName(method.getNameAsString()), new Modifier.Keyword[0]).setType(returnType)).setBody(null);
            this.copyParameters(method, mtd);
            MethodDeclaration impl = (MethodDeclaration)((MethodDeclaration)exec.addMethod(this.calcPresetName(method.getNameAsString()), new Modifier.Keyword[0]).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setType(implReturnType);
            this.copyParameters(method, impl);
            impl.setBody((BlockStmt)description.getParser().parseBlock("{((" + description.getInterfaceName() + ".QuerySelect<Object>) this)." + expression + ";return this;}").getResult().get());
        } else {
            log.error("Expression '{}' is not valid Preset expression! Preset expressions must directly return string! Example 'return \"title(title)\"'", (Object)body);
        }
    }

    private void handlePreset(PrototypeDescription<ClassOrInterfaceDeclaration> description, MethodDeclaration method, BlockStmt body, ClassOrInterfaceDeclaration select, ClassOrInterfaceDeclaration exec, String returnType, String implReturnType) {
        String expression = body.getStatement(0).toString();
        if (expression.startsWith("Preset.declare().")) {
            MethodDeclaration mtd = ((MethodDeclaration)select.addMethod(this.calcPresetName(method.getNameAsString()), new Modifier.Keyword[0]).setType(returnType)).setBody(null);
            this.copyParameters(method, mtd);
            MethodDeclaration impl = (MethodDeclaration)((MethodDeclaration)exec.addMethod(this.calcPresetName(method.getNameAsString()), new Modifier.Keyword[0]).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setType(implReturnType);
            this.copyParameters(method, impl);
            expression = this.handlePresetParameters(description, expression);
            impl.setBody((BlockStmt)description.getParser().parseBlock("{((" + description.getInterfaceName() + ".QuerySelect<Object>) this)" + expression + "return this;}").getResult().get());
        } else {
            log.error("Expression '{}' is not valid Preset expression! Preset expressions must start with: Preset.declare()", (Object)body);
        }
    }

    private void handleCompiledStringPreset(PrototypeDescription<ClassOrInterfaceDeclaration> description, Method method, String body, ClassOrInterfaceDeclaration select, ClassOrInterfaceDeclaration exec, String returnType, String implReturnType) {
        MethodDeclaration mtd = ((MethodDeclaration)select.addMethod(this.calcPresetName(method.getName()), new Modifier.Keyword[0]).setType(returnType)).setBody(null);
        this.copyCompiledParameters(method, mtd);
        MethodDeclaration impl = (MethodDeclaration)((MethodDeclaration)exec.addMethod(this.calcPresetName(method.getName()), new Modifier.Keyword[0]).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setType(implReturnType);
        this.copyCompiledParameters(method, impl);
        impl.setBody((BlockStmt)description.getParser().parseBlock("{((" + description.getInterfaceName() + ".QuerySelect<Object>) this)." + body + ";return this;}").getResult().get());
    }

    private void copyParameters(MethodDeclaration method, MethodDeclaration dest) {
        CompilationUnit unit = (CompilationUnit)method.findCompilationUnit().get();
        method.getParameters().forEach(param -> {
            PrototypeDescription<ClassOrInterfaceDeclaration> proto = this.lookup.findParsed(Helpers.getExternalClassName(unit, param.getType().asString()));
            if (Objects.nonNull(proto)) {
                dest.addParameter(proto.getInterfaceName(), param.getNameAsString());
                unit.addImport(proto.getInterfaceFullName());
            } else {
                dest.addParameter(param);
            }
        });
    }

    private void copyCompiledParameters(Method method, MethodDeclaration dest) {
        String[] names = new StandardReflectionParameterNameDiscoverer().getParameterNames(method);
        if (Objects.isNull(names)) {
            log.info("Project is compiled without '-parameters' argument. Thus why the actual parameter names can't be extracted!");
        }
        Parameter[] params = method.getParameters();
        CompilationUnit unit = (CompilationUnit)dest.findCompilationUnit().get();
        for (int i = 0; i < params.length; ++i) {
            String name;
            PrototypeDescription<ClassOrInterfaceDeclaration> proto = this.lookup.findParsed(params[i].getType().getCanonicalName());
            String string = name = Objects.isNull(names) ? params[i].getName() : names[i];
            if (Objects.nonNull(proto)) {
                dest.addParameter(proto.getInterfaceName(), name);
                unit.addImport(proto.getInterfaceFullName());
                continue;
            }
            dest.addParameter(params[i].getType().getSimpleName(), name);
        }
    }

    private String handlePresetParameters(PrototypeDescription<ClassOrInterfaceDeclaration> description, String expression) {
        String[] params = expression.split(".field\\(|.prototype\\(|.collection\\(");
        if (params.length > 1) {
            StringBuilder builder = new StringBuilder();
            for (int j = 1; j < params.length; ++j) {
                int i = params[j].indexOf("(");
                String name = params[j].substring(0, i);
                Optional<PrototypeField> field = description.findField(name);
                if (field.isPresent()) {
                    if (params[j].charAt(i + 2) == ')') {
                        builder.append('.').append(name).append('(').append(params[j].substring(i + 2));
                        continue;
                    }
                    if (params[j].charAt(i + 2) == ',') {
                        builder.append('.').append(name).append('(').append(params[j].substring(i + 4));
                        continue;
                    }
                    log.error("Invalid preset format!");
                    continue;
                }
                log.error("Field not found '{}'!", (Object)name);
            }
            expression = builder.toString();
        }
        return expression;
    }

    private String calcPresetName(String name) {
        if (name.startsWith(PRESET_PREFIX)) {
            return name;
        }
        return PRESET_PREFIX + name;
    }

    private void combineQueryNames(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        ClassOrInterfaceDeclaration mix = description.getRegisteredClass(QUERY_NAME);
        ClassOrInterfaceDeclaration base = description.getMixIn().getRegisteredClass(QUERY_NAME);
        base.addImplementedType(mix.getImplementedTypes(0));
        mix.getMembers().forEach(m -> {
            if (!Helpers.methodExists(base, m.asMethodDeclaration(), true)) {
                base.addMember(m);
            }
        });
        description.getRegisteredClass(QUERY_EXECUTOR).findAll(ObjectCreationExpr.class, n -> n.getType().getNameAsString().equals(mix.getNameAsString())).forEach(n -> n.setType(base.getNameAsString()));
        Helpers.addInitializer(description, description.getRegisteredClass("QueryQueryNameIntf"), description.getMixIn().getRegisteredClass(QUERY_NAME), false);
    }

    private boolean checkQueryName(PrototypeField desc) {
        return Objects.nonNull(desc.getPrototype()) && Objects.nonNull(desc.getPrototype().getRegisteredClass("QueryQueryNameIntf"));
    }
}

