/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import java.lang.reflect.Method;
import java.util.Objects;
import net.binis.codegen.enrich.HibernateEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.tools.Tools;

public class HibernateEnricherHandler
extends BaseEnricher
implements HibernateEnricher {
    private static final Method EQUALS = HibernateEnricherHandler.initEqualsMethod();
    private static final Method HASH_CODE = HibernateEnricherHandler.initHashCode();

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        description.getFields().stream().filter(field -> Objects.nonNull(field.getPrototype()) && field.getPrototype().isCodeEnum() || Objects.nonNull(this.lookup.findEnum(field.getFullType()))).forEach(this::processField);
    }

    private void processField(PrototypeField field) {
        field.getDeclaration().findCompilationUnit().ifPresent(unit -> unit.addImport("org.hibernate.annotations.Type"));
        field.getDeclaration().addAnnotation(StaticJavaParser.parseAnnotation((String)"@Type(net.binis.codegen.hibernate.CodeEnumType.class)"));
        Tools.with(field.getPrototype(), prototype -> {
            ClassOrInterfaceDeclaration intf = prototype.getIntf();
            if (!Helpers.methodExists(intf, EQUALS, false)) {
                ((MethodDeclaration)intf.addMethod("equals", new Modifier.Keyword[0]).setType((Type)PrimitiveType.booleanType()).addParameter("Object", "o")).setBody(null);
            }
            if (!Helpers.methodExists(intf, HASH_CODE, false)) {
                intf.addMethod("hashCode", new Modifier.Keyword[0]).setType((Type)PrimitiveType.intType()).setBody(null);
            }
        });
    }

    @Override
    public int order() {
        return 0;
    }

    private static Method initEqualsMethod() {
        try {
            return Object.class.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new GenericCodeGenException((Exception)e);
        }
    }

    private static Method initHashCode() {
        try {
            return Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new GenericCodeGenException((Exception)e);
        }
    }
}

