/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.test;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.binis.codegen.CodeGen;
import net.binis.codegen.generation.core.CompileHelper;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.test.JavaByteObject;
import net.binis.codegen.test.TestClassLoader;
import net.binis.codegen.test.TestExecutor;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTest {
    private static final Logger log = LoggerFactory.getLogger(BaseTest.class);
    protected JavaParser parser = new JavaParser();

    protected String getAsString(CompilationUnit file) {
        CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
        Helpers.sortImports(file);
        if (file.getType(0).isClassOrInterfaceDeclaration()) {
            Helpers.sortClass(file.getType(0).asClassOrInterfaceDeclaration());
        }
        return printer.print((Node)file);
    }

    protected void generate() {
        ArrayList<PrototypeDescription<ClassOrInterfaceDeclaration>> parsed = new ArrayList<PrototypeDescription<ClassOrInterfaceDeclaration>>(Helpers.lookup.parsed());
        for (PrototypeDescription<ClassOrInterfaceDeclaration> entry : parsed) {
            Tools.ifNull(entry.getFiles(), () -> Generator.generateCodeForClass((CompilationUnit)entry.getDeclaration().findCompilationUnit().get(), entry));
        }
        Helpers.lookup.calcPrototypeMaps();
        Tools.with(Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).sorted(Helpers::sortForEnrich).collect(Collectors.toList()), list -> {
            list.forEach(Helpers::handleEnrichers);
            list.forEach(Helpers::finalizeEnrichers);
            list.forEach(Helpers::postProcessEnrichers);
        });
    }

    protected void cleanUp() {
        Helpers.cleanUp();
    }

    protected void load(List<Pair<String, String>> list, String resource) {
        String source = this.resourceAsString(resource);
        ParseResult parse = this.parser.parse(source);
        Assert.assertTrue((String)parse.toString(), (boolean)parse.isSuccessful());
        if (Objects.nonNull(list)) {
            CompilationUnit result = (CompilationUnit)parse.getResult().get();
            String name = (String)((TypeDeclaration)result.findFirst(TypeDeclaration.class).get()).getFullyQualifiedName().get();
            list.add((Pair<String, String>)Pair.of((Object)name, (Object)source));
        }
        parse.getResult().ifPresent(u -> u.getTypes().forEach(t -> CodeGen.handleType(this.parser, t, resource)));
    }

    protected String loadExecute(List<Pair<String, String>> list, String resource) {
        String source = this.resourceAsString(resource);
        String className = source.substring(source.indexOf("package") + 8, source.indexOf(59)) + ".Execute";
        if (Objects.nonNull(list)) {
            list.add((Pair<String, String>)Pair.of((Object)className, (Object)source));
        }
        return className;
    }

    protected void compare(CompilationUnit unit, String resource) {
        if (Objects.nonNull(resource)) {
            Assert.assertEquals((String)resource, (Object)this.resourceAsString(resource), (Object)this.getAsString(unit));
        }
    }

    protected void testSingleExecute(String prototype, String resClass, String resInterface, String resExecute) {
        this.testSingleExecute(prototype, resClass, resInterface, null, 1, resExecute, false);
    }

    protected void testSingleExecute(String prototype, String resClass, String resInterface, int expected, String resExecute) {
        this.testSingleExecute(prototype, resClass, resInterface, null, expected, resExecute, false);
    }

    protected void testSingle(String prototype, String resClass, String resInterface) {
        this.testSingle(prototype, resClass, resInterface, null, 1);
    }

    protected void testSingle(String prototype, String resClass, String resInterface, String pathToSave) {
        this.testSingle(prototype, resClass, resInterface, pathToSave, 1);
    }

    protected void testSingle(String prototype, String resClass, String resInterface, int expected) {
        this.testSingle(prototype, resClass, resInterface, null, expected);
    }

    protected void testSingle(String prototype, String resClass, String resInterface, int expected, boolean skipCompilation) {
        this.testSingleExecute(prototype, resClass, resInterface, null, expected, null, skipCompilation);
    }

    protected void testSingle(String prototype, String resClass, String resInterface, String pathToSave, int expected) {
        this.testSingleExecute(prototype, resClass, resInterface, pathToSave, expected, null, false);
    }

    protected void testSingleExecute(String prototype, String resClass, String resInterface, String pathToSave, int expected, String resExecute, boolean skipCompilation) {
        List<Pair<String, String>> list = this.newList();
        this.load(list, prototype);
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list, null));
        this.generate();
        Assert.assertEquals((long)expected, (long)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list2 = this.newList();
        Helpers.lookup.generated().stream().sorted((o1, o2) -> Boolean.compare(Objects.isNull(o1.getCompiled()), Objects.isNull(o2.getCompiled()))).forEach(parsed -> {
            if (Objects.isNull(parsed.getCompiled()) && (!parsed.isNested() || Objects.isNull(parsed.getParentClassName()))) {
                if (Objects.nonNull(pathToSave)) {
                    this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                    this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
                }
                this.compare(parsed.getFiles().get(1), resInterface);
                this.compare(parsed.getFiles().get(0), resClass);
            }
            if (!parsed.isNested() || Objects.isNull(parsed.getParentClassName())) {
                if (!Helpers.classExists(parsed.getInterfaceFullName())) {
                    list2.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
                }
                if (!Helpers.classExists(parsed.getParsedFullName())) {
                    list2.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
                }
            }
        });
        if (!skipCompilation) {
            TestClassLoader loader = new TestClassLoader();
            Assert.assertTrue((boolean)this.compile(loader, list2, resExecute));
        }
    }

    protected void testMultiPass(List<Pair<List<Triple<String, String, String>>, Integer>> passes) {
        this.testMultiPassExecute(passes, null, null);
    }

    protected void testMulti(List<Triple<String, String, String>> files) {
        this.testMulti(files, null);
    }

    protected void testMulti(List<Triple<String, String, String>> files, int expected) {
        this.testMultiExecute(files, expected, null, null);
    }

    protected void testMulti(List<Triple<String, String, String>> files, String pathToSave) {
        this.testMultiExecute(files, files.size(), pathToSave, null);
    }

    protected void testMultiExecute(List<Triple<String, String, String>> files, String resExecute) {
        this.testMultiExecute(files, files.size(), null, resExecute);
    }

    protected void testMultiExecute(List<Triple<String, String, String>> files, int expected, String pathToSave, String resExecute) {
        List<Pair<String, String>> list = this.newList();
        files.forEach(t -> this.load(list, (String)t.getLeft()));
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list, null));
        this.generate();
        Assert.assertEquals((long)expected, (long)Helpers.lookup.parsed().size());
        ArrayList<Pair<String, String>> compileList = new ArrayList<Pair<String, String>>();
        files.forEach(f -> Helpers.lookup.findGeneratedByFileName((String)f.getLeft()).forEach(parsed -> {
            block4: {
                block3: {
                    this.compare(parsed.getFiles().get(1), (String)f.getRight());
                    this.compare(parsed.getFiles().get(0), (String)f.getMiddle());
                    if (Objects.nonNull(pathToSave)) {
                        if (Objects.isNull(parsed.getMixIn())) {
                            this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                        }
                        this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
                    }
                    if (!Objects.isNull(parsed.getMixIn())) break block3;
                    if (parsed.isNested() && !Objects.isNull(parsed.getParentClassName())) break block4;
                    compileList.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
                    compileList.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
                    break block4;
                }
                for (int i = 0; i < compileList.size(); ++i) {
                    if (!((String)((Pair)compileList.get(i)).getKey()).equals(parsed.getMixIn().getParsedFullName())) continue;
                    compileList.add(i, Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
                    break;
                }
            }
        }));
        TestClassLoader loader = new TestClassLoader();
        Assert.assertTrue((boolean)this.compile(loader, compileList, resExecute));
    }

    protected void testMultiPassExecute(List<Pair<List<Triple<String, String, String>>, Integer>> passes, String pathToSave, String resExecute) {
        TestClassLoader loader = new TestClassLoader();
        List<Pair<String, String>> list = this.newList();
        ArrayList compileList = new ArrayList();
        passes.forEach(pass -> {
            List files = (List)pass.getKey();
            int expected = (Integer)pass.getValue();
            files.forEach(t -> this.load(list, (String)t.getLeft()));
            Assert.assertTrue((boolean)this.compile(loader, list, null));
            this.generate();
            Assert.assertEquals((long)expected, (long)Helpers.lookup.parsed().size());
            files.forEach(f -> Helpers.lookup.findGeneratedByFileName((String)f.getLeft()).forEach(parsed -> {
                block4: {
                    block3: {
                        this.compare(parsed.getFiles().get(1), (String)f.getRight());
                        this.compare(parsed.getFiles().get(0), (String)f.getMiddle());
                        if (Objects.nonNull(pathToSave)) {
                            if (Objects.isNull(parsed.getMixIn())) {
                                this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                            }
                            this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
                        }
                        if (!Objects.isNull(parsed.getMixIn())) break block3;
                        if (parsed.isNested() && !Objects.isNull(parsed.getParentClassName())) break block4;
                        Pair intf = Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1)));
                        compileList.add(intf);
                        list.add(intf);
                        compileList.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
                        break block4;
                    }
                    for (int i = 0; i < compileList.size(); ++i) {
                        if (!((String)((Pair)compileList.get(i)).getKey()).equals(parsed.getMixIn().getParsedFullName())) continue;
                        Pair intf = Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1)));
                        compileList.add(intf);
                        list.add(intf);
                        break;
                    }
                }
            }));
            Assert.assertTrue((boolean)this.compile(loader, compileList, resExecute));
        });
    }

    protected void save(String name, CompilationUnit unit, String pathToSave) {
        String fileName = pathToSave + "/" + name + ".java";
        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        writer.write(this.getAsString(unit));
        writer.close();
        log.info("Saving - {}", (Object)fileName);
    }

    protected void testSingleWithBase(String basePrototype, String baseClassName, String prototype, String className, String baseClass, String baseInterface, String resClass, String resInterface) {
        List<Pair<String, String>> src = this.newList();
        this.load(src, basePrototype);
        this.load(src, prototype);
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), src, null));
        this.generate();
        Assert.assertEquals((long)2L, (long)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list = this.newList();
        Tools.with(Helpers.lookup.findGenerated(baseClassName), parsed -> {
            this.compare(parsed.getFiles().get(0), baseClass);
            this.compare(parsed.getFiles().get(1), baseInterface);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        });
        Tools.with(Helpers.lookup.findGenerated(className), parsed -> {
            this.compare(parsed.getFiles().get(0), resClass);
            this.compare(parsed.getFiles().get(1), resInterface);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        });
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list, null));
    }

    protected void testSingleWithMixIn(String basePrototype, String baseClassName, String prototype, String className, String baseClass, String baseInterface, String mixInInterface) {
        List<Pair<String, String>> src = this.newList();
        this.load(src, basePrototype);
        this.load(src, prototype);
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), src, null));
        this.generate();
        Assert.assertEquals((long)2L, (long)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list = this.newList();
        Tools.with(Helpers.lookup.findGenerated(baseClassName), parsed -> Tools.with(Helpers.lookup.findGenerated(className), parsedMixIn -> {
            this.compare(parsed.getFiles().get(1), baseInterface);
            this.compare(parsedMixIn.getFiles().get(1), mixInInterface);
            this.compare(parsed.getFiles().get(0), baseClass);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsedMixIn.getInterfaceFullName(), (Object)this.getAsString(parsedMixIn.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        }));
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list, null));
    }

    protected boolean compile(TestClassLoader loader, List<Pair<String, String>> files, String resExecute) {
        String className = null;
        if (Objects.nonNull(resExecute)) {
            className = this.loadExecute(files, resExecute);
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        Map<String, JavaByteObject> objects = files.stream().collect(Collectors.toMap(Pair::getKey, f -> new JavaByteObject((String)f.getKey())));
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        JavaFileManager fileManager = CompileHelper.createFileManager(standardFileManager, objects);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, List.of("-Xlint:unchecked"), null, CompileHelper.getCompilationUnits(files));
        if (!task.call().booleanValue()) {
            diagnostics.getDiagnostics().forEach(System.out::println);
            fileManager.close();
            return false;
        }
        diagnostics.getDiagnostics().forEach(System.out::println);
        fileManager.close();
        files.forEach(f -> Tools.with((JavaByteObject)objects.get(f.getKey()), o -> Tools.ifNull(loader.findClass((String)f.getKey()), () -> loader.define((String)f.getKey(), (JavaByteObject)o))));
        if (Objects.nonNull(resExecute)) {
            Class<?> cls = loader.findClass(className);
            Assert.assertNotNull((String)"Executor class not found!", cls);
            Assert.assertNotNull((String)"Executor doesn't inherit TestExecutor!", cls.getSuperclass());
            Assert.assertEquals((String)"Executor doesn't inherit TestExecutor!", TestExecutor.class, cls.getSuperclass());
            this.defineObjects(loader, objects);
            Reflection.withLoader((ClassLoader)loader, () -> Assert.assertTrue((String)"Test execution failed!", (boolean)TestExecutor.test(cls)));
        }
        return true;
    }

    private void defineObjects(TestClassLoader loader, Map<String, JavaByteObject> objects) {
        this.defineObjects(loader, objects, objects.size());
    }

    private void defineObjects(TestClassLoader loader, Map<String, JavaByteObject> objects, int tries) {
        boolean error = false;
        for (Map.Entry<String, JavaByteObject> entry : objects.entrySet()) {
            if (!Objects.isNull(loader.findClass(entry.getKey()))) continue;
            try {
                loader.define(entry.getKey(), entry.getValue());
            }
            catch (NoClassDefFoundError ex) {
                error = true;
            }
        }
        if (error && tries > 0) {
            this.defineObjects(loader, objects, tries - 1);
        }
    }

    private String resourceAsString(String resource) {
        try {
            return new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource(resource).toURI())));
        }
        catch (Exception e) {
            log.error("Unable to load resource: {}!", (Object)resource);
            throw e;
        }
    }

    protected List<Pair<String, String>> newList() {
        return new ArrayList<Pair<String, String>>();
    }

    protected UnaryOperator<String> testSourcesLookup() {
        return s -> {
            try {
                return Files.readString(Path.of("./src/test/java/" + s.replace('.', '/') + ".java", new String[0]));
            }
            catch (Exception e) {
                return null;
            }
        };
    }
}

