/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.binis.codegen.annotation.CodeAnnotation;
import net.binis.codegen.annotation.CodeImplementation;
import net.binis.codegen.annotation.CodePrototype;
import net.binis.codegen.annotation.EnumPrototype;
import net.binis.codegen.enrich.Enricher;
import net.binis.codegen.enrich.PrototypeEnricher;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompiledPrototypesHandler {
    private static final Logger log = LoggerFactory.getLogger(CompiledPrototypesHandler.class);

    public static boolean handleCompiledPrototype(String compiledPrototype) {
        Holder result = Holder.of((Object)false);
        Tools.notNull(Reflection.loadClass((String)compiledPrototype), c -> Tools.notNull(c.getAnnotation(CodePrototype.class), ann -> {
            ClassOrInterfaceDeclaration declaration = new CompilationUnit().setPackageDeclaration(c.getPackageName()).addClass(c.getSimpleName()).setInterface(true);
            for (TypeVariable p : c.getTypeParameters()) {
                declaration.addTypeParameter(p.getName());
            }
            CompiledPrototypesHandler.handleAnnotations(c, declaration);
            CompiledPrototypesHandler.handleFields(c, declaration);
            CompiledPrototypesHandler.handleDefaultMethods(c, declaration);
            Structures.PrototypeDataHandler props = CompiledPrototypesHandler.handleProperties(declaration, c, ann);
            Structures.Parsed.ParsedBuilder parsed = Structures.Parsed.builder().compiled((Class<?>)c).properties(props).parser(Helpers.lookup.getParser()).declaration(declaration);
            Structures.Parsed<ClassOrInterfaceDeclaration> prsd = parsed.build();
            Helpers.lookup.registerParsed(compiledPrototype, prsd);
            Generator.generateCodeForClass((CompilationUnit)declaration.findCompilationUnit().get(), prsd);
            result.set((Object)true);
        }));
        return (Boolean)result.get();
    }

    public static boolean handleCompiledEnumPrototype(String compiledPrototype) {
        Holder result = Holder.of((Object)false);
        Tools.notNull(Reflection.loadClass((String)compiledPrototype), c -> Tools.notNull(c.getAnnotation(EnumPrototype.class), ann -> {
            if (c.isEnum()) {
                EnumDeclaration declaration = new CompilationUnit().setPackageDeclaration(c.getPackageName()).addEnum(c.getSimpleName());
                CompiledPrototypesHandler.handleEntries(c, declaration);
                Structures.PrototypeDataHandler props = CompiledPrototypesHandler.handleProperties(declaration, c, ann);
                Structures.Parsed.ParsedBuilder parsed = Structures.Parsed.builder().compiled((Class<?>)c).codeEnum(true).properties(props).parser(Helpers.lookup.getParser()).interfaceName(props.getInterfaceName()).interfaceFullName(props.getInterfacePackage() + "." + props.getInterfaceName()).declaration(declaration);
                Structures.Parsed prsd = parsed.build();
                Helpers.lookup.registerParsed(compiledPrototype, prsd);
                result.set((Object)true);
            } else {
                log.warn("'{}' isn't enum class!", (Object)compiledPrototype);
            }
        }));
        return (Boolean)result.get();
    }

    private static void handleEntries(Class<?> c, EnumDeclaration declaration) {
        for (Object cnst : c.getEnumConstants()) {
            declaration.addEnumConstant(cnst.toString());
        }
    }

    private static Structures.PrototypeDataHandler handleProperties(ClassOrInterfaceDeclaration type, Class<?> cls, CodePrototype ann) {
        Holder iName = Holder.of((Object)Helpers.defaultInterfaceName(type));
        Object cName = Helpers.defaultClassName(type);
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.builder(cls.getSimpleName()).classPackage(Helpers.defaultClassPackage(type)).interfacePackage(Helpers.defaultInterfacePackage(type));
        if (StringUtils.isNotBlank((CharSequence)ann.name())) {
            String intf = ann.name().replace("Entity", "");
            builder.name(ann.name()).className(ann.name()).interfaceName(intf).longModifierName(intf + ".Modify");
        }
        if (StringUtils.isNotBlank((CharSequence)ann.interfaceName())) {
            iName.set((Object)ann.interfaceName());
        }
        if (StringUtils.isNotBlank((CharSequence)ann.implementationPackage())) {
            builder.classPackage(ann.implementationPackage());
        }
        if (StringUtils.isNotBlank((CharSequence)ann.basePath())) {
            builder.basePath(ann.basePath());
        }
        builder.base(ann.base()).classGetters(ann.classGetters()).classSetters(ann.classSetters()).interfaceSetters(ann.interfaceSetters()).generateConstructor(ann.generateConstructor()).generateInterface(ann.generateInterface()).generateImplementation(ann.generateImplementation()).mixInClass(Objects.nonNull(ann.mixInClass()) && !Void.TYPE.equals(ann.mixInClass()) ? ann.mixInClass().getCanonicalName() : null).baseModifierClass(Objects.nonNull(ann.baseModifierClass()) && !Void.TYPE.equals(ann.baseModifierClass()) ? ann.baseModifierClass().getCanonicalName() : null).enrichers(CompiledPrototypesHandler.checkEnrichers(ann.enrichers())).inheritedEnrichers(CompiledPrototypesHandler.checkEnrichers(ann.inheritedEnrichers()));
        if (((String)cName).equals(iName.get())) {
            cName = (String)iName.get() + "Impl";
        }
        builder.className((String)cName).interfaceName((String)iName.get()).longModifierName((String)iName.get() + ".Modify");
        Structures.PrototypeDataHandler result = builder.build();
        if (Objects.isNull(result.getEnrichers())) {
            result.setEnrichers(new ArrayList<PrototypeEnricher>());
        }
        if (Objects.isNull(result.getInheritedEnrichers())) {
            result.setInheritedEnrichers(new ArrayList<PrototypeEnricher>());
        }
        CompiledPrototypesHandler.checkBaseClassForEnrichers(cls, result.getEnrichers());
        return result;
    }

    private static Structures.PrototypeDataHandler handleProperties(EnumDeclaration type, Class<?> cls, EnumPrototype ann) {
        Holder iName = Holder.of((Object)Helpers.defaultInterfaceName(type));
        Object cName = Helpers.defaultClassName(type);
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.builder(cls.getSimpleName()).classPackage(Helpers.defaultClassPackage(type)).interfacePackage(Helpers.defaultInterfacePackage(type));
        if (StringUtils.isNotBlank((CharSequence)ann.name())) {
            String intf = ann.name().replace("Entity", "");
            builder.name(ann.name()).className(ann.name()).interfaceName(intf).longModifierName(intf + ".Modify");
        }
        builder.mixInClass(Objects.nonNull(ann.mixIn()) && !Void.TYPE.equals(ann.mixIn()) ? ann.mixIn().getCanonicalName() : null);
        if (((String)cName).equals(iName.get())) {
            cName = (String)iName.get() + "Impl";
        }
        builder.className((String)cName).interfaceName((String)iName.get());
        return builder.build();
    }

    private static void checkBaseClassForEnrichers(Class<?> cls, List<PrototypeEnricher> list) {
        for (Class<?> intf : cls.getInterfaces()) {
            Tools.notNull(intf.getAnnotation(CodePrototype.class), ann -> CompiledPrototypesHandler.checkEnrichers(list, ann.inheritedEnrichers()));
            CompiledPrototypesHandler.checkBaseClassForEnrichers(intf, list);
        }
    }

    private static List<PrototypeEnricher> checkEnrichers(Class<? extends Enricher>[] enrichers) {
        ArrayList<PrototypeEnricher> list = new ArrayList<PrototypeEnricher>();
        CompiledPrototypesHandler.checkEnrichers(list, enrichers);
        return list;
    }

    private static List<PrototypeEnricher> checkEnrichers(List<PrototypeEnricher> list, Class<? extends Enricher>[] enrichers) {
        Arrays.stream(enrichers).map(CodeFactory::create).filter(Objects::nonNull).filter(i -> PrototypeEnricher.class.isAssignableFrom(i.getClass())).forEach(e -> Tools.with((PrototypeEnricher)e, enricher -> {
            enricher.init(Helpers.lookup);
            list.add((PrototypeEnricher)enricher);
        }));
        return list;
    }

    private static void handleFields(Class<?> c, ClassOrInterfaceDeclaration declaration) {
        CompilationUnit unit = (CompilationUnit)declaration.findCompilationUnit().get();
        for (Method method : c.getDeclaredMethods()) {
            if (method.isDefault() || method.getParameterCount() != 0 || Void.class.equals(method.getReturnType())) continue;
            MethodDeclaration mtd = ((MethodDeclaration)declaration.addMethod(method.getName(), new Modifier.Keyword[0]).setType(CompiledPrototypesHandler.buildType(unit, method.getGenericReturnType(), method.getReturnType()))).setBody(null);
            if (!method.getReturnType().isPrimitive()) {
                unit.addImport(method.getReturnType());
            }
            for (Annotation ann : method.getAnnotations()) {
                Method[] methods = ann.annotationType().getDeclaredMethods();
                Helpers.lookup.getParser().parseAnnotation(ann.toString()).getResult().ifPresent(annotation -> {
                    for (Method m : methods) {
                        if (!Objects.nonNull(m.getDefaultValue())) continue;
                        annotation.getChildNodes().stream().filter(MemberValuePair.class::isInstance).map(MemberValuePair.class::cast).filter(v -> v.getName().asString().equals(m.getName())).findFirst().ifPresent(pair -> {
                            if (m.getDefaultValue() instanceof Class && pair.getValue().toString().equals(((Class)m.getDefaultValue()).getName() + ".class")) {
                                annotation.remove((Node)pair);
                            } else if (m.getDefaultValue().getClass().equals(String.class) && m.getDefaultValue().toString().equals(pair.getValue().asStringLiteralExpr().asString())) {
                                annotation.remove((Node)pair);
                            } else if (m.getDefaultValue().toString().equals(pair.getValue().toString())) {
                                annotation.remove((Node)pair);
                            }
                        });
                    }
                    unit.addImport(ann.annotationType().getCanonicalName());
                    annotation.setName(ann.annotationType().getSimpleName());
                    CompiledPrototypesHandler.addAnnotationTypeImports(ann, unit);
                    mtd.addAnnotation(annotation);
                });
            }
        }
    }

    private static String buildType(CompilationUnit unit, Type type, Class<?> returnType) {
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            StringBuilder result = new StringBuilder(returnType.getSimpleName());
            Type[] generics = t.getActualTypeArguments();
            if (generics.length > 0) {
                result.append('<');
                for (Type generic : generics) {
                    if (generic instanceof Class) {
                        Class cls = (Class)generic;
                        result.append(cls.getSimpleName()).append(", ");
                        if (cls.isPrimitive()) continue;
                        unit.addImport(cls);
                        continue;
                    }
                    result.append(generic.getTypeName()).append(", ");
                }
                result.setLength(result.length() - 2);
                result.append('>');
            }
            return result.toString();
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getName();
        }
        return returnType.getSimpleName();
    }

    private static void handleAnnotations(Class<?> cls, ClassOrInterfaceDeclaration declaration) {
        CompilationUnit unit = (CompilationUnit)declaration.findCompilationUnit().get();
        for (Annotation ann : cls.getAnnotations()) {
            Helpers.lookup.getParser().parseAnnotation(ann.toString()).getResult().ifPresent(annotation -> {
                unit.addImport(ann.annotationType().getCanonicalName());
                annotation.setName(ann.annotationType().getSimpleName());
                CompiledPrototypesHandler.addAnnotationTypeImports(ann, unit);
                declaration.addAnnotation(annotation);
            });
        }
    }

    private static void handleMethodAnnotations(Method method, MethodDeclaration mtd) {
        CompilationUnit unit = (CompilationUnit)mtd.findCompilationUnit().get();
        for (Annotation ann : method.getAnnotations()) {
            if (ann.annotationType().equals(CodeAnnotation.class)) continue;
            Helpers.lookup.getParser().parseAnnotation(ann.toString()).getResult().ifPresent(annotation -> {
                unit.addImport(ann.annotationType().getCanonicalName());
                annotation.setName(ann.annotationType().getSimpleName());
                CompiledPrototypesHandler.addAnnotationTypeImports(ann, unit);
                mtd.addAnnotation(annotation);
            });
        }
    }

    private static void addAnnotationTypeImports(Annotation ann, CompilationUnit unit) {
        for (Method method : ann.annotationType().getDeclaredMethods()) {
            if ("java.lang".equals(method.getReturnType().getPackageName())) continue;
            try {
                Object result = method.invoke((Object)ann, new Object[0]);
                CompiledPrototypesHandler.handleAnnotationValue(result, unit);
            }
            catch (Exception e) {
                log.warn("Unable to access value for {}::{}", (Object)ann.annotationType().getSimpleName(), (Object)method.getName());
            }
        }
    }

    private static void handleAnnotationValue(Object value, CompilationUnit unit) {
        if (Objects.nonNull(value)) {
            String name = value.getClass().getCanonicalName();
            if (value instanceof Annotation) {
                CompiledPrototypesHandler.addAnnotationTypeImports((Annotation)value, unit);
            } else if (value.getClass().isEnum()) {
                unit.addImport(name + "." + ((Enum)value).name(), true, false);
            } else if (value.getClass().isArray()) {
                CompiledPrototypesHandler.handleAnnotationArray(value, unit);
                if (name.endsWith("[]")) {
                    name = name.substring(0, name.length() - 2);
                }
            }
            unit.addImport(name);
        }
    }

    private static void handleAnnotationArray(Object object, CompilationUnit unit) {
        for (int i = 0; i < Array.getLength(object); ++i) {
            CompiledPrototypesHandler.handleAnnotationValue(Array.get(object, i), unit);
        }
    }

    private static void handleDefaultMethods(Class<?> cls, ClassOrInterfaceDeclaration declaration) {
        CompilationUnit unit = (CompilationUnit)declaration.findCompilationUnit().get();
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.isDefault()) continue;
            CodeImplementation ann = method.getAnnotation(CodeImplementation.class);
            if (Objects.nonNull(ann)) {
                MethodDeclaration mtd = (MethodDeclaration)declaration.addMethod(method.getName(), new Modifier.Keyword[]{Modifier.Keyword.DEFAULT}).setType(method.getReturnType().getSimpleName());
                Helpers.importClass(unit, method.getReturnType());
                for (Parameter par : method.getParameters()) {
                    mtd.addParameter(par.getType().getSimpleName(), par.getName());
                    Helpers.importClass(unit, par.getType());
                }
                CompiledPrototypesHandler.handleMethodAnnotations(method, mtd);
                for (String imprt : ann.imports()) {
                    unit.addImport(imprt);
                }
                mtd.setBody((BlockStmt)Helpers.lookup.getParser().parseBlock(CompiledPrototypesHandler.calcBlock(ann.value())).getResult().get());
                continue;
            }
            if (!Arrays.stream(method.getAnnotations()).noneMatch(a -> Objects.nonNull(a.annotationType().getAnnotation(CodeAnnotation.class)))) continue;
            log.warn("Compiled default method {}.{} can't be handled!", (Object)cls.getSimpleName(), (Object)method.getName());
        }
        for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
            CompiledPrototypesHandler.handleDefaultMethods(genericDeclaration, declaration);
        }
    }

    private static String calcBlock(String value) {
        StringBuilder result = new StringBuilder().append('{').append(value);
        if (value.length() > 0 && result.charAt(result.length() - 1) != ';') {
            result.append(';');
        }
        result.append('}');
        return result.toString();
    }
}

