/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithStaticModifier;
import java.util.Objects;
import java.util.function.Predicate;
import net.binis.codegen.enrich.RegionEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;

public class RegionEnricherHandler
extends BaseEnricher
implements RegionEnricher {
    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public int order() {
        return -2147482648;
    }

    @Override
    public void postProcess(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        ClassOrInterfaceDeclaration intf = description.getIntf();
        Helpers.sortClass(intf);
        this.calcRegions(intf, m -> m instanceof MethodDeclaration && !m.asMethodDeclaration().isStatic());
        if (Objects.isNull(description.getProperties().getMixInClass())) {
            ClassOrInterfaceDeclaration spec = description.getSpec();
            Helpers.sortClass(spec);
            this.calcRegions(spec, m -> m instanceof FieldDeclaration && !m.asFieldDeclaration().isFinal() && !m.asFieldDeclaration().isStatic());
        }
    }

    private void calcRegions(ClassOrInterfaceDeclaration spec, Predicate<BodyDeclaration<?>> skipRegionFor) {
        BodyDeclaration region = null;
        String regionDesc = null;
        BodyDeclaration prv = null;
        boolean added = false;
        for (BodyDeclaration member : spec.getMembers()) {
            if (this.areDifferent(member, region)) {
                regionDesc = this.getDescription(member);
                if (!skipRegionFor.test(member)) {
                    member.setLineComment("region " + regionDesc);
                    added = true;
                }
                if (Objects.nonNull(region) && !skipRegionFor.test(prv)) {
                    prv.addOrphanComment((Comment)new LineComment("endregion"));
                }
                region = member;
            }
            prv = member;
        }
        if (Objects.nonNull(region) && added) {
            prv.addOrphanComment((Comment)new LineComment("endregion"));
        }
    }

    private boolean areDifferent(BodyDeclaration<?> member, BodyDeclaration<?> region) {
        if (Objects.isNull(region)) {
            return true;
        }
        if ((member instanceof ConstructorDeclaration || member instanceof InitializerDeclaration) && (region instanceof ConstructorDeclaration || region instanceof InitializerDeclaration)) {
            return false;
        }
        if (member instanceof NodeWithStaticModifier && region instanceof NodeWithStaticModifier && ((NodeWithStaticModifier)member).isStatic() != ((NodeWithStaticModifier)region).isStatic() && !member.isClassOrInterfaceDeclaration() && !region.isClassOrInterfaceDeclaration()) {
            return true;
        }
        if (member instanceof MethodDeclaration && region instanceof MethodDeclaration && member.asMethodDeclaration().getNameAsString().startsWith("set") && !region.asMethodDeclaration().getNameAsString().startsWith("set")) {
            return true;
        }
        if (member instanceof FieldDeclaration && region instanceof FieldDeclaration && (member.asFieldDeclaration().isFinal() && member.asFieldDeclaration().isStatic() && !region.asFieldDeclaration().isFinal() && !region.asFieldDeclaration().isStatic() || !member.asFieldDeclaration().isFinal() && !member.asFieldDeclaration().isStatic() && region.asFieldDeclaration().isFinal() && region.asFieldDeclaration().isStatic())) {
            return true;
        }
        return !member.getClass().equals(region.getClass());
    }

    private String getDescription(BodyDeclaration<?> member) {
        if (member instanceof FieldDeclaration) {
            if (member.asFieldDeclaration().isStatic() && member.asFieldDeclaration().isFinal()) {
                return "constants";
            }
            return "fields";
        }
        if (member instanceof InitializerDeclaration) {
            return "constructor & initializer";
        }
        if (member instanceof MethodDeclaration) {
            if (member.asMethodDeclaration().isStatic()) {
                return "starters";
            }
            if (member.asMethodDeclaration().getNameAsString().startsWith("set")) {
                return "setters";
            }
            return "getters";
        }
        if (member instanceof ClassOrInterfaceDeclaration) {
            return "inner classes";
        }
        return member.getClass().getSimpleName();
    }
}

