/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.type.Type;
import java.util.Objects;
import net.binis.codegen.enrich.JacksonEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.options.Options;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonEnricherHandler
extends BaseEnricher
implements JacksonEnricher {
    private static final Logger log = LoggerFactory.getLogger(JacksonEnricherHandler.class);
    private static final boolean IS_JACKSON_AVAILABLE = Objects.nonNull(Reflection.loadClass((String)"com.fasterxml.jackson.databind.annotation.JsonDeserialize"));

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        if (this.generate(description)) {
            ClassOrInterfaceDeclaration spec = description.getSpec();
            spec.findCompilationUnit().ifPresent(unit -> {
                unit.addImport("com.fasterxml.jackson.databind.annotation", false, true);
                description.getFields().forEach(f -> this.enrichField((CompilationUnit)unit, (PrototypeField)f));
            });
        }
    }

    @Override
    public int order() {
        return -2147473648;
    }

    private void enrichField(CompilationUnit unit, PrototypeField field) {
        if (field.isCollection() && !field.getTypePrototypes().isEmpty()) {
            NormalAnnotationExpr ann = field.getDeclaration().addAndGetAnnotation("JsonDeserialize");
            if ("java.util.Map".equals(field.getFullType())) {
                if (field.getDeclaration().getCommonType().isClassOrInterfaceType()) {
                    field.getDeclaration().getCommonType().asClassOrInterfaceType().getTypeArguments().ifPresent(args -> {
                        PrototypeDescription<ClassOrInterfaceDeclaration> content;
                        unit.addImport("java.util.HashMap");
                        ann.addPair("as", "HashMap.class");
                        PrototypeDescription<ClassOrInterfaceDeclaration> key = field.getTypePrototypes().get(((Type)args.get(0)).asString());
                        if (Objects.nonNull(key)) {
                            ann.addPair("keyAs", key.getInterfaceName() + ".class");
                        }
                        if (Objects.nonNull(content = field.getTypePrototypes().get(((Type)args.get(1)).asString()))) {
                            ann.addPair("contentAs", content.getInterfaceName() + ".class");
                        }
                    });
                }
            } else {
                PrototypeDescription<ClassOrInterfaceDeclaration> proto = field.getTypePrototypes().values().iterator().next();
                ann.addPair("contentAs", proto.getInterfaceName() + ".class");
            }
        }
    }

    private boolean generate(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        return description.hasOption(Options.HANDLE_JACKSON_ALWAYS) || IS_JACKSON_AVAILABLE && description.hasOption(Options.HANDLE_JACKSON_IF_AVAILABLE);
    }
}

