/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.utils.StringEscapeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.binis.codegen.annotation.validation.AliasFor;
import net.binis.codegen.annotation.validation.AsCode;
import net.binis.codegen.annotation.validation.Execute;
import net.binis.codegen.annotation.validation.Sanitize;
import net.binis.codegen.annotation.validation.Validate;
import net.binis.codegen.enrich.Enrichers;
import net.binis.codegen.enrich.ValidationEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.options.Options;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ValidationEnricherHandler
extends BaseEnricher
implements ValidationEnricher {
    private static final Logger log = LoggerFactory.getLogger(ValidationEnricherHandler.class);
    private static final String VALUE = "value";
    private static final String PARAMS = "params";
    private static final String MESSAGE = "message";
    private static final String MESSAGES = "messages";
    private static final String AS_CODE = "asCode";

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        StringBuilder form = new StringBuilder();
        description.getFields().forEach(f -> this.handleField(description, (PrototypeField)f, form));
        if (description.hasOption(Options.VALIDATION_FORM)) {
            this.buildValidationForm(description, form);
        }
    }

    @Override
    public int order() {
        return 0;
    }

    private void handleField(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, StringBuilder code) {
        MethodDeclaration form = description.hasOption(Options.VALIDATION_FORM) ? this.formMethod(field) : null;
        field.getDescription().getAnnotations().stream().filter(this::isValidationAnnotation).forEach(a -> this.processAnnotation(description, field, (AnnotationExpr)a, form));
        if (Objects.nonNull(form)) {
            boolean isChild = this.hasChildren(field);
            String exp = ((BlockStmt)form.getBody().get()).getStatement(0).toString();
            if (exp.length() > field.getName().length() + 5) {
                code.append("e -> ").append(exp.replace(".start(", ".start(e, "));
                code.setLength(code.length() - 1);
                if (isChild) {
                    code.insert(code.lastIndexOf(".perform("), ".child()");
                }
                code.append(",\n");
            } else if (isChild) {
                code.append("e -> Validation.start(e, this.getClass(), \"").append(field.getName()).append("\", ").append(field.getName()).append(").child(),\n");
            }
        }
    }

    private boolean hasChildren(PrototypeField field) {
        boolean result = this.hasForm(field.getPrototype());
        if (!result && !CollectionUtils.isEmpty(field.getTypePrototypes())) {
            result = field.getTypePrototypes().values().stream().anyMatch(this::hasForm);
        }
        return result;
    }

    private boolean hasForm(PrototypeDescription<?> desc) {
        return Objects.nonNull(desc) && desc.hasEnricher(Enrichers.VALIDATION) && desc.hasOption(Options.VALIDATION_FORM);
    }

    private void processAnnotation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, MethodDeclaration form) {
        String name = Helpers.getExternalClassNameIfExists((CompilationUnit)annotation.findCompilationUnit().get(), annotation.getNameAsString());
        Class cls = Reflection.loadClass((String)name);
        if (Objects.nonNull(cls)) {
            if (Validate.class.equals((Object)cls) || cls.isAnnotationPresent(Validate.class)) {
                this.generateValidation(description, field, annotation, cls, form);
            } else if (Sanitize.class.equals((Object)cls) || cls.isAnnotationPresent(Sanitize.class)) {
                this.generateSanitization(description, field, annotation, cls, form);
            } else if (Execute.class.equals((Object)cls) || cls.isAnnotationPresent(Execute.class)) {
                this.generateExecution(description, field, annotation, cls);
            }
        } else {
            Tools.notNull(this.lookup.findExternal(name), d -> this.handleAnnotationFromSource(description, d.getDeclaration().asAnnotationDeclaration(), field, annotation, form));
        }
    }

    private void handleAnnotationFromSource(PrototypeDescription<ClassOrInterfaceDeclaration> description, AnnotationDeclaration decl, PrototypeField field, AnnotationExpr annotation, MethodDeclaration form) {
        Optional ann = decl.getAnnotationByClass(Validate.class);
        if (ann.isPresent()) {
            this.generateValidation(description, field, annotation, (AnnotationExpr)ann.get(), decl, form);
        } else {
            ann = decl.getAnnotationByClass(Sanitize.class);
            if (ann.isPresent()) {
                this.generateSanitization(description, field, annotation, (AnnotationExpr)ann.get(), decl, form);
            } else {
                ann = decl.getAnnotationByClass(Execute.class);
                if (ann.isPresent()) {
                    this.generateExecution(description, field, annotation, (AnnotationExpr)ann.get(), decl);
                }
            }
        }
    }

    private void generateSanitization(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass, MethodDeclaration form) {
        Params params = this.getSanitizationParams(field, annotation, ann, annotationClass);
        field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(Helpers.getExternalClassName((CompilationUnit)annotationClass.findCompilationUnit().get(), params.getCls())));
        this.generateSanitization(description, field, params, form);
    }

    private void generateSanitization(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass, MethodDeclaration form) {
        this.generateSanitization(description, field, this.getSanitizationParams(field, annotation, annotationClass), form);
    }

    private void generateSanitization(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, Params params, MethodDeclaration form) {
        if (Objects.nonNull(field.getImplementationSetter())) {
            this.addSanitization(field, field.getImplementationSetter(), params, ModifierType.MAIN);
        }
        field.getModifiers().forEach(modifier -> this.addSanitization(field, (MethodDeclaration)modifier, params, ModifierType.MODIFIER));
        if (description.hasOption(Options.VALIDATION_FORM)) {
            this.addSanitization(field, form, params, ModifierType.FORM);
        }
    }

    private Params getSanitizationParams(PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        this.handleSanitizationAnnotation(ann, params);
        return params.build();
    }

    private Params getSanitizationParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        String cls = null;
        Params.ParamsBuilder params = Params.builder();
        if (!Sanitize.class.equals(annotationClass)) {
            Sanitize ann = annotationClass.getDeclaredAnnotation(Sanitize.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params()));
            cls = ann.value().getCanonicalName();
            ((CompilationUnit)field.getDeclaration().findCompilationUnit().get()).addImport(cls);
            this.handleAliases(annotation, annotationClass, params);
        } else {
            this.handleSanitizationAnnotation(annotation, params);
        }
        Params result = params.build();
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass(Objects.isNull(cls) ? Helpers.getExternalClassName((CompilationUnit)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    private void handleSanitizationAnnotation(AnnotationExpr annotation, Params.ParamsBuilder params) {
        for (Node node : annotation.getChildNodes()) {
            if (node instanceof ClassExpr) {
                params.cls(((ClassExpr)node).getTypeAsString());
                continue;
            }
            if (!(node instanceof MemberValuePair)) continue;
            MemberValuePair pair = (MemberValuePair)node;
            switch (pair.getNameAsString()) {
                case "value": {
                    params.cls(pair.getValue().asClassExpr().getTypeAsString());
                    break;
                }
                case "params": {
                    params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                    break;
                }
                case "asCode": {
                    params.asCode(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
            }
        }
    }

    private Params getValidationParams(PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        this.handleValidationAnnotation(ann, params);
        return params.build();
    }

    private Params getValidationParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        String cls = null;
        if (!Validate.class.equals(annotationClass)) {
            Validate ann = annotationClass.getDeclaredAnnotation(Validate.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params())).message(ann.message());
            cls = ann.value().getCanonicalName();
            ((CompilationUnit)field.getDeclaration().findCompilationUnit().get()).addImport(cls);
            this.handleAliases(annotation, annotationClass, params);
        } else {
            this.handleValidationAnnotation(annotation, params);
        }
        Params result = params.build();
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass(Objects.isNull(cls) ? Helpers.getExternalClassName((CompilationUnit)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    private void handleValidationAnnotation(AnnotationExpr annotation, Params.ParamsBuilder params) {
        for (Node node : annotation.getChildNodes()) {
            if (node instanceof ClassExpr) {
                params.cls(((ClassExpr)node).getTypeAsString());
                continue;
            }
            if (!(node instanceof MemberValuePair)) continue;
            MemberValuePair pair = (MemberValuePair)node;
            switch (pair.getNameAsString()) {
                case "value": {
                    params.cls(pair.getValue().asClassExpr().getTypeAsString());
                    break;
                }
                case "message": {
                    params.message(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
                case "messages": {
                    params.messages(pair.getValue().asArrayInitializerExpr().getValues().stream().map(e -> e.asStringLiteralExpr().asString()).collect(Collectors.toList()));
                    break;
                }
                case "params": {
                    if (pair.getValue().isArrayInitializerExpr()) {
                        params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                        break;
                    }
                    params.params(List.of(pair.getValue()));
                    break;
                }
                case "asCode": {
                    params.asCode(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
            }
        }
    }

    private void handleAliases(AnnotationExpr annotation, Class<?> annotationClass, Params.ParamsBuilder params) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<ParamHolder> parOrder = Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).filter(a -> a.annotationType().isAssignableFrom(AliasFor.class)).map(AliasFor.class::cast).anyMatch(a -> PARAMS.equals(a.value()))).map(m -> ParamHolder.builder().name(m.getName()).value(m.getDefaultValue()).annotation(m.getDeclaredAnnotation(AsCode.class)).order(m.getDeclaredAnnotation(AliasFor.class).order()).build()).collect(Collectors.toList());
        parOrder.sort(Comparator.comparing(ParamHolder::getOrder));
        Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> MESSAGE.equals(m.getName())).filter(m -> m.getReturnType().equals(String.class)).filter(m -> Objects.isNull(m.getDeclaredAnnotation(AliasFor.class))).findFirst().ifPresent(m -> params.message((String)m.getDefaultValue()));
        Holder messages = Holder.blank();
        Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> MESSAGES.equals(m.getName())).filter(m -> m.getReturnType().equals(String[].class)).filter(m -> Objects.isNull(m.getDeclaredAnnotation(AliasFor.class))).findFirst().ifPresent(m -> messages.set(List.of((String[])m.getDefaultValue())));
        if (messages.isEmpty()) {
            Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getReturnType().equals(String.class)).filter(m -> Tools.nullCheck(m.getDeclaredAnnotation(AliasFor.class), a -> MESSAGES.equals(a.value()), false)).forEach(m -> {
                int order = m.getDeclaredAnnotation(AliasFor.class).order();
                if (messages.isEmpty()) {
                    messages.set(new ArrayList());
                }
                String value = Objects.nonNull(m.getDefaultValue()) ? m.getDefaultValue().toString() : "(%s) Invalid value!";
                List msgs = (List)messages.get();
                for (int i = msgs.size(); i <= order; ++i) {
                    msgs.add(null);
                }
                msgs.set(order, value);
            });
        }
        parOrder.forEach(p -> list.add(this.checkAsCode(p.getValue(), p.getAnnotation())));
        int msgs = 0;
        for (Node node : annotation.getChildNodes()) {
            ParamHolder triple;
            if (node instanceof MemberValuePair) {
                MemberValuePair pair = (MemberValuePair)node;
                switch (Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getName().equals(pair.getNameAsString())).map(m -> m.getDeclaredAnnotation(AliasFor.class)).filter(Objects::nonNull).map(AliasFor::value).findFirst().orElseGet(() -> ((MemberValuePair)pair).getNameAsString())) {
                    case "value": {
                        params.cls(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                    case "message": {
                        params.message(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "messages": {
                        if (pair.getValue().isArrayInitializerExpr()) {
                            params.messages(pair.getValue().asArrayInitializerExpr().getValues().stream().map(e -> e.asStringLiteralExpr().asString()).collect(Collectors.toList()));
                            break;
                        }
                        if (!pair.getValue().isStringLiteralExpr()) break;
                        String msg = pair.getValue().asStringLiteralExpr().asString();
                        if (messages.isEmpty()) {
                            messages.set(new ArrayList());
                        }
                        if (msgs < ((List)messages.get()).size()) {
                            ((List)messages.get()).set(msgs, msg);
                        } else {
                            ((List)messages.get()).add(msg);
                        }
                        ++msgs;
                        break;
                    }
                    case "asCode": {
                        params.asCode(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "params": {
                        if (pair.getValue().isArrayInitializerExpr()) {
                            list.addAll(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                            break;
                        }
                        int idx = this.getParamIndex(parOrder, pair.getNameAsString());
                        if (idx != -1) {
                            triple = parOrder.get(idx);
                            list.set(idx, this.checkAsCode(this.getParamValue(pair.getValue()), triple.getAnnotation()));
                            break;
                        }
                        throw new GenericCodeGenException("Invalid annotation params! " + annotation);
                    }
                }
                continue;
            }
            if (!(node instanceof LiteralExpr)) continue;
            Object exp = this.getParamValue((Expression)((LiteralExpr)node));
            switch (Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getName().equals(VALUE)).map(m -> m.getDeclaredAnnotation(AliasFor.class)).filter(Objects::nonNull).map(AliasFor::value).findFirst().orElse(VALUE)) {
                case "value": {
                    params.cls(exp.toString());
                    break;
                }
                case "message": {
                    params.message(exp.toString());
                    break;
                }
                case "asCode": {
                    params.asCode(exp.toString());
                    break;
                }
                case "params": {
                    int idx = this.getParamIndex(parOrder, VALUE);
                    if (idx != -1) {
                        triple = parOrder.get(idx);
                        if (Objects.nonNull(triple.getAnnotation())) {
                            list.set(idx, this.checkAsCode(exp, triple.getAnnotation()));
                            break;
                        }
                        list.set(idx, exp);
                        break;
                    }
                    throw new GenericCodeGenException("Invalid annotation params! " + annotation);
                }
            }
        }
        if (!list.isEmpty()) {
            params.params(list);
        }
        params.messages = (List)messages.get();
    }

    private Object checkAsCode(Object value, AsCode code) {
        if (Objects.nonNull(code)) {
            return AsCodeHolder.builder().value((String)value).format(code.value()).build();
        }
        return value;
    }

    private Object getParamValue(Expression value) {
        if (value.isStringLiteralExpr()) {
            return value.asStringLiteralExpr().asString();
        }
        if (value.isIntegerLiteralExpr()) {
            return value.asIntegerLiteralExpr().asNumber();
        }
        if (value.isDoubleLiteralExpr()) {
            return value.asDoubleLiteralExpr().asDouble();
        }
        if (value.isBooleanLiteralExpr()) {
            return value.asBooleanLiteralExpr().getValue();
        }
        return null;
    }

    private int getParamIndex(List<ParamHolder> list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(list.get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    private void generateValidation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass, MethodDeclaration form) {
        Params params = this.getValidationParams(field, annotation, ann, annotationClass);
        field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(Helpers.getExternalClassName((CompilationUnit)annotationClass.findCompilationUnit().get(), params.getCls())));
        this.generateValidation(description, field, params, form);
    }

    private void generateValidation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass, MethodDeclaration form) {
        this.generateValidation(description, field, this.getValidationParams(field, annotation, annotationClass), form);
    }

    private void generateValidation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, Params params, MethodDeclaration form) {
        if (Objects.nonNull(field.getImplementationSetter())) {
            this.addValidation(field, field.getImplementationSetter(), params, ModifierType.MAIN);
        }
        field.getModifiers().forEach(modifier -> this.addValidation(field, (MethodDeclaration)modifier, params, ModifierType.MODIFIER));
        if (description.hasOption(Options.VALIDATION_FORM)) {
            this.addValidation(field, form, params, ModifierType.FORM);
        }
    }

    private void addValidation(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier) {
        method.findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.flow.Validation"));
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        if (((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression() instanceof AssignExpr) {
            StringBuilder exp = new StringBuilder("Validation.start(this.getClass(), \"").append(field.getName()).append("\", ").append(field.getName()).append(").validate").append(Objects.nonNull(params.getMessages()) ? "WithMessages(" : "(").append(params.getCls()).append(".class, ").append(this.calcMessage(params)).append(this.buildParamsStr(params, field, modifier)).append(").perform(v -> this.map = v);");
            Statement expr = (Statement)this.lookup.getParser().parseStatement(exp.toString()).getResult().get();
            Statement original = (Statement)block.getStatements().remove(0);
            ((ExpressionStmt)original).getExpression().asAssignExpr().setValue((Expression)new NameExpr("v"));
            MethodCallExpr mCall = expr.asExpressionStmt().getExpression().asMethodCallExpr();
            ((LambdaExpr)mCall.getChildNodes().get(mCall.getChildNodes().size() - 1)).setBody(original);
            block.getStatements().add(0, (Node)expr);
        } else {
            MethodCallExpr mCall = ((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression().asMethodCallExpr();
            Expression chain = (Expression)mCall.getScope().get();
            mCall.removeScope();
            MethodCallExpr m = (MethodCallExpr)((MethodCallExpr)new MethodCallExpr(chain, "validate" + (Objects.nonNull(params.getMessages()) ? "WithMessages" : "")).addArgument(params.getCls() + ".class")).addArgument(this.calcMessage(params));
            Tools.notNull(params.getParams(), p -> p.forEach(param -> m.addArgument(this.buildParamsStr(param, params, field))));
            mCall.setScope((Expression)m);
        }
    }

    private String calcMessage(Params params) {
        if (Objects.nonNull(params.getMessages())) {
            return "new String[] {" + params.messages.stream().map(s -> "\"" + StringEscapeUtils.escapeJava((String)s) + "\"").collect(Collectors.joining(", ")) + "}";
        }
        return Objects.isNull(params.getMessage()) ? "null" : "\"" + StringEscapeUtils.escapeJava((String)params.getMessage()) + "\"";
    }

    private void addSanitization(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier) {
        method.findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.flow.Validation"));
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        if (((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression() instanceof AssignExpr) {
            StringBuilder exp = new StringBuilder("Validation.start(this.getClass(), \"").append(field.getName()).append("\", ").append(field.getName()).append(").sanitize(").append(params.getCls()).append(".class").append(this.buildParamsStr(params, field, modifier)).append(").perform(v -> this.map = v);");
            Statement expr = (Statement)this.lookup.getParser().parseStatement(exp.toString()).getResult().get();
            Statement original = (Statement)block.getStatements().remove(0);
            ((ExpressionStmt)original).getExpression().asAssignExpr().setValue((Expression)new NameExpr("v"));
            MethodCallExpr mCall = expr.asExpressionStmt().getExpression().asMethodCallExpr();
            ((LambdaExpr)mCall.getChildNodes().get(mCall.getChildNodes().size() - 1)).setBody(original);
            block.getStatements().add(0, (Node)expr);
        } else {
            MethodCallExpr mCall = ((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression().asMethodCallExpr();
            Expression chain = (Expression)mCall.getScope().get();
            mCall.removeScope();
            MethodCallExpr m = (MethodCallExpr)new MethodCallExpr(chain, "sanitize").addArgument(params.getCls() + ".class");
            Tools.notNull(params.getParams(), p -> p.forEach(param -> m.addArgument(this.buildParamsStr(param, params, field))));
            mCall.setScope((Expression)m);
        }
    }

    private void generateExecution(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass) {
        Params params = this.getExecutionParams(field, annotation, ann, annotationClass);
        field.getDeclaration().findCompilationUnit().ifPresent(u -> u.addImport(Helpers.getExternalClassName((CompilationUnit)annotationClass.findCompilationUnit().get(), params.getCls())));
        this.generateExecution(description, field, params);
    }

    private void generateExecution(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        this.generateExecution(description, field, this.getExecutionParams(field, annotation, annotationClass));
    }

    private void generateExecution(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, Params params) {
        if (Objects.nonNull(field.getImplementationSetter())) {
            this.addExecution(field, field.getImplementationSetter(), params, ModifierType.MAIN);
        }
        field.getModifiers().forEach(modifier -> this.addExecution(field, (MethodDeclaration)modifier, params, ModifierType.MODIFIER));
    }

    private void addExecution(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier) {
        ((CompilationUnit)method.findCompilationUnit().get()).addImport("net.binis.codegen.validation.flow.Validation");
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        if (((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression() instanceof AssignExpr) {
            StringBuilder exp = new StringBuilder("Validation.start(this.getClass(), \"").append(field.getName()).append("\", ").append(field.getName()).append(").execute(").append(params.getCls()).append(".class, ").append(this.calcMessage(params)).append(this.buildParamsStr(params, field, modifier)).append(").perform(v -> this.map = v);");
            Statement expr = (Statement)this.lookup.getParser().parseStatement(exp.toString()).getResult().get();
            Statement original = (Statement)block.getStatements().remove(0);
            ((ExpressionStmt)original).getExpression().asAssignExpr().setValue((Expression)new NameExpr("v"));
            MethodCallExpr mCall = expr.asExpressionStmt().getExpression().asMethodCallExpr();
            ((LambdaExpr)mCall.getChildNodes().get(mCall.getChildNodes().size() - 1)).setBody(original);
            block.getStatements().add(0, (Node)expr);
        } else {
            MethodCallExpr mCall = ((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression().asMethodCallExpr();
            Expression chain = (Expression)mCall.getScope().get();
            mCall.removeScope();
            MethodCallExpr m = (MethodCallExpr)((MethodCallExpr)new MethodCallExpr(chain, "execute").addArgument(params.getCls() + ".class")).addArgument(this.calcMessage(params));
            Tools.notNull(params.getParams(), p -> p.forEach(param -> m.addArgument(this.buildParamsStr(param, params, field))));
            mCall.setScope((Expression)m);
        }
    }

    private Params getExecutionParams(PrototypeField field, AnnotationExpr annotation, AnnotationExpr ann, AnnotationDeclaration annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        this.handleExecutionAnnotation(ann, params);
        return params.build();
    }

    private Params getExecutionParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        String cls = null;
        if (!Execute.class.equals(annotationClass)) {
            Execute ann = annotationClass.getDeclaredAnnotation(Execute.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params()));
            cls = ann.value().getCanonicalName();
            ((CompilationUnit)field.getDeclaration().findCompilationUnit().get()).addImport(cls);
            this.handleAliases(annotation, annotationClass, params);
        } else {
            this.handleExecutionAnnotation(annotation, params);
        }
        Params result = params.build();
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass(Objects.isNull(cls) ? Helpers.getExternalClassName((CompilationUnit)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    private void handleExecutionAnnotation(AnnotationExpr annotation, Params.ParamsBuilder params) {
        for (Node node : annotation.getChildNodes()) {
            if (node instanceof ClassExpr) {
                params.cls(((ClassExpr)node).getTypeAsString());
                continue;
            }
            if (!(node instanceof MemberValuePair)) continue;
            MemberValuePair pair = (MemberValuePair)node;
            switch (pair.getNameAsString()) {
                case "value": {
                    params.cls(pair.getValue().asClassExpr().getTypeAsString());
                    break;
                }
                case "message": {
                    params.message(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
                case "params": {
                    params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                    break;
                }
                case "asCode": {
                    params.asCode(pair.getValue().asStringLiteralExpr().asString());
                    break;
                }
            }
        }
    }

    private String buildParamsStr(Params params, PrototypeField field, ModifierType modifier) {
        List<Object> list = params.getParams();
        if (Objects.isNull(list) || list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (Objects.nonNull(params.getAsCode()) && list.size() == 1 && list.get(0) instanceof String) {
            this.formatCode(field, modifier, result, (String)list.get(0), params.getAsCode());
        } else {
            for (Object param : list) {
                if (param instanceof String) {
                    result.append(", \"").append(StringEscapeUtils.escapeJava((String)((String)param))).append("\"");
                    continue;
                }
                if (param instanceof AsCodeHolder) {
                    AsCodeHolder holder = (AsCodeHolder)param;
                    String format = "%s".equals(holder.getFormat()) && !StringUtils.isBlank((CharSequence)params.getAsCode()) ? params.getAsCode() : holder.getFormat();
                    this.formatCode(field, modifier, result, holder.getValue(), format);
                    continue;
                }
                result.append(", ").append(Objects.nonNull(param) ? param.toString() : "null");
            }
        }
        return result.toString();
    }

    private void formatCode(PrototypeField field, ModifierType modifier, StringBuilder result, String value, String format) {
        result.append(", ").append(String.format(format.replaceAll("\\{type}", field.getDeclaration().getVariable(0).getTypeAsString()), value.replaceAll("\\{type}", field.getDeclaration().getVariable(0).getTypeAsString()).replaceAll("\\{entity}", (String)(ModifierType.MODIFIER.equals((Object)modifier) ? "(" + ((ClassOrInterfaceDeclaration)field.getDeclaration().findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).get()).getNameAsString() + ")" : "") + modifier.getValue())));
    }

    private String buildParamsStr(Object param, Params params, PrototypeField field) {
        if (param instanceof String) {
            return "\"" + StringEscapeUtils.escapeJava((String)((String)param)) + "\"";
        }
        if (param instanceof AsCodeHolder) {
            AsCodeHolder holder = (AsCodeHolder)param;
            String format = "%s".equals(holder.getFormat()) && !StringUtils.isBlank((CharSequence)params.getAsCode()) ? params.getAsCode() : holder.getFormat();
            return String.format(format.replaceAll("\\{type}", field.getDeclaration().getVariable(0).getTypeAsString()), holder.getValue());
        }
        return Objects.nonNull(param) ? param.toString() : "null";
    }

    private boolean isValidationAnnotation(AnnotationExpr annotation) {
        String name = Helpers.getExternalClassNameIfExists((CompilationUnit)annotation.findCompilationUnit().get(), annotation.getNameAsString());
        PrototypeDescription<ClassOrInterfaceDeclaration> external = this.lookup.findExternal(name);
        if (Objects.nonNull(external)) {
            return Tools.withRes(external.getDeclaration(), decl -> decl.isAnnotationPresent(Validate.class) || decl.isAnnotationPresent(Sanitize.class) || decl.isAnnotationPresent(Execute.class));
        }
        return Tools.withRes(Reflection.loadClass((String)name), cls -> Validate.class.equals(cls) || cls.isAnnotationPresent(Validate.class) || Sanitize.class.equals(cls) || cls.isAnnotationPresent(Sanitize.class) || Execute.class.equals(cls) || cls.isAnnotationPresent(Execute.class), false);
    }

    private void buildValidationForm(PrototypeDescription<ClassOrInterfaceDeclaration> description, StringBuilder form) {
        if (form.length() > 0) {
            form.setLength(form.lastIndexOf(","));
            form.append("); }");
            if (description.hasOption(Options.EXPOSE_VALIDATE_METHOD)) {
                description.getIntf().addExtendedType("Validatable");
                description.getIntf().findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.Validatable"));
            } else {
                description.getSpec().addImplementedType("Validatable");
                description.getSpec().findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.Validatable"));
            }
            description.getSpec().findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.validation.flow.Validation"));
            description.getSpec().addMethod("validate", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setBody((BlockStmt)description.getParser().parseBlock("{ Validation.form(this.getClass(), " + form).getResult().get());
        }
    }

    private MethodDeclaration formMethod(PrototypeField field) {
        MethodDeclaration result = new MethodDeclaration();
        result.setBody((BlockStmt)this.lookup.getParser().parseBlock("{ " + field.getName() + " = v; }").getResult().get());
        return result;
    }

    private static class Params {
        private String cls;
        private String message;
        private List<String> messages;
        private List<Object> params;
        private String asCode;

        Params(String cls, String message, List<String> messages, List<Object> params, String asCode) {
            this.cls = cls;
            this.message = message;
            this.messages = messages;
            this.params = params;
            this.asCode = asCode;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public String getCls() {
            return this.cls;
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public String getAsCode() {
            return this.asCode;
        }

        public void setCls(String cls) {
            this.cls = cls;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setMessages(List<String> messages) {
            this.messages = messages;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }

        public void setAsCode(String asCode) {
            this.asCode = asCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Params)) {
                return false;
            }
            Params other = (Params)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cls = this.getCls();
            String other$cls = other.getCls();
            if (this$cls == null ? other$cls != null : !this$cls.equals(other$cls)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            List<String> this$messages = this.getMessages();
            List<String> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            List<Object> this$params = this.getParams();
            List<Object> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            String this$asCode = this.getAsCode();
            String other$asCode = other.getAsCode();
            return !(this$asCode == null ? other$asCode != null : !this$asCode.equals(other$asCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Params;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cls = this.getCls();
            result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            List<String> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            List<Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            String $asCode = this.getAsCode();
            result = result * 59 + ($asCode == null ? 43 : $asCode.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.Params(cls=" + this.getCls() + ", message=" + this.getMessage() + ", messages=" + this.getMessages() + ", params=" + this.getParams() + ", asCode=" + this.getAsCode() + ")";
        }

        public static class ParamsBuilder {
            private String cls;
            private String message;
            private List<String> messages;
            private List<Object> params;
            private String asCode;

            ParamsBuilder() {
            }

            public ParamsBuilder cls(String cls) {
                this.cls = cls;
                return this;
            }

            public ParamsBuilder message(String message) {
                this.message = message;
                return this;
            }

            public ParamsBuilder messages(List<String> messages) {
                this.messages = messages;
                return this;
            }

            public ParamsBuilder params(List<Object> params) {
                this.params = params;
                return this;
            }

            public ParamsBuilder asCode(String asCode) {
                this.asCode = asCode;
                return this;
            }

            public Params build() {
                return new Params(this.cls, this.message, this.messages, this.params, this.asCode);
            }

            public String toString() {
                return "ValidationEnricherHandler.Params.ParamsBuilder(cls=" + this.cls + ", message=" + this.message + ", messages=" + this.messages + ", params=" + this.params + ", asCode=" + this.asCode + ")";
            }
        }
    }

    private static enum ModifierType {
        MAIN("this"),
        MODIFIER("parent"),
        FORM(null);

        private final String value;

        private ModifierType(String s) {
            this.value = s;
        }

        String getValue() {
            return this.value;
        }
    }

    private static class ParamHolder {
        private String name;
        private Object value;
        private AsCode annotation;
        private int order;

        ParamHolder(String name, Object value, AsCode annotation, int order) {
            this.name = name;
            this.value = value;
            this.annotation = annotation;
            this.order = order;
        }

        public static ParamHolderBuilder builder() {
            return new ParamHolderBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public AsCode getAnnotation() {
            return this.annotation;
        }

        public int getOrder() {
            return this.order;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setAnnotation(AsCode annotation) {
            this.annotation = annotation;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamHolder)) {
                return false;
            }
            ParamHolder other = (ParamHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            AsCode this$annotation = this.getAnnotation();
            AsCode other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParamHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOrder();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            AsCode $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.ParamHolder(name=" + this.getName() + ", value=" + this.getValue() + ", annotation=" + this.getAnnotation() + ", order=" + this.getOrder() + ")";
        }

        public static class ParamHolderBuilder {
            private String name;
            private Object value;
            private AsCode annotation;
            private int order;

            ParamHolderBuilder() {
            }

            public ParamHolderBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ParamHolderBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public ParamHolderBuilder annotation(AsCode annotation) {
                this.annotation = annotation;
                return this;
            }

            public ParamHolderBuilder order(int order) {
                this.order = order;
                return this;
            }

            public ParamHolder build() {
                return new ParamHolder(this.name, this.value, this.annotation, this.order);
            }

            public String toString() {
                return "ValidationEnricherHandler.ParamHolder.ParamHolderBuilder(name=" + this.name + ", value=" + this.value + ", annotation=" + this.annotation + ", order=" + this.order + ")";
            }
        }
    }

    private static class AsCodeHolder {
        private String value;
        private String format;

        AsCodeHolder(String value, String format) {
            this.value = value;
            this.format = format;
        }

        public static AsCodeHolderBuilder builder() {
            return new AsCodeHolderBuilder();
        }

        public String getValue() {
            return this.value;
        }

        public String getFormat() {
            return this.format;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsCodeHolder)) {
                return false;
            }
            AsCodeHolder other = (AsCodeHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsCodeHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.AsCodeHolder(value=" + this.getValue() + ", format=" + this.getFormat() + ")";
        }

        public static class AsCodeHolderBuilder {
            private String value;
            private String format;

            AsCodeHolderBuilder() {
            }

            public AsCodeHolderBuilder value(String value) {
                this.value = value;
                return this;
            }

            public AsCodeHolderBuilder format(String format) {
                this.format = format;
                return this;
            }

            public AsCodeHolder build() {
                return new AsCodeHolder(this.value, this.format);
            }

            public String toString() {
                return "ValidationEnricherHandler.AsCodeHolder.AsCodeHolderBuilder(value=" + this.value + ", format=" + this.format + ")";
            }
        }
    }
}

