/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.TypeParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.annotation.Ignore;
import net.binis.codegen.enrich.Enricher;
import net.binis.codegen.enrich.PrototypeEnricher;
import net.binis.codegen.enrich.PrototypeLookup;
import net.binis.codegen.enrich.handler.AsEnricherHandler;
import net.binis.codegen.enrich.handler.CloneEnricherHandler;
import net.binis.codegen.enrich.handler.CreatorEnricherHandler;
import net.binis.codegen.enrich.handler.CreatorModifierEnricherHandler;
import net.binis.codegen.enrich.handler.FluentEnricherHandler;
import net.binis.codegen.enrich.handler.JacksonEnricherHandler;
import net.binis.codegen.enrich.handler.ModifierEnricherHandler;
import net.binis.codegen.enrich.handler.OpenApiEnricherHandler;
import net.binis.codegen.enrich.handler.QueryEnricherHandler;
import net.binis.codegen.enrich.handler.RegionEnricherHandler;
import net.binis.codegen.enrich.handler.ValidationEnricherHandler;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.PrototypeLookupHandler;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helpers {
    private static final Logger log = LoggerFactory.getLogger(Helpers.class);
    public static final Set<String> knownClassAnnotations = Set.of("javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany");
    public static final Map<String, String> knownTypes = Map.of("CodeList", "net.binis.codegen.collection.CodeList", "CodeListImpl", "net.binis.codegen.collection.CodeListImpl", "EmbeddedCodeListImpl", "net.binis.codegen.collection.EmbeddedCodeListImpl", "EmbeddedCodeSetImpl", "net.binis.codegen.collection.EmbeddedCodeSetImpl");
    public static final Set<String> reserved = Set.of("ensure", "reference", "get", "list", "references", "count", "top", "page", "tuple", "tuples", "prepare", "projection", "flush", "lock", "hint", "filter", "exists", "delete", "remove");
    public static final Set<String> primitiveTypes = Set.of("byte", "short", "int", "long", "float", "double", "boolean", "char", "void");
    public static final PrototypeLookup lookup = new PrototypeLookupHandler();
    public static final Map<String, PrototypeDescription<EnumDeclaration>> enumParsed = new HashMap<String, PrototypeDescription<EnumDeclaration>>();
    public static final Map<String, PrototypeDescription<EnumDeclaration>> enumGenerated = new HashMap<String, PrototypeDescription<EnumDeclaration>>();
    public static final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> constantParsed = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    public static final Map<String, List<Pair<String, String>>> declaredConstants = new HashMap<String, List<Pair<String, String>>>();
    public static final Map<String, Structures.ProcessingType> processingTypes = new HashMap<String, Structures.ProcessingType>();
    public static final List<Triple<PrototypeDescription<ClassOrInterfaceDeclaration>, CompilationUnit, ClassExpr>> recursiveExpr = new LinkedList<Triple<PrototypeDescription<ClassOrInterfaceDeclaration>, CompilationUnit, ClassExpr>>();

    public static String defaultPackage(TypeDeclaration<?> type, String name) {
        String result = ((PackageDeclaration)((CompilationUnit)type.findCompilationUnit().get()).getPackageDeclaration().get()).getNameAsString();
        if (Objects.nonNull(name)) {
            return result.replace("prototype", name);
        }
        if (result.endsWith(".prototype")) {
            return result.replace(".prototype", "");
        }
        return result.replace(".prototype.", ".");
    }

    public static String defaultInterfacePackage(ClassOrInterfaceDeclaration type) {
        return Helpers.defaultPackage(type, null);
    }

    public static String defaultClassPackage(ClassOrInterfaceDeclaration type) {
        return Helpers.defaultPackage(type, null);
    }

    public static String defaultInterfaceName(String type) {
        return Helpers.defaultClassName(type).replace("Entity", "");
    }

    public static String defaultInterfaceName(ClassOrInterfaceDeclaration type) {
        return Helpers.defaultClassName(type).replace("Entity", "");
    }

    public static String defaultClassName(TypeDeclaration<?> type) {
        return Helpers.defaultClassName(type.getNameAsString());
    }

    public static String defaultClassName(String name) {
        return name.replace("Prototype", "");
    }

    public static String defaultModifierClassName(String className) {
        if (className.endsWith("Impl")) {
            className = className.substring(0, className.length() - 4);
        }
        return className + "ModifyImpl";
    }

    public static String getGetterName(String name, String type) {
        if ("boolean".equals(type)) {
            return "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String getSetterName(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String getFieldName(String name) {
        if (name.startsWith("is")) {
            return name.substring(2, 3).toLowerCase() + name.substring(3);
        }
        return name.substring(3, 4).toLowerCase() + name.substring(4);
    }

    public static String getClassName(TypeDeclaration<?> type) {
        return type.getFullyQualifiedName().orElse(type.getNameAsString());
    }

    public static String getClassName(ClassOrInterfaceType type) {
        Holder result = Holder.blank();
        type.findCompilationUnit().flatMap(CompilationUnit::getPackageDeclaration).ifPresent(p -> result.set((Object)p.getName().asString()));
        return result.get() + "." + type.getNameAsString();
    }

    public static String getExternalClassName(CompilationUnit unit, String type) {
        if (Objects.nonNull(lookup.findParsed(type))) {
            return type;
        }
        Object result = Helpers.getExternalClassNameIfExists(unit, type);
        if (Objects.isNull(result)) {
            result = ((PackageDeclaration)unit.getPackageDeclaration().get()).getNameAsString() + "." + type;
        }
        return result;
    }

    public static String getExternalClassNameIfExists(CompilationUnit unit, String t) {
        Class cls;
        int idx = t.indexOf(60);
        String type = idx == -1 ? t : t.substring(0, idx);
        idx = type.indexOf(46);
        Object result = (String)((Object)Tools.nullCheck(Helpers.getClassImport(unit, type), i -> i.isAsterisk() ? i.getNameAsString() + "." + type : i.getNameAsString()));
        if (Objects.nonNull(result) && idx > -1) {
            result = (String)result + type.substring(idx).replace(".", "$");
        }
        if (Objects.isNull(result)) {
            result = unit.getImports().stream().filter(ImportDeclaration::isAsterisk).map(i -> i.getNameAsString() + "." + type).filter(name -> lookup.isParsed((String)name) || Helpers.classExists(name) || lookup.isExternal((String)name)).findFirst().orElse(null);
        }
        if (Objects.isNull(result)) {
            result = Helpers.findLocalType(unit, t);
        }
        if (Objects.isNull(result) && Objects.nonNull(cls = Reflection.loadClass((String)("java.lang." + t)))) {
            result = cls.getCanonicalName();
        }
        return result;
    }

    public static String findLocalType(CompilationUnit unit, String t) {
        String result = null;
        for (TypeDeclaration type : unit.getTypes()) {
            if (t.equals(type.getName().asString())) {
                return (String)type.getFullyQualifiedName().get();
            }
            if (type.isClassOrInterfaceDeclaration()) {
                result = Helpers.findLocalType(type.asClassOrInterfaceDeclaration(), t);
            }
            if (!Objects.nonNull(result)) continue;
            return result;
        }
        return null;
    }

    public static String findLocalType(ClassOrInterfaceDeclaration parent, String t) {
        String result = null;
        for (BodyDeclaration member : parent.getMembers()) {
            if (!member.isClassOrInterfaceDeclaration()) continue;
            ClassOrInterfaceDeclaration type = member.asClassOrInterfaceDeclaration();
            if (t.equals(type.getName().asString())) {
                return (String)type.getFullyQualifiedName().get();
            }
            result = Helpers.findLocalType(type, t);
            if (!Objects.nonNull(result)) continue;
            return result;
        }
        return null;
    }

    public static ImportDeclaration getClassImport(CompilationUnit unit, String type) {
        ImportDeclaration result;
        String known = knownTypes.get(type);
        if (Objects.nonNull(known)) {
            return new ImportDeclaration(known, false, false);
        }
        Holder rType = Holder.of((Object)type);
        int idx = type.indexOf(46);
        if (idx > -1) {
            rType.set((Object)type.substring(0, idx));
        }
        if (Objects.nonNull(result = (ImportDeclaration)unit.getImports().stream().filter(i -> i.getNameAsString().endsWith("." + (String)rType.get())).findFirst().orElse(null))) {
            return result;
        }
        return Helpers.forceGetClassImport(unit, type);
    }

    private static ImportDeclaration forceGetClassImport(CompilationUnit unit, String type) {
        return unit.getImports().stream().filter(ImportDeclaration::isAsterisk).filter(i -> Objects.nonNull(Reflection.loadClass((String)(i.getNameAsString() + "." + type)))).findFirst().orElse(null);
    }

    public static boolean methodExists(ClassOrInterfaceDeclaration spec, String name, Method declaration, boolean isClass) {
        return spec.getMethods().stream().anyMatch(m -> m.getNameAsString().equals(name) && m.getParameters().size() == declaration.getParameterCount() && m.getType().asString().equals(declaration.getReturnType().getSimpleName())) || !isClass && Helpers.ancestorMethodExists(spec, declaration);
    }

    public static boolean methodExists(ClassOrInterfaceDeclaration spec, Method declaration, boolean isClass) {
        return spec.getMethods().stream().anyMatch(m -> m.getNameAsString().equals(declaration.getName()) && m.getParameters().size() == declaration.getParameterCount() && m.getType().asString().equals(declaration.getReturnType().getSimpleName())) || !isClass && Helpers.ancestorMethodExists(spec, declaration);
    }

    public static boolean methodExists(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass) {
        return spec.getMethods().stream().anyMatch(m -> m.getNameAsString().equals(declaration.getNameAsString()) && m.getParameters().size() == declaration.getParameters().size() && m.getType().equals((Object)declaration.getType())) || !isClass && Helpers.ancestorMethodExists(spec, declaration, declaration.getNameAsString());
    }

    public static boolean methodExists(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, String methodName, boolean isClass) {
        String type = declaration.getType().asString();
        String actual = declaration.getTypeParameters().stream().map(TypeParameter::asString).anyMatch(s -> s.equals(type)) ? type : (declaration.getParentNode().isPresent() ? Generator.handleType((ClassOrInterfaceDeclaration)declaration.getParentNode().get(), spec, declaration.getType()) : type);
        return spec.getMethods().stream().anyMatch(m -> m.getNameAsString().equals(methodName) && m.getParameters().size() == declaration.getParameters().size() && (m.getType().asString().equals(actual) || declaration.getTypeParameters().isNonEmpty())) || !isClass && Helpers.ancestorMethodExists(spec, declaration, methodName);
    }

    public static boolean methodExists(ClassOrInterfaceDeclaration spec, PrototypeField declaration, String methodName, boolean isClass) {
        return spec.getMethods().stream().anyMatch(m -> m.getNameAsString().equals(methodName) && m.getParameters().size() == 1 && m.getType().equals((Object)declaration.getDeclaration().getVariable(0).getType())) || !isClass && Helpers.ancestorMethodExists(spec, declaration, methodName);
    }

    public static boolean methodExists(ClassOrInterfaceDeclaration spec, PrototypeField declaration, boolean isClass) {
        return Helpers.methodExists(spec, declaration, isClass, declaration.getDeclaration().getVariable(0).getType());
    }

    public static boolean methodExists(ClassOrInterfaceDeclaration spec, PrototypeField declaration, boolean isClass, com.github.javaparser.ast.type.Type type) {
        return spec.getMethods().stream().anyMatch(m -> m.getNameAsString().equals(declaration.getName()) && m.getParameters().size() == 1 && m.getType().equals((Object)type)) || !isClass && Helpers.ancestorMethodExists(spec, declaration, declaration.getName(), type);
    }

    public static boolean methodSignatureExists(ClassOrInterfaceDeclaration spec, PrototypeField declaration, String methodName) {
        return Helpers.methodSignatureExists(spec, declaration, methodName, declaration.getDeclaration().getVariable(0).getType());
    }

    public static boolean methodSignatureExists(ClassOrInterfaceDeclaration spec, PrototypeField declaration, String methodName, com.github.javaparser.ast.type.Type returnType) {
        boolean result = spec.getMethods().stream().anyMatch(m -> m.getNameAsString().equals(methodName) && m.getParameters().size() == 1 && m.getParameter(0).getType().equals((Object)returnType));
        if (!result) {
            for (ClassOrInterfaceType type : spec.getExtendedTypes()) {
                Optional<ClassOrInterfaceDeclaration> intf;
                PrototypeDescription<ClassOrInterfaceDeclaration> parsed;
                if (!type.getScope().isPresent() || !Objects.nonNull(parsed = lookup.findByInterfaceName(((ClassOrInterfaceType)type.getScope().get()).getNameAsString())) || !(intf = parsed.getIntf().findAll(ClassOrInterfaceDeclaration.class).stream().filter(c -> c.getNameAsString().equals(type.getNameAsString())).findFirst()).isPresent() || !(result = Helpers.methodSignatureExists(intf.get(), declaration, methodName, returnType))) continue;
                return true;
            }
        }
        return result;
    }

    public static boolean ancestorMethodExists(ClassOrInterfaceDeclaration spec, Method declaration) {
        CompilationUnit unit = (CompilationUnit)spec.findCompilationUnit().get();
        return spec.getExtendedTypes().stream().map(t -> Reflection.loadClass((String)Helpers.getExternalClassName(unit, t.getNameAsString()))).filter(Objects::nonNull).anyMatch(c -> Arrays.stream(c.getMethods()).anyMatch(m -> m.getName().equals(declaration.getName()) && m.getReturnType().equals(declaration.getReturnType())));
    }

    public static boolean ancestorMethodExists(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, String methodName) {
        CompilationUnit unit = (CompilationUnit)spec.findCompilationUnit().get();
        return spec.getExtendedTypes().stream().map(t -> Reflection.loadClass((String)Helpers.getExternalClassName(unit, t.getNameAsString()))).filter(Objects::nonNull).anyMatch(c -> Arrays.stream(c.getMethods()).anyMatch(m -> m.getName().equals(methodName)));
    }

    public static boolean ancestorMethodExists(ClassOrInterfaceDeclaration spec, PrototypeField declaration, String methodName) {
        return Helpers.ancestorMethodExists(spec, declaration, methodName, declaration.getDeclaration().getVariable(0).getType());
    }

    public static boolean ancestorMethodExists(ClassOrInterfaceDeclaration spec, PrototypeField declaration, String methodName, com.github.javaparser.ast.type.Type returnType) {
        Optional parent;
        CompilationUnit unit = (CompilationUnit)spec.findCompilationUnit().get();
        boolean result = spec.getExtendedTypes().stream().map(t -> Reflection.loadClass((String)Helpers.getExternalClassName(unit, t.getNameAsString()))).filter(Objects::nonNull).anyMatch(c -> Arrays.stream(c.getMethods()).anyMatch(m -> m.getName().equals(methodName)));
        if (!result && (parent = spec.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class})).isPresent()) {
            for (ClassOrInterfaceType type : spec.getExtendedTypes()) {
                Optional<ClassOrInterfaceDeclaration> inner = ((ClassOrInterfaceDeclaration)parent.get()).findAll(ClassOrInterfaceDeclaration.class).stream().filter(c -> c.getNameAsString().equals(type.getNameAsString())).findFirst();
                if (!inner.isPresent() || !type.getScope().isEmpty() && !((ClassOrInterfaceType)type.getScope().get()).getNameAsString().equals(((ClassOrInterfaceDeclaration)parent.get()).getNameAsString()) || !(result = Helpers.methodSignatureExists(inner.get(), declaration, methodName, returnType))) continue;
                return true;
            }
        }
        return result;
    }

    public static boolean defaultMethodExists(ClassOrInterfaceDeclaration spec, Method method) {
        return spec.getMethods().stream().anyMatch(m -> m.isDefault() && m.getNameAsString().equals(method.getName()) && m.getParameters().size() == method.getParameterCount() && m.getTypeAsString().equals(method.getReturnType().getSimpleName()));
    }

    public static String findProperType(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, CompilationUnit unit, ClassExpr expr) {
        AnnotationExpr parent = Helpers.findParentClassOfType((Node)expr, AnnotationExpr.class, a -> knownClassAnnotations.contains(Helpers.getExternalClassName(unit, a.getNameAsString())));
        if (Objects.isNull(parent)) {
            return parsed.getFiles().get(1).getType(0).getNameAsString();
        }
        List<CompilationUnit> files = parsed.getFiles();
        if (Objects.nonNull(files)) {
            TypeDeclaration type = files.get(0).getType(0);
            expr.findCompilationUnit().ifPresent(u -> u.addImport((String)type.getFullyQualifiedName().get()));
            return type.getNameAsString();
        }
        recursiveExpr.add((Triple<PrototypeDescription<ClassOrInterfaceDeclaration>, CompilationUnit, ClassExpr>)Triple.of(parsed, (Object)unit, (Object)expr));
        return expr.getTypeAsString();
    }

    public static <T extends Node> T findParentClassOfType(Node node, Class<T> cls, Predicate<T> predicate) {
        Optional parent = node.getParentNode();
        if (parent.isEmpty()) {
            return null;
        }
        if (cls.isAssignableFrom(((Node)parent.get()).getClass()) && predicate.test((Node)parent.get())) {
            return (T)((Node)parent.get());
        }
        return Helpers.findParentClassOfType((Node)parent.get(), cls, predicate);
    }

    public static boolean fieldExists(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, String field) {
        return Objects.nonNull(Helpers.findField(parsed, field));
    }

    public static PrototypeField findField(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, String field) {
        Optional<PrototypeField> result = parsed.getFields().stream().filter(f -> f.getName().equals(field)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        if (Objects.nonNull(parsed.getBase())) {
            return Helpers.findField(parsed.getBase(), field);
        }
        return null;
    }

    public static MethodDeclaration findMethod(ClassOrInterfaceDeclaration spec, String method) {
        return spec.getMethods().stream().filter(m -> m.getNameAsString().equals(method)).findFirst().orElse(null);
    }

    public static void mergeImports(CompilationUnit source, CompilationUnit destination) {
        source.getImports().stream().filter(i -> !i.getNameAsString().startsWith("net.binis.codegen.annotation")).forEach(i -> {
            PrototypeDescription<EnumDeclaration> enm = enumParsed.get(i.getNameAsString());
            if (Objects.nonNull(enm)) {
                if (Objects.isNull(enm.getProperties().getMixInClass())) {
                    destination.addImport(enm.getParsedFullName());
                } else {
                    Tools.notNull(enumParsed.get(Helpers.getExternalClassName((CompilationUnit)enm.getDeclaration().findCompilationUnit().get(), enm.getProperties().getMixInClass())), p -> destination.addImport(p.getParsedFullName()));
                }
            } else {
                destination.addImport(i);
            }
        });
    }

    public static ClassOrInterfaceDeclaration findModifier(ClassOrInterfaceDeclaration intf) {
        return (ClassOrInterfaceDeclaration)intf.findFirst(ClassOrInterfaceDeclaration.class, m -> (Boolean)((Object)Tools.nullCheck(m.getNameAsString(), name -> name.equals("Modify") || name.endsWith("ModifyImpl")))).orElseThrow();
    }

    public static String getEnumNameFromPrototype(TypeDeclaration<?> type, String prototype) {
        Holder result = Holder.blank();
        Tools.notNull(enumParsed.get(Helpers.getExternalClassName((CompilationUnit)type.findCompilationUnit().get(), prototype)), p -> Tools.nullCheck(p.getProperties().getMixInClass(), m -> (String)result.update((Object)Helpers.getEnumNameFromPrototype(p.getDeclaration(), m)), (String)result.update((Object)p.getParsedName())));
        return (String)result.get();
    }

    public static PrototypeDescription<ClassOrInterfaceDeclaration> getParsed(ClassOrInterfaceType type) {
        PrototypeDescription<ClassOrInterfaceDeclaration> result = lookup.findParsed(Helpers.getClassName(type));
        if (Objects.isNull(result)) {
            result = lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)type.findCompilationUnit().get(), type.getNameAsString()));
        }
        return result;
    }

    public static Map<String, com.github.javaparser.ast.type.Type> processGenerics(Class<?> cls, NodeList<com.github.javaparser.ast.type.Type> generics) {
        HashMap<String, com.github.javaparser.ast.type.Type> result = null;
        List<String> types = Helpers.parseGenericClassSignature(cls);
        if (types.size() != generics.size()) {
            log.warn("Generic types miss match for {}", (Object)cls.getName());
        }
        result = new HashMap<String, com.github.javaparser.ast.type.Type>();
        for (int i = 0; i < types.size(); ++i) {
            PrototypeDescription<ClassOrInterfaceDeclaration> parsed;
            com.github.javaparser.ast.type.Type generic = (com.github.javaparser.ast.type.Type)generics.get(i);
            if (generic.isClassOrInterfaceType() && Objects.nonNull(parsed = Helpers.getParsed(generic.asClassOrInterfaceType()))) {
                generic = (com.github.javaparser.ast.type.Type)new ClassOrInterfaceType().setName(parsed.getIntf().getNameAsString());
            }
            result.put(types.get(i), generic);
        }
        return result;
    }

    public static Map<String, com.github.javaparser.ast.type.Type> processGenerics(Class<?> cls, Map<String, com.github.javaparser.ast.type.Type> parent, Type[] generics) {
        HashMap<String, com.github.javaparser.ast.type.Type> result = new HashMap<String, com.github.javaparser.ast.type.Type>();
        List<String> types = Helpers.parseGenericClassSignature(cls);
        if (types.size() != generics.length) {
            log.warn("Generic types miss match for {}", (Object)cls.getName());
        }
        if (Objects.nonNull(parent)) {
            result = new HashMap();
            for (int i = 0; i < types.size(); ++i) {
                com.github.javaparser.ast.type.Type generic;
                if (generics[i] instanceof TypeVariable) {
                    generic = parent.get(generics[i].getTypeName());
                    PrototypeDescription<ClassOrInterfaceDeclaration> parsed = lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)generic.findCompilationUnit().get(), generic.asString()));
                    if (Objects.nonNull(parsed)) {
                        generic = (com.github.javaparser.ast.type.Type)new ClassOrInterfaceType().setName(parsed.getIntf().getNameAsString());
                    }
                } else {
                    PrototypeDescription<ClassOrInterfaceDeclaration> parsed;
                    Class type = (Class)generics[i];
                    generic = (com.github.javaparser.ast.type.Type)new ClassOrInterfaceType().setName(type.getSimpleName());
                    if (type.isInterface() && Objects.nonNull(parsed = lookup.findParsed(type.getCanonicalName()))) {
                        generic = (com.github.javaparser.ast.type.Type)new ClassOrInterfaceType().setName(parsed.getIntf().getNameAsString());
                    }
                }
                result.put(types.get(i), generic);
            }
        } else {
            for (int i = 0; i < types.size(); ++i) {
                PrototypeDescription<ClassOrInterfaceDeclaration> parsed;
                Class type = (Class)generics[i];
                ClassOrInterfaceType generic = (ClassOrInterfaceType)new ClassOrInterfaceType().setName(type.getSimpleName());
                if (type.isInterface() && Objects.nonNull(parsed = lookup.findParsed(type.getCanonicalName()))) {
                    generic = (ClassOrInterfaceType)new ClassOrInterfaceType().setName(parsed.getIntf().getNameAsString());
                }
                result.put(types.get(i), (com.github.javaparser.ast.type.Type)generic);
            }
        }
        return result.isEmpty() ? null : result;
    }

    public static List<String> parseGenericClassSignature(Class<?> cls) {
        return Arrays.stream(cls.getTypeParameters()).map(TypeVariable::getName).collect(Collectors.toList());
    }

    public static String parseMethodSignature(Method method) {
        return method.getGenericReturnType().getTypeName();
    }

    public static String mapGenericMethodSignature(Method method, Map<String, String> types) {
        return Helpers.mapGenericSignature(method.getGenericReturnType(), types);
    }

    public static String mapGenericSignature(Type type, Map<String, String> types) {
        if (type instanceof TypeVariable) {
            String result = types.get(((TypeVariable)type).getName());
            if (Objects.isNull(result)) {
                throw new GenericCodeGenException("Invalid generic type: " + type);
            }
            return result;
        }
        if (type.equals(Void.TYPE)) {
            return "void";
        }
        ParameterizedType t = (ParameterizedType)type;
        if (t.getActualTypeArguments().length > 0) {
            return Arrays.stream(t.getActualTypeArguments()).map(tt -> Helpers.mapGenericSignature(tt, types)).collect(Collectors.joining(",", t.getRawType().getTypeName() + "<", ">"));
        }
        return t.getTypeName();
    }

    public static String parseMethodSignature(MethodDeclaration method) {
        return "Not Implemented";
    }

    public static Structures.Ignores getIgnores(CompilationUnit unit, BodyDeclaration<?> member) {
        Structures.Ignores.IgnoresBuilder result = Structures.Ignores.builder();
        member.getAnnotations().forEach(annotation -> Tools.notNull(Helpers.getExternalClassName(unit, annotation.getNameAsString()), className -> Tools.notNull(Reflection.loadClass((String)className), cls -> {
            if (Ignore.class.equals(cls)) {
                annotation.getChildNodes().forEach(node -> {
                    if (node instanceof MemberValuePair) {
                        String name;
                        MemberValuePair pair = (MemberValuePair)node;
                        switch (name = pair.getNameAsString()) {
                            case "forField": {
                                result.forField(pair.getValue().asBooleanLiteralExpr().getValue());
                                break;
                            }
                            case "forClass": {
                                result.forClass(pair.getValue().asBooleanLiteralExpr().getValue());
                                break;
                            }
                            case "forInterface": {
                                result.forInterface(pair.getValue().asBooleanLiteralExpr().getValue());
                                break;
                            }
                            case "forModifier": {
                                result.forModifier(pair.getValue().asBooleanLiteralExpr().getValue());
                                break;
                            }
                            case "forQuery": {
                                result.forQuery(pair.getValue().asBooleanLiteralExpr().getValue());
                                break;
                            }
                        }
                    }
                });
            } else {
                Tools.notNull(cls.getAnnotation(Ignore.class), ann -> result.forField(ann.forField()).forClass(ann.forClass()).forInterface(ann.forInterface()).forModifier(ann.forModifier()).forQuery(ann.forQuery()));
            }
        })));
        return result.build();
    }

    public static Structures.Ignores getIgnores(BodyDeclaration<?> member) {
        return Helpers.getIgnores((CompilationUnit)member.findCompilationUnit().get(), member);
    }

    public static String getDefaultValue(BodyDeclaration<?> member) {
        Holder result = new Holder();
        member.getAnnotations().stream().filter(a -> "Default".equals(a.getNameAsString())).findFirst().ifPresent(annotation -> result.set((Object)annotation.getNameAsString()));
        return (String)result.get();
    }

    public static Structures.Constants getConstants(BodyDeclaration<?> member) {
        Structures.Constants.ConstantsBuilder result = Structures.Constants.builder().forPublic(true);
        member.getAnnotations().stream().filter(a -> "CodeConstant".equals(a.getNameAsString())).findFirst().ifPresent(annotation -> annotation.getChildNodes().forEach(node -> {
            if (node instanceof MemberValuePair) {
                String name;
                MemberValuePair pair = (MemberValuePair)node;
                switch (name = pair.getNameAsString()) {
                    case "isPublic": {
                        result.forPublic(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "forClass": {
                        result.forClass(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "forInterface": {
                        result.forInterface(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                }
            }
        }));
        return result.build();
    }

    public static void addDeclaredConstant(String namespace, String type, String constant) {
        List<Pair<String, String>> decl = declaredConstants.get(namespace);
        if (Objects.nonNull(decl)) {
            decl.add((Pair<String, String>)Pair.of((Object)type, (Object)constant));
        } else {
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.add(Pair.of((Object)type, (Object)constant));
            declaredConstants.put(namespace, list);
        }
    }

    public static void addProcessingType(String type, String interfacePackage, String interfaceName, String classPackage, String className) {
        processingTypes.put(type, Structures.ProcessingType.builder().interfaceName(interfaceName).interfacePackage(interfacePackage).className(className).classPackage(classPackage).build());
    }

    public static void sortImports(CompilationUnit unit) {
        unit.getImports().sort((i1, i2) -> i2.getNameAsString().compareTo(i1.getNameAsString()));
    }

    public static void sortClass(ClassOrInterfaceDeclaration cls) {
        cls.getMembers().sort(Helpers::compareMembers);
        cls.getMembers().stream().filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(BodyDeclaration::asClassOrInterfaceDeclaration).forEach(Helpers::sortClass);
    }

    private static int compareMembers(BodyDeclaration<?> m1, BodyDeclaration<?> m2) {
        int result = Helpers.memberIndex(m2) - Helpers.memberIndex(m1);
        if (result == 0) {
            if (m1 instanceof NodeWithSimpleName) {
                return ((NodeWithSimpleName)m1).getNameAsString().compareTo(((NodeWithSimpleName)m2).getNameAsString());
            }
            if (m1 instanceof NodeWithVariables) {
                return ((NodeWithVariables)m1).getVariable(0).getNameAsString().compareTo(((NodeWithVariables)m2).getVariable(0).getNameAsString());
            }
        }
        return result;
    }

    private static int memberIndex(BodyDeclaration<?> member) {
        if (member.isFieldDeclaration()) {
            FieldDeclaration field = member.asFieldDeclaration();
            if (field.isStatic() && field.isFinal()) {
                return 1000;
            }
            if (field.isStatic()) {
                return 999;
            }
            return 998;
        }
        if (member.isInitializerDeclaration()) {
            return 997;
        }
        if (member.isConstructorDeclaration()) {
            return 996;
        }
        if (member.isMethodDeclaration()) {
            return 995;
        }
        if (member.isClassOrInterfaceDeclaration()) {
            return 994;
        }
        return 0;
    }

    public static boolean classExists(String className) {
        return Objects.nonNull(Reflection.loadClass((String)className));
    }

    public static void cleanUp() {
        Tools.with((PrototypeLookupHandler)lookup, PrototypeLookupHandler::clean);
        enumParsed.clear();
        enumGenerated.clear();
        constantParsed.clear();
        declaredConstants.clear();
        processingTypes.clear();
        recursiveExpr.clear();
        lookup.registerExternalLookup(null);
    }

    public static void registerEnricher(Class enricher) {
        boolean reg = false;
        for (Class<?> i : enricher.getInterfaces()) {
            if (!Enricher.class.isAssignableFrom(i) || Enricher.class.equals(i.getClass())) continue;
            CodeFactory.registerType(i, () -> Reflection.instantiate((Class)enricher), null);
            reg = true;
        }
        if (!reg) {
            throw new GenericCodeGenException(enricher.getCanonicalName() + " is not enricher!");
        }
    }

    public static void registerKnownEnrichers() {
        Helpers.registerEnricher(AsEnricherHandler.class);
        Helpers.registerEnricher(CloneEnricherHandler.class);
        Helpers.registerEnricher(CreatorEnricherHandler.class);
        Helpers.registerEnricher(CreatorModifierEnricherHandler.class);
        Helpers.registerEnricher(ModifierEnricherHandler.class);
        Helpers.registerEnricher(QueryEnricherHandler.class);
        Helpers.registerEnricher(ValidationEnricherHandler.class);
        Helpers.registerEnricher(FluentEnricherHandler.class);
        Helpers.registerEnricher(RegionEnricherHandler.class);
        Helpers.registerEnricher(OpenApiEnricherHandler.class);
        Helpers.registerEnricher(JacksonEnricherHandler.class);
    }

    public static String handleGenericPrimitiveType(com.github.javaparser.ast.type.Type type) {
        if (type.isPrimitiveType()) {
            return type.asPrimitiveType().toBoxedType().asString();
        }
        return type.asString();
    }

    public static void handleEnrichersSetup(PrototypeData properties) {
        Tools.notNull(properties.getEnrichers(), enrichers -> enrichers.forEach(e -> e.setup(properties)));
    }

    public static void handleInheritedEnrichersSetup(PrototypeData properties) {
        Tools.notNull(properties.getInheritedEnrichers(), enrichers -> enrichers.forEach(e -> e.setup(properties)));
    }

    private static List<PrototypeEnricher> getEnrichersList(PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        HashMap map = new HashMap();
        Tools.notNull(parsed.getBase(), base -> Tools.notNull(base.getProperties().getInheritedEnrichers(), l -> l.forEach(e -> map.put(e.getClass(), e))));
        Tools.notNull(parsed.getMixIn(), mixIn -> Tools.notNull(mixIn.getBase(), base -> Tools.notNull(base.getProperties().getInheritedEnrichers(), l -> l.forEach(e -> map.put(e.getClass(), e)))));
        Tools.notNull(parsed.getProperties().getEnrichers(), l -> l.forEach(e -> map.put(e.getClass(), e)));
        ArrayList<PrototypeEnricher> list = new ArrayList<PrototypeEnricher>(map.values());
        list.sort(Comparator.comparingInt(PrototypeEnricher::order).reversed());
        return list;
    }

    public static void handleEnrichers(PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        Helpers.getEnrichersList(parsed).forEach(e -> Helpers.safeEnrich(e, parsed));
    }

    private static void safeEnrich(PrototypeEnricher enricher, PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        try {
            enricher.enrich(parsed);
        }
        catch (Exception e) {
            log.error("Failed to enrich {} with {}", new Object[]{parsed.getProperties().getPrototypeName(), enricher.getClass(), e});
        }
    }

    public static void finalizeEnrichers(PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        Helpers.getEnrichersList(parsed).forEach(e -> e.finalizeEnrich(parsed));
    }

    public static void postProcessEnrichers(PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        parsed.processActions();
        parsed.getInitializers().forEach(i -> {
            if (i.getMiddle() instanceof ClassOrInterfaceDeclaration) {
                ClassOrInterfaceDeclaration type = (ClassOrInterfaceDeclaration)i.getMiddle();
                Helpers.getInitializer(Objects.isNull(parsed.getMixIn()) ? parsed.getSpec() : parsed.getMixIn().getSpec()).addStatement((Expression)((MethodCallExpr)((MethodCallExpr)((MethodCallExpr)new MethodCallExpr().setName("CodeFactory.registerType")).addArgument((String)(((ClassOrInterfaceDeclaration)i.getLeft()).getParentNode().get() instanceof ClassOrInterfaceDeclaration ? ((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)i.getLeft()).getParentNode().get()).getNameAsString() + "." : "") + ((ClassOrInterfaceDeclaration)i.getLeft()).getNameAsString() + ".class")).addArgument(type.getNameAsString() + "::new")).addArgument(Helpers.calcModifierExpression((PrototypeDescription)i.getRight())));
            } else if (i.getMiddle() instanceof LambdaExpr && Objects.nonNull(i.getLeft())) {
                LambdaExpr expr = (LambdaExpr)i.getMiddle();
                Helpers.getInitializer(Objects.isNull(parsed.getMixIn()) ? parsed.getSpec() : parsed.getMixIn().getSpec()).addStatement((Expression)((MethodCallExpr)((MethodCallExpr)((MethodCallExpr)new MethodCallExpr().setName("CodeFactory.registerType")).addArgument((String)(((ClassOrInterfaceDeclaration)i.getLeft()).getParentNode().get() instanceof ClassOrInterfaceDeclaration ? ((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)i.getLeft()).getParentNode().get()).getNameAsString() + "." : "") + ((ClassOrInterfaceDeclaration)i.getLeft()).getNameAsString() + ".class")).addArgument((Expression)expr)).addArgument("null"));
            }
        });
        parsed.getCustomInitializers().forEach(i -> i.accept(Helpers.getInitializer(parsed.getSpec())));
        Helpers.handleImports(parsed.getDeclaration().asClassOrInterfaceDeclaration(), parsed.getIntf());
        Helpers.handleImports(parsed.getDeclaration().asClassOrInterfaceDeclaration(), parsed.getSpec());
        Helpers.getEnrichersList(parsed).forEach(e -> e.postProcess(parsed));
    }

    private static String calcModifierExpression(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        ClassOrInterfaceDeclaration modClass;
        if (Objects.nonNull(description) && Objects.nonNull(modClass = description.getRegisteredClass("EmbeddedModifier"))) {
            String className;
            ClassOrInterfaceDeclaration soloClass = description.getRegisteredClass("EmbeddedSoloModifier");
            ClassOrInterfaceDeclaration collectionClass = description.getRegisteredClass("EmbeddedCollectionModifier");
            String string = className = Objects.isNull(description.getMixIn()) ? description.getProperties().getClassName() : description.getMixIn().getProperties().getClassName();
            if (Objects.nonNull(soloClass) && Objects.nonNull(collectionClass)) {
                soloClass.findCompilationUnit().ifPresent(u -> u.addImport("net.binis.codegen.collection.EmbeddedCodeCollection"));
                return "(p, v) -> p instanceof EmbeddedCodeCollection ? ((" + description.getProperties().getClassName() + ") v).new " + collectionClass.getNameAsString() + "(p) : ((" + className + ") v).new " + soloClass.getNameAsString() + "(p)";
            }
            ClassOrInterfaceDeclaration cls = modClass;
            if (Objects.nonNull(soloClass)) {
                cls = soloClass;
            } else if (Objects.nonNull(collectionClass)) {
                cls = collectionClass;
            }
            return "(p, v) -> ((" + className + ") v).new " + cls.getNameAsString() + "(p)";
        }
        return "null";
    }

    public static BlockStmt getInitializer(ClassOrInterfaceDeclaration type) {
        return type.getChildNodes().stream().filter(InitializerDeclaration.class::isInstance).map(n -> ((InitializerDeclaration)n).asInitializerDeclaration().getBody()).findFirst().orElseGet(() -> ((ClassOrInterfaceDeclaration)type).addInitializer());
    }

    public static boolean isJavaType(String type) {
        return primitiveTypes.contains(type) || Helpers.classExists("java.lang." + type);
    }

    public static boolean isPrimitiveType(String type) {
        return primitiveTypes.contains(type);
    }

    public static void handleImports(ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration type) {
        declaration.findCompilationUnit().ifPresent(decl -> type.findCompilationUnit().ifPresent(unit -> Helpers.findUsedTypes(type).stream().map(t -> Helpers.getClassImport(decl, t)).filter(Objects::nonNull).forEach(arg_0 -> ((CompilationUnit)unit).addImport(arg_0))));
    }

    public static Set<String> findUsedTypes(ClassOrInterfaceDeclaration type) {
        HashSet<String> result = new HashSet<String>();
        Helpers.findUsedTypesInternal(result, (Node)type);
        return result;
    }

    private static void findUsedTypesInternal(Set<String> types, Node node) {
        VariableDeclarator declarator;
        if (node instanceof ClassOrInterfaceType) {
            ClassOrInterfaceType type = (ClassOrInterfaceType)node;
            types.add(type.getNameAsString());
            type.getTypeArguments().ifPresent(a -> a.forEach(n -> Helpers.findUsedTypesInternal(types, (Node)n)));
        } else if (node instanceof AnnotationExpr) {
            types.add(((AnnotationExpr)node).getNameAsString());
        } else if (node instanceof NameExpr) {
            types.add(((NameExpr)node).getNameAsString());
        } else if (node instanceof SimpleName) {
            Arrays.stream(((SimpleName)node).asString().split("[.()<\\s]")).filter(s -> !"".equals(s)).forEach(types::add);
        } else if (node instanceof VariableDeclarator && (declarator = (VariableDeclarator)node).getType() instanceof ClassOrInterfaceType) {
            types.add(((ClassOrInterfaceType)declarator.getType()).getNameAsString());
        }
        node.getChildNodes().forEach(n -> Helpers.findUsedTypesInternal(types, n));
    }

    public static void importType(com.github.javaparser.ast.type.Type type, CompilationUnit destination) {
        if (!type.isPrimitiveType()) {
            type.findCompilationUnit().ifPresent(unit -> {
                String full = Helpers.getExternalClassNameIfExists((CompilationUnit)type.findCompilationUnit().get(), type.asClassOrInterfaceType().getNameAsString());
                if (Objects.nonNull(full)) {
                    destination.addImport(full);
                }
            });
        }
    }

    public static void addInitializer(PrototypeDescription<ClassOrInterfaceDeclaration> description, ClassOrInterfaceDeclaration intf, ClassOrInterfaceDeclaration type, boolean embedded) {
        Helpers.addInitializerInternal(description, intf, (Node)type, embedded);
    }

    public static void addInitializer(PrototypeDescription<ClassOrInterfaceDeclaration> description, ClassOrInterfaceDeclaration intf, LambdaExpr expr, boolean embedded) {
        Helpers.addInitializerInternal(description, intf, (Node)expr, embedded);
    }

    public static void addDefaultCreation(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        ClassOrInterfaceDeclaration intf = description.getIntf();
        if (description.getProperties().isGenerateImplementation() && intf.getAnnotationByName("Default").isEmpty()) {
            Object name = description.getImplementorFullName();
            if (description.isNested() && Objects.nonNull(description.getParentClassName())) {
                name = Helpers.getBasePackage(description) + "." + description.getParsedName().replace('.', '$');
            }
            intf.addAnnotation((AnnotationExpr)description.getParser().parseAnnotation("@Default(\"" + (String)name + "\")").getResult().get());
            ((CompilationUnit)intf.findCompilationUnit().get()).addImport(Default.class.getCanonicalName());
        }
    }

    private static String getBasePackage(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        if (description.isNested() && Objects.nonNull(description.getParentClassName())) {
            return Helpers.getBasePackage(lookup.findParsed(description.getParentClassName()));
        }
        return description.getProperties().getClassPackage();
    }

    private static void addInitializerInternal(PrototypeDescription<ClassOrInterfaceDeclaration> description, ClassOrInterfaceDeclaration intf, Node node, boolean embedded) {
        ((CompilationUnit)description.getSpec().findCompilationUnit().get()).addImport("net.binis.codegen.factory.CodeFactory");
        List<Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>> list = description.getInitializers();
        for (int i = 0; i < list.size(); ++i) {
            if (!((String)((ClassOrInterfaceDeclaration)list.get(i).getLeft()).getFullyQualifiedName().get()).equals(intf.getFullyQualifiedName().get())) continue;
            if (Objects.isNull(list.get(i).getRight()) && embedded) {
                list.set(i, (Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>)Triple.of((Object)intf, (Object)node, description));
            }
            return;
        }
        list.add((Triple<ClassOrInterfaceDeclaration, Node, PrototypeDescription<ClassOrInterfaceDeclaration>>)Triple.of((Object)intf, (Object)node, embedded ? description : null));
    }

    public static boolean hasAnnotation(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, Class<? extends Annotation> annotation) {
        return parsed.getDeclaration().getAnnotationByClass(annotation).isPresent();
    }

    public static void importClass(CompilationUnit unit, Class<?> cls) {
        if (!cls.isPrimitive() && !"java.lang".equals(cls.getPackageName())) {
            unit.addImport(cls.getCanonicalName());
        }
    }

    public static Map<String, com.github.javaparser.ast.type.Type> buildGenerics(ClassOrInterfaceType type, ClassOrInterfaceDeclaration cls) {
        HashMap<String, com.github.javaparser.ast.type.Type> generics = new HashMap<String, com.github.javaparser.ast.type.Type>();
        int i = 0;
        for (TypeParameter g : cls.getTypeParameters()) {
            try {
                generics.put(g.getNameAsString(), (com.github.javaparser.ast.type.Type)((NodeList)type.getTypeArguments().get()).get(i));
            }
            catch (NoSuchElementException e) {
                throw new GenericCodeGenException("Invalid generic type arguments for type " + type.getNameAsString());
            }
            ++i;
        }
        return generics.isEmpty() ? null : generics;
    }

    public static com.github.javaparser.ast.type.Type buildGeneric(String type, ClassOrInterfaceType t, ClassOrInterfaceDeclaration cls) {
        Map<String, com.github.javaparser.ast.type.Type> generics = Helpers.buildGenerics(t, cls);
        if (Objects.nonNull(generics)) {
            return generics.get(type);
        }
        return null;
    }

    public static Pair<com.github.javaparser.ast.type.Type, PrototypeDescription<ClassOrInterfaceDeclaration>> getFieldType(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field) {
        if (field.getDescription().getTypeParameters().isEmpty()) {
            if (field.isGenericField()) {
                ClassOrInterfaceDeclaration intf = field.getParsed().getIntf();
                Holder type = Holder.blank();
                Holder proto = Holder.blank();
                description.getIntf().getExtendedTypes().stream().filter(t -> t.getNameAsString().equals(intf.getNameAsString())).findFirst().ifPresent(t -> type.set((Object)Helpers.buildGeneric(field.getType(), t, intf)));
                description.getDeclaration().asClassOrInterfaceDeclaration().getExtendedTypes().stream().filter(t -> t.getNameAsString().equals(field.getParsed().getDeclaration().getNameAsString())).findFirst().ifPresent(t -> proto.set(lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)description.getDeclaration().asClassOrInterfaceDeclaration().findCompilationUnit().get(), Helpers.buildGeneric(field.getType(), t, intf).asString()))));
                if (type.isPresent()) {
                    return Pair.of((Object)((com.github.javaparser.ast.type.Type)type.get()), (Object)((PrototypeDescription)proto.get()));
                }
            }
            if (Objects.nonNull(field.getGenerics())) {
                com.github.javaparser.ast.type.Type type = field.getGenerics().get(field.getType());
                if (Objects.nonNull(type)) {
                    return Pair.of((Object)type, null);
                }
                type = field.getGenerics().get(field.getDescription().getType().asString());
                if (Objects.nonNull(type)) {
                    return Pair.of((Object)type, null);
                }
            }
            if (Objects.isNull(field.getDescription())) {
                return Pair.of((Object)((VariableDeclarator)field.getDeclaration().getVariables().get(0)).getType(), null);
            }
            com.github.javaparser.ast.type.Type result = field.getDescription().getType();
            if (Objects.nonNull(lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)field.getDescription().findCompilationUnit().get(), result.asString())))) {
                result = (com.github.javaparser.ast.type.Type)lookup.getParser().parseClassOrInterfaceType(field.getType()).getResult().get();
            } else if (Objects.nonNull(field.getDeclaration())) {
                result = field.getDeclaration().getCommonType();
            }
            return Pair.of((Object)result, null);
        }
        return Pair.of((Object)((com.github.javaparser.ast.type.Type)new ClassOrInterfaceType().setName("Object")), null);
    }

    public static int sortForEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> left, PrototypeDescription<ClassOrInterfaceDeclaration> right) {
        return (Objects.nonNull(left.getMixIn()) ? 2 : 0) + (Objects.nonNull(left.getBase()) ? 1 : 0) - ((Objects.nonNull(right.getMixIn()) ? 2 : 0) + (Objects.nonNull(right.getBase()) ? 1 : 0));
    }

    public static String getAnnotationValue(AnnotationExpr annotation) {
        String result = "BOTH";
        if (annotation.isSingleMemberAnnotationExpr()) {
            result = annotation.asSingleMemberAnnotationExpr().getMemberValue().toString();
        } else if (annotation.isNormalAnnotationExpr()) {
            for (MemberValuePair pair : annotation.asNormalAnnotationExpr().getPairs()) {
                if (!"value".equals(pair.getName().asString())) continue;
                result = pair.getValue().toString();
                break;
            }
        }
        return result.substring(Math.max(0, result.lastIndexOf(46) + 1));
    }

    public static String calcType(ClassOrInterfaceDeclaration spec) {
        Object result = spec.getNameAsString();
        if (spec.getTypeParameters().isNonEmpty()) {
            result = (String)result + spec.getTypeParameters().stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.joining(", ", "<", ">"));
        }
        return result;
    }

    public static boolean annotationHasTarget(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, String target) {
        return parsed.getDeclaration().stream().filter(AnnotationExpr.class::isInstance).map(AnnotationExpr.class::cast).filter(an -> "java.lang.annotation.Target".equals(Helpers.getExternalClassName((CompilationUnit)parsed.getDeclaration().findCompilationUnit().get(), an.getNameAsString()))).findFirst().map(t -> t.stream().filter(ArrayInitializerExpr.class::isInstance).map(ArrayInitializerExpr.class::cast).findFirst().map(arr -> arr.getValues().stream().map(Object::toString).anyMatch(target::equals)).orElse(false)).orElse(true);
    }

    public static String checkReserved(String name) {
        if (reserved.contains(name)) {
            return name + "_";
        }
        return name;
    }

    public static String sanitizeImport(String imprt) {
        return imprt.replace('$', '.');
    }

    public static void addSuppressWarningsUnchecked(NodeWithAnnotations node) {
        if (!node.isAnnotationPresent(SuppressWarnings.class)) {
            node.addAndGetAnnotation(SuppressWarnings.class).addPair("value", "\"unchecked\"");
        }
    }
}

