/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.test;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.binis.codegen.CodeGen;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.test.JavaByteObject;
import net.binis.codegen.test.JavaSourceObject;
import net.binis.codegen.test.TestClassLoader;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTest {
    private static final Logger log = LoggerFactory.getLogger(BaseTest.class);
    protected JavaParser parser = new JavaParser();

    protected String getAsString(CompilationUnit file) {
        CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
        Helpers.sortImports(file);
        if (file.getType(0).isClassOrInterfaceDeclaration()) {
            Helpers.sortClass(file.getType(0).asClassOrInterfaceDeclaration());
        }
        return printer.print((Node)file);
    }

    protected void generate() {
        for (PrototypeDescription<ClassOrInterfaceDeclaration> entry : Helpers.lookup.parsed()) {
            Tools.ifNull(entry.getFiles(), () -> Generator.generateCodeForClass((CompilationUnit)entry.getDeclaration().findCompilationUnit().get()));
        }
        Helpers.lookup.calcPrototypeMaps();
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.isNull(p.getBase()) && Objects.isNull(p.getMixIn())).forEach(Helpers::handleEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.nonNull(p.getBase()) || Objects.nonNull(p.getMixIn())).forEach(Helpers::handleEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.isNull(p.getBase()) && Objects.isNull(p.getMixIn())).forEach(Helpers::finalizeEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.nonNull(p.getBase()) || Objects.nonNull(p.getMixIn())).forEach(Helpers::finalizeEnrichers);
    }

    protected void cleanUp() {
        Helpers.cleanUp();
    }

    protected void load(List<Pair<String, String>> list, String resource) {
        String source = this.resourceAsString(resource);
        ParseResult parse = this.parser.parse(source);
        Assert.assertTrue((String)parse.toString(), (boolean)parse.isSuccessful());
        if (Objects.nonNull(list)) {
            list.add((Pair<String, String>)Pair.of((Object)((String)((ClassOrInterfaceDeclaration)((CompilationUnit)parse.getResult().get()).findFirst(ClassOrInterfaceDeclaration.class).get()).getFullyQualifiedName().get()), (Object)source));
        }
        parse.getResult().ifPresent(u -> u.getTypes().forEach(t -> CodeGen.handleType(this.parser, t, resource)));
    }

    protected void compare(CompilationUnit unit, String resource) {
        if (Objects.nonNull(resource)) {
            Assert.assertEquals((String)resource, (Object)this.resourceAsString(resource), (Object)this.getAsString(unit));
        }
    }

    protected void testSingle(String prototype, String resClass, String resInterface) {
        this.testSingle(prototype, resClass, resInterface, null, 1);
    }

    protected void testSingle(String prototype, String resClass, String resInterface, String pathToSave) {
        this.testSingle(prototype, resClass, resInterface, pathToSave, 1);
    }

    protected void testSingle(String prototype, String resClass, String resInterface, int expected) {
        this.testSingle(prototype, resClass, resInterface, null, expected);
    }

    protected void testSingle(String prototype, String resClass, String resInterface, String pathToSave, int expected) {
        List<Pair<String, String>> list = this.newList();
        this.load(list, prototype);
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list));
        this.generate();
        Assert.assertEquals((long)expected, (long)Helpers.lookup.parsed().size());
        list = this.newList();
        for (PrototypeDescription<ClassOrInterfaceDeclaration> parsed : Helpers.lookup.generated()) {
            if (Objects.isNull(parsed.getCompiled())) {
                if (Objects.nonNull(pathToSave)) {
                    this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                    this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
                }
                this.compare(parsed.getFiles().get(1), resInterface);
                this.compare(parsed.getFiles().get(0), resClass);
            }
            list.add((Pair<String, String>)Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add((Pair<String, String>)Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        }
        TestClassLoader loader = new TestClassLoader();
        Assert.assertTrue((boolean)this.compile(loader, list));
    }

    protected void testMulti(List<Triple<String, String, String>> files) {
        this.testMulti(files, null);
    }

    protected void testMulti(List<Triple<String, String, String>> files, String pathToSave) {
        List<Pair<String, String>> list = this.newList();
        files.forEach(t -> this.load(list, (String)t.getLeft()));
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list));
        this.generate();
        Assert.assertEquals((long)files.size(), (long)Helpers.lookup.parsed().size());
        ArrayList<Pair<String, String>> compileList = new ArrayList<Pair<String, String>>();
        files.forEach(f -> Helpers.lookup.findGeneratedByFileName((String)f.getLeft()).forEach(parsed -> {
            this.compare(parsed.getFiles().get(1), (String)f.getRight());
            this.compare(parsed.getFiles().get(0), (String)f.getMiddle());
            if (Objects.nonNull(pathToSave)) {
                if (Objects.isNull(parsed.getMixIn())) {
                    this.save(parsed.getProperties().getClassName(), parsed.getFiles().get(0), pathToSave);
                }
                this.save(parsed.getProperties().getInterfaceName(), parsed.getFiles().get(1), pathToSave);
            }
            if (Objects.isNull(parsed.getMixIn())) {
                compileList.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
                compileList.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
            } else {
                for (int i = 0; i < compileList.size(); ++i) {
                    if (!((String)((Pair)compileList.get(i)).getKey()).equals(parsed.getMixIn().getParsedFullName())) continue;
                    compileList.add(i, Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
                    break;
                }
            }
        }));
        TestClassLoader loader = new TestClassLoader();
        Assert.assertTrue((boolean)this.compile(loader, compileList));
    }

    protected void save(String name, CompilationUnit unit, String pathToSave) {
        String fileName = pathToSave + "/" + name + ".java";
        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        writer.write(this.getAsString(unit));
        writer.close();
    }

    protected void testSingleWithBase(String basePrototype, String baseClassName, String prototype, String className, String baseClass, String baseInterface, String resClass, String resInterface) {
        List<Pair<String, String>> src = this.newList();
        this.load(src, basePrototype);
        this.load(src, prototype);
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), src));
        this.generate();
        Assert.assertEquals((long)2L, (long)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list = this.newList();
        Tools.with(Helpers.lookup.findGenerated(baseClassName), parsed -> {
            this.compare(parsed.getFiles().get(0), baseClass);
            this.compare(parsed.getFiles().get(1), baseInterface);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        });
        Tools.with(Helpers.lookup.findGenerated(className), parsed -> {
            this.compare(parsed.getFiles().get(0), resClass);
            this.compare(parsed.getFiles().get(1), resInterface);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        });
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list));
    }

    protected void testSingleWithMixIn(String basePrototype, String baseClassName, String prototype, String className, String baseClass, String baseInterface, String mixInInterface) {
        List<Pair<String, String>> src = this.newList();
        this.load(src, basePrototype);
        this.load(src, prototype);
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), src));
        this.generate();
        Assert.assertEquals((long)2L, (long)Helpers.lookup.parsed().size());
        List<Pair<String, String>> list = this.newList();
        Tools.with(Helpers.lookup.findGenerated(baseClassName), parsed -> Tools.with(Helpers.lookup.findGenerated(className), parsedMixIn -> {
            this.compare(parsed.getFiles().get(1), baseInterface);
            this.compare(parsedMixIn.getFiles().get(1), mixInInterface);
            this.compare(parsed.getFiles().get(0), baseClass);
            list.add(Pair.of((Object)parsed.getInterfaceFullName(), (Object)this.getAsString(parsed.getFiles().get(1))));
            list.add(Pair.of((Object)parsedMixIn.getInterfaceFullName(), (Object)this.getAsString(parsedMixIn.getFiles().get(1))));
            list.add(Pair.of((Object)parsed.getParsedFullName(), (Object)this.getAsString(parsed.getFiles().get(0))));
        }));
        Assert.assertTrue((boolean)this.compile(new TestClassLoader(), list));
    }

    protected boolean compile(TestClassLoader loader, List<Pair<String, String>> files) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        Map<String, JavaByteObject> objects = files.stream().collect(Collectors.toMap(Pair::getKey, f -> new JavaByteObject((String)f.getKey())));
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        JavaFileManager fileManager = BaseTest.createFileManager(loader, standardFileManager, objects);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, BaseTest.getCompilationUnits(files));
        if (!task.call().booleanValue()) {
            diagnostics.getDiagnostics().forEach(System.out::println);
            fileManager.close();
            return false;
        }
        fileManager.close();
        files.forEach(f -> Tools.with((JavaByteObject)objects.get(f.getKey()), o -> loader.define((String)f.getKey(), (JavaByteObject)o)));
        return true;
    }

    private String resourceAsString(String resource) {
        try {
            return new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource(resource).toURI())));
        }
        catch (Exception e) {
            log.error("Unable to load resource: {}!", (Object)resource);
            throw e;
        }
    }

    private static JavaFileManager createFileManager(ClassLoader loader, StandardJavaFileManager fileManager, final Map<String, JavaByteObject> files) {
        return new ForwardingJavaFileManager<StandardJavaFileManager>(fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
                int pos = className.indexOf(36);
                if (pos > -1) {
                    files.put(className, new JavaByteObject(className));
                }
                return (JavaFileObject)files.get(className);
            }
        };
    }

    public static Iterable<? extends JavaFileObject> getCompilationUnits(List<Pair<String, String>> files) {
        return files.stream().map(f -> new JavaSourceObject((String)f.getKey(), (String)f.getValue())).collect(Collectors.toList());
    }

    protected List<Pair<String, String>> newList() {
        return new ArrayList<Pair<String, String>>();
    }
}

