/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import net.binis.codegen.annotation.CodePrototype;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompiledPrototypesHandler {
    private static final Logger log = LoggerFactory.getLogger(CompiledPrototypesHandler.class);

    private CompiledPrototypesHandler() {
    }

    public static void handleCompiledPrototype(String compiledPrototype) {
        Tools.notNull(Reflection.loadClass((String)compiledPrototype), c -> Tools.notNull(c.getAnnotation(CodePrototype.class), ann -> {
            ClassOrInterfaceDeclaration declaration = new CompilationUnit().setPackageDeclaration(c.getPackageName()).addClass(c.getSimpleName()).setInterface(true);
            CompiledPrototypesHandler.handleAnnotations(c, declaration);
            CompiledPrototypesHandler.handleFields(c, declaration);
            Structures.Parsed.ParsedBuilder parsed = Structures.Parsed.builder().compiled((Class<?>)c).parser(Helpers.lookup.getParser()).declaration(declaration);
            Helpers.lookup.registerParsed(compiledPrototype, parsed.build());
            Generator.generateCodeForClass((CompilationUnit)declaration.findCompilationUnit().get());
        }));
    }

    private static void handleFields(Class<?> c, ClassOrInterfaceDeclaration declaration) {
        for (Method method : c.getDeclaredMethods()) {
            if (method.isDefault() || method.getParameterCount() != 0 || Void.class.equals(method.getReturnType())) continue;
            ((MethodDeclaration)declaration.addMethod(method.getName(), new Modifier.Keyword[0]).setType(method.getReturnType().getSimpleName())).setBody(null);
            if (!method.getReturnType().isPrimitive()) continue;
            ((CompilationUnit)declaration.findCompilationUnit().get()).addImport(method.getReturnType().getCanonicalName());
        }
    }

    private static void handleAnnotations(Class<?> cls, ClassOrInterfaceDeclaration declaration) {
        for (Annotation ann : cls.getAnnotations()) {
            Helpers.lookup.getParser().parseAnnotation(ann.toString()).getResult().ifPresent(annotation -> {
                ((CompilationUnit)declaration.findCompilationUnit().get()).addImport(ann.annotationType().getCanonicalName());
                annotation.setName(ann.annotationType().getSimpleName());
                declaration.addAnnotation(annotation);
            });
        }
    }
}

