/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.utils.StringEscapeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.binis.codegen.annotation.validation.AliasFor;
import net.binis.codegen.annotation.validation.AsCode;
import net.binis.codegen.annotation.validation.Execute;
import net.binis.codegen.annotation.validation.Sanitize;
import net.binis.codegen.annotation.validation.Validate;
import net.binis.codegen.enrich.ValidationEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationEnricherHandler
extends BaseEnricher
implements ValidationEnricher {
    private static final Logger log = LoggerFactory.getLogger(ValidationEnricherHandler.class);
    private static final String VALUE = "value";
    private static final String PARAMS = "params";
    private static final String MESSAGE = "message";
    private static final String AS_CODE = "asCode";

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        description.getFields().forEach(f -> this.handleField(description, (PrototypeField)f));
    }

    @Override
    public int order() {
        return 0;
    }

    private void handleField(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field) {
        field.getDescription().getAnnotations().stream().filter(this::isValidationAnnotation).forEach(a -> this.processAnnotation(description, field, (AnnotationExpr)a));
    }

    private void processAnnotation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation) {
        String name = Helpers.getExternalClassNameIfExists((CompilationUnit)annotation.findCompilationUnit().get(), annotation.getNameAsString());
        Tools.notNull(Reflection.loadClass((String)name), cls -> {
            if (Validate.class.equals(cls) || cls.isAnnotationPresent(Validate.class)) {
                this.generateValidation(description, field, annotation, (Class<?>)cls);
            } else if (Sanitize.class.equals(cls) || cls.isAnnotationPresent(Sanitize.class)) {
                this.generateSanitization(description, field, annotation, (Class<?>)cls);
            } else if (Execute.class.equals(cls) || cls.isAnnotationPresent(Execute.class)) {
                this.generateExecution(description, field, annotation, (Class<?>)cls);
            }
        });
    }

    private void generateSanitization(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params ann = this.getSanitizationParams(field, annotation, annotationClass);
        if (Objects.isNull(field.getImplementationSetter())) {
            field.generateSetter();
        }
        this.addSanitization(field, field.getImplementationSetter(), ann, ModifierType.MAIN);
        field.getModifiers().forEach(modifier -> this.addSanitization(field, (MethodDeclaration)modifier, ann, ModifierType.MODIFIER));
        this.handleSanitizationModifier(description, field, "EmbeddedModifier", ann);
    }

    private Params getSanitizationParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        String cls = null;
        Params.ParamsBuilder params = Params.builder();
        if (!Sanitize.class.equals(annotationClass)) {
            Sanitize ann = annotationClass.getDeclaredAnnotation(Sanitize.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params()));
            cls = ann.value().getCanonicalName();
            ((CompilationUnit)field.getDeclaration().findCompilationUnit().get()).addImport(cls);
            this.handleAliases(annotation, annotationClass, params);
        } else {
            for (Node node : annotation.getChildNodes()) {
                if (node instanceof ClassExpr) {
                    params.cls(((ClassExpr)node).getTypeAsString());
                    continue;
                }
                if (!(node instanceof MemberValuePair)) continue;
                MemberValuePair pair = (MemberValuePair)node;
                switch (pair.getNameAsString()) {
                    case "value": {
                        params.cls(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                    case "params": {
                        params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                        break;
                    }
                    case "asCode": {
                        params.asCode(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                }
            }
        }
        Params result = params.build();
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass((String)(Objects.isNull(cls) ? Helpers.getExternalClassName((CompilationUnit)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls)), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    private Params getValidationParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        String cls = null;
        if (!Validate.class.equals(annotationClass)) {
            Validate ann = annotationClass.getDeclaredAnnotation(Validate.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params()));
            cls = ann.value().getCanonicalName();
            ((CompilationUnit)field.getDeclaration().findCompilationUnit().get()).addImport(cls);
            this.handleAliases(annotation, annotationClass, params);
        } else {
            for (Node node : annotation.getChildNodes()) {
                if (node instanceof ClassExpr) {
                    params.cls(((ClassExpr)node).getTypeAsString());
                    continue;
                }
                if (!(node instanceof MemberValuePair)) continue;
                MemberValuePair pair = (MemberValuePair)node;
                switch (pair.getNameAsString()) {
                    case "value": {
                        params.cls(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                    case "message": {
                        params.message(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "params": {
                        params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                        break;
                    }
                    case "asCode": {
                        params.asCode(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                }
            }
        }
        Params result = params.build();
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass((String)(Objects.isNull(cls) ? Helpers.getExternalClassName((CompilationUnit)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls)), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    private void handleAliases(AnnotationExpr annotation, Class<?> annotationClass, Params.ParamsBuilder params) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Triple<String, Object, AsCode>> parOrder = Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).filter(a -> a.annotationType().isAssignableFrom(AliasFor.class)).map(AliasFor.class::cast).anyMatch(a -> PARAMS.equals(a.value()))).map(m -> Triple.of((Object)m.getName(), (Object)m.getDefaultValue(), (Object)m.getDeclaredAnnotation(AsCode.class))).collect(Collectors.toList());
        Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> MESSAGE.equals(m.getName())).filter(m -> m.getReturnType().equals(String.class)).filter(m -> Objects.isNull(m.getDeclaredAnnotation(AliasFor.class))).findFirst().ifPresent(m -> params.message((String)m.getDefaultValue()));
        parOrder.forEach(p -> list.add(this.checkAsCode(p.getMiddle(), (AsCode)p.getRight())));
        for (Node node : annotation.getChildNodes()) {
            int idx;
            if (node instanceof MemberValuePair) {
                MemberValuePair pair = (MemberValuePair)node;
                switch (Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getName().equals(pair.getNameAsString())).map(m -> m.getDeclaredAnnotation(AliasFor.class)).filter(Objects::nonNull).map(AliasFor::value).findFirst().orElseGet(() -> ((MemberValuePair)pair).getNameAsString())) {
                    case "value": {
                        params.cls(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                    case "message": {
                        params.message(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "asCode": {
                        params.asCode(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "params": {
                        if (pair.getValue().isArrayInitializerExpr()) {
                            list.addAll(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                            break;
                        }
                        idx = this.getParamIndex(parOrder, pair.getNameAsString());
                        if (idx != -1) {
                            list.set(idx, this.getParamValue(pair.getValue()));
                            break;
                        }
                        throw new GenericCodeGenException("Invalid annotation params! " + annotation);
                    }
                }
                continue;
            }
            if (!(node instanceof StringLiteralExpr)) continue;
            String exp = ((StringLiteralExpr)node).asString();
            switch (Arrays.stream(annotationClass.getDeclaredMethods()).filter(m -> m.getName().equals(VALUE)).map(m -> m.getDeclaredAnnotation(AliasFor.class)).filter(Objects::nonNull).map(AliasFor::value).findFirst().orElse(VALUE)) {
                case "value": {
                    params.cls(exp);
                    break;
                }
                case "message": {
                    params.message(exp);
                    break;
                }
                case "asCode": {
                    params.asCode(exp);
                    break;
                }
                case "params": {
                    idx = this.getParamIndex(parOrder, VALUE);
                    if (idx != -1) {
                        Triple<String, Object, AsCode> triple = parOrder.get(idx);
                        if (Objects.nonNull(triple.getRight())) {
                            list.set(idx, this.checkAsCode(exp, (AsCode)triple.getRight()));
                            break;
                        }
                        list.set(idx, exp);
                        break;
                    }
                    throw new GenericCodeGenException("Invalid annotation params! " + annotation);
                }
            }
        }
        if (!list.isEmpty()) {
            params.params(list);
        }
    }

    private Object checkAsCode(Object value, AsCode code) {
        if (Objects.nonNull(code)) {
            return AsCodeHolder.builder().value((String)value).format(code.value()).build();
        }
        return value;
    }

    private Object getParamValue(Expression value) {
        if (value.isStringLiteralExpr()) {
            return value.asStringLiteralExpr().asString();
        }
        if (value.isIntegerLiteralExpr()) {
            return value.asIntegerLiteralExpr().asNumber();
        }
        if (value.isDoubleLiteralExpr()) {
            return value.asDoubleLiteralExpr().asDouble();
        }
        if (value.isBooleanLiteralExpr()) {
            return value.asBooleanLiteralExpr().getValue();
        }
        return null;
    }

    private int getParamIndex(List<Triple<String, Object, AsCode>> list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(list.get(i).getLeft())) continue;
            return i;
        }
        return -1;
    }

    private void generateValidation(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params ann = this.getValidationParams(field, annotation, annotationClass);
        if (Objects.isNull(field.getImplementationSetter())) {
            field.generateSetter();
        }
        this.addValidation(field, field.getImplementationSetter(), ann, ModifierType.MAIN);
        field.getModifiers().forEach(modifier -> this.addValidation(field, (MethodDeclaration)modifier, ann, ModifierType.MODIFIER));
        this.handleValidationModifier(description, field, "EmbeddedModifier", ann);
    }

    private void handleValidationModifier(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, String key, Params params) {
        ClassOrInterfaceDeclaration modifier = description.getRegisteredClass(key);
        if (Objects.nonNull(modifier)) {
            modifier.getChildNodes().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(m -> m.getNameAsString().equals(field.getName())).findFirst().ifPresent(m -> this.addValidation(field, (MethodDeclaration)m, params, ModifierType.EMBEDDED));
        }
    }

    private void addValidation(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier) {
        ((CompilationUnit)method.findCompilationUnit().get()).addImport("net.binis.codegen.validation.flow.Validation");
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        if (((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression() instanceof AssignExpr) {
            StringBuilder exp = new StringBuilder("Validation.start(\"").append(field.getName()).append("\", ").append(field.getName()).append(").validate(").append(params.getCls()).append(".class, ").append(this.calcMessage(params)).append(this.buildParamsStr(params, field, modifier)).append(").perform(v -> this.map = v);");
            Statement expr = (Statement)this.lookup.getParser().parseStatement(exp.toString()).getResult().get();
            Statement original = (Statement)block.getStatements().remove(0);
            ((ExpressionStmt)original).getExpression().asAssignExpr().setValue((Expression)new NameExpr("v"));
            MethodCallExpr mCall = expr.asExpressionStmt().getExpression().asMethodCallExpr();
            ((LambdaExpr)mCall.getChildNodes().get(mCall.getChildNodes().size() - 1)).setBody(original);
            block.getStatements().add(0, (Node)expr);
        } else {
            MethodCallExpr mCall = ((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression().asMethodCallExpr();
            Expression chain = (Expression)mCall.getScope().get();
            mCall.removeScope();
            MethodCallExpr m = (MethodCallExpr)((MethodCallExpr)new MethodCallExpr(chain, "validate").addArgument(params.getCls() + ".class")).addArgument(this.calcMessage(params));
            Tools.notNull(params.getParams(), p -> p.forEach(param -> m.addArgument(this.buildParamsStr(param, params, field, modifier))));
            mCall.setScope((Expression)m);
        }
    }

    private String calcMessage(Params params) {
        return Objects.isNull(params.getMessage()) ? "null" : "\"" + StringEscapeUtils.escapeJava((String)params.getMessage()) + "\"";
    }

    private void handleSanitizationModifier(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, String key, Params params) {
        ClassOrInterfaceDeclaration modifier = description.getRegisteredClass(key);
        if (Objects.nonNull(modifier)) {
            modifier.getChildNodes().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(m -> m.getNameAsString().equals(field.getName())).findFirst().ifPresent(m -> this.addSanitization(field, (MethodDeclaration)m, params, ModifierType.EMBEDDED));
        }
    }

    private void addSanitization(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier) {
        ((CompilationUnit)method.findCompilationUnit().get()).addImport("net.binis.codegen.validation.flow.Validation");
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        if (((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression() instanceof AssignExpr) {
            StringBuilder exp = new StringBuilder("Validation.start(\"").append(field.getName()).append("\", ").append(field.getName()).append(").sanitize(").append(params.getCls()).append(".class").append(this.buildParamsStr(params, field, modifier)).append(").perform(v -> this.map = v);");
            Statement expr = (Statement)this.lookup.getParser().parseStatement(exp.toString()).getResult().get();
            Statement original = (Statement)block.getStatements().remove(0);
            ((ExpressionStmt)original).getExpression().asAssignExpr().setValue((Expression)new NameExpr("v"));
            MethodCallExpr mCall = expr.asExpressionStmt().getExpression().asMethodCallExpr();
            ((LambdaExpr)mCall.getChildNodes().get(mCall.getChildNodes().size() - 1)).setBody(original);
            block.getStatements().add(0, (Node)expr);
        } else {
            MethodCallExpr mCall = ((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression().asMethodCallExpr();
            Expression chain = (Expression)mCall.getScope().get();
            mCall.removeScope();
            MethodCallExpr m = (MethodCallExpr)((MethodCallExpr)new MethodCallExpr(chain, "sanitize").addArgument(params.getCls() + ".class")).addArgument(this.calcMessage(params));
            Tools.notNull(params.getParams(), p -> p.forEach(param -> m.addArgument(this.buildParamsStr(param, params, field, modifier))));
            mCall.setScope((Expression)m);
        }
    }

    private void generateExecution(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params ann = this.getExecutionParams(field, annotation, annotationClass);
        if (Objects.isNull(field.getImplementationSetter())) {
            field.generateSetter();
        }
        this.addExecution(field, field.getImplementationSetter(), ann, ModifierType.MAIN);
        field.getModifiers().forEach(modifier -> this.addExecution(field, (MethodDeclaration)modifier, ann, ModifierType.MODIFIER));
        this.handleExecutionModifier(description, field, "EmbeddedModifier", ann);
    }

    private void handleExecutionModifier(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeField field, String key, Params params) {
        ClassOrInterfaceDeclaration modifier = description.getRegisteredClass(key);
        if (Objects.nonNull(modifier)) {
            modifier.getChildNodes().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(m -> m.getNameAsString().equals(field.getName())).findFirst().ifPresent(m -> this.addExecution(field, (MethodDeclaration)m, params, ModifierType.EMBEDDED));
        }
    }

    private void addExecution(PrototypeField field, MethodDeclaration method, Params params, ModifierType modifier) {
        ((CompilationUnit)method.findCompilationUnit().get()).addImport("net.binis.codegen.validation.flow.Validation");
        BlockStmt block = method.getChildNodes().stream().filter(BlockStmt.class::isInstance).map(BlockStmt.class::cast).findFirst().get();
        if (((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression() instanceof AssignExpr) {
            StringBuilder exp = new StringBuilder("Validation.start(\"").append(field.getName()).append("\", ").append(field.getName()).append(").execute(").append(params.getCls()).append(".class, ").append(this.calcMessage(params)).append(this.buildParamsStr(params, field, modifier)).append(").perform(v -> this.map = v);");
            Statement expr = (Statement)this.lookup.getParser().parseStatement(exp.toString()).getResult().get();
            Statement original = (Statement)block.getStatements().remove(0);
            ((ExpressionStmt)original).getExpression().asAssignExpr().setValue((Expression)new NameExpr("v"));
            MethodCallExpr mCall = expr.asExpressionStmt().getExpression().asMethodCallExpr();
            ((LambdaExpr)mCall.getChildNodes().get(mCall.getChildNodes().size() - 1)).setBody(original);
            block.getStatements().add(0, (Node)expr);
        } else {
            MethodCallExpr mCall = ((Statement)block.getStatements().get(0)).asExpressionStmt().getExpression().asMethodCallExpr();
            Expression chain = (Expression)mCall.getScope().get();
            mCall.removeScope();
            MethodCallExpr m = (MethodCallExpr)((MethodCallExpr)new MethodCallExpr(chain, "execute").addArgument(params.getCls() + ".class")).addArgument(this.calcMessage(params));
            Tools.notNull(params.getParams(), p -> p.forEach(param -> m.addArgument(this.buildParamsStr(param, params, field, modifier))));
            mCall.setScope((Expression)m);
        }
    }

    private Params getExecutionParams(PrototypeField field, AnnotationExpr annotation, Class<?> annotationClass) {
        Params.ParamsBuilder params = Params.builder();
        String cls = null;
        if (!Execute.class.equals(annotationClass)) {
            Execute ann = annotationClass.getDeclaredAnnotation(Execute.class);
            params.cls(ann.value().getSimpleName()).params(Arrays.asList(ann.params()));
            cls = ann.value().getCanonicalName();
            ((CompilationUnit)field.getDeclaration().findCompilationUnit().get()).addImport(cls);
            this.handleAliases(annotation, annotationClass, params);
        } else {
            for (Node node : annotation.getChildNodes()) {
                if (node instanceof ClassExpr) {
                    params.cls(((ClassExpr)node).getTypeAsString());
                    continue;
                }
                if (!(node instanceof MemberValuePair)) continue;
                MemberValuePair pair = (MemberValuePair)node;
                switch (pair.getNameAsString()) {
                    case "value": {
                        params.cls(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                    case "message": {
                        params.message(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "params": {
                        params.params(pair.getValue().asArrayInitializerExpr().getValues().stream().map(Expression::asStringLiteralExpr).map(StringLiteralExpr::asString).collect(Collectors.toList()));
                        break;
                    }
                    case "asCode": {
                        params.asCode(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                }
            }
        }
        Params result = params.build();
        if (Objects.isNull(result.getAsCode())) {
            Tools.notNull(Reflection.loadClass((String)(Objects.isNull(cls) ? Helpers.getExternalClassName((CompilationUnit)field.getParsed().getDeclaration().findCompilationUnit().get(), result.getCls()) : cls)), c -> Tools.notNull(c.getDeclaredAnnotation(AsCode.class), a -> result.setAsCode(a.value())));
        }
        return result;
    }

    private String buildParamsStr(Params params, PrototypeField field, ModifierType modifier) {
        List<Object> list = params.getParams();
        if (Objects.isNull(list) || list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Object param : list) {
            if (param instanceof String) {
                result.append(", \"").append(StringEscapeUtils.escapeJava((String)((String)param))).append("\"");
                continue;
            }
            if (param instanceof AsCodeHolder) {
                AsCodeHolder holder = (AsCodeHolder)param;
                String format = "%s".equals(holder.getFormat()) && !StringUtils.isBlank((CharSequence)params.getAsCode()) ? params.getAsCode() : holder.getFormat();
                result.append(", ").append(String.format(format.replaceAll("\\{type}", field.getDeclaration().getVariable(0).getTypeAsString()), holder.getValue().replaceAll("\\{entity}", modifier.getValue())));
                continue;
            }
            result.append(", ").append(Objects.nonNull(param) ? param.toString() : "null");
        }
        return result.toString();
    }

    private String buildParamsStr(Object param, Params params, PrototypeField field, ModifierType modifier) {
        if (param instanceof String) {
            return "\"" + StringEscapeUtils.escapeJava((String)((String)param)) + "\"";
        }
        if (param instanceof AsCodeHolder) {
            AsCodeHolder holder = (AsCodeHolder)param;
            String format = "%s".equals(holder.getFormat()) && !StringUtils.isBlank((CharSequence)params.getAsCode()) ? params.getAsCode() : holder.getFormat();
            return String.format(format.replaceAll("\\{type}", field.getDeclaration().getVariable(0).getTypeAsString()), holder.getValue());
        }
        return Objects.nonNull(param) ? param.toString() : "null";
    }

    private boolean isValidationAnnotation(AnnotationExpr annotation) {
        return Tools.withRes(Reflection.loadClass((String)Helpers.getExternalClassNameIfExists((CompilationUnit)annotation.findCompilationUnit().get(), annotation.getNameAsString())), cls -> Validate.class.equals(cls) || cls.isAnnotationPresent(Validate.class) || Sanitize.class.equals(cls) || cls.isAnnotationPresent(Sanitize.class) || Execute.class.equals(cls) || cls.isAnnotationPresent(Execute.class), false);
    }

    private static class Params {
        private String cls;
        private String message;
        private List<Object> params;
        private String asCode;

        Params(String cls, String message, List<Object> params, String asCode) {
            this.cls = cls;
            this.message = message;
            this.params = params;
            this.asCode = asCode;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public String getCls() {
            return this.cls;
        }

        public String getMessage() {
            return this.message;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public String getAsCode() {
            return this.asCode;
        }

        public void setCls(String cls) {
            this.cls = cls;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }

        public void setAsCode(String asCode) {
            this.asCode = asCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Params)) {
                return false;
            }
            Params other = (Params)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cls = this.getCls();
            String other$cls = other.getCls();
            if (this$cls == null ? other$cls != null : !this$cls.equals(other$cls)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            List<Object> this$params = this.getParams();
            List<Object> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            String this$asCode = this.getAsCode();
            String other$asCode = other.getAsCode();
            return !(this$asCode == null ? other$asCode != null : !this$asCode.equals(other$asCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Params;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cls = this.getCls();
            result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            List<Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            String $asCode = this.getAsCode();
            result = result * 59 + ($asCode == null ? 43 : $asCode.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.Params(cls=" + this.getCls() + ", message=" + this.getMessage() + ", params=" + this.getParams() + ", asCode=" + this.getAsCode() + ")";
        }

        public static class ParamsBuilder {
            private String cls;
            private String message;
            private List<Object> params;
            private String asCode;

            ParamsBuilder() {
            }

            public ParamsBuilder cls(String cls) {
                this.cls = cls;
                return this;
            }

            public ParamsBuilder message(String message) {
                this.message = message;
                return this;
            }

            public ParamsBuilder params(List<Object> params) {
                this.params = params;
                return this;
            }

            public ParamsBuilder asCode(String asCode) {
                this.asCode = asCode;
                return this;
            }

            public Params build() {
                return new Params(this.cls, this.message, this.params, this.asCode);
            }

            public String toString() {
                return "ValidationEnricherHandler.Params.ParamsBuilder(cls=" + this.cls + ", message=" + this.message + ", params=" + this.params + ", asCode=" + this.asCode + ")";
            }
        }
    }

    private static enum ModifierType {
        MAIN("this"),
        MODIFIER("parent"),
        EMBEDDED("entity");

        private String value;

        private ModifierType(String s) {
            this.value = s;
        }

        String getValue() {
            return this.value;
        }
    }

    private static class AsCodeHolder {
        private String value;
        private String format;

        AsCodeHolder(String value, String format) {
            this.value = value;
            this.format = format;
        }

        public static AsCodeHolderBuilder builder() {
            return new AsCodeHolderBuilder();
        }

        public String getValue() {
            return this.value;
        }

        public String getFormat() {
            return this.format;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsCodeHolder)) {
                return false;
            }
            AsCodeHolder other = (AsCodeHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsCodeHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationEnricherHandler.AsCodeHolder(value=" + this.getValue() + ", format=" + this.getFormat() + ")";
        }

        public static class AsCodeHolderBuilder {
            private String value;
            private String format;

            AsCodeHolderBuilder() {
            }

            public AsCodeHolderBuilder value(String value) {
                this.value = value;
                return this;
            }

            public AsCodeHolderBuilder format(String format) {
                this.format = format;
                return this;
            }

            public AsCodeHolder build() {
                return new AsCodeHolder(this.value, this.format);
            }

            public String toString() {
                return "ValidationEnricherHandler.AsCodeHolder.AsCodeHolderBuilder(value=" + this.value + ", format=" + this.format + ")";
            }
        }
    }
}

