/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.ClassExpr;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.tools.Tools;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGen {
    private static final Logger log = LoggerFactory.getLogger(CodeGen.class);
    public static final String NONE = "<none>";
    public static final String SOURCE = "source";
    public static final String DESTINATION = "destination";
    public static final String IMPL_DESTINATION = "idestination";
    public static final String FILTER = "filter";

    public static void main(String[] args) throws IOException {
        log.info("Class path: {}", (Object)System.getProperty("java.class.path"));
        CommandLine cmd = CodeGen.handleArgs(args);
        ArrayList<Path> files = new ArrayList<Path>();
        CodeGen.addTree(Paths.get(cmd.getOptionValue(SOURCE), new String[0]), files, cmd.getOptionValue(FILTER));
        CodeGen.processFiles(files);
        Helpers.enumParsed.values().stream().filter(v -> Objects.nonNull(v.getFiles())).forEach(p -> {
            if (Objects.isNull(p.getProperties().getMixInClass())) {
                CodeGen.saveFile(CodeGen.getBasePath(cmd.getOptionValue(DESTINATION), p.getProperties()), p.getFiles().get(0));
            }
        });
        CompilationUnit constants = Generator.generateCodeForConstants();
        if (Objects.nonNull(constants)) {
            CodeGen.saveFile(cmd.getOptionValue(DESTINATION), constants);
        }
        String destination = cmd.getOptionValue(DESTINATION);
        String impl_destination = cmd.getOptionValue(IMPL_DESTINATION);
        Helpers.lookup.parsed().stream().filter(v -> Objects.nonNull(v.getFiles())).forEach(p -> {
            if (p.getProperties().isGenerateImplementation() && Objects.isNull(p.getProperties().getMixInClass())) {
                CodeGen.saveFile(Tools.nullCheck(CodeGen.getBasePath(impl_destination, p.getProperties()), destination), p.getFiles().get(0));
            }
            if (p.getProperties().isGenerateInterface()) {
                CodeGen.saveFile(CodeGen.getBasePath(destination, p.getProperties()), p.getFiles().get(1));
            }
        });
    }

    public static void processFiles(List<Path> files) {
        JavaParser parser = new JavaParser();
        for (Path path : files) {
            try {
                String fileName = path.toAbsolutePath().toString();
                ParseResult parse = parser.parse(path);
                log.info("Parsed {} - {}", (Object)fileName, (Object)parse.toString());
                parse.getResult().ifPresent(u -> u.getTypes().forEach(t -> CodeGen.handleType(parser, t, fileName)));
            }
            catch (IOException e) {
                log.error("Unable to parse {}", (Object)path.getFileName(), (Object)e);
            }
        }
        for (Map.Entry entry : Helpers.enumParsed.entrySet()) {
            Tools.ifNull(((PrototypeDescription)entry.getValue()).getFiles(), () -> Generator.generateCodeForEnum((CompilationUnit)((PrototypeDescription)entry.getValue()).getDeclaration().findCompilationUnit().get()));
        }
        for (PrototypeDescription prototypeDescription : Helpers.lookup.parsed()) {
            Tools.ifNull(prototypeDescription.getFiles(), () -> Generator.generateCodeForClass((CompilationUnit)prototypeDescription.getDeclaration().findCompilationUnit().get()));
        }
        Helpers.recursiveExpr.forEach(pair -> ((ClassExpr)pair.getRight()).setType(Helpers.findProperType((PrototypeDescription)pair.getLeft(), (CompilationUnit)pair.getMiddle(), (ClassExpr)pair.getRight())));
        Helpers.lookup.calcPrototypeMaps();
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.isNull(p.getBase()) && Objects.isNull(p.getMixIn())).forEach(Helpers::handleEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.nonNull(p.getBase()) || Objects.nonNull(p.getMixIn())).forEach(Helpers::handleEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.isNull(p.getBase()) && Objects.isNull(p.getMixIn())).forEach(Helpers::finalizeEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.nonNull(p.getBase()) || Objects.nonNull(p.getMixIn())).forEach(Helpers::finalizeEnrichers);
    }

    public static void processSources(List<String> files) {
        JavaParser parser = new JavaParser();
        for (String string : files) {
            try {
                ParseResult parse = parser.parse(string);
                CompilationUnit unit = (CompilationUnit)parse.getResult().get();
                String fileName = ((PackageDeclaration)unit.getPackageDeclaration().get()).getNameAsString().replace('.', '/') + unit.getType(0).getNameAsString();
                log.info("Parsed {} - {}", (Object)fileName, (Object)parse);
                parse.getResult().ifPresent(u -> u.getTypes().forEach(t -> CodeGen.handleType(parser, t, fileName)));
            }
            catch (Exception e) {
                log.error("Unable to parse {}", (Object)string, (Object)e);
            }
        }
        for (Map.Entry entry : Helpers.enumParsed.entrySet()) {
            Tools.ifNull(((PrototypeDescription)entry.getValue()).getFiles(), () -> Generator.generateCodeForEnum((CompilationUnit)((PrototypeDescription)entry.getValue()).getDeclaration().findCompilationUnit().get()));
        }
        for (PrototypeDescription prototypeDescription : Helpers.lookup.parsed()) {
            Tools.ifNull(prototypeDescription.getFiles(), () -> Generator.generateCodeForClass((CompilationUnit)prototypeDescription.getDeclaration().findCompilationUnit().get()));
        }
        Helpers.recursiveExpr.forEach(pair -> ((ClassExpr)pair.getRight()).setType(Helpers.findProperType((PrototypeDescription)pair.getLeft(), (CompilationUnit)pair.getMiddle(), (ClassExpr)pair.getRight())));
        Helpers.lookup.calcPrototypeMaps();
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.isNull(p.getBase()) && Objects.isNull(p.getMixIn())).forEach(Helpers::handleEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.nonNull(p.getBase()) || Objects.nonNull(p.getMixIn())).forEach(Helpers::handleEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.isNull(p.getBase()) && Objects.isNull(p.getMixIn())).forEach(Helpers::finalizeEnrichers);
        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isValid).filter(p -> Objects.nonNull(p.getBase()) || Objects.nonNull(p.getMixIn())).forEach(Helpers::finalizeEnrichers);
    }

    public static void handleType(JavaParser parser, TypeDeclaration<?> t, String fileName) {
        String className = ((PackageDeclaration)((CompilationUnit)t.findCompilationUnit().get()).getPackageDeclaration().get()).getNameAsString() + "." + t.getNameAsString();
        if (t.isEnumDeclaration()) {
            Helpers.enumParsed.put(Helpers.getClassName(t.asEnumDeclaration()), Structures.Parsed.builder().declaration(t.asTypeDeclaration()).prototypeFileName(fileName).prototypeClassName(className).parser(parser).build());
        } else if (t.getAnnotationByName("ConstantPrototype").isPresent()) {
            Helpers.constantParsed.put(Helpers.getClassName(t.asClassOrInterfaceDeclaration()), Structures.Parsed.builder().declaration(t.asTypeDeclaration()).prototypeFileName(fileName).prototypeClassName(className).parser(parser).build());
        } else {
            String name = Helpers.getClassName(t.asClassOrInterfaceDeclaration());
            CodeGen.checkForNestedClasses(t.asTypeDeclaration(), fileName, className, parser);
            Helpers.lookup.registerParsed(name, Structures.Parsed.builder().declaration(t.asTypeDeclaration()).prototypeFileName(fileName).prototypeClassName(className).parser(parser).build());
        }
    }

    public static void checkForNestedClasses(TypeDeclaration<?> type, String fileName, String className, JavaParser parser) {
        type.getChildNodes().stream().filter(ClassOrInterfaceDeclaration.class::isInstance).map(ClassOrInterfaceDeclaration.class::cast).forEach(nested -> {
            if (nested.asClassOrInterfaceDeclaration().isInterface() && Generator.getCodeAnnotation(nested).isPresent()) {
                CompilationUnit parent = (CompilationUnit)type.findCompilationUnit().get();
                CompilationUnit unit = new CompilationUnit().setPackageDeclaration((PackageDeclaration)parent.getPackageDeclaration().get());
                ClassOrInterfaceDeclaration nestedType = nested.clone();
                parent.getImports().forEach(arg_0 -> ((CompilationUnit)unit).addImport(arg_0));
                unit.addType((TypeDeclaration)nestedType);
                Helpers.lookup.registerParsed(Helpers.getClassName(nestedType), Structures.Parsed.builder().declaration(nestedType.asTypeDeclaration()).prototypeFileName(fileName).prototypeClassName(className).parser(parser).nested(true).build());
            }
        });
    }

    private static void saveFile(String baseDir, CompilationUnit file) {
        CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
        Helpers.sortImports(file);
        if (file.getType(0).isClassOrInterfaceDeclaration()) {
            Helpers.sortClass(file.getType(0).asClassOrInterfaceDeclaration());
        }
        file.getPackageDeclaration().ifPresent(p -> {
            String fileName = baseDir + "/" + p.getNameAsString().replace(".", "/") + "/" + file.getType(0).getNameAsString() + ".java";
            log.info("Writing file - {}", (Object)fileName);
            File f = new File(fileName);
            if (f.getParentFile().exists() || f.getParentFile().mkdirs()) {
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                    writer.write(printer.print((Node)file));
                    writer.close();
                }
                catch (IOException e) {
                    log.error("Unable to open for write file {}", (Object)fileName);
                }
            } else {
                log.error("Unable to write file {}", (Object)fileName);
            }
        });
    }

    private static void addTree(Path directory, final Collection<Path> all, String filter) throws IOException {
        final PathMatcher pm = FileSystems.getDefault().getPathMatcher("glob:" + Tools.nullCheck(filter, "**"));
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!file.toFile().isDirectory() && pm.matches(file)) {
                    all.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static CommandLine handleArgs(String[] args) {
        Options options = new Options();
        Option input = new Option("s", SOURCE, true, "Sources root folder");
        input.setRequired(true);
        options.addOption(input);
        Option output = new Option("d", DESTINATION, true, "Destination folder");
        output.setRequired(true);
        options.addOption(output);
        Option iOutput = new Option("id", IMPL_DESTINATION, true, "Implementations Destination folder");
        iOutput.setRequired(false);
        options.addOption(iOutput);
        Option filter = new Option("f", FILTER, true, "File pattern filter");
        filter.setRequired(false);
        options.addOption(filter);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            log.info("source: " + Tools.nullCheck(cmd.getOptionValue(SOURCE), NONE));
            log.info("destination: " + Tools.nullCheck(cmd.getOptionValue(DESTINATION), NONE));
            log.info("implementations destination: " + Tools.nullCheck(cmd.getOptionValue(IMPL_DESTINATION), "<destination>"));
            log.info("filter: " + Tools.nullCheck(cmd.getOptionValue(FILTER), NONE));
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            formatter.printHelp("CodeGen", options);
            System.exit(1);
        }
        return cmd;
    }

    private static String getBasePath(String defaultPath, PrototypeData properties) {
        if (StringUtils.isNotBlank((CharSequence)properties.getBasePath())) {
            return properties.getBasePath();
        }
        return defaultPath;
    }
}

