/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import java.lang.annotation.Annotation;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.binis.codegen.annotation.CodeAnnotation;
import net.binis.codegen.annotation.CodeFieldAnnotations;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.annotation.Final;
import net.binis.codegen.annotation.ForImplementation;
import net.binis.codegen.annotation.ForInterface;
import net.binis.codegen.annotation.Ignore;
import net.binis.codegen.enrich.PrototypeEnricher;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.CollectionsHandler;
import net.binis.codegen.generation.core.CompiledPrototypesHandler;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    public static final String MIX_IN_EXTENSION = "$MixIn";

    private Generator() {
    }

    public static void generateCodeForClass(CompilationUnit parser) {
        for (TypeDeclaration type : parser.getTypes()) {
            if (!type.isClassOrInterfaceDeclaration() || !type.asClassOrInterfaceDeclaration().isInterface()) continue;
            Generator.getCodeAnnotation(type).ifPresent(prototype -> {
                ClassOrInterfaceDeclaration typeDeclaration = type.asClassOrInterfaceDeclaration();
                log.info("Processing - {}", (Object)typeDeclaration.getNameAsString());
                Structures.PrototypeDataHandler properties = Generator.getProperties(prototype);
                properties.setPrototypeName(typeDeclaration.getNameAsString());
                Helpers.addProcessingType(typeDeclaration.getNameAsString(), properties.getInterfacePackage(), properties.getInterfaceName(), properties.getClassPackage(), properties.getClassName());
                Generator.ensureParsedParents(typeDeclaration, (PrototypeData)properties);
                Helpers.handleEnrichersSetup(properties);
                CompilationUnit unit = new CompilationUnit();
                unit.addImport("javax.annotation.processing.Generated");
                ClassOrInterfaceDeclaration spec = unit.addClass(properties.getClassName());
                unit.setPackageDeclaration(properties.getClassPackage());
                spec.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
                if (properties.isGenerateConstructor()) {
                    spec.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
                }
                CompilationUnit iUnit = new CompilationUnit();
                iUnit.addImport("javax.annotation.processing.Generated");
                ClassOrInterfaceDeclaration intf = iUnit.addClass(properties.getInterfaceName()).setInterface(true);
                iUnit.setPackageDeclaration(properties.getInterfacePackage());
                intf.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
                Structures.Parsed parse = (Structures.Parsed)Helpers.lookup.findParsed(Helpers.getClassName(typeDeclaration));
                parse.setParsedName(spec.getNameAsString());
                parse.setParsedFullName((String)spec.getFullyQualifiedName().get());
                parse.setInterfaceName(intf.getNameAsString());
                parse.setInterfaceFullName((String)intf.getFullyQualifiedName().get());
                parse.setProperties(properties);
                parse.setFiles(List.of(unit, iUnit));
                parse.setSpec(spec);
                parse.setIntf(intf);
                spec.addAnnotation((AnnotationExpr)parse.getParser().parseAnnotation("@Generated(value=\"" + properties.getPrototypeName() + "\", comments=\"" + properties.getInterfaceName() + "\")").getResult().get());
                intf.addAnnotation((AnnotationExpr)parse.getParser().parseAnnotation("@Generated(value=\"" + properties.getPrototypeName() + "\", comments=\"" + properties.getClassName() + "\")").getResult().get());
                typeDeclaration.getExtendedTypes().forEach(t -> {
                    PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.getParsed(t);
                    if (Objects.nonNull(parsed) && parsed.getProperties().isBase()) {
                        properties.setBaseClassName(parsed.getParsedName());
                        if (!Objects.isNull(parse.getBase())) {
                            throw new GenericCodeGenException(parse.getDeclaration().getNameAsString() + " can't have more that one base class!");
                        }
                        parse.setBase((Structures.Parsed)parsed);
                        unit.addImport(parsed.getParsedFullName());
                        spec.addExtendedType(parsed.getParsedName());
                        if (parsed.getProperties().isGenerateConstructor() && properties.isGenerateConstructor()) {
                            spec.findFirst(ConstructorDeclaration.class).ifPresent(c -> c.getBody().addStatement("super();"));
                        }
                    }
                });
                typeDeclaration.getExtendedTypes().forEach(t -> {
                    PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.getParsed(t);
                    if (Objects.nonNull(parsed)) {
                        if (!parsed.getProperties().isBase() && !parsed.getProperties().getPrototypeName().equals(parse.getProperties().getMixInClass())) {
                            parsed.getFields().forEach(field -> {
                                MethodDeclaration method = field.getDescription().clone();
                                CompilationUnit dummy = Generator.envelopWithDummyClass(method);
                                field.getDescription().findCompilationUnit().ifPresent(u -> u.getImports().forEach(arg_0 -> ((CompilationUnit)dummy).addImport(arg_0)));
                                Generator.addField(parse, parsed.getDeclaration().asClassOrInterfaceDeclaration(), spec, method, Objects.nonNull(field.getGenerics()) ? field.getGenerics().values().iterator().next() : null);
                            });
                        }
                        if (Objects.isNull(properties.getMixInClass()) || !properties.getMixInClass().equals(t.toString())) {
                            if (!parsed.getProperties().isBase()) {
                                Generator.implementPrototype(parse, spec, parsed, null, false);
                            }
                            if (StringUtils.isNotBlank((CharSequence)parsed.getInterfaceName())) {
                                iUnit.addImport(parsed.getInterfaceFullName());
                                if (Objects.nonNull(properties.getMixInClass())) {
                                    intf.addExtendedType(parsed.getInterfaceName() + MIX_IN_EXTENSION);
                                } else {
                                    intf.addExtendedType(parsed.getInterfaceName());
                                }
                            }
                        } else {
                            parse.setMixIn((Structures.Parsed)parsed);
                        }
                    } else {
                        Generator.handleExternalInterface((Structures.Parsed<ClassOrInterfaceDeclaration>)parse, typeDeclaration, spec, intf, t);
                    }
                });
                if (Objects.nonNull(properties.getMixInClass()) && Objects.isNull(parse.getMixIn())) {
                    throw new GenericCodeGenException("Mix in Class " + properties.getPrototypeName() + " must inherit " + properties.getMixInClass());
                }
                if (properties.isGenerateInterface()) {
                    spec.addImplementedType(properties.getInterfaceName());
                    unit.addImport(Helpers.getClassName(intf));
                }
                for (BodyDeclaration member : type.getMembers()) {
                    if (member.isMethodDeclaration()) {
                        MethodDeclaration declaration = member.asMethodDeclaration();
                        if (!declaration.isDefault()) {
                            Structures.Ignores ignore = Helpers.getIgnores(member);
                            PrototypeField field = Structures.FieldData.builder().parsed(parse).build();
                            if (!ignore.isForField()) {
                                field = Generator.addField(parse, typeDeclaration, spec, declaration, null);
                            }
                            if (!ignore.isForClass()) {
                                if (properties.isClassGetters()) {
                                    Generator.addGetter(typeDeclaration, spec, declaration, true, field);
                                }
                                if (properties.isClassSetters()) {
                                    Generator.addSetter(typeDeclaration, spec, declaration, true, field);
                                }
                            }
                            if (ignore.isForInterface()) continue;
                            Generator.addGetter(typeDeclaration, intf, declaration, false, field);
                            if (!properties.isInterfaceSetters()) continue;
                            Generator.addSetter(typeDeclaration, intf, declaration, false, field);
                            continue;
                        }
                        Generator.handleDefaultMethod(parse, spec, intf, declaration);
                        continue;
                    }
                    if (member.isClassOrInterfaceDeclaration()) {
                        Generator.processInnerClass(parse, typeDeclaration, spec, member.asClassOrInterfaceDeclaration());
                        continue;
                    }
                    if (member.isFieldDeclaration()) {
                        Generator.processConstant(typeDeclaration, spec, intf, member.asFieldDeclaration());
                        continue;
                    }
                    log.error("Can't process method " + member.toString());
                }
                unit.setComment((Comment)new BlockComment("Generated code by Binis' code generator."));
                iUnit.setComment((Comment)new BlockComment("Generated code by Binis' code generator."));
                Helpers.lookup.registerGenerated(Helpers.getClassName(spec), parse);
                Generator.cleanUpInterface(typeDeclaration, intf);
                Generator.handleClassAnnotations(typeDeclaration, spec);
                Generator.checkForDeclaredConstants((Node)spec);
                Generator.checkForDeclaredConstants((Node)intf);
                Generator.checkForClassExpressions((Node)spec, typeDeclaration);
                Generator.checkForClassExpressions((Node)intf, typeDeclaration);
                Generator.handleMixin(parse);
                Helpers.handleImports(typeDeclaration, spec);
                Helpers.handleImports(typeDeclaration, intf);
                Helpers.processingTypes.remove(typeDeclaration.getNameAsString());
            });
        }
    }

    public static Optional<AnnotationExpr> getCodeAnnotation(TypeDeclaration<?> type) {
        for (String name : Structures.defaultProperties.keySet()) {
            Optional ann = type.getAnnotationByName(name);
            if (!ann.isPresent()) continue;
            return ann;
        }
        log.warn("Type {} is not annotated with Code annotation!", (Object)type.getName());
        return Optional.empty();
    }

    private static void cleanUpInterface(Class<?> cls, ClassOrInterfaceDeclaration intf) {
        ArrayList<MethodDeclaration> toRemove = new ArrayList<MethodDeclaration>();
        Arrays.stream(cls.getInterfaces()).forEach(i -> Generator.cleanUpInterface(i, intf));
        Arrays.stream(cls.getDeclaredMethods()).forEach(mtd -> intf.getMethods().stream().filter(m -> m.getNameAsString().equals(mtd.getName()) && m.getParameters().size() == mtd.getParameterCount()).forEach(toRemove::add));
        toRemove.forEach(arg_0 -> ((ClassOrInterfaceDeclaration)intf).remove(arg_0));
    }

    private static void cleanUpInterface(ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration intf) {
        declaration.findCompilationUnit().ifPresent(unit -> intf.getExtendedTypes().forEach(t -> Tools.notNull(Helpers.getExternalClassName(unit, t.getNameAsString()), className -> Tools.notNull(Reflection.loadClass((String)className), cls -> Generator.cleanUpInterface(cls, intf)))));
    }

    private static void handleDefaultMethod(Structures.Parsed<ClassOrInterfaceDeclaration> parse, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, MethodDeclaration declaration) {
        Structures.Ignores ignores = Helpers.getIgnores(declaration);
        MethodDeclaration method = (MethodDeclaration)declaration.clone().removeModifier(new Modifier.Keyword[]{Modifier.Keyword.DEFAULT});
        method.getAnnotationByClass(Ignore.class).ifPresent(arg_0 -> ((MethodDeclaration)method).remove(arg_0));
        if (!ignores.isForInterface()) {
            if (ignores.isForClass()) {
                throw new GenericCodeGenException("Not implemented!");
            }
            if (Helpers.methodExists(intf, method, false)) {
                intf.getChildNodes().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(m -> m.getNameAsString().equals(method.getNameAsString())).findFirst().ifPresent(arg_0 -> ((ClassOrInterfaceDeclaration)intf).remove(arg_0));
            }
            intf.addMember((BodyDeclaration)Generator.handleForAnnotations(method.clone(), false).setBody(null));
        }
        if (!ignores.isForClass()) {
            method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            declaration.getBody().ifPresent(b -> {
                BlockStmt body = b.clone();
                Generator.handleDefaultMethodBody(parse, (Node)body, false);
                method.setBody(body);
            });
            if (Helpers.methodExists(spec, method, false)) {
                spec.getChildNodes().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(m -> m.getNameAsString().equals(method.getNameAsString())).findFirst().ifPresent(arg_0 -> ((ClassOrInterfaceDeclaration)spec).remove(arg_0));
            }
            spec.addMember((BodyDeclaration)Generator.handleForAnnotations(method, true));
        }
    }

    private static MethodDeclaration handleForAnnotations(MethodDeclaration method, boolean isClass) {
        String chk = isClass ? "ForInterface" : "ForImplementation";
        for (int i = method.getAnnotations().size() - 1; i > 0; --i) {
            if (!chk.equals(method.getAnnotation(i - 1).getNameAsString())) continue;
            method.remove((Node)method.getAnnotation(i));
        }
        method.getAnnotationByClass(ForInterface.class).ifPresent(arg_0 -> ((MethodDeclaration)method).remove(arg_0));
        method.getAnnotationByClass(ForImplementation.class).ifPresent(arg_0 -> ((MethodDeclaration)method).remove(arg_0));
        return method;
    }

    private static boolean handleDefaultMethodBody(PrototypeDescription<ClassOrInterfaceDeclaration> parse, Node node, boolean isGetter) {
        TypeDeclaration<ClassOrInterfaceDeclaration> typeDeclaration = parse.getDeclaration();
        if (isGetter && ((Node)node.getParentNode().get()).getChildNodes().size() == 2 && ((Node)node.getParentNode().get()).getChildNodes().get(1) instanceof SimpleName) {
            SimpleName name = (SimpleName)((Node)node.getParentNode().get()).getChildNodes().get(1);
            Optional<BodyDeclaration> parent = typeDeclaration.getMembers().stream().filter(m -> m.isMethodDeclaration() && !m.asMethodDeclaration().isDefault() && m.asMethodDeclaration().getNameAsString().equals(name.asString())).findFirst();
            if (parent.isEmpty() && Objects.nonNull(parse.getBase())) {
                parent = parse.getBase().getDeclaration().getMembers().stream().filter(m -> m.isMethodDeclaration() && !m.asMethodDeclaration().isDefault() && m.asMethodDeclaration().getNameAsString().equals(name.asString())).findFirst();
            }
            if (parent.isPresent()) {
                name.setIdentifier(Helpers.getGetterName(name.asString(), null));
            }
        } else {
            for (int i = 0; i < node.getChildNodes().size(); ++i) {
                Node n = (Node)node.getChildNodes().get(i);
                if (n instanceof MethodCallExpr) {
                    MethodCallExpr method = (MethodCallExpr)n;
                    Optional<BodyDeclaration> parent = typeDeclaration.getMembers().stream().filter(m -> m.isMethodDeclaration() && !m.asMethodDeclaration().isDefault() && m.asMethodDeclaration().getNameAsString().equals(method.getNameAsString())).findFirst();
                    if (parent.isEmpty() && Objects.nonNull(parse.getBase())) {
                        parent = parse.getBase().getDeclaration().getMembers().stream().filter(m -> m.isMethodDeclaration() && !m.asMethodDeclaration().isDefault() && m.asMethodDeclaration().getNameAsString().equals(method.getNameAsString())).findFirst();
                    }
                    if (parent.isPresent()) {
                        Tools.notNull(Helpers.lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)typeDeclaration.findCompilationUnit().get(), parent.get().asMethodDeclaration().getTypeAsString())), p -> Generator.handleDefaultMethodBody(p, n, true));
                        return node.replace((Node)method, (Node)new FieldAccessExpr().setName(method.getName()));
                    }
                    if (!Generator.handleDefaultMethodBody(parse, n, false)) continue;
                    Generator.handleDefaultMethodBody(parse, node, false);
                    continue;
                }
                if (!Generator.handleDefaultMethodBody(parse, n, isGetter)) continue;
                Generator.handleDefaultMethodBody(parse, node, isGetter);
            }
        }
        return false;
    }

    private static void checkForDeclaredConstants(Node type) {
        for (Node node : type.getChildNodes()) {
            FieldAccessExpr expr;
            if (node instanceof FieldAccessExpr && (expr = (FieldAccessExpr)node).getChildNodes().size() > 1 && expr.getChildNodes().get(0) instanceof NameExpr && expr.getChildNodes().get(1) instanceof SimpleName) {
                NameExpr namespace = (NameExpr)expr.getChildNodes().get(0);
                String name = ((SimpleName)expr.getChildNodes().get(1)).asString();
                List<Pair<String, String>> decl = Helpers.declaredConstants.get(namespace.getNameAsString());
                if (Objects.nonNull(decl)) {
                    decl.stream().filter(p -> ((String)p.getValue()).equals(name)).findFirst().ifPresent(c -> namespace.setName((String)c.getKey()));
                }
            }
            Generator.checkForDeclaredConstants(node);
        }
    }

    private static void checkForClassExpressions(Node type, ClassOrInterfaceDeclaration declaration) {
        declaration.findCompilationUnit().ifPresent(unit -> {
            for (Node node : type.getChildNodes()) {
                if (node instanceof ClassExpr) {
                    ClassExpr expr = (ClassExpr)node;
                    Tools.notNull(Helpers.lookup.findParsed(Helpers.getExternalClassName(unit, expr.getTypeAsString())), p -> {
                        if (Objects.isNull(p.getMixIn())) {
                            expr.setType(Helpers.findProperType(p, unit, expr));
                        } else {
                            expr.setType(Helpers.findProperType(p.getMixIn(), unit, expr));
                        }
                    });
                }
                Generator.checkForClassExpressions(node, declaration);
            }
        });
    }

    private static void processConstant(ClassOrInterfaceDeclaration prototype, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, FieldDeclaration field) {
        Structures.Constants consts = Helpers.getConstants(field);
        FieldDeclaration f = field.clone();
        String name = field.getVariable(0).getNameAsString();
        f.getAnnotationByName("CodeConstant").ifPresent(arg_0 -> ((FieldDeclaration)f).remove(arg_0));
        if (consts.isForInterface()) {
            intf.addMember((BodyDeclaration)f);
            Helpers.addDeclaredConstant(prototype.getNameAsString(), intf.getNameAsString(), name);
        } else {
            spec.addMember((BodyDeclaration)((FieldDeclaration)((FieldDeclaration)f.addModifier(new Modifier.Keyword[]{consts.isForPublic() ? Modifier.Keyword.PUBLIC : ("serialVersionUID".equals(name) ? Modifier.Keyword.PRIVATE : Modifier.Keyword.PROTECTED)})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.STATIC})).addModifier(new Modifier.Keyword[]{Modifier.Keyword.FINAL}));
            Helpers.addDeclaredConstant(prototype.getNameAsString(), spec.getNameAsString(), name);
        }
    }

    private static Structures.PrototypeDataHandler getProperties(AnnotationExpr prototype) {
        ClassOrInterfaceDeclaration type = (ClassOrInterfaceDeclaration)prototype.getParentNode().get();
        Holder<String> iName = Holder.of(Helpers.defaultInterfaceName(type));
        Object cName = Helpers.defaultClassName(type);
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.builder(prototype.getNameAsString()).classPackage(Helpers.defaultClassPackage(type)).interfacePackage(Helpers.defaultInterfacePackage(type));
        prototype.getChildNodes().forEach(node -> {
            if (node instanceof MemberValuePair) {
                String name;
                MemberValuePair pair = (MemberValuePair)node;
                switch (name = pair.getNameAsString()) {
                    case "name": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        String intf = value.replace("Entity", "");
                        builder.name(value).className(value).interfaceName(intf).longModifierName(intf + ".Modify");
                        break;
                    }
                    case "generateConstructor": {
                        builder.generateConstructor(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "generateImplementation": {
                        builder.generateImplementation(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "generateInterface": {
                        builder.generateInterface(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "interfaceName": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        iName.set(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "classGetters": {
                        builder.classGetters(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "classSetters": {
                        builder.classSetters(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "interfaceSetters": {
                        builder.interfaceSetters(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "base": {
                        builder.base(pair.getValue().asBooleanLiteralExpr().getValue());
                        break;
                    }
                    case "baseModifierClass": {
                        String value = pair.getValue().asClassExpr().getTypeAsString();
                        if (!StringUtils.isNotBlank((CharSequence)value) || "void".equals(value)) break;
                        builder.baseModifierClass(value);
                        break;
                    }
                    case "mixInClass": {
                        String value = pair.getValue().asClassExpr().getTypeAsString();
                        if (!StringUtils.isNotBlank((CharSequence)value) || "void".equals(value)) break;
                        builder.mixInClass(value);
                        break;
                    }
                    case "implementationPackage": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.classPackage(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "basePath": {
                        String value = pair.getValue().asStringLiteralExpr().asString();
                        if (!StringUtils.isNotBlank((CharSequence)value)) break;
                        builder.basePath(value);
                        break;
                    }
                    case "enrichers": {
                        Generator.checkEnrichers(builder::enrichers, pair.getValue().asArrayInitializerExpr());
                        break;
                    }
                    case "inheritedEnrichers": {
                        Generator.checkEnrichers(builder::inheritedEnrichers, pair.getValue().asArrayInitializerExpr());
                        break;
                    }
                }
            }
        });
        if (((String)cName).equals(iName.get())) {
            cName = iName.get() + "Impl";
        }
        builder.className((String)cName).interfaceName(iName.get()).longModifierName(iName.get() + ".Modify");
        Structures.PrototypeDataHandler result = builder.build();
        if (Objects.isNull(result.getEnrichers())) {
            result.setEnrichers(new ArrayList<PrototypeEnricher>());
        }
        if (Objects.isNull(result.getInheritedEnrichers())) {
            result.setInheritedEnrichers(new ArrayList<PrototypeEnricher>());
        }
        Tools.notNull(result.getPredefinedEnrichers(), list -> list.forEach(e -> Generator.checkEnrichers(result.getEnrichers(), e)));
        Tools.notNull(result.getPredefinedInheritedEnrichers(), list -> list.forEach(e -> Generator.checkEnrichers(result.getInheritedEnrichers(), e)));
        return result;
    }

    private static void checkEnrichers(Consumer<List<PrototypeEnricher>> consumer, ArrayInitializerExpr expression) {
        ArrayList list = new ArrayList();
        expression.getValues().stream().filter(Expression::isClassExpr).map(e -> Reflection.loadClass((String)Helpers.getExternalClassName((CompilationUnit)expression.findCompilationUnit().get(), e.asClassExpr().getType().asString()))).filter(Objects::nonNull).map(CodeFactory::create).filter(Objects::nonNull).filter(i -> PrototypeEnricher.class.isAssignableFrom(i.getClass())).forEach(e -> Tools.with((PrototypeEnricher)e, enricher -> {
            enricher.init(Helpers.lookup);
            list.add(enricher);
        }));
        consumer.accept(list);
    }

    private static void checkEnrichers(List<PrototypeEnricher> list, Class enricher) {
        Object e2;
        if (list.stream().noneMatch(e -> enricher.isAssignableFrom(e.getClass())) && (e2 = CodeFactory.create((Class)enricher)) instanceof PrototypeEnricher) {
            Tools.with((PrototypeEnricher)e2, r -> {
                r.init(Helpers.lookup);
                list.add((PrototypeEnricher)r);
            });
        }
    }

    private static void ensureParsedParents(ClassOrInterfaceDeclaration declaration, PrototypeData properties) {
        for (ClassOrInterfaceType extended : declaration.getExtendedTypes()) {
            PrototypeDescription<ClassOrInterfaceDeclaration> parsed = Helpers.getParsed(extended);
            if (Objects.nonNull(parsed)) {
                Tools.ifNull(parsed.getFiles(), () -> Generator.generateCodeForClass((CompilationUnit)parsed.getDeclaration().findCompilationUnit().get()));
                continue;
            }
            CompiledPrototypesHandler.handleCompiledPrototype(Helpers.getExternalClassName((CompilationUnit)declaration.findCompilationUnit().get(), extended.getNameAsString()));
        }
        Tools.notNull(properties.getMixInClass(), c -> Tools.notNull(Helpers.getExternalClassName((CompilationUnit)declaration.findCompilationUnit().get(), c), name -> Tools.notNull(Helpers.lookup.findParsed((String)name), parse -> Tools.ifNull(parse.getFiles(), () -> Generator.generateCodeForClass((CompilationUnit)parse.getDeclaration().findCompilationUnit().get())))));
    }

    private static void ensureParsedParents(EnumDeclaration declaration, PrototypeData properties) {
        Tools.notNull(properties.getMixInClass(), c -> Tools.notNull(Helpers.getExternalClassName((CompilationUnit)declaration.findCompilationUnit().get(), c), name -> Tools.notNull(Helpers.enumParsed.get(name), parse -> Tools.ifNull(parse.getFiles(), () -> Generator.generateCodeForEnum((CompilationUnit)parse.getDeclaration().findCompilationUnit().get())))));
    }

    private static void implementPrototype(Structures.Parsed<ClassOrInterfaceDeclaration> parse, ClassOrInterfaceDeclaration spec, PrototypeDescription<ClassOrInterfaceDeclaration> declaration, Map<String, Type> generic, boolean external) {
        Structures.PrototypeDataHandler properties = parse.getProperties();
        for (MethodDeclaration method : declaration.getSpec().getMethods()) {
            PrototypeField field;
            if (declaration.isValid()) {
                if (declaration.getDeclaration().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).anyMatch(m -> m.getNameAsString().equals(method.getNameAsString()))) {
                    spec.addMember((BodyDeclaration)method.clone());
                    continue;
                }
            }
            if (method.getNameAsString().startsWith("get")) {
                if (external) {
                    if (!parse.getDeclaration().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).noneMatch(m -> m.isDefault() && m.getNameAsString().equals(method.getNameAsString()) && m.getTypeAsString().equals(method.getTypeAsString()))) continue;
                }
                if (!Objects.nonNull(field = Generator.addFieldFromGetter(parse, spec, method, generic, external)) || !properties.isClassGetters()) continue;
                Generator.addGetterFromGetter(spec, method, true, field);
                continue;
            }
            if (!method.getNameAsString().startsWith("set")) continue;
            if (external) {
                if (!parse.getDeclaration().stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).noneMatch(m -> m.isDefault() && m.getNameAsString().equals(method.getNameAsString()) && m.getTypeAsString().equals(method.getTypeAsString()))) continue;
            }
            if (!Objects.nonNull(field = Generator.addFieldFromSetter(parse, spec, method, generic, external)) || !properties.isClassSetters()) continue;
            Generator.addSetterFromSetter(spec, method, true, field);
        }
        Helpers.handleImports(declaration.getSpec(), spec);
    }

    private static boolean handleExternalInterface(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, ClassOrInterfaceType type) {
        String className = Helpers.getExternalClassName((CompilationUnit)declaration.findCompilationUnit().get(), type.getNameAsString());
        if (Objects.nonNull(className)) {
            Class cls = Reflection.loadClass((String)className);
            if (Objects.nonNull(cls)) {
                if (cls.isInterface()) {
                    for (Class<?> i : cls.getInterfaces()) {
                        Generator.handleExternalInterface(parsed, declaration, spec, i, (NodeList<Type>)((NodeList)type.getTypeArguments().orElse(null)));
                    }
                    Generator.handleExternalInterface(parsed, declaration, spec, cls, (NodeList<Type>)((NodeList)type.getTypeArguments().orElse(null)));
                    if (Objects.nonNull(intf)) {
                        intf.addExtendedType(Generator.handleType((CompilationUnit)declaration.findCompilationUnit().get(), (CompilationUnit)intf.findCompilationUnit().get(), (Type)type));
                    } else if (spec.getImplementedTypes().stream().noneMatch(arg_0 -> ((ClassOrInterfaceType)type).equals(arg_0))) {
                        spec.addImplementedType(Generator.handleType((CompilationUnit)declaration.findCompilationUnit().get(), (CompilationUnit)spec.findCompilationUnit().get(), (Type)type));
                    }
                } else {
                    log.error("{} is not interface!", (Object)className);
                }
            } else {
                ClassOrInterfaceDeclaration ext;
                PrototypeDescription<ClassOrInterfaceDeclaration> external = Helpers.lookup.findExternal(className);
                if (Objects.nonNull(external) && external.getDeclaration().isClassOrInterfaceDeclaration() && (ext = external.getDeclaration().asClassOrInterfaceDeclaration()).isInterface()) {
                    HashMap<String, Type> generics = new HashMap<String, Type>();
                    int i = 0;
                    for (TypeParameter g : ext.getTypeParameters()) {
                        generics.put(g.getNameAsString(), (Type)((NodeList)type.getTypeArguments().get()).get(i));
                        ++i;
                    }
                    ClassOrInterfaceDeclaration org = external.getSpec();
                    ((Structures.Parsed)external).setSpec(((CompilationUnit)org.findCompilationUnit().get()).clone().getType(0).asClassOrInterfaceDeclaration());
                    Generator.implementPrototype(parsed, spec, external, generics, true);
                    ((Structures.Parsed)external).setSpec(org);
                    return true;
                }
            }
        } else {
            log.error("Can't process interface {} cause can't find its type!", (Object)type.getNameAsString());
        }
        return false;
    }

    private static void handleExternalInterface(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, Class<?> cls, NodeList<Type> generics) {
        Map<String, Type> generic = null;
        if (Objects.nonNull(generics)) {
            generic = Helpers.processGenerics(cls, generics);
        }
        Arrays.stream(cls.getInterfaces()).forEach(i -> Generator.handleExternalInterface(parsed, declaration, spec, i, generics));
        Structures.PrototypeDataHandler properties = parsed.getProperties();
        for (Method method : cls.getDeclaredMethods()) {
            PrototypeField field;
            if (Modifier.isStatic(method.getModifiers()) || method.isDefault() || Helpers.defaultMethodExists(declaration, method)) continue;
            if (method.getParameterCount() == 0 && method.getName().startsWith("get") || method.getName().startsWith("is") && method.getReturnType().getCanonicalName().equals("boolean")) {
                field = Generator.addFieldFromGetter(parsed, spec, method, generic);
                if (!properties.isClassGetters()) continue;
                Generator.addGetterFromGetter(spec, method, true, generic, field);
                continue;
            }
            if (method.getParameterCount() == 1 && method.getName().startsWith("set") && method.getReturnType().getCanonicalName().equals("void")) {
                field = Generator.addFieldFromGetter(parsed, spec, method, generic);
                if (!properties.isClassSetters()) continue;
                Generator.addSetterFromSetter(spec, method, true, generic, field);
                continue;
            }
            log.error("Method {} of {} is nor getter or setter. Not implemented!", (Object)method.getName(), (Object)cls.getCanonicalName());
        }
    }

    private static void handleMixin(PrototypeDescription<ClassOrInterfaceDeclaration> parse) {
        PrototypeDescription<ClassOrInterfaceDeclaration> parent;
        if (Objects.nonNull(parse.getProperties().getMixInClass()) && (parent = Helpers.lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)parse.getDeclaration().findCompilationUnit().get(), parse.getProperties().getMixInClass()))) != null) {
            ClassOrInterfaceDeclaration spec = parse.getSpec();
            ClassOrInterfaceDeclaration intf = parse.getIntf();
            ClassOrInterfaceDeclaration parentSpec = parent.getSpec();
            ClassOrInterfaceDeclaration parentIntf = parent.getIntf();
            ((CompilationUnit)intf.findCompilationUnit().get()).addImport((String)parentIntf.getFullyQualifiedName().get());
            ((CompilationUnit)parentSpec.findCompilationUnit().get()).addImport((String)intf.getFullyQualifiedName().get());
            parentSpec.addImplementedType(intf.getNameAsString());
            Generator.mergeTypes(spec, parentSpec, m -> true, a -> a);
            intf.getExtendedTypes().forEach(t -> Tools.condition(t.getNameAsString().endsWith(MIX_IN_EXTENSION), () -> (ClassOrInterfaceType)t.setName(t.getNameAsString().replace(MIX_IN_EXTENSION, ""))));
            if (intf.getExtendedTypes().stream().noneMatch(t -> t.getNameAsString().equals(parentIntf.getNameAsString()))) {
                intf.addExtendedType(parentIntf.getNameAsString());
            }
            Helpers.handleImports(parse.getDeclaration().asClassOrInterfaceDeclaration(), intf);
            Helpers.handleImports(parent.getDeclaration().asClassOrInterfaceDeclaration(), intf);
            Helpers.handleImports(parse.getDeclaration().asClassOrInterfaceDeclaration(), parentSpec);
        }
    }

    private static void setScope(Type type, String scope) {
        if (type.isClassOrInterfaceType() && type.asClassOrInterfaceType().getScope().isPresent()) {
            ((ClassOrInterfaceType)type.asClassOrInterfaceType().getScope().get()).setName(scope);
        }
    }

    private static String getScope(Type type) {
        if (type.isClassOrInterfaceType() && type.asClassOrInterfaceType().getScope().isPresent()) {
            return ((ClassOrInterfaceType)type.asClassOrInterfaceType().getScope().get()).getNameAsString();
        }
        return null;
    }

    public static String handleType(ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination, Type type) {
        return Generator.handleType(source, destination, type, null);
    }

    public static String handleType(ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination, Type type, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        return Generator.handleType((CompilationUnit)source.findCompilationUnit().get(), (CompilationUnit)destination.findCompilationUnit().get(), type, prototypeMap);
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, Type type) {
        return Generator.handleType(source, destination, type, null);
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, Type type, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        List<String> generic;
        Object result = type.toString();
        if (type.isClassOrInterfaceType() && !ObjectUtils.isEmpty(generic = Generator.handleGenericTypes(source, destination, type.asClassOrInterfaceType(), prototypeMap))) {
            result = type.asClassOrInterfaceType().getNameAsString() + "<" + String.join((CharSequence)",", generic) + ">";
        }
        return Generator.handleType(source, destination, (String)result, false);
    }

    public static List<String> handleGenericTypes(CompilationUnit source, CompilationUnit destination, ClassOrInterfaceType type, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        ArrayList<String> result = new ArrayList<String>();
        Optional arguments = type.getTypeArguments();
        if (arguments.isEmpty() || ((NodeList)arguments.get()).isEmpty()) {
            return result;
        }
        return ((NodeList)arguments.get()).stream().map(n -> Generator.handleType(source, destination, n.toString(), true, prototypeMap)).collect(Collectors.toList());
    }

    public static List<Pair<String, Boolean>> getGenericsList(CompilationUnit source, CompilationUnit destination, ClassOrInterfaceType type, boolean isCollection) {
        Optional arguments = type.getTypeArguments();
        if (arguments.isEmpty() || ((NodeList)arguments.get()).isEmpty()) {
            return Collections.singletonList(Pair.of((Object)"Object", (Object)false));
        }
        return ((NodeList)arguments.get()).stream().map(n -> Generator.handleType(source, destination, n.toString(), true)).map(t -> Pair.of((Object)t, (Object)Helpers.lookup.parsed().stream().anyMatch(p -> Helpers.getExternalClassName(destination, t).equals(p.getInterfaceFullName())))).collect(Collectors.toList());
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, String type, boolean embedded) {
        return Generator.handleType(source, destination, type, embedded, null);
    }

    public static String handleType(CompilationUnit source, CompilationUnit destination, String type, boolean embedded, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        String full = Helpers.getExternalClassName(source, type);
        PrototypeDescription<ClassOrInterfaceDeclaration> parse = Helpers.lookup.findParsed(full);
        if (Objects.nonNull(parse)) {
            Structures.ProcessingType processing = Helpers.processingTypes.get(type);
            if (embedded) {
                Helpers.lookup.generateEmbeddedModifier(parse);
                if (Objects.nonNull(prototypeMap)) {
                    prototypeMap.put(parse.getInterfaceName(), parse);
                    if (Objects.isNull(parse.getInterfaceName())) {
                        Helpers.lookup.addPrototypeMap(parse, prototypeMap);
                    }
                }
            }
            if (Objects.isNull(processing)) {
                if (Objects.isNull(parse.getFiles())) {
                    Generator.generateCodeForClass((CompilationUnit)parse.getDeclaration().findCompilationUnit().get());
                }
                TypeDeclaration intf = parse.getFiles().get(1).getType(0);
                destination.addImport((String)intf.getFullyQualifiedName().get());
                return intf.getNameAsString();
            }
            destination.addImport(processing.getInterfacePackage() + "." + processing.getInterfaceName());
            return processing.getInterfaceName();
        }
        if (!Helpers.isJavaType(type) && !full.contains(".prototype.")) {
            destination.findCompilationUnit().ifPresent(u -> u.addImport(full));
        }
        return type;
    }

    private static void handleFieldAnnotations(CompilationUnit unit, FieldDeclaration field, MethodDeclaration method) {
        method.getAnnotations().forEach(a -> Tools.notNull(Helpers.getExternalClassName(unit, a.getNameAsString()), name -> {
            Class ann = Reflection.loadClass((String)name);
            if (Objects.nonNull(ann)) {
                if (Objects.isNull(ann.getAnnotation(CodeAnnotation.class))) {
                    Target target = ann.getAnnotation(Target.class);
                    if (target == null || target.toString().contains("FIELD")) {
                        Generator.handleAnnotation(unit, field, a);
                    }
                } else if (CodeFieldAnnotations.class.isAssignableFrom(ann)) {
                    a.getChildNodes().stream().filter(ArrayInitializerExpr.class::isInstance).findFirst().ifPresent(e -> e.getChildNodes().forEach(n -> field.addAnnotation(((StringLiteralExpr)n).asStringLiteralExpr().asString())));
                } else if (Default.class.isAssignableFrom(ann) && a.isSingleMemberAnnotationExpr()) {
                    ((VariableDeclarator)field.getVariables().iterator().next()).setInitializer(a.asSingleMemberAnnotationExpr().getMemberValue().asStringLiteralExpr().asString());
                }
            } else {
                log.warn("Can't process annotation {}", name);
            }
        }));
    }

    private static void handleAnnotation(CompilationUnit unit, FieldDeclaration field, AnnotationExpr ann) {
        field.getAnnotations().stream().filter(a -> a.getNameAsString().equals(ann.getNameAsString())).findFirst().ifPresent(a -> field.getAnnotations().remove((Node)a));
        field.addAnnotation(ann);
    }

    private static void handleAnnotation(CompilationUnit unit, MethodDeclaration method, AnnotationExpr ann) {
        method.getAnnotations().stream().filter(a -> a.getNameAsString().equals(ann.getNameAsString())).findFirst().ifPresent(a -> method.getAnnotations().remove((Node)a));
        method.addAnnotation(ann);
        Tools.notNull(Helpers.getExternalClassNameIfExists(unit, ann.getNameAsString()), i -> method.findCompilationUnit().ifPresent(u -> u.addImport(i)));
    }

    private static void handleMethodAnnotations(MethodDeclaration method, MethodDeclaration declaration) {
        declaration.getAnnotations().forEach(a -> Tools.notNull(Helpers.getExternalClassName((CompilationUnit)declaration.findCompilationUnit().get(), a.getNameAsString()), name -> {
            Target target;
            Class ann = Reflection.loadClass((String)name);
            if (Objects.nonNull(ann) && !ann.isAnnotationPresent(CodeAnnotation.class) && (target = ann.getAnnotation(Target.class)) != null && target.toString().contains("METHOD")) {
                method.addAnnotation(a);
            }
        }));
    }

    private static void handleClassAnnotations(ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec) {
        declaration.findCompilationUnit().ifPresent(unit -> declaration.getAnnotations().forEach(a -> Tools.notNull(Helpers.getExternalClassName(unit, a.getNameAsString()), name -> {
            Class ann = Reflection.loadClass((String)name);
            if (Objects.nonNull(ann) && !CodeAnnotation.class.isAssignableFrom(ann)) {
                Target target = ann.getAnnotation(Target.class);
                if (target != null && !target.toString().equals("TYPE")) {
                    spec.addAnnotation(a);
                }
            } else {
                log.warn("Can't process annotation {}", name);
            }
        })));
    }

    public static <T> T findInheritanceProperty(ClassOrInterfaceDeclaration spec, PrototypeData properties, BiFunction<ClassOrInterfaceDeclaration, PrototypeData, T> func) {
        T data;
        block1: {
            ClassOrInterfaceType type;
            PrototypeDescription<ClassOrInterfaceDeclaration> parse;
            data = func.apply(spec, properties);
            if (!Objects.isNull(data)) break block1;
            Iterator iterator = spec.getExtendedTypes().iterator();
            while (!(!iterator.hasNext() || Objects.nonNull(parse = Helpers.lookup.findGenerated(Helpers.getClassName(type = (ClassOrInterfaceType)iterator.next()))) && Objects.nonNull(data = Generator.findInheritanceProperty(parse.getDeclaration().asClassOrInterfaceDeclaration(), parse.getProperties(), func)))) {
            }
        }
        return data;
    }

    private static void processInnerClass(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration declaration, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration cls) {
        cls.getImplementedTypes().forEach(t -> {
            if (Generator.handleExternalInterface(parsed, declaration, spec, null, t)) {
                Generator.handleType(cls, spec, (Type)t);
                spec.addImplementedType(t);
            }
        });
        Tools.notNull(spec.getAnnotationByName("CodeClassAnnotations"), a -> cls.getAnnotations().forEach(ann -> {
            if (!"CodeClassAnnotations".equals(ann.getNameAsString())) {
                spec.addAnnotation(ann.clone());
            }
        }));
    }

    private static PrototypeField addField(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration type, ClassOrInterfaceDeclaration spec, MethodDeclaration method, Type generic) {
        PrototypeField result = null;
        String fieldName = method.getNameAsString();
        FieldDeclaration field = Helpers.findField(spec, fieldName);
        if (Objects.isNull(field)) {
            HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
            field = Objects.nonNull(generic) ? spec.addField(generic, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : (method.getTypeParameters().isEmpty() || !method.getType().asString().equals(method.getTypeParameter(0).asString()) ? spec.addField(Generator.handleType(type, spec, method.getType(), prototypeMap), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : spec.addField("Object", fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}));
            result = Structures.FieldData.builder().parsed(parsed).name(fieldName).description(method).declaration(field).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).ignores(Helpers.getIgnores(method)).generics(Objects.nonNull(generic) ? Map.of(generic.asString(), generic) : null).prototype(Objects.isNull(generic) ? Helpers.lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)type.findCompilationUnit().get(), method.getType().asString())) : null).typePrototypes(!prototypeMap.isEmpty() ? prototypeMap : null).type(field.getElementType().asString()).fullType(Helpers.getExternalClassNameIfExists((CompilationUnit)spec.findCompilationUnit().get(), field.getElementType().asString())).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
                ((Structures.FieldData)result).setPrototype(Objects.isNull(generic) ? Helpers.lookup.findParsed(Helpers.getExternalClassName((CompilationUnit)type.findCompilationUnit().get(), method.getType().asString())) : null);
                Generator.mergeAnnotations(method, result.getDescription());
            }
        }
        Generator.handleFieldAnnotations((CompilationUnit)type.findCompilationUnit().get(), field, method);
        return result;
    }

    private static PrototypeField addFieldFromGetter(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, MethodDeclaration method, Map<String, Type> generic, boolean external) {
        PrototypeField result = null;
        boolean genericMethod = !method.getTypeParameters().isEmpty() && method.getTypeAsString().equals(method.getTypeParameter(0).getNameAsString());
        String fieldName = Helpers.getFieldName(method.getNameAsString());
        if (!Helpers.fieldExists(spec, fieldName)) {
            FieldDeclaration field = Objects.nonNull(generic) && !generic.isEmpty() ? spec.addField(generic.get(method.getTypeAsString()), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : (genericMethod ? spec.addField("Object", fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : spec.addField(method.getType(), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}));
            result = Structures.FieldData.builder().parsed(parsed).name(fieldName).description(method).declaration(field).ignores(Helpers.getIgnores(method)).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).generics(Objects.nonNull(generic) && !generic.isEmpty() ? generic : null).genericMethod(genericMethod).fullType(genericMethod ? null : Helpers.getExternalClassNameIfExists((CompilationUnit)spec.findCompilationUnit().get(), field.getElementType().asString())).type(genericMethod ? method.getTypeParameter(0).getNameAsString() : field.getElementType().asString()).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
            }
        }
        return result;
    }

    private static PrototypeField addFieldFromSetter(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, MethodDeclaration method, Map<String, Type> generic, boolean external) {
        PrototypeField result = null;
        String fieldName = Helpers.getFieldName(method.getNameAsString());
        if (!Helpers.fieldExists(spec, fieldName)) {
            FieldDeclaration field = Objects.nonNull(generic) ? spec.addField(generic.get(Helpers.parseMethodSignature(method)), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}) : spec.addField(method.getParameter(0).getType(), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
            result = Structures.FieldData.builder().parsed(parsed).name(fieldName).description(method).declaration(field).ignores(Helpers.getIgnores(method)).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).generics(generic).genericMethod(false).fullType(Helpers.getExternalClassNameIfExists((CompilationUnit)spec.findCompilationUnit().get(), field.getElementType().asString())).type(field.getElementType().asString()).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
            }
        }
        return result;
    }

    private static PrototypeField addFieldFromGetter(Structures.Parsed<ClassOrInterfaceDeclaration> parsed, ClassOrInterfaceDeclaration spec, Method method, Map<String, Type> generic) {
        PrototypeField result = null;
        String fieldName = Helpers.getFieldName(method.getName());
        boolean genericMethod = false;
        if (!Helpers.fieldExists(spec, fieldName)) {
            MethodDeclaration description;
            FieldDeclaration field;
            if (Objects.nonNull(generic)) {
                Type type = generic.get(Helpers.parseMethodSignature(method));
                field = spec.addField(type, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
                description = ((MethodDeclaration)new MethodDeclaration().setName(fieldName)).setType(type);
                Generator.handleType(parsed.getDeclaration().asClassOrInterfaceDeclaration(), spec, type);
            } else {
                genericMethod = !method.getReturnType().getCanonicalName().equals(Helpers.parseMethodSignature(method));
                field = spec.addField(method.getReturnType(), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
                description = (MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(fieldName)).setType(method.getReturnType());
                if (!method.getReturnType().isPrimitive() && !method.getReturnType().getCanonicalName().startsWith("java.lang.")) {
                    ((CompilationUnit)spec.findCompilationUnit().get()).addImport(method.getReturnType().getCanonicalName());
                }
            }
            CompilationUnit dummy = Generator.envelopWithDummyClass(description);
            if (method.getDeclaredAnnotations().length > 0) {
                for (Annotation ann : method.getDeclaredAnnotations()) {
                    description.addAnnotation(ann.annotationType());
                    dummy.addImport(ann.annotationType().getPackageName());
                    field.addAnnotation(ann.annotationType());
                }
            }
            result = Structures.FieldData.builder().parsed(parsed).description(description).name(fieldName).declaration(field).collection(CollectionsHandler.isCollection(field.getVariable(0).getType())).ignores(Structures.Ignores.builder().build()).generics(generic).genericMethod(genericMethod).fullType(genericMethod ? null : Helpers.getExternalClassNameIfExists((CompilationUnit)spec.findCompilationUnit().get(), field.getElementType().asString())).type(genericMethod ? Helpers.parseMethodSignature(method) : field.getElementType().asString()).build();
            parsed.getFields().add(result);
        } else {
            Optional<PrototypeField> proto = parsed.getFields().stream().filter(d -> d.getName().equals(fieldName)).findFirst();
            if (proto.isPresent()) {
                result = proto.get();
            }
        }
        return result;
    }

    private static CompilationUnit envelopWithDummyClass(MethodDeclaration description) {
        CompilationUnit dummy = new CompilationUnit();
        dummy.setPackageDeclaration("dummy");
        dummy.addClass("Dummy").addMember((BodyDeclaration)description);
        return dummy;
    }

    public static void addGetter(ClassOrInterfaceDeclaration type, ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        String name = Helpers.getGetterName(declaration.getNameAsString(), declaration.getType().asString());
        if (!Helpers.methodExists(spec, declaration, name, isClass)) {
            String rType = declaration.getTypeParameters().isEmpty() ? Generator.handleType(type, spec, declaration.getType()) : declaration.getType().asString();
            MethodDeclaration method = (MethodDeclaration)spec.addMethod(name, new Modifier.Keyword[0]).setType(rType);
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName(declaration.getName()))));
                ((Structures.FieldData)field).setImplementationGetter(method);
                Generator.handleMethodAnnotations(method, declaration);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    method.setType("Object");
                }
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceGetter(method);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    declaration.getTypeParameters().forEach(arg_0 -> ((MethodDeclaration)method).addTypeParameter(arg_0));
                }
            }
        }
    }

    private static void addGetterFromGetter(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            MethodDeclaration method = spec.addMethod(declaration.getNameAsString(), new Modifier.Keyword[0]).setType(declaration.getType());
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName(Helpers.getFieldName(declaration.getNameAsString())))));
                ((Structures.FieldData)field).setImplementationGetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceGetter(method);
            }
        }
    }

    private static void addGetterFromGetter(ClassOrInterfaceDeclaration spec, Method declaration, boolean isClass, Map<String, Type> generic, PrototypeField field) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            MethodDeclaration method = spec.addMethod(declaration.getName(), new Modifier.Keyword[0]);
            if (Objects.nonNull(generic)) {
                method.setType(generic.get(Helpers.parseMethodSignature(declaration)));
            } else {
                method.setType(declaration.getReturnType());
            }
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName(Helpers.getFieldName(declaration.getName())))));
                ((Structures.FieldData)field).setImplementationGetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceGetter(method);
            }
        }
    }

    public static void addSetter(ClassOrInterfaceDeclaration type, ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        MethodDeclaration method;
        String fieldName = Objects.nonNull(field.getName()) ? field.getName() : declaration.getNameAsString();
        String name = Helpers.getSetterName(fieldName);
        String returnType = null;
        if (Objects.nonNull(field.getType())) {
            returnType = field.getType();
        } else if (Objects.nonNull(field.getGenerics())) {
            returnType = field.getGenerics().get(declaration.getType().asString()).asString();
        }
        if (Objects.isNull(returnType)) {
            Generator.handleType(type, spec, declaration.getType());
        }
        if (!Helpers.methodExists(spec, method = (MethodDeclaration)((MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(name)).setType("void")).addParameter((Parameter)((Parameter)new Parameter().setName(fieldName)).setType(returnType)), name, isClass)) {
            spec.addMember((BodyDeclaration)method);
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this." + fieldName)).setValue((Expression)new NameExpr().setName(fieldName))));
                ((Structures.FieldData)field).setImplementationSetter(method);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    method.getParameter(0).setType("Object");
                }
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceSetter(method);
                if (declaration.getTypeParameters().isNonEmpty()) {
                    declaration.getTypeParameters().forEach(arg_0 -> ((MethodDeclaration)method).addTypeParameter(arg_0));
                }
            }
        }
    }

    private static void addSetterFromSetter(ClassOrInterfaceDeclaration spec, MethodDeclaration declaration, boolean isClass, PrototypeField field) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            MethodDeclaration method = (MethodDeclaration)spec.addMethod(declaration.getNameAsString(), new Modifier.Keyword[0]).addParameter(((Parameter)new Parameter().setName(Helpers.getFieldName(declaration.getNameAsString()))).setType(declaration.getParameter(0).getType()));
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this." + Helpers.getFieldName(declaration.getNameAsString()))).setValue((Expression)new NameExpr().setName(Helpers.getFieldName(declaration.getNameAsString())))));
                ((Structures.FieldData)field).setImplementationSetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)field).setInterfaceSetter(method);
            }
        }
    }

    private static void addSetterFromSetter(ClassOrInterfaceDeclaration spec, Method declaration, boolean isClass, Map<String, Type> generic, PrototypeField proto) {
        if (!Helpers.methodExists(spec, declaration, isClass)) {
            String field = Helpers.getFieldName(declaration.getName());
            MethodDeclaration method = spec.addMethod(declaration.getName(), new Modifier.Keyword[0]);
            if (Objects.nonNull(generic)) {
                method.addParameter(((Parameter)new Parameter().setName(field)).setType(generic.get(Helpers.parseMethodSignature(declaration))));
            } else {
                method.addParameter((Parameter)((Parameter)new Parameter().setName(field)).setType(declaration.getParameterTypes()[0]));
            }
            if (isClass) {
                ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this." + field)).setValue((Expression)new NameExpr().setName(field))));
                ((Structures.FieldData)proto).setImplementationSetter(method);
            } else {
                method.setBody(null);
                ((Structures.FieldData)proto).setInterfaceSetter(method);
            }
        }
    }

    public static void addMethod(ClassOrInterfaceDeclaration spec, Method declaration, Map<String, String> signature, String name) {
        if (!Helpers.methodExists(spec, declaration, false)) {
            MethodDeclaration method = spec.addMethod(declaration.getName(), new Modifier.Keyword[0]);
            method.setType(Helpers.mapGenericMethodSignature(declaration, signature));
            for (int i = 0; i < declaration.getParameterCount(); ++i) {
                java.lang.reflect.Parameter param = declaration.getParameters()[i];
                method.addParameter(param.getType().getCanonicalName(), param.getName());
            }
            method.setBody(null);
        }
    }

    public static void addMethod(ClassOrInterfaceDeclaration spec, Method declaration, Map<String, String> signature, String modName, String intfName, Final ann) {
        if (!Helpers.methodExists(spec, declaration, false)) {
            spec.findCompilationUnit().ifPresent(u -> Arrays.stream(ann.imports()).forEach(arg_0 -> ((CompilationUnit)u).addImport(arg_0)));
            MethodDeclaration method = spec.addMethod(declaration.getName(), new Modifier.Keyword[0]);
            method.setType(Helpers.mapGenericMethodSignature(declaration, signature));
            String[] params = ann.description().split(";");
            for (int i = 0; i < declaration.getParameterCount(); ++i) {
                java.lang.reflect.Parameter param = declaration.getParameters()[i];
                if (i < params.length && StringUtils.isNotBlank((CharSequence)params[i])) {
                    String desc = params[i].replace("{T}", intfName).replace("{R}", modName);
                    int idx = desc.lastIndexOf(" ");
                    if (idx > -1) {
                        method.addParameter(desc.substring(0, idx), desc.substring(idx + 1));
                        continue;
                    }
                    method.addParameter(param.getType().getCanonicalName(), param.getName());
                    continue;
                }
                method.addParameter(param.getType().getCanonicalName(), param.getName());
            }
            method.setBody(null);
        }
    }

    private static void mergeTypes(ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination, Predicate<BodyDeclaration<?>> filter, Function<MethodDeclaration, MethodDeclaration> adjuster) {
        for (BodyDeclaration member : source.getMembers()) {
            MethodDeclaration method;
            if (!filter.test(member)) continue;
            if (member instanceof FieldDeclaration) {
                FieldDeclaration field = Helpers.findField(destination, member.asFieldDeclaration().getVariable(0).getNameAsString());
                if (!Objects.isNull(field)) continue;
                destination.addMember(member.clone());
                continue;
            }
            if (!(member instanceof MethodDeclaration) || !Objects.isNull(method = Helpers.findMethod(destination, member.asMethodDeclaration().getNameAsString()))) continue;
            destination.addMember((BodyDeclaration)adjuster.apply((MethodDeclaration)member.clone()));
        }
    }

    private static void mergeAnnotations(MethodDeclaration source, MethodDeclaration destination) {
        source.findCompilationUnit().ifPresent(unit -> {
            for (AnnotationExpr ann : source.getAnnotations()) {
                Generator.handleAnnotation(unit, destination, ann);
            }
        });
    }

    public static void generateCodeForEnum(CompilationUnit parser) {
        for (TypeDeclaration type : parser.getTypes()) {
            if (type.isEnumDeclaration()) {
                type.getAnnotationByName("EnumPrototype").ifPresent(prototype -> {
                    EnumDeclaration typeDeclaration = type.asEnumDeclaration();
                    log.info("Processing - {}", prototype);
                    Structures.PrototypeDataHandler properties = Generator.getEnumProperties(prototype);
                    Generator.ensureParsedParents(typeDeclaration, (PrototypeData)properties);
                    CompilationUnit unit = new CompilationUnit();
                    EnumDeclaration spec = unit.addEnum(properties.getClassName());
                    unit.setPackageDeclaration(properties.getClassPackage());
                    Generator.mergeEnums(typeDeclaration, spec);
                    Structures.Parsed parse = (Structures.Parsed)Helpers.enumParsed.get(Helpers.getClassName(typeDeclaration));
                    parse.setParsedName(spec.getNameAsString());
                    parse.setParsedFullName((String)spec.getFullyQualifiedName().get());
                    parse.setProperties(properties);
                    parse.setFiles(List.of(unit));
                    Helpers.enumGenerated.put(Helpers.getClassName(spec), parse);
                    Tools.notNull(properties.getMixInClass(), c -> Tools.notNull(Helpers.getExternalClassName((CompilationUnit)typeDeclaration.findCompilationUnit().get(), c), name -> Tools.notNull(Helpers.enumParsed.get(name), p -> Generator.mergeEnums(spec, (EnumDeclaration)p.getFiles().get(0).findFirst(EnumDeclaration.class).get()))));
                });
                continue;
            }
            log.error("Invalid type " + type.getNameAsString());
        }
    }

    private static void mergeEnums(EnumDeclaration source, EnumDeclaration destination) {
        Helpers.mergeImports((CompilationUnit)source.findCompilationUnit().get(), (CompilationUnit)destination.findCompilationUnit().get());
        source.getEntries().forEach(entry -> Tools.condition(destination.getEntries().stream().noneMatch(e -> e.getNameAsString().equals(entry.getNameAsString())), () -> destination.addEntry(entry)));
        source.getImplementedTypes().forEach(entry -> Tools.condition(destination.getImplementedTypes().stream().noneMatch(e -> e.getNameAsString().equals(entry.getNameAsString())), () -> (EnumDeclaration)destination.addImplementedType(entry)));
        source.getMembers().forEach(member -> Generator.mergeEnumMember(member, destination));
        source.getModifiers().forEach(m -> destination.addModifier(new Modifier.Keyword[]{m.getKeyword()}));
        source.getAnnotations().stream().filter(a -> !"EnumPrototype".equals(a.getNameAsString())).forEach(arg_0 -> ((EnumDeclaration)destination).addAnnotation(arg_0));
        source.getComment().ifPresent(arg_0 -> ((EnumDeclaration)destination).setComment(arg_0));
        source.getOrphanComments().forEach(arg_0 -> ((EnumDeclaration)destination).addOrphanComment(arg_0));
    }

    private static void mergeEnumMember(BodyDeclaration<?> member, EnumDeclaration destination) {
        if (member.isConstructorDeclaration()) {
            if (destination.getConstructors().isEmpty()) {
                ConstructorDeclaration constructor = destination.addConstructor(new Modifier.Keyword[0]);
                ConstructorDeclaration source = member.asConstructorDeclaration();
                constructor.setModifiers(source.getModifiers());
                constructor.setParameters(source.getParameters());
                constructor.setBody(source.getBody());
                constructor.setAnnotations(source.getAnnotations());
            }
        } else if (member.isFieldDeclaration()) {
            if (destination.getFieldByName(((VariableDeclarator)member.asFieldDeclaration().getVariables().get(0)).getNameAsString()).isEmpty()) {
                destination.addMember(member);
            }
        } else if (member.isMethodDeclaration()) {
            if (destination.getMethodsByName(member.asMethodDeclaration().getNameAsString()).isEmpty()) {
                destination.addMember(member);
            }
        } else {
            throw new GenericCodeGenException("TODO: Unhandled enum mix in type!");
        }
    }

    private static Structures.PrototypeDataHandler getEnumProperties(AnnotationExpr prototype) {
        EnumDeclaration type = (EnumDeclaration)prototype.getParentNode().get();
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.PrototypeDataHandler.builder().className(Helpers.defaultClassName(type)).classPackage(Helpers.defaultPackage(type, null));
        prototype.getChildNodes().forEach(node -> {
            if (node instanceof MemberValuePair) {
                String name;
                MemberValuePair pair = (MemberValuePair)node;
                switch (name = pair.getNameAsString()) {
                    case "name": {
                        builder.name(pair.getValue().asStringLiteralExpr().asString());
                        break;
                    }
                    case "mixIn": {
                        builder.mixInClass(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                }
            }
        });
        return builder.build();
    }

    private static Structures.PrototypeDataHandler getConstantProperties(AnnotationExpr prototype) {
        ClassOrInterfaceDeclaration type = (ClassOrInterfaceDeclaration)prototype.getParentNode().get();
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.PrototypeDataHandler.builder().className(Helpers.defaultClassName(type)).classPackage(Helpers.defaultPackage(type, null));
        prototype.getChildNodes().forEach(node -> {
            if (node instanceof MemberValuePair) {
                String name;
                MemberValuePair pair = (MemberValuePair)node;
                switch (name = pair.getNameAsString()) {
                    case "mixIn": {
                        builder.mixInClass(pair.getValue().asClassExpr().getTypeAsString());
                        break;
                    }
                }
            }
        });
        return builder.build();
    }

    public static CompilationUnit generateCodeForConstants() {
        if (!Helpers.constantParsed.isEmpty()) {
            CompilationUnit result = new CompilationUnit();
            ClassOrInterfaceDeclaration parent = result.addClass("Constants");
            parent.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            for (Map.Entry<String, PrototypeDescription<ClassOrInterfaceDeclaration>> entry : Helpers.constantParsed.entrySet()) {
                TypeDeclaration<ClassOrInterfaceDeclaration> type = entry.getValue().getDeclaration();
                if (!type.isClassOrInterfaceDeclaration()) continue;
                type.getAnnotationByName("ConstantPrototype").ifPresent(prototype -> {
                    ClassOrInterfaceDeclaration cls;
                    ClassOrInterfaceDeclaration typeDeclaration = type.asClassOrInterfaceDeclaration();
                    log.info("Processing - {}", (Object)prototype.toString());
                    Structures.PrototypeDataHandler properties = Generator.getConstantProperties(prototype);
                    Holder<String> name = Holder.of(Helpers.defaultClassName(((PrototypeDescription)entry.getValue()).getDeclaration()));
                    if (Objects.nonNull(properties.getMixInClass())) {
                        name.set(Helpers.defaultClassName(properties.getMixInClass()));
                    }
                    if (Objects.isNull(cls = (ClassOrInterfaceDeclaration)parent.getMembers().stream().filter(c -> c.isClassOrInterfaceDeclaration() && c.asClassOrInterfaceDeclaration().getNameAsString().equals(name.get())).findFirst().orElse(null))) {
                        cls = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration().setName(name.get())).setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
                        cls.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
                        parent.addMember((BodyDeclaration)cls);
                    }
                    Generator.mergeConstants(typeDeclaration, cls);
                });
            }
            return result;
        }
        return null;
    }

    private static void mergeConstants(ClassOrInterfaceDeclaration source, ClassOrInterfaceDeclaration destination) {
        Helpers.mergeImports((CompilationUnit)source.findCompilationUnit().get(), (CompilationUnit)destination.findCompilationUnit().get());
        for (BodyDeclaration member : source.getMembers()) {
            if (!member.isFieldDeclaration()) continue;
            FieldDeclaration type = member.asFieldDeclaration();
            FieldDeclaration field = new FieldDeclaration();
            field.setModifiers(type.getModifiers());
            type.getVariables().forEach(v -> {
                VariableDeclarator variable = new VariableDeclarator().setName(v.getName());
                if (v.getType().isClassOrInterfaceType()) {
                    String enm = Helpers.getEnumNameFromPrototype(source, v.getType().asClassOrInterfaceType().getNameAsString());
                    if (Objects.nonNull(enm)) {
                        variable.setType(enm);
                    } else {
                        variable.setType(v.getType());
                    }
                } else {
                    variable.setType(v.getType());
                }
                v.getInitializer().ifPresent(i -> {
                    if (i.isFieldAccessExpr()) {
                        FieldAccessExpr expr = i.asFieldAccessExpr();
                        if (expr.getScope().isNameExpr()) {
                            String enm = Helpers.getEnumNameFromPrototype(source, expr.getScope().asNameExpr().getNameAsString());
                            if (Objects.nonNull(enm)) {
                                variable.setInitializer((Expression)new FieldAccessExpr().setName(expr.getName()).setScope((Expression)new NameExpr(enm)));
                            } else {
                                variable.setInitializer(i);
                            }
                        } else {
                            variable.setInitializer(i);
                        }
                    } else {
                        variable.setInitializer(i);
                    }
                });
                field.addVariable(variable);
            });
            destination.addMember((BodyDeclaration)field);
        }
    }
}

