/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.binis.codegen.enrich.PrototypeLookup;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeLookupHandler
implements PrototypeLookup {
    private static final Logger log = LoggerFactory.getLogger(PrototypeLookupHandler.class);
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> parsed = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> generated = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> requestedEmbeddedModifiers = new HashMap<String, PrototypeDescription<ClassOrInterfaceDeclaration>>();
    private final List<Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>> prototypeMaps = new ArrayList<Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>>();
    private final JavaParser parser = new JavaParser();

    @Override
    public void registerParsed(String prototype, PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        this.parsed.put(prototype, parsed);
    }

    @Override
    public void registerGenerated(String prototype, PrototypeDescription<ClassOrInterfaceDeclaration> generated) {
        this.generated.put(prototype, generated);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findParsed(String prototype) {
        return this.parsed.get(prototype);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findGenerated(String prototype) {
        return this.generated.get(prototype);
    }

    @Override
    public PrototypeDescription<ClassOrInterfaceDeclaration> findByInterfaceName(String name) {
        return this.parsed.values().stream().filter(p -> p.getInterfaceName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public PrototypeField findField(String prototype, String name) {
        return (PrototypeField)((Object)Tools.nullCheck(this.findParsed(prototype), parsed -> parsed.getFields().stream().filter(n -> n.getName().equals(name)).findFirst().orElse(null)));
    }

    @Override
    public boolean isParsed(String prototype) {
        return this.parsed.containsKey(prototype);
    }

    @Override
    public boolean isGenerated(String prototype) {
        return this.generated.containsKey(prototype);
    }

    @Override
    public Collection<PrototypeDescription<ClassOrInterfaceDeclaration>> parsed() {
        return this.parsed.values();
    }

    @Override
    public Collection<PrototypeDescription<ClassOrInterfaceDeclaration>> generated() {
        return this.generated.values();
    }

    @Override
    public void generateEmbeddedModifier(PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        this.requestedEmbeddedModifiers.putIfAbsent((String)parsed.getDeclaration().getFullyQualifiedName().get(), parsed);
    }

    @Override
    public boolean embeddedModifierRequested(PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        return this.requestedEmbeddedModifiers.containsKey(parsed.getDeclaration().getFullyQualifiedName().get());
    }

    @Override
    public void addPrototypeMap(PrototypeDescription<ClassOrInterfaceDeclaration> parsed, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> prototypeMap) {
        this.prototypeMaps.add((Pair<Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>>, PrototypeDescription<ClassOrInterfaceDeclaration>>)Pair.of(prototypeMap, parsed));
    }

    @Override
    public void calcPrototypeMaps() {
        this.prototypeMaps.forEach(p -> ((Map)p.getLeft()).put(((PrototypeDescription)p.getRight()).getInterfaceName(), (PrototypeDescription)p.getRight()));
    }

    @Override
    public List<PrototypeDescription<ClassOrInterfaceDeclaration>> findGeneratedByFileName(String fileName) {
        return this.generated.values().stream().filter(g -> fileName.equals(g.getPrototypeFileName())).collect(Collectors.toList());
    }

    @Override
    public void generateEmbeddedModifier(String type, PrototypeDescription<ClassOrInterfaceDeclaration> parsed) {
        if (!Helpers.isJavaType(type)) {
            String full = Helpers.getExternalClassName((CompilationUnit)parsed.getDeclaration().findCompilationUnit().get(), type);
            PrototypeDescription<ClassOrInterfaceDeclaration> p = this.findParsed(full);
            if (Objects.nonNull(p)) {
                this.generateEmbeddedModifier(p);
            } else {
                parsed.getSpec().findCompilationUnit().ifPresent(u -> u.addImport(full));
                parsed.getIntf().findCompilationUnit().ifPresent(u -> u.addImport(full));
            }
        }
    }

    public void clean() {
        this.parsed.clear();
        this.generated.clear();
        this.requestedEmbeddedModifiers.clear();
    }

    @Override
    public JavaParser getParser() {
        return this.parser;
    }
}

