/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.binis.codegen.enrich.CreatorModifierEnricher;
import net.binis.codegen.enrich.Enricher;
import net.binis.codegen.enrich.ModifierEnricher;
import net.binis.codegen.enrich.PrototypeEnricher;
import net.binis.codegen.enrich.QueryEnricher;
import net.binis.codegen.enrich.ValidationEnricher;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import org.apache.commons.lang3.tuple.Triple;

public class Structures {
    public static final Map<String, Supplier<PrototypeDataHandler.PrototypeDataHandlerBuilder>> defaultProperties = Structures.initDefaultProperties();

    public static PrototypeDataHandler.PrototypeDataHandlerBuilder builder(String type) {
        Supplier<PrototypeDataHandler.PrototypeDataHandlerBuilder> result = defaultProperties.get(type);
        if (Objects.isNull(result)) {
            return Structures.defaultBuilder();
        }
        return result.get();
    }

    private static PrototypeDataHandler.PrototypeDataHandlerBuilder defaultBuilder() {
        return PrototypeDataHandler.builder().generateConstructor(true).generateInterface(true).generateImplementation(true).classGetters(true).classSetters(true).interfaceSetters(true).modifierName("Modify");
    }

    private static Map<String, Supplier<PrototypeDataHandler.PrototypeDataHandlerBuilder>> initDefaultProperties() {
        return Map.of("CodePrototype", Structures::defaultBuilder, "CodeBuilder", () -> Structures.defaultBuilder().predefinedEnrichers(List.of(CreatorModifierEnricher.class, ModifierEnricher.class)).classSetters(false).interfaceSetters(false), "CodeValidationBuilder", () -> Structures.defaultBuilder().predefinedEnrichers(List.of(ValidationEnricher.class, CreatorModifierEnricher.class, ModifierEnricher.class)).classSetters(false).interfaceSetters(false), "CodeQueryBuilder", () -> Structures.defaultBuilder().predefinedEnrichers(List.of(QueryEnricher.class, ValidationEnricher.class, CreatorModifierEnricher.class, ModifierEnricher.class)).classSetters(false).interfaceSetters(false).baseModifierClass("net.binis.codegen.spring.BaseEntityModifier"));
    }

    public static class PrototypeDataHandler
    implements PrototypeData {
        private String prototypeName;
        private String name;
        private String className;
        private String classPackage;
        private boolean classGetters;
        private boolean classSetters;
        private String interfaceName;
        private String interfacePackage;
        private boolean interfaceSetters;
        private String modifierName;
        private String longModifierName;
        private String modifierPackage;
        private String baseClassName;
        private boolean generateConstructor;
        private boolean generateInterface;
        private boolean generateImplementation;
        private boolean base;
        private String baseModifierClass;
        private String mixInClass;
        private String basePath;
        private String interfacePath;
        private String implementationPath;
        private List<PrototypeEnricher> enrichers;
        private List<PrototypeEnricher> inheritedEnrichers;
        private List<Class<? extends Enricher>> predefinedEnrichers;
        private List<Class<? extends Enricher>> predefinedInheritedEnrichers;

        PrototypeDataHandler(String prototypeName, String name, String className, String classPackage, boolean classGetters, boolean classSetters, String interfaceName, String interfacePackage, boolean interfaceSetters, String modifierName, String longModifierName, String modifierPackage, String baseClassName, boolean generateConstructor, boolean generateInterface, boolean generateImplementation, boolean base, String baseModifierClass, String mixInClass, String basePath, String interfacePath, String implementationPath, List<PrototypeEnricher> enrichers, List<PrototypeEnricher> inheritedEnrichers, List<Class<? extends Enricher>> predefinedEnrichers, List<Class<? extends Enricher>> predefinedInheritedEnrichers) {
            this.prototypeName = prototypeName;
            this.name = name;
            this.className = className;
            this.classPackage = classPackage;
            this.classGetters = classGetters;
            this.classSetters = classSetters;
            this.interfaceName = interfaceName;
            this.interfacePackage = interfacePackage;
            this.interfaceSetters = interfaceSetters;
            this.modifierName = modifierName;
            this.longModifierName = longModifierName;
            this.modifierPackage = modifierPackage;
            this.baseClassName = baseClassName;
            this.generateConstructor = generateConstructor;
            this.generateInterface = generateInterface;
            this.generateImplementation = generateImplementation;
            this.base = base;
            this.baseModifierClass = baseModifierClass;
            this.mixInClass = mixInClass;
            this.basePath = basePath;
            this.interfacePath = interfacePath;
            this.implementationPath = implementationPath;
            this.enrichers = enrichers;
            this.inheritedEnrichers = inheritedEnrichers;
            this.predefinedEnrichers = predefinedEnrichers;
            this.predefinedInheritedEnrichers = predefinedInheritedEnrichers;
        }

        public static PrototypeDataHandlerBuilder builder() {
            return new PrototypeDataHandlerBuilder();
        }

        @Override
        public String getPrototypeName() {
            return this.prototypeName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getClassPackage() {
            return this.classPackage;
        }

        @Override
        public boolean isClassGetters() {
            return this.classGetters;
        }

        @Override
        public boolean isClassSetters() {
            return this.classSetters;
        }

        @Override
        public String getInterfaceName() {
            return this.interfaceName;
        }

        @Override
        public String getInterfacePackage() {
            return this.interfacePackage;
        }

        @Override
        public boolean isInterfaceSetters() {
            return this.interfaceSetters;
        }

        @Override
        public String getModifierName() {
            return this.modifierName;
        }

        @Override
        public String getLongModifierName() {
            return this.longModifierName;
        }

        @Override
        public String getModifierPackage() {
            return this.modifierPackage;
        }

        @Override
        public String getBaseClassName() {
            return this.baseClassName;
        }

        @Override
        public boolean isGenerateConstructor() {
            return this.generateConstructor;
        }

        @Override
        public boolean isGenerateInterface() {
            return this.generateInterface;
        }

        @Override
        public boolean isGenerateImplementation() {
            return this.generateImplementation;
        }

        @Override
        public boolean isBase() {
            return this.base;
        }

        @Override
        public String getBaseModifierClass() {
            return this.baseModifierClass;
        }

        @Override
        public String getMixInClass() {
            return this.mixInClass;
        }

        @Override
        public String getBasePath() {
            return this.basePath;
        }

        @Override
        public String getInterfacePath() {
            return this.interfacePath;
        }

        @Override
        public String getImplementationPath() {
            return this.implementationPath;
        }

        @Override
        public List<PrototypeEnricher> getEnrichers() {
            return this.enrichers;
        }

        @Override
        public List<PrototypeEnricher> getInheritedEnrichers() {
            return this.inheritedEnrichers;
        }

        public List<Class<? extends Enricher>> getPredefinedEnrichers() {
            return this.predefinedEnrichers;
        }

        public List<Class<? extends Enricher>> getPredefinedInheritedEnrichers() {
            return this.predefinedInheritedEnrichers;
        }

        public void setPrototypeName(String prototypeName) {
            this.prototypeName = prototypeName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setClassPackage(String classPackage) {
            this.classPackage = classPackage;
        }

        @Override
        public void setClassGetters(boolean classGetters) {
            this.classGetters = classGetters;
        }

        @Override
        public void setClassSetters(boolean classSetters) {
            this.classSetters = classSetters;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public void setInterfacePackage(String interfacePackage) {
            this.interfacePackage = interfacePackage;
        }

        @Override
        public void setInterfaceSetters(boolean interfaceSetters) {
            this.interfaceSetters = interfaceSetters;
        }

        public void setModifierName(String modifierName) {
            this.modifierName = modifierName;
        }

        public void setLongModifierName(String longModifierName) {
            this.longModifierName = longModifierName;
        }

        public void setModifierPackage(String modifierPackage) {
            this.modifierPackage = modifierPackage;
        }

        public void setBaseClassName(String baseClassName) {
            this.baseClassName = baseClassName;
        }

        @Override
        public void setGenerateConstructor(boolean generateConstructor) {
            this.generateConstructor = generateConstructor;
        }

        @Override
        public void setGenerateInterface(boolean generateInterface) {
            this.generateInterface = generateInterface;
        }

        @Override
        public void setGenerateImplementation(boolean generateImplementation) {
            this.generateImplementation = generateImplementation;
        }

        public void setBase(boolean base) {
            this.base = base;
        }

        public void setBaseModifierClass(String baseModifierClass) {
            this.baseModifierClass = baseModifierClass;
        }

        public void setMixInClass(String mixInClass) {
            this.mixInClass = mixInClass;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setInterfacePath(String interfacePath) {
            this.interfacePath = interfacePath;
        }

        public void setImplementationPath(String implementationPath) {
            this.implementationPath = implementationPath;
        }

        public void setEnrichers(List<PrototypeEnricher> enrichers) {
            this.enrichers = enrichers;
        }

        public void setInheritedEnrichers(List<PrototypeEnricher> inheritedEnrichers) {
            this.inheritedEnrichers = inheritedEnrichers;
        }

        public void setPredefinedEnrichers(List<Class<? extends Enricher>> predefinedEnrichers) {
            this.predefinedEnrichers = predefinedEnrichers;
        }

        public void setPredefinedInheritedEnrichers(List<Class<? extends Enricher>> predefinedInheritedEnrichers) {
            this.predefinedInheritedEnrichers = predefinedInheritedEnrichers;
        }

        public static class PrototypeDataHandlerBuilder {
            private String prototypeName;
            private String name;
            private String className;
            private String classPackage;
            private boolean classGetters;
            private boolean classSetters;
            private String interfaceName;
            private String interfacePackage;
            private boolean interfaceSetters;
            private String modifierName;
            private String longModifierName;
            private String modifierPackage;
            private String baseClassName;
            private boolean generateConstructor;
            private boolean generateInterface;
            private boolean generateImplementation;
            private boolean base;
            private String baseModifierClass;
            private String mixInClass;
            private String basePath;
            private String interfacePath;
            private String implementationPath;
            private List<PrototypeEnricher> enrichers;
            private List<PrototypeEnricher> inheritedEnrichers;
            private List<Class<? extends Enricher>> predefinedEnrichers;
            private List<Class<? extends Enricher>> predefinedInheritedEnrichers;

            PrototypeDataHandlerBuilder() {
            }

            public PrototypeDataHandlerBuilder prototypeName(String prototypeName) {
                this.prototypeName = prototypeName;
                return this;
            }

            public PrototypeDataHandlerBuilder name(String name) {
                this.name = name;
                return this;
            }

            public PrototypeDataHandlerBuilder className(String className) {
                this.className = className;
                return this;
            }

            public PrototypeDataHandlerBuilder classPackage(String classPackage) {
                this.classPackage = classPackage;
                return this;
            }

            public PrototypeDataHandlerBuilder classGetters(boolean classGetters) {
                this.classGetters = classGetters;
                return this;
            }

            public PrototypeDataHandlerBuilder classSetters(boolean classSetters) {
                this.classSetters = classSetters;
                return this;
            }

            public PrototypeDataHandlerBuilder interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public PrototypeDataHandlerBuilder interfacePackage(String interfacePackage) {
                this.interfacePackage = interfacePackage;
                return this;
            }

            public PrototypeDataHandlerBuilder interfaceSetters(boolean interfaceSetters) {
                this.interfaceSetters = interfaceSetters;
                return this;
            }

            public PrototypeDataHandlerBuilder modifierName(String modifierName) {
                this.modifierName = modifierName;
                return this;
            }

            public PrototypeDataHandlerBuilder longModifierName(String longModifierName) {
                this.longModifierName = longModifierName;
                return this;
            }

            public PrototypeDataHandlerBuilder modifierPackage(String modifierPackage) {
                this.modifierPackage = modifierPackage;
                return this;
            }

            public PrototypeDataHandlerBuilder baseClassName(String baseClassName) {
                this.baseClassName = baseClassName;
                return this;
            }

            public PrototypeDataHandlerBuilder generateConstructor(boolean generateConstructor) {
                this.generateConstructor = generateConstructor;
                return this;
            }

            public PrototypeDataHandlerBuilder generateInterface(boolean generateInterface) {
                this.generateInterface = generateInterface;
                return this;
            }

            public PrototypeDataHandlerBuilder generateImplementation(boolean generateImplementation) {
                this.generateImplementation = generateImplementation;
                return this;
            }

            public PrototypeDataHandlerBuilder base(boolean base) {
                this.base = base;
                return this;
            }

            public PrototypeDataHandlerBuilder baseModifierClass(String baseModifierClass) {
                this.baseModifierClass = baseModifierClass;
                return this;
            }

            public PrototypeDataHandlerBuilder mixInClass(String mixInClass) {
                this.mixInClass = mixInClass;
                return this;
            }

            public PrototypeDataHandlerBuilder basePath(String basePath) {
                this.basePath = basePath;
                return this;
            }

            public PrototypeDataHandlerBuilder interfacePath(String interfacePath) {
                this.interfacePath = interfacePath;
                return this;
            }

            public PrototypeDataHandlerBuilder implementationPath(String implementationPath) {
                this.implementationPath = implementationPath;
                return this;
            }

            public PrototypeDataHandlerBuilder enrichers(List<PrototypeEnricher> enrichers) {
                this.enrichers = enrichers;
                return this;
            }

            public PrototypeDataHandlerBuilder inheritedEnrichers(List<PrototypeEnricher> inheritedEnrichers) {
                this.inheritedEnrichers = inheritedEnrichers;
                return this;
            }

            public PrototypeDataHandlerBuilder predefinedEnrichers(List<Class<? extends Enricher>> predefinedEnrichers) {
                this.predefinedEnrichers = predefinedEnrichers;
                return this;
            }

            public PrototypeDataHandlerBuilder predefinedInheritedEnrichers(List<Class<? extends Enricher>> predefinedInheritedEnrichers) {
                this.predefinedInheritedEnrichers = predefinedInheritedEnrichers;
                return this;
            }

            public PrototypeDataHandler build() {
                return new PrototypeDataHandler(this.prototypeName, this.name, this.className, this.classPackage, this.classGetters, this.classSetters, this.interfaceName, this.interfacePackage, this.interfaceSetters, this.modifierName, this.longModifierName, this.modifierPackage, this.baseClassName, this.generateConstructor, this.generateInterface, this.generateImplementation, this.base, this.baseModifierClass, this.mixInClass, this.basePath, this.interfacePath, this.implementationPath, this.enrichers, this.inheritedEnrichers, this.predefinedEnrichers, this.predefinedInheritedEnrichers);
            }

            public String toString() {
                return "Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder(prototypeName=" + this.prototypeName + ", name=" + this.name + ", className=" + this.className + ", classPackage=" + this.classPackage + ", classGetters=" + this.classGetters + ", classSetters=" + this.classSetters + ", interfaceName=" + this.interfaceName + ", interfacePackage=" + this.interfacePackage + ", interfaceSetters=" + this.interfaceSetters + ", modifierName=" + this.modifierName + ", longModifierName=" + this.longModifierName + ", modifierPackage=" + this.modifierPackage + ", baseClassName=" + this.baseClassName + ", generateConstructor=" + this.generateConstructor + ", generateInterface=" + this.generateInterface + ", generateImplementation=" + this.generateImplementation + ", base=" + this.base + ", baseModifierClass=" + this.baseModifierClass + ", mixInClass=" + this.mixInClass + ", basePath=" + this.basePath + ", interfacePath=" + this.interfacePath + ", implementationPath=" + this.implementationPath + ", enrichers=" + this.enrichers + ", inheritedEnrichers=" + this.inheritedEnrichers + ", predefinedEnrichers=" + this.predefinedEnrichers + ", predefinedInheritedEnrichers=" + this.predefinedInheritedEnrichers + ")";
            }
        }
    }

    public static class ProcessingType {
        private String interfacePackage;
        private String interfaceName;
        private String classPackage;
        private String className;

        ProcessingType(String interfacePackage, String interfaceName, String classPackage, String className) {
            this.interfacePackage = interfacePackage;
            this.interfaceName = interfaceName;
            this.classPackage = classPackage;
            this.className = className;
        }

        public static ProcessingTypeBuilder builder() {
            return new ProcessingTypeBuilder();
        }

        public String getInterfacePackage() {
            return this.interfacePackage;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getClassPackage() {
            return this.classPackage;
        }

        public String getClassName() {
            return this.className;
        }

        public void setInterfacePackage(String interfacePackage) {
            this.interfacePackage = interfacePackage;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public void setClassPackage(String classPackage) {
            this.classPackage = classPackage;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessingType)) {
                return false;
            }
            ProcessingType other = (ProcessingType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$interfacePackage = this.getInterfacePackage();
            String other$interfacePackage = other.getInterfacePackage();
            if (this$interfacePackage == null ? other$interfacePackage != null : !this$interfacePackage.equals(other$interfacePackage)) {
                return false;
            }
            String this$interfaceName = this.getInterfaceName();
            String other$interfaceName = other.getInterfaceName();
            if (this$interfaceName == null ? other$interfaceName != null : !this$interfaceName.equals(other$interfaceName)) {
                return false;
            }
            String this$classPackage = this.getClassPackage();
            String other$classPackage = other.getClassPackage();
            if (this$classPackage == null ? other$classPackage != null : !this$classPackage.equals(other$classPackage)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            return !(this$className == null ? other$className != null : !this$className.equals(other$className));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessingType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $interfacePackage = this.getInterfacePackage();
            result = result * 59 + ($interfacePackage == null ? 43 : $interfacePackage.hashCode());
            String $interfaceName = this.getInterfaceName();
            result = result * 59 + ($interfaceName == null ? 43 : $interfaceName.hashCode());
            String $classPackage = this.getClassPackage();
            result = result * 59 + ($classPackage == null ? 43 : $classPackage.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            return result;
        }

        public String toString() {
            return "Structures.ProcessingType(interfacePackage=" + this.getInterfacePackage() + ", interfaceName=" + this.getInterfaceName() + ", classPackage=" + this.getClassPackage() + ", className=" + this.getClassName() + ")";
        }

        public static class ProcessingTypeBuilder {
            private String interfacePackage;
            private String interfaceName;
            private String classPackage;
            private String className;

            ProcessingTypeBuilder() {
            }

            public ProcessingTypeBuilder interfacePackage(String interfacePackage) {
                this.interfacePackage = interfacePackage;
                return this;
            }

            public ProcessingTypeBuilder interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public ProcessingTypeBuilder classPackage(String classPackage) {
                this.classPackage = classPackage;
                return this;
            }

            public ProcessingTypeBuilder className(String className) {
                this.className = className;
                return this;
            }

            public ProcessingType build() {
                return new ProcessingType(this.interfacePackage, this.interfaceName, this.classPackage, this.className);
            }

            public String toString() {
                return "Structures.ProcessingType.ProcessingTypeBuilder(interfacePackage=" + this.interfacePackage + ", interfaceName=" + this.interfaceName + ", classPackage=" + this.classPackage + ", className=" + this.className + ")";
            }
        }
    }

    public static class Constants {
        private boolean forPublic;
        private boolean forClass;
        private boolean forInterface;

        Constants(boolean forPublic, boolean forClass, boolean forInterface) {
            this.forPublic = forPublic;
            this.forClass = forClass;
            this.forInterface = forInterface;
        }

        public static ConstantsBuilder builder() {
            return new ConstantsBuilder();
        }

        public boolean isForPublic() {
            return this.forPublic;
        }

        public boolean isForClass() {
            return this.forClass;
        }

        public boolean isForInterface() {
            return this.forInterface;
        }

        public void setForPublic(boolean forPublic) {
            this.forPublic = forPublic;
        }

        public void setForClass(boolean forClass) {
            this.forClass = forClass;
        }

        public void setForInterface(boolean forInterface) {
            this.forInterface = forInterface;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constants)) {
                return false;
            }
            Constants other = (Constants)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isForPublic() != other.isForPublic()) {
                return false;
            }
            if (this.isForClass() != other.isForClass()) {
                return false;
            }
            return this.isForInterface() == other.isForInterface();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Constants;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isForPublic() ? 79 : 97);
            result = result * 59 + (this.isForClass() ? 79 : 97);
            result = result * 59 + (this.isForInterface() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "Structures.Constants(forPublic=" + this.isForPublic() + ", forClass=" + this.isForClass() + ", forInterface=" + this.isForInterface() + ")";
        }

        public static class ConstantsBuilder {
            private boolean forPublic;
            private boolean forClass;
            private boolean forInterface;

            ConstantsBuilder() {
            }

            public ConstantsBuilder forPublic(boolean forPublic) {
                this.forPublic = forPublic;
                return this;
            }

            public ConstantsBuilder forClass(boolean forClass) {
                this.forClass = forClass;
                return this;
            }

            public ConstantsBuilder forInterface(boolean forInterface) {
                this.forInterface = forInterface;
                return this;
            }

            public Constants build() {
                return new Constants(this.forPublic, this.forClass, this.forInterface);
            }

            public String toString() {
                return "Structures.Constants.ConstantsBuilder(forPublic=" + this.forPublic + ", forClass=" + this.forClass + ", forInterface=" + this.forInterface + ")";
            }
        }
    }

    public static class Ignores {
        private boolean forField;
        private boolean forClass;
        private boolean forInterface;
        private boolean forModifier;

        Ignores(boolean forField, boolean forClass, boolean forInterface, boolean forModifier) {
            this.forField = forField;
            this.forClass = forClass;
            this.forInterface = forInterface;
            this.forModifier = forModifier;
        }

        public static IgnoresBuilder builder() {
            return new IgnoresBuilder();
        }

        public boolean isForField() {
            return this.forField;
        }

        public boolean isForClass() {
            return this.forClass;
        }

        public boolean isForInterface() {
            return this.forInterface;
        }

        public boolean isForModifier() {
            return this.forModifier;
        }

        public void setForField(boolean forField) {
            this.forField = forField;
        }

        public void setForClass(boolean forClass) {
            this.forClass = forClass;
        }

        public void setForInterface(boolean forInterface) {
            this.forInterface = forInterface;
        }

        public void setForModifier(boolean forModifier) {
            this.forModifier = forModifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ignores)) {
                return false;
            }
            Ignores other = (Ignores)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isForField() != other.isForField()) {
                return false;
            }
            if (this.isForClass() != other.isForClass()) {
                return false;
            }
            if (this.isForInterface() != other.isForInterface()) {
                return false;
            }
            return this.isForModifier() == other.isForModifier();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ignores;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isForField() ? 79 : 97);
            result = result * 59 + (this.isForClass() ? 79 : 97);
            result = result * 59 + (this.isForInterface() ? 79 : 97);
            result = result * 59 + (this.isForModifier() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "Structures.Ignores(forField=" + this.isForField() + ", forClass=" + this.isForClass() + ", forInterface=" + this.isForInterface() + ", forModifier=" + this.isForModifier() + ")";
        }

        public static class IgnoresBuilder {
            private boolean forField;
            private boolean forClass;
            private boolean forInterface;
            private boolean forModifier;

            IgnoresBuilder() {
            }

            public IgnoresBuilder forField(boolean forField) {
                this.forField = forField;
                return this;
            }

            public IgnoresBuilder forClass(boolean forClass) {
                this.forClass = forClass;
                return this;
            }

            public IgnoresBuilder forInterface(boolean forInterface) {
                this.forInterface = forInterface;
                return this;
            }

            public IgnoresBuilder forModifier(boolean forModifier) {
                this.forModifier = forModifier;
                return this;
            }

            public Ignores build() {
                return new Ignores(this.forField, this.forClass, this.forInterface, this.forModifier);
            }

            public String toString() {
                return "Structures.Ignores.IgnoresBuilder(forField=" + this.forField + ", forClass=" + this.forClass + ", forInterface=" + this.forInterface + ", forModifier=" + this.forModifier + ")";
            }
        }
    }

    public static class Parsed<T extends TypeDeclaration<T>>
    implements PrototypeDescription<T> {
        private boolean processed;
        private boolean invalid;
        private JavaParser parser;
        private Class<?> compiled;
        private String prototypeFileName;
        private String prototypeClassName;
        private PrototypeDataHandler properties;
        private String parsedName;
        private String parsedFullName;
        private String interfaceName;
        private String interfaceFullName;
        private TypeDeclaration<T> declaration;
        private List<CompilationUnit> files;
        private Parsed<T> base;
        private Parsed<T> mixIn;
        private boolean nested;
        private Map<String, ClassOrInterfaceDeclaration> classes;
        private List<PrototypeField> fields;
        private ClassOrInterfaceDeclaration spec;
        private ClassOrInterfaceDeclaration intf;
        private List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> initializers;
        private List<Consumer<BlockStmt>> customInitializers;
        private List<Runnable> postProcessActions;

        @Override
        public String getImplementorFullName() {
            if (Objects.nonNull(this.mixIn)) {
                return this.mixIn.parsedFullName;
            }
            return this.parsedFullName;
        }

        @Override
        public void registerClass(String key, ClassOrInterfaceDeclaration declaration) {
            this.classes.put(key, declaration);
        }

        @Override
        public ClassOrInterfaceDeclaration getRegisteredClass(String key) {
            return this.classes.get(key);
        }

        @Override
        public void registerPostProcessAction(Runnable task) {
            this.postProcessActions.add(task);
        }

        @Override
        public void processActions() {
            this.postProcessActions.forEach(Runnable::run);
        }

        @Override
        public boolean isValid() {
            return Objects.nonNull(this.properties);
        }

        @Override
        public Optional<PrototypeField> findField(String name) {
            Optional<PrototypeField> result = this.fields.stream().filter(f -> f.getName().equals(name)).findFirst();
            if (result.isEmpty() && Objects.nonNull(this.getBase())) {
                result = ((Parsed)this.getBase()).getFields().stream().filter(f -> f.getName().equals(name)).findFirst();
            }
            return result;
        }

        private static <T extends TypeDeclaration<T>> Map<String, ClassOrInterfaceDeclaration> $default$classes() {
            return new HashMap<String, ClassOrInterfaceDeclaration>();
        }

        private static <T extends TypeDeclaration<T>> List<PrototypeField> $default$fields() {
            return new ArrayList<PrototypeField>();
        }

        private static <T extends TypeDeclaration<T>> List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> $default$initializers() {
            return new ArrayList<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>>();
        }

        private static <T extends TypeDeclaration<T>> List<Consumer<BlockStmt>> $default$customInitializers() {
            return new ArrayList<Consumer<BlockStmt>>();
        }

        private static <T extends TypeDeclaration<T>> List<Runnable> $default$postProcessActions() {
            return new ArrayList<Runnable>();
        }

        Parsed(boolean processed, boolean invalid, JavaParser parser, Class<?> compiled, String prototypeFileName, String prototypeClassName, PrototypeDataHandler properties, String parsedName, String parsedFullName, String interfaceName, String interfaceFullName, TypeDeclaration<T> declaration, List<CompilationUnit> files, Parsed<T> base, Parsed<T> mixIn, boolean nested, Map<String, ClassOrInterfaceDeclaration> classes, List<PrototypeField> fields, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> initializers, List<Consumer<BlockStmt>> customInitializers, List<Runnable> postProcessActions) {
            Helpers.registerKnownEnrichers();
            this.processed = processed;
            this.invalid = invalid;
            this.parser = parser;
            this.compiled = compiled;
            this.prototypeFileName = prototypeFileName;
            this.prototypeClassName = prototypeClassName;
            this.properties = properties;
            this.parsedName = parsedName;
            this.parsedFullName = parsedFullName;
            this.interfaceName = interfaceName;
            this.interfaceFullName = interfaceFullName;
            this.declaration = declaration;
            this.files = files;
            this.base = base;
            this.mixIn = mixIn;
            this.nested = nested;
            this.classes = classes;
            this.fields = fields;
            this.spec = spec;
            this.intf = intf;
            this.initializers = initializers;
            this.customInitializers = customInitializers;
            this.postProcessActions = postProcessActions;
        }

        public static <T extends TypeDeclaration<T>> ParsedBuilder<T> builder() {
            return new ParsedBuilder();
        }

        @Override
        public boolean isProcessed() {
            return this.processed;
        }

        @Override
        public boolean isInvalid() {
            return this.invalid;
        }

        @Override
        public JavaParser getParser() {
            return this.parser;
        }

        @Override
        public Class<?> getCompiled() {
            return this.compiled;
        }

        @Override
        public String getPrototypeFileName() {
            return this.prototypeFileName;
        }

        public String getPrototypeClassName() {
            return this.prototypeClassName;
        }

        @Override
        public PrototypeDataHandler getProperties() {
            return this.properties;
        }

        @Override
        public String getParsedName() {
            return this.parsedName;
        }

        @Override
        public String getParsedFullName() {
            return this.parsedFullName;
        }

        @Override
        public String getInterfaceName() {
            return this.interfaceName;
        }

        @Override
        public String getInterfaceFullName() {
            return this.interfaceFullName;
        }

        @Override
        public TypeDeclaration<T> getDeclaration() {
            return this.declaration;
        }

        @Override
        public List<CompilationUnit> getFiles() {
            return this.files;
        }

        @Override
        public Parsed<T> getBase() {
            return this.base;
        }

        @Override
        public Parsed<T> getMixIn() {
            return this.mixIn;
        }

        @Override
        public boolean isNested() {
            return this.nested;
        }

        public Map<String, ClassOrInterfaceDeclaration> getClasses() {
            return this.classes;
        }

        @Override
        public List<PrototypeField> getFields() {
            return this.fields;
        }

        @Override
        public ClassOrInterfaceDeclaration getSpec() {
            return this.spec;
        }

        @Override
        public ClassOrInterfaceDeclaration getIntf() {
            return this.intf;
        }

        @Override
        public List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> getInitializers() {
            return this.initializers;
        }

        @Override
        public List<Consumer<BlockStmt>> getCustomInitializers() {
            return this.customInitializers;
        }

        public List<Runnable> getPostProcessActions() {
            return this.postProcessActions;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public void setInvalid(boolean invalid) {
            this.invalid = invalid;
        }

        public void setParser(JavaParser parser) {
            this.parser = parser;
        }

        public void setCompiled(Class<?> compiled) {
            this.compiled = compiled;
        }

        public void setPrototypeFileName(String prototypeFileName) {
            this.prototypeFileName = prototypeFileName;
        }

        public void setPrototypeClassName(String prototypeClassName) {
            this.prototypeClassName = prototypeClassName;
        }

        public void setProperties(PrototypeDataHandler properties) {
            this.properties = properties;
        }

        public void setParsedName(String parsedName) {
            this.parsedName = parsedName;
        }

        public void setParsedFullName(String parsedFullName) {
            this.parsedFullName = parsedFullName;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public void setInterfaceFullName(String interfaceFullName) {
            this.interfaceFullName = interfaceFullName;
        }

        public void setDeclaration(TypeDeclaration<T> declaration) {
            this.declaration = declaration;
        }

        public void setFiles(List<CompilationUnit> files) {
            this.files = files;
        }

        public void setBase(Parsed<T> base) {
            this.base = base;
        }

        public void setMixIn(Parsed<T> mixIn) {
            this.mixIn = mixIn;
        }

        public void setNested(boolean nested) {
            this.nested = nested;
        }

        public void setClasses(Map<String, ClassOrInterfaceDeclaration> classes) {
            this.classes = classes;
        }

        public void setFields(List<PrototypeField> fields) {
            this.fields = fields;
        }

        public void setSpec(ClassOrInterfaceDeclaration spec) {
            this.spec = spec;
        }

        public void setIntf(ClassOrInterfaceDeclaration intf) {
            this.intf = intf;
        }

        public void setInitializers(List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> initializers) {
            this.initializers = initializers;
        }

        public void setCustomInitializers(List<Consumer<BlockStmt>> customInitializers) {
            this.customInitializers = customInitializers;
        }

        public void setPostProcessActions(List<Runnable> postProcessActions) {
            this.postProcessActions = postProcessActions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parsed)) {
                return false;
            }
            Parsed other = (Parsed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isProcessed() != other.isProcessed()) {
                return false;
            }
            if (this.isInvalid() != other.isInvalid()) {
                return false;
            }
            if (this.isNested() != other.isNested()) {
                return false;
            }
            JavaParser this$parser = this.getParser();
            JavaParser other$parser = other.getParser();
            if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
                return false;
            }
            Class<?> this$compiled = this.getCompiled();
            Class<?> other$compiled = other.getCompiled();
            if (this$compiled == null ? other$compiled != null : !this$compiled.equals(other$compiled)) {
                return false;
            }
            String this$prototypeFileName = this.getPrototypeFileName();
            String other$prototypeFileName = other.getPrototypeFileName();
            if (this$prototypeFileName == null ? other$prototypeFileName != null : !this$prototypeFileName.equals(other$prototypeFileName)) {
                return false;
            }
            String this$prototypeClassName = this.getPrototypeClassName();
            String other$prototypeClassName = other.getPrototypeClassName();
            if (this$prototypeClassName == null ? other$prototypeClassName != null : !this$prototypeClassName.equals(other$prototypeClassName)) {
                return false;
            }
            PrototypeDataHandler this$properties = this.getProperties();
            PrototypeDataHandler other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
                return false;
            }
            String this$parsedName = this.getParsedName();
            String other$parsedName = other.getParsedName();
            if (this$parsedName == null ? other$parsedName != null : !this$parsedName.equals(other$parsedName)) {
                return false;
            }
            String this$parsedFullName = this.getParsedFullName();
            String other$parsedFullName = other.getParsedFullName();
            if (this$parsedFullName == null ? other$parsedFullName != null : !this$parsedFullName.equals(other$parsedFullName)) {
                return false;
            }
            String this$interfaceName = this.getInterfaceName();
            String other$interfaceName = other.getInterfaceName();
            if (this$interfaceName == null ? other$interfaceName != null : !this$interfaceName.equals(other$interfaceName)) {
                return false;
            }
            String this$interfaceFullName = this.getInterfaceFullName();
            String other$interfaceFullName = other.getInterfaceFullName();
            if (this$interfaceFullName == null ? other$interfaceFullName != null : !this$interfaceFullName.equals(other$interfaceFullName)) {
                return false;
            }
            TypeDeclaration<T> this$declaration = this.getDeclaration();
            TypeDeclaration<T> other$declaration = other.getDeclaration();
            if (this$declaration == null ? other$declaration != null : !this$declaration.equals(other$declaration)) {
                return false;
            }
            List<CompilationUnit> this$files = this.getFiles();
            List<CompilationUnit> other$files = other.getFiles();
            if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
                return false;
            }
            PrototypeDescription this$base = this.getBase();
            PrototypeDescription other$base = other.getBase();
            if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
                return false;
            }
            PrototypeDescription this$mixIn = this.getMixIn();
            PrototypeDescription other$mixIn = other.getMixIn();
            if (this$mixIn == null ? other$mixIn != null : !this$mixIn.equals(other$mixIn)) {
                return false;
            }
            ClassOrInterfaceDeclaration this$spec = this.getSpec();
            ClassOrInterfaceDeclaration other$spec = other.getSpec();
            if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
                return false;
            }
            ClassOrInterfaceDeclaration this$intf = this.getIntf();
            ClassOrInterfaceDeclaration other$intf = other.getIntf();
            if (this$intf == null ? other$intf != null : !this$intf.equals(other$intf)) {
                return false;
            }
            List<Runnable> this$postProcessActions = this.getPostProcessActions();
            List<Runnable> other$postProcessActions = other.getPostProcessActions();
            return !(this$postProcessActions == null ? other$postProcessActions != null : !((Object)this$postProcessActions).equals(other$postProcessActions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parsed;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isProcessed() ? 79 : 97);
            result = result * 59 + (this.isInvalid() ? 79 : 97);
            result = result * 59 + (this.isNested() ? 79 : 97);
            JavaParser $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            Class<?> $compiled = this.getCompiled();
            result = result * 59 + ($compiled == null ? 43 : $compiled.hashCode());
            String $prototypeFileName = this.getPrototypeFileName();
            result = result * 59 + ($prototypeFileName == null ? 43 : $prototypeFileName.hashCode());
            String $prototypeClassName = this.getPrototypeClassName();
            result = result * 59 + ($prototypeClassName == null ? 43 : $prototypeClassName.hashCode());
            PrototypeDataHandler $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
            String $parsedName = this.getParsedName();
            result = result * 59 + ($parsedName == null ? 43 : $parsedName.hashCode());
            String $parsedFullName = this.getParsedFullName();
            result = result * 59 + ($parsedFullName == null ? 43 : $parsedFullName.hashCode());
            String $interfaceName = this.getInterfaceName();
            result = result * 59 + ($interfaceName == null ? 43 : $interfaceName.hashCode());
            String $interfaceFullName = this.getInterfaceFullName();
            result = result * 59 + ($interfaceFullName == null ? 43 : $interfaceFullName.hashCode());
            TypeDeclaration<T> $declaration = this.getDeclaration();
            result = result * 59 + ($declaration == null ? 43 : $declaration.hashCode());
            List<CompilationUnit> $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            PrototypeDescription $base = this.getBase();
            result = result * 59 + ($base == null ? 43 : $base.hashCode());
            PrototypeDescription $mixIn = this.getMixIn();
            result = result * 59 + ($mixIn == null ? 43 : $mixIn.hashCode());
            ClassOrInterfaceDeclaration $spec = this.getSpec();
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            ClassOrInterfaceDeclaration $intf = this.getIntf();
            result = result * 59 + ($intf == null ? 43 : $intf.hashCode());
            List<Runnable> $postProcessActions = this.getPostProcessActions();
            result = result * 59 + ($postProcessActions == null ? 43 : ((Object)$postProcessActions).hashCode());
            return result;
        }

        public String toString() {
            return "Structures.Parsed(processed=" + this.isProcessed() + ", invalid=" + this.isInvalid() + ", parser=" + this.getParser() + ", compiled=" + this.getCompiled() + ", prototypeFileName=" + this.getPrototypeFileName() + ", prototypeClassName=" + this.getPrototypeClassName() + ", properties=" + this.getProperties() + ", parsedName=" + this.getParsedName() + ", parsedFullName=" + this.getParsedFullName() + ", interfaceName=" + this.getInterfaceName() + ", interfaceFullName=" + this.getInterfaceFullName() + ", declaration=" + this.getDeclaration() + ", files=" + this.getFiles() + ", base=" + (Parsed)this.getBase() + ", mixIn=" + (Parsed)this.getMixIn() + ", nested=" + this.isNested() + ", spec=" + this.getSpec() + ", intf=" + this.getIntf() + ")";
        }

        public static class ParsedBuilder<T extends TypeDeclaration<T>> {
            private boolean processed;
            private boolean invalid;
            private JavaParser parser;
            private Class<?> compiled;
            private String prototypeFileName;
            private String prototypeClassName;
            private PrototypeDataHandler properties;
            private String parsedName;
            private String parsedFullName;
            private String interfaceName;
            private String interfaceFullName;
            private TypeDeclaration<T> declaration;
            private List<CompilationUnit> files;
            private Parsed<T> base;
            private Parsed<T> mixIn;
            private boolean nested;
            private boolean classes$set;
            private Map<String, ClassOrInterfaceDeclaration> classes$value;
            private boolean fields$set;
            private List<PrototypeField> fields$value;
            private ClassOrInterfaceDeclaration spec;
            private ClassOrInterfaceDeclaration intf;
            private boolean initializers$set;
            private List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> initializers$value;
            private boolean customInitializers$set;
            private List<Consumer<BlockStmt>> customInitializers$value;
            private boolean postProcessActions$set;
            private List<Runnable> postProcessActions$value;

            ParsedBuilder() {
            }

            public ParsedBuilder<T> processed(boolean processed) {
                this.processed = processed;
                return this;
            }

            public ParsedBuilder<T> invalid(boolean invalid) {
                this.invalid = invalid;
                return this;
            }

            public ParsedBuilder<T> parser(JavaParser parser) {
                this.parser = parser;
                return this;
            }

            public ParsedBuilder<T> compiled(Class<?> compiled) {
                this.compiled = compiled;
                return this;
            }

            public ParsedBuilder<T> prototypeFileName(String prototypeFileName) {
                this.prototypeFileName = prototypeFileName;
                return this;
            }

            public ParsedBuilder<T> prototypeClassName(String prototypeClassName) {
                this.prototypeClassName = prototypeClassName;
                return this;
            }

            public ParsedBuilder<T> properties(PrototypeDataHandler properties) {
                this.properties = properties;
                return this;
            }

            public ParsedBuilder<T> parsedName(String parsedName) {
                this.parsedName = parsedName;
                return this;
            }

            public ParsedBuilder<T> parsedFullName(String parsedFullName) {
                this.parsedFullName = parsedFullName;
                return this;
            }

            public ParsedBuilder<T> interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public ParsedBuilder<T> interfaceFullName(String interfaceFullName) {
                this.interfaceFullName = interfaceFullName;
                return this;
            }

            public ParsedBuilder<T> declaration(TypeDeclaration<T> declaration) {
                this.declaration = declaration;
                return this;
            }

            public ParsedBuilder<T> files(List<CompilationUnit> files) {
                this.files = files;
                return this;
            }

            public ParsedBuilder<T> base(Parsed<T> base) {
                this.base = base;
                return this;
            }

            public ParsedBuilder<T> mixIn(Parsed<T> mixIn) {
                this.mixIn = mixIn;
                return this;
            }

            public ParsedBuilder<T> nested(boolean nested) {
                this.nested = nested;
                return this;
            }

            public ParsedBuilder<T> classes(Map<String, ClassOrInterfaceDeclaration> classes) {
                this.classes$value = classes;
                this.classes$set = true;
                return this;
            }

            public ParsedBuilder<T> fields(List<PrototypeField> fields) {
                this.fields$value = fields;
                this.fields$set = true;
                return this;
            }

            public ParsedBuilder<T> spec(ClassOrInterfaceDeclaration spec) {
                this.spec = spec;
                return this;
            }

            public ParsedBuilder<T> intf(ClassOrInterfaceDeclaration intf) {
                this.intf = intf;
                return this;
            }

            public ParsedBuilder<T> initializers(List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> initializers) {
                this.initializers$value = initializers;
                this.initializers$set = true;
                return this;
            }

            public ParsedBuilder<T> customInitializers(List<Consumer<BlockStmt>> customInitializers) {
                this.customInitializers$value = customInitializers;
                this.customInitializers$set = true;
                return this;
            }

            public ParsedBuilder<T> postProcessActions(List<Runnable> postProcessActions) {
                this.postProcessActions$value = postProcessActions;
                this.postProcessActions$set = true;
                return this;
            }

            public Parsed<T> build() {
                Map<String, ClassOrInterfaceDeclaration> classes$value = this.classes$value;
                if (!this.classes$set) {
                    classes$value = Parsed.$default$classes();
                }
                List<PrototypeField> fields$value = this.fields$value;
                if (!this.fields$set) {
                    fields$value = Parsed.$default$fields();
                }
                List<Triple<ClassOrInterfaceDeclaration, Node, ClassOrInterfaceDeclaration>> initializers$value = this.initializers$value;
                if (!this.initializers$set) {
                    initializers$value = Parsed.$default$initializers();
                }
                List<Consumer<BlockStmt>> customInitializers$value = this.customInitializers$value;
                if (!this.customInitializers$set) {
                    customInitializers$value = Parsed.$default$customInitializers();
                }
                List<Runnable> postProcessActions$value = this.postProcessActions$value;
                if (!this.postProcessActions$set) {
                    postProcessActions$value = Parsed.$default$postProcessActions();
                }
                return new Parsed<T>(this.processed, this.invalid, this.parser, this.compiled, this.prototypeFileName, this.prototypeClassName, this.properties, this.parsedName, this.parsedFullName, this.interfaceName, this.interfaceFullName, this.declaration, this.files, this.base, this.mixIn, this.nested, classes$value, fields$value, this.spec, this.intf, initializers$value, customInitializers$value, postProcessActions$value);
            }

            public String toString() {
                return "Structures.Parsed.ParsedBuilder(processed=" + this.processed + ", invalid=" + this.invalid + ", parser=" + this.parser + ", compiled=" + this.compiled + ", prototypeFileName=" + this.prototypeFileName + ", prototypeClassName=" + this.prototypeClassName + ", properties=" + this.properties + ", parsedName=" + this.parsedName + ", parsedFullName=" + this.parsedFullName + ", interfaceName=" + this.interfaceName + ", interfaceFullName=" + this.interfaceFullName + ", declaration=" + this.declaration + ", files=" + this.files + ", base=" + this.base + ", mixIn=" + this.mixIn + ", nested=" + this.nested + ", classes$value=" + this.classes$value + ", fields$value=" + this.fields$value + ", spec=" + this.spec + ", intf=" + this.intf + ", initializers$value=" + this.initializers$value + ", customInitializers$value=" + this.customInitializers$value + ", postProcessActions$value=" + this.postProcessActions$value + ")";
            }
        }
    }

    public static class FieldData
    implements PrototypeField {
        Parsed<ClassOrInterfaceDeclaration> parsed;
        private String name;
        private FieldDeclaration declaration;
        private MethodDeclaration description;
        private String fullType;
        private String type;
        private boolean collection;
        private boolean external;
        private boolean genericMethod;
        private Ignores ignores;
        private PrototypeDescription<ClassOrInterfaceDeclaration> prototype;
        private Map<String, Type> generics;
        private Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes;
        private List<MethodDeclaration> modifiers;
        MethodDeclaration interfaceGetter;
        MethodDeclaration interfaceSetter;
        MethodDeclaration implementationGetter;
        MethodDeclaration implementationSetter;

        @Override
        public List<MethodDeclaration> getModifiers() {
            if (Objects.isNull(this.modifiers)) {
                this.modifiers = new ArrayList<MethodDeclaration>();
            }
            return this.modifiers;
        }

        @Override
        public void addModifier(MethodDeclaration modifier) {
            this.getModifiers().add(modifier);
        }

        @Override
        public MethodDeclaration generateGetter() {
            ClassOrInterfaceDeclaration cls = (ClassOrInterfaceDeclaration)this.declaration.getParentNode().get();
            Generator.addGetter(this.parsed.getDeclaration().asClassOrInterfaceDeclaration(), cls, this.description, true, this);
            return this.implementationGetter;
        }

        @Override
        public MethodDeclaration generateSetter() {
            ClassOrInterfaceDeclaration cls = (ClassOrInterfaceDeclaration)this.declaration.getParentNode().get();
            Generator.addSetter(this.parsed.getDeclaration().asClassOrInterfaceDeclaration(), cls, this.description, true, this);
            return this.implementationSetter;
        }

        FieldData(Parsed<ClassOrInterfaceDeclaration> parsed, String name, FieldDeclaration declaration, MethodDeclaration description, String fullType, String type, boolean collection, boolean external, boolean genericMethod, Ignores ignores, PrototypeDescription<ClassOrInterfaceDeclaration> prototype, Map<String, Type> generics, Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes, List<MethodDeclaration> modifiers, MethodDeclaration interfaceGetter, MethodDeclaration interfaceSetter, MethodDeclaration implementationGetter, MethodDeclaration implementationSetter) {
            this.parsed = parsed;
            this.name = name;
            this.declaration = declaration;
            this.description = description;
            this.fullType = fullType;
            this.type = type;
            this.collection = collection;
            this.external = external;
            this.genericMethod = genericMethod;
            this.ignores = ignores;
            this.prototype = prototype;
            this.generics = generics;
            this.typePrototypes = typePrototypes;
            this.modifiers = modifiers;
            this.interfaceGetter = interfaceGetter;
            this.interfaceSetter = interfaceSetter;
            this.implementationGetter = implementationGetter;
            this.implementationSetter = implementationSetter;
        }

        public static FieldDataBuilder builder() {
            return new FieldDataBuilder();
        }

        public String toString() {
            return "Structures.FieldData(parsed=" + this.getParsed() + ", name=" + this.getName() + ", declaration=" + this.getDeclaration() + ", description=" + this.getDescription() + ", fullType=" + this.getFullType() + ", type=" + this.getType() + ", collection=" + this.isCollection() + ", external=" + this.isExternal() + ", genericMethod=" + this.isGenericMethod() + ", ignores=" + this.getIgnores() + ", interfaceGetter=" + this.getInterfaceGetter() + ", interfaceSetter=" + this.getInterfaceSetter() + ", implementationGetter=" + this.getImplementationGetter() + ", implementationSetter=" + this.getImplementationSetter() + ")";
        }

        @Override
        public Parsed<ClassOrInterfaceDeclaration> getParsed() {
            return this.parsed;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public FieldDeclaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public MethodDeclaration getDescription() {
            return this.description;
        }

        @Override
        public String getFullType() {
            return this.fullType;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isCollection() {
            return this.collection;
        }

        @Override
        public boolean isExternal() {
            return this.external;
        }

        @Override
        public boolean isGenericMethod() {
            return this.genericMethod;
        }

        @Override
        public Ignores getIgnores() {
            return this.ignores;
        }

        @Override
        public PrototypeDescription<ClassOrInterfaceDeclaration> getPrototype() {
            return this.prototype;
        }

        @Override
        public Map<String, Type> getGenerics() {
            return this.generics;
        }

        @Override
        public Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> getTypePrototypes() {
            return this.typePrototypes;
        }

        @Override
        public MethodDeclaration getInterfaceGetter() {
            return this.interfaceGetter;
        }

        @Override
        public MethodDeclaration getInterfaceSetter() {
            return this.interfaceSetter;
        }

        @Override
        public MethodDeclaration getImplementationGetter() {
            return this.implementationGetter;
        }

        @Override
        public MethodDeclaration getImplementationSetter() {
            return this.implementationSetter;
        }

        public void setParsed(Parsed<ClassOrInterfaceDeclaration> parsed) {
            this.parsed = parsed;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDeclaration(FieldDeclaration declaration) {
            this.declaration = declaration;
        }

        public void setDescription(MethodDeclaration description) {
            this.description = description;
        }

        public void setFullType(String fullType) {
            this.fullType = fullType;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setCollection(boolean collection) {
            this.collection = collection;
        }

        public void setExternal(boolean external) {
            this.external = external;
        }

        public void setGenericMethod(boolean genericMethod) {
            this.genericMethod = genericMethod;
        }

        public void setIgnores(Ignores ignores) {
            this.ignores = ignores;
        }

        public void setPrototype(PrototypeDescription<ClassOrInterfaceDeclaration> prototype) {
            this.prototype = prototype;
        }

        public void setGenerics(Map<String, Type> generics) {
            this.generics = generics;
        }

        public void setTypePrototypes(Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes) {
            this.typePrototypes = typePrototypes;
        }

        public void setModifiers(List<MethodDeclaration> modifiers) {
            this.modifiers = modifiers;
        }

        public void setInterfaceGetter(MethodDeclaration interfaceGetter) {
            this.interfaceGetter = interfaceGetter;
        }

        public void setInterfaceSetter(MethodDeclaration interfaceSetter) {
            this.interfaceSetter = interfaceSetter;
        }

        public void setImplementationGetter(MethodDeclaration implementationGetter) {
            this.implementationGetter = implementationGetter;
        }

        public void setImplementationSetter(MethodDeclaration implementationSetter) {
            this.implementationSetter = implementationSetter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldData)) {
                return false;
            }
            FieldData other = (FieldData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCollection() != other.isCollection()) {
                return false;
            }
            if (this.isExternal() != other.isExternal()) {
                return false;
            }
            if (this.isGenericMethod() != other.isGenericMethod()) {
                return false;
            }
            Parsed<ClassOrInterfaceDeclaration> this$parsed = this.getParsed();
            Parsed<ClassOrInterfaceDeclaration> other$parsed = other.getParsed();
            if (this$parsed == null ? other$parsed != null : !((Object)this$parsed).equals(other$parsed)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            FieldDeclaration this$declaration = this.getDeclaration();
            FieldDeclaration other$declaration = other.getDeclaration();
            if (this$declaration == null ? other$declaration != null : !this$declaration.equals(other$declaration)) {
                return false;
            }
            MethodDeclaration this$description = this.getDescription();
            MethodDeclaration other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$fullType = this.getFullType();
            String other$fullType = other.getFullType();
            if (this$fullType == null ? other$fullType != null : !this$fullType.equals(other$fullType)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Ignores this$ignores = this.getIgnores();
            Ignores other$ignores = other.getIgnores();
            if (this$ignores == null ? other$ignores != null : !((Object)this$ignores).equals(other$ignores)) {
                return false;
            }
            PrototypeDescription<ClassOrInterfaceDeclaration> this$prototype = this.getPrototype();
            PrototypeDescription<ClassOrInterfaceDeclaration> other$prototype = other.getPrototype();
            if (this$prototype == null ? other$prototype != null : !this$prototype.equals(other$prototype)) {
                return false;
            }
            Map<String, Type> this$generics = this.getGenerics();
            Map<String, Type> other$generics = other.getGenerics();
            if (this$generics == null ? other$generics != null : !((Object)this$generics).equals(other$generics)) {
                return false;
            }
            Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> this$typePrototypes = this.getTypePrototypes();
            Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> other$typePrototypes = other.getTypePrototypes();
            if (this$typePrototypes == null ? other$typePrototypes != null : !((Object)this$typePrototypes).equals(other$typePrototypes)) {
                return false;
            }
            List<MethodDeclaration> this$modifiers = this.getModifiers();
            List<MethodDeclaration> other$modifiers = other.getModifiers();
            if (this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers)) {
                return false;
            }
            MethodDeclaration this$interfaceGetter = this.getInterfaceGetter();
            MethodDeclaration other$interfaceGetter = other.getInterfaceGetter();
            if (this$interfaceGetter == null ? other$interfaceGetter != null : !this$interfaceGetter.equals(other$interfaceGetter)) {
                return false;
            }
            MethodDeclaration this$interfaceSetter = this.getInterfaceSetter();
            MethodDeclaration other$interfaceSetter = other.getInterfaceSetter();
            if (this$interfaceSetter == null ? other$interfaceSetter != null : !this$interfaceSetter.equals(other$interfaceSetter)) {
                return false;
            }
            MethodDeclaration this$implementationGetter = this.getImplementationGetter();
            MethodDeclaration other$implementationGetter = other.getImplementationGetter();
            if (this$implementationGetter == null ? other$implementationGetter != null : !this$implementationGetter.equals(other$implementationGetter)) {
                return false;
            }
            MethodDeclaration this$implementationSetter = this.getImplementationSetter();
            MethodDeclaration other$implementationSetter = other.getImplementationSetter();
            return !(this$implementationSetter == null ? other$implementationSetter != null : !this$implementationSetter.equals(other$implementationSetter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCollection() ? 79 : 97);
            result = result * 59 + (this.isExternal() ? 79 : 97);
            result = result * 59 + (this.isGenericMethod() ? 79 : 97);
            Parsed<ClassOrInterfaceDeclaration> $parsed = this.getParsed();
            result = result * 59 + ($parsed == null ? 43 : ((Object)$parsed).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            FieldDeclaration $declaration = this.getDeclaration();
            result = result * 59 + ($declaration == null ? 43 : $declaration.hashCode());
            MethodDeclaration $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $fullType = this.getFullType();
            result = result * 59 + ($fullType == null ? 43 : $fullType.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Ignores $ignores = this.getIgnores();
            result = result * 59 + ($ignores == null ? 43 : ((Object)$ignores).hashCode());
            PrototypeDescription<ClassOrInterfaceDeclaration> $prototype = this.getPrototype();
            result = result * 59 + ($prototype == null ? 43 : $prototype.hashCode());
            Map<String, Type> $generics = this.getGenerics();
            result = result * 59 + ($generics == null ? 43 : ((Object)$generics).hashCode());
            Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> $typePrototypes = this.getTypePrototypes();
            result = result * 59 + ($typePrototypes == null ? 43 : ((Object)$typePrototypes).hashCode());
            List<MethodDeclaration> $modifiers = this.getModifiers();
            result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
            MethodDeclaration $interfaceGetter = this.getInterfaceGetter();
            result = result * 59 + ($interfaceGetter == null ? 43 : $interfaceGetter.hashCode());
            MethodDeclaration $interfaceSetter = this.getInterfaceSetter();
            result = result * 59 + ($interfaceSetter == null ? 43 : $interfaceSetter.hashCode());
            MethodDeclaration $implementationGetter = this.getImplementationGetter();
            result = result * 59 + ($implementationGetter == null ? 43 : $implementationGetter.hashCode());
            MethodDeclaration $implementationSetter = this.getImplementationSetter();
            result = result * 59 + ($implementationSetter == null ? 43 : $implementationSetter.hashCode());
            return result;
        }

        public static class FieldDataBuilder {
            private Parsed<ClassOrInterfaceDeclaration> parsed;
            private String name;
            private FieldDeclaration declaration;
            private MethodDeclaration description;
            private String fullType;
            private String type;
            private boolean collection;
            private boolean external;
            private boolean genericMethod;
            private Ignores ignores;
            private PrototypeDescription<ClassOrInterfaceDeclaration> prototype;
            private Map<String, Type> generics;
            private Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes;
            private List<MethodDeclaration> modifiers;
            private MethodDeclaration interfaceGetter;
            private MethodDeclaration interfaceSetter;
            private MethodDeclaration implementationGetter;
            private MethodDeclaration implementationSetter;

            FieldDataBuilder() {
            }

            public FieldDataBuilder parsed(Parsed<ClassOrInterfaceDeclaration> parsed) {
                this.parsed = parsed;
                return this;
            }

            public FieldDataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public FieldDataBuilder declaration(FieldDeclaration declaration) {
                this.declaration = declaration;
                return this;
            }

            public FieldDataBuilder description(MethodDeclaration description) {
                this.description = description;
                return this;
            }

            public FieldDataBuilder fullType(String fullType) {
                this.fullType = fullType;
                return this;
            }

            public FieldDataBuilder type(String type) {
                this.type = type;
                return this;
            }

            public FieldDataBuilder collection(boolean collection) {
                this.collection = collection;
                return this;
            }

            public FieldDataBuilder external(boolean external) {
                this.external = external;
                return this;
            }

            public FieldDataBuilder genericMethod(boolean genericMethod) {
                this.genericMethod = genericMethod;
                return this;
            }

            public FieldDataBuilder ignores(Ignores ignores) {
                this.ignores = ignores;
                return this;
            }

            public FieldDataBuilder prototype(PrototypeDescription<ClassOrInterfaceDeclaration> prototype) {
                this.prototype = prototype;
                return this;
            }

            public FieldDataBuilder generics(Map<String, Type> generics) {
                this.generics = generics;
                return this;
            }

            public FieldDataBuilder typePrototypes(Map<String, PrototypeDescription<ClassOrInterfaceDeclaration>> typePrototypes) {
                this.typePrototypes = typePrototypes;
                return this;
            }

            public FieldDataBuilder modifiers(List<MethodDeclaration> modifiers) {
                this.modifiers = modifiers;
                return this;
            }

            public FieldDataBuilder interfaceGetter(MethodDeclaration interfaceGetter) {
                this.interfaceGetter = interfaceGetter;
                return this;
            }

            public FieldDataBuilder interfaceSetter(MethodDeclaration interfaceSetter) {
                this.interfaceSetter = interfaceSetter;
                return this;
            }

            public FieldDataBuilder implementationGetter(MethodDeclaration implementationGetter) {
                this.implementationGetter = implementationGetter;
                return this;
            }

            public FieldDataBuilder implementationSetter(MethodDeclaration implementationSetter) {
                this.implementationSetter = implementationSetter;
                return this;
            }

            public FieldData build() {
                return new FieldData(this.parsed, this.name, this.declaration, this.description, this.fullType, this.type, this.collection, this.external, this.genericMethod, this.ignores, this.prototype, this.generics, this.typePrototypes, this.modifiers, this.interfaceGetter, this.interfaceSetter, this.implementationGetter, this.implementationSetter);
            }

            public String toString() {
                return "Structures.FieldData.FieldDataBuilder(parsed=" + this.parsed + ", name=" + this.name + ", declaration=" + this.declaration + ", description=" + this.description + ", fullType=" + this.fullType + ", type=" + this.type + ", collection=" + this.collection + ", external=" + this.external + ", genericMethod=" + this.genericMethod + ", ignores=" + this.ignores + ", prototype=" + this.prototype + ", generics=" + this.generics + ", typePrototypes=" + this.typePrototypes + ", modifiers=" + this.modifiers + ", interfaceGetter=" + this.interfaceGetter + ", interfaceSetter=" + this.interfaceSetter + ", implementationGetter=" + this.implementationGetter + ", implementationSetter=" + this.implementationSetter + ")";
            }
        }
    }
}

