/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.enrich.handler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.binis.codegen.annotation.Embeddable;
import net.binis.codegen.annotation.Final;
import net.binis.codegen.enrich.ModifierEnricher;
import net.binis.codegen.enrich.handler.base.BaseEnricher;
import net.binis.codegen.generation.core.CollectionsHandler;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.generation.core.interfaces.PrototypeField;
import net.binis.codegen.modifier.Modifier;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifierEnricherHandler
extends BaseEnricher
implements ModifierEnricher {
    private static final Logger log = LoggerFactory.getLogger(ModifierEnricherHandler.class);

    @Override
    public void enrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        ClassOrInterfaceDeclaration fields;
        String methodName;
        if (Helpers.hasAnnotation(description, Embeddable.class)) {
            this.lookup.generateEmbeddedModifier(description);
        }
        ArrayList<Pair<CompilationUnit, String>> imports = new ArrayList<Pair<CompilationUnit, String>>();
        ClassOrInterfaceDeclaration spec = description.getSpec();
        if (Objects.nonNull(description.getProperties().getMixInClass())) {
            spec = description.getMixIn().getSpec();
        }
        ClassOrInterfaceDeclaration intf = description.getIntf();
        PrototypeData properties = description.getProperties();
        String entity = description.getProperties().getInterfaceName();
        ClassOrInterfaceDeclaration modifier = new ClassOrInterfaceDeclaration(com.github.javaparser.ast.Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, properties.getModifierName());
        ClassOrInterfaceDeclaration modifierClass = null;
        ClassOrInterfaceDeclaration modifierFields = (ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(com.github.javaparser.ast.Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), true, "Fields").addTypeParameter("T");
        description.registerClass("ModifierIntf", modifier);
        String string = methodName = Objects.isNull(properties.getMixInClass()) ? "with" : "as" + intf.getNameAsString();
        if (!description.getProperties().isBase()) {
            modifierClass = new ClassOrInterfaceDeclaration(com.github.javaparser.ast.Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}), false, Helpers.defaultModifierClassName(properties.getClassName()));
            modifierClass.addImplementedType(properties.getLongModifierName());
            description.registerClass("Modifier", modifierClass);
            spec.addMember((BodyDeclaration)modifierClass);
            intf.addMember((BodyDeclaration)modifier);
            ModifierEnricherHandler.addModifyMethod(methodName, spec, properties.getLongModifierName(), modifierClass.getNameAsString(), true);
            ModifierEnricherHandler.addModifyMethod(methodName, intf, properties.getLongModifierName(), null, false);
            ModifierEnricherHandler.addDoneMethod(modifierClass, properties.getInterfaceName(), Objects.isNull(properties.getMixInClass()) ? properties.getClassName() : description.getMixIn().getParsedName(), true);
            ModifierEnricherHandler.addDoneMethod(modifier, properties.getInterfaceName(), null, false);
            ModifierEnricherHandler.handleModifierBaseImplementation(Objects.isNull(properties.getMixInClass()) ? description : description.getMixIn(), spec, intf, modifier, modifierClass);
            ((CompilationUnit)spec.findCompilationUnit().get()).addImport("net.binis.codegen.modifier.Modifiable");
        }
        if (Objects.isNull(description.getMixIn()) && !description.getProperties().isBase()) {
            spec.addImplementedType("Modifiable<" + intf.getNameAsString() + "." + modifier.getNameAsString() + ">");
        }
        for (PrototypeField prototypeField : description.getFields()) {
            this.declare(description, properties, modifier, modifierClass, modifierFields, prototypeField, description.getDeclaration(), imports);
        }
        if (Objects.nonNull(description.getBase())) {
            fields = description.getBase().getRegisteredClass("ModifierFields");
            if (Objects.nonNull(fields)) {
                modifierFields.addExtendedType(description.getBase().getInterfaceName() + "." + fields.getNameAsString() + "<T>");
                for (PrototypeField field : description.getBase().getFields()) {
                    this.declare(description, properties, modifier, modifierClass, null, field, description.getBase().getDeclaration(), imports);
                }
            } else {
                for (PrototypeField field : description.getBase().getFields()) {
                    this.declare(description, properties, modifier, modifierClass, modifierFields, field, description.getBase().getDeclaration(), imports);
                }
            }
        }
        if (Objects.nonNull(description.getMixIn())) {
            fields = description.getMixIn().getRegisteredClass("ModifierFields");
            if (Objects.nonNull(fields)) {
                modifierFields.addExtendedType(description.getMixIn().getInterfaceName() + "." + fields.getNameAsString() + "<T>");
                for (PrototypeField field : description.getMixIn().getFields()) {
                    this.declare(description, properties, modifier, modifierClass, null, field, description.getMixIn().getDeclaration(), imports);
                }
            } else {
                for (PrototypeField field : description.getMixIn().getFields()) {
                    this.declare(description, properties, modifier, modifierClass, modifierFields, field, description.getMixIn().getDeclaration(), imports);
                }
            }
            if (Objects.nonNull(description.getMixIn().getBase())) {
                ClassOrInterfaceDeclaration classOrInterfaceDeclaration = description.getMixIn().getBase().getRegisteredClass("ModifierFields");
                if (Objects.nonNull(classOrInterfaceDeclaration)) {
                    String type = description.getMixIn().getBase().getInterfaceName() + "." + classOrInterfaceDeclaration.getNameAsString() + "<T>";
                    if (fields.getExtendedTypes().stream().noneMatch(t -> t.toString().equals(type))) {
                        modifierFields.addExtendedType(type);
                    }
                    for (PrototypeField field : description.getMixIn().getBase().getFields()) {
                        this.declare(description, properties, modifier, modifierClass, null, field, description.getMixIn().getBase().getDeclaration(), imports);
                    }
                } else {
                    for (PrototypeField field : description.getMixIn().getBase().getFields()) {
                        this.declare(description, properties, modifier, modifierClass, modifierFields, field, description.getMixIn().getBase().getDeclaration(), imports);
                    }
                }
            }
        }
        if (!modifierFields.isEmpty()) {
            intf.addMember((BodyDeclaration)modifierFields);
            description.registerClass("ModifierFields", modifierFields);
            modifier.addExtendedType(intf.getNameAsString() + "." + modifierFields.getNameAsString() + "<" + intf.getNameAsString() + "." + modifier.getNameAsString() + ">");
            intf.findCompilationUnit().ifPresent(dest -> imports.forEach(pair -> Tools.notNull(Helpers.getExternalClassNameIfExists((CompilationUnit)pair.getKey(), (String)pair.getValue()), arg_0 -> ((CompilationUnit)dest).addImport(arg_0))));
        }
    }

    private void declare(PrototypeDescription<ClassOrInterfaceDeclaration> description, PrototypeData properties, ClassOrInterfaceDeclaration modifier, ClassOrInterfaceDeclaration modifierClass, ClassOrInterfaceDeclaration modifierFields, PrototypeField field, TypeDeclaration<ClassOrInterfaceDeclaration> classDeclaration, List<Pair<CompilationUnit, String>> imports) {
        if (!field.getIgnores().isForModifier()) {
            Type type = this.getFieldType(field);
            if (Objects.nonNull(modifierClass)) {
                this.addModifier(modifierClass, field, Objects.isNull(properties.getMixInClass()) ? properties.getClassName() : description.getMixIn().getParsedName(), properties.getLongModifierName(), true);
            }
            if (CollectionsHandler.isCollection(type)) {
                this.addModifier(modifier, field, null, properties.getModifierName(), false);
                CollectionsHandler.addModifier(modifierClass, field, properties.getLongModifierName(), Objects.isNull(properties.getMixInClass()) ? properties.getClassName() : description.getMixIn().getParsedName(), true);
                CollectionsHandler.addModifier(modifier, field, properties.getModifierName(), null, false);
                Tools.notNull(this.lookup.findParsed(CollectionsHandler.getFullCollectionType(type)), parsed -> this.lookup.generateEmbeddedModifier((PrototypeDescription<ClassOrInterfaceDeclaration>)parsed));
            } else {
                this.addField(field, modifierFields, imports);
            }
        }
    }

    private Type getFieldType(PrototypeField field) {
        if (field.getDescription().getTypeParameters().isEmpty()) {
            return Objects.isNull(field.getDescription()) ? ((VariableDeclarator)field.getDeclaration().getVariables().get(0)).getType() : field.getDescription().getType();
        }
        return (Type)new ClassOrInterfaceType().setName("Object");
    }

    private void addField(PrototypeField field, ClassOrInterfaceDeclaration modifierFields, List<Pair<CompilationUnit, String>> imports) {
        if (Objects.nonNull(modifierFields)) {
            Type type = field.getDeclaration().getVariable(0).getType();
            ((MethodDeclaration)((MethodDeclaration)modifierFields.addMethod(field.getName(), new Modifier.Keyword[0]).setType("T")).addParameter(type, field.getName())).setBody(null);
            field.getDeclaration().findCompilationUnit().ifPresent(source -> imports.add(Pair.of((Object)source, (Object)type.asString())));
        }
    }

    private static void addModifyMethod(String methodName, ClassOrInterfaceDeclaration spec, String modifierName, String modifierClassName, boolean isClass) {
        MethodDeclaration method = (MethodDeclaration)spec.addMethod(methodName, new Modifier.Keyword[0]).setType(modifierName);
        if (isClass) {
            ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("new " + modifierClassName + "()"))));
        } else {
            method.setBody(null);
        }
    }

    private static void addDoneMethod(ClassOrInterfaceDeclaration spec, String parentName, String parentClassName, boolean isClass) {
        MethodDeclaration method = (MethodDeclaration)spec.addMethod("done", new Modifier.Keyword[0]).setType(parentName);
        if (isClass) {
            ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName(parentClassName + ".this"))));
        } else {
            method.setBody(null);
        }
    }

    private static void handleModifierBaseImplementation(PrototypeDescription<ClassOrInterfaceDeclaration> parse, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, ClassOrInterfaceDeclaration modifier, ClassOrInterfaceDeclaration modifierClass) {
        Tools.notNull(Generator.findInheritanceProperty(parse.getDeclaration().asClassOrInterfaceDeclaration(), parse.getProperties(), (s, p) -> (String)((Object)Tools.nullCheck(p.getBaseModifierClass(), prp -> Helpers.getExternalClassName((CompilationUnit)s.findCompilationUnit().get(), prp)))), baseClass -> Tools.notNull(Reflection.loadClass((String)baseClass), cls -> {
            if (Modifier.class.isAssignableFrom((Class<?>)cls)) {
                modifierClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).setBody((BlockStmt)new BlockStmt().addStatement("setObject(" + parse.getProperties().getClassName() + ".this);"));
                ((CompilationUnit)spec.findCompilationUnit().get()).addImport(Modifier.class);
            }
            ((CompilationUnit)spec.findCompilationUnit().get()).addImport(baseClass);
            String intfName = intf.getNameAsString();
            String modName = intfName + "." + modifier.getNameAsString();
            List<String> signature = Helpers.parseGenericClassSignature(cls);
            if (signature.size() != 2) {
                log.error("BaseModifier ({}) should have two generic params!", (Object)cls.getCanonicalName());
            }
            Map<String, String> clsSignature = Map.of(signature.get(0), modName, signature.get(1), intfName);
            modifierClass.addExtendedType(cls.getSimpleName() + "<" + modName + ", " + intfName + ">");
            for (Method method : cls.getDeclaredMethods()) {
                if (!java.lang.reflect.Modifier.isPublic(method.getModifiers()) || java.lang.reflect.Modifier.isStatic(method.getModifiers()) || "setObject".equals(method.getName())) continue;
                Final ann = method.getAnnotation(Final.class);
                if (Objects.nonNull(ann)) {
                    if (StringUtils.isBlank((CharSequence)ann.description())) {
                        Generator.addMethod(modifier, method, clsSignature, intfName);
                        continue;
                    }
                    Generator.addMethod(modifier, method, clsSignature, modName, intfName, ann);
                    continue;
                }
                Generator.addMethod(modifier, method, clsSignature, modName);
            }
            if (Objects.nonNull(cls.getSuperclass()) && Modifier.class.isAssignableFrom((Class<?>)cls)) {
                ModifierEnricherHandler.handleSuperModifierBaseImplementation(parse, spec, intf, modifier, modifierClass, cls.getSuperclass(), clsSignature);
            }
        }));
    }

    private static void handleSuperModifierBaseImplementation(PrototypeDescription<ClassOrInterfaceDeclaration> parse, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf, ClassOrInterfaceDeclaration modifier, ClassOrInterfaceDeclaration modifierClass, Class<?> cls, Map<String, String> clsSignature) {
        String intfName = intf.getNameAsString();
        String modName = intfName + "." + modifier.getNameAsString();
        for (Method method : cls.getDeclaredMethods()) {
            if (!java.lang.reflect.Modifier.isPublic(method.getModifiers()) || java.lang.reflect.Modifier.isStatic(method.getModifiers()) || "setObject".equals(method.getName())) continue;
            Final ann = method.getAnnotation(Final.class);
            if (Objects.nonNull(ann)) {
                if (StringUtils.isBlank((CharSequence)ann.description())) {
                    Generator.addMethod(modifier, method, clsSignature, intfName);
                    continue;
                }
                Generator.addMethod(modifier, method, clsSignature, modName, intfName, ann);
                continue;
            }
            Generator.addMethod(modifier, method, clsSignature, modName);
        }
        if (Objects.nonNull(cls.getSuperclass()) && Modifier.class.isAssignableFrom(cls)) {
            ModifierEnricherHandler.handleSuperModifierBaseImplementation(parse, spec, intf, modifier, modifierClass, cls.getSuperclass(), clsSignature);
        }
    }

    @Override
    public void finalizeEnrich(PrototypeDescription<ClassOrInterfaceDeclaration> description) {
        if (this.lookup.embeddedModifierRequested(description)) {
            ModifierEnricherHandler.buildEmbeddedModifier(description, true);
            ModifierEnricherHandler.buildEmbeddedModifier(description, false);
        }
    }

    @Override
    public int order() {
        return 10000;
    }

    public static void buildEmbeddedModifier(PrototypeDescription<ClassOrInterfaceDeclaration> parse, boolean isClass) {
        String intfName;
        CompilationUnit unit = parse.getFiles().get(isClass ? 0 : 1);
        ClassOrInterfaceDeclaration modifier = parse.getRegisteredClass("ModifierIntf");
        ClassOrInterfaceDeclaration embedded = parse.getRegisteredClass("EmbeddedModifierIntf");
        if (isClass) {
            modifier = parse.getRegisteredClass("Modifier");
            embedded = parse.getRegisteredClass("EmbeddedModifier");
        }
        String string = intfName = unit.getType(0).asClassOrInterfaceDeclaration().isInterface() ? unit.getType(0).getNameAsString() : "void";
        if (Objects.isNull(embedded)) {
            ModifierEnricherHandler.handleEmbeddedModifier(parse, parse.getSpec(), parse.getIntf());
            ClassOrInterfaceDeclaration classOrInterfaceDeclaration = embedded = isClass ? parse.getRegisteredClass("EmbeddedModifier") : parse.getRegisteredClass("EmbeddedModifierIntf");
        }
        if (Objects.nonNull(embedded)) {
            if (isClass) {
                embedded.setExtendedTypes(modifier.getExtendedTypes());
            } else {
                embedded.addExtendedType(parse.getIntf().getNameAsString() + ".Fields<" + parse.getIntf().getNameAsString() + ".EmbeddedModify<T>>");
            }
            String intf = modifier.getNameAsString();
            Object eIntf = embedded.getNameAsString() + "<T>";
            if (modifier.getImplementedTypes().isNonEmpty()) {
                intf = modifier.getImplementedTypes(0).toString();
                eIntf = embedded.getImplementedTypes(0).toString();
            }
            for (MethodDeclaration old : modifier.getMethods()) {
                if ("Modify".equals(old.getType().toString()) || old.getType().toString().endsWith(".Modify") || old.getTypeAsString().startsWith("EmbeddedCodeCollection<")) {
                    MethodDeclaration method = embedded.addMethod(old.getNameAsString(), new Modifier.Keyword[0]).setModifiers(old.getModifiers()).setParameters(old.getParameters());
                    if (old.getType().asString().equals(intf)) {
                        method.setType((String)eIntf);
                        if (old.getBody().isPresent()) {
                            method.setBody((BlockStmt)((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("entity." + method.getNameAsString())).setValue((Expression)new NameExpr().setName(method.getNameAsString())))).addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("this"))));
                            continue;
                        }
                        method.setBody(null);
                        continue;
                    }
                    if (CollectionsHandler.isCollection(old.getType())) {
                        method.setType(old.getType().toString().replace(intf, (CharSequence)eIntf));
                        if (old.getBody().isPresent()) {
                            CollectionsHandler.CollectionType collection = CollectionsHandler.getCollectionType(unit, unit, old.getType().asClassOrInterfaceType());
                            String parent = "entity." + method.getNameAsString();
                            method.setBody((BlockStmt)((BlockStmt)new BlockStmt().addStatement((Statement)new IfStmt().setCondition((Expression)new NameExpr().setName(parent + " != null")).setThenStmt((Statement)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName(parent)).setValue((Expression)new NameExpr().setName("new " + collection.getImplementor() + "<>()")))))).addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("new " + collection.getClassType() + "<>(this, " + parent + ")"))));
                            continue;
                        }
                        method.setBody(null);
                        continue;
                    }
                    if (old.getTypeAsString().startsWith("EmbeddedCodeCollection<")) {
                        if (old.getBody().isPresent()) {
                            method.setType(old.getType().toString().replace(", " + intf, ", " + (String)eIntf));
                            String[] split = ((NameExpr)((Node)((BlockStmt)old.getBody().get()).getChildNodes().get(1)).getChildNodes().get(0)).getNameAsString().split("[\\s<.]");
                            String collection = split[1];
                            String cls = split[6];
                            String collectionType = ((Node)((Node)((Node)((BlockStmt)old.getBody().get()).getChildNodes().get(0)).getChildNodes().get(1)).getChildNodes().get(0)).toString().split("[\\s<]")[3];
                            String parent = "entity." + method.getNameAsString();
                            method.setBody((BlockStmt)((BlockStmt)new BlockStmt().addStatement((Statement)new IfStmt().setCondition((Expression)new NameExpr().setName(parent + " != null")).setThenStmt((Statement)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName(parent)).setValue((Expression)new NameExpr().setName("new " + collectionType + "<>()")))))).addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("new " + collection + "<>(this, " + parent + ", " + cls + ".class)"))));
                            continue;
                        }
                        method.setType(old.getType().toString().replace(", Modify>", ", " + intfName + ".EmbeddedModify<T>>"));
                        method.setBody(null);
                        continue;
                    }
                    method.setType(old.getType());
                    method.setBody((BlockStmt)old.getBody().orElse(null));
                    continue;
                }
                intfName = old.getType().asClassOrInterfaceType().getNameAsString();
            }
        }
    }

    private static void handleEmbeddedModifier(PrototypeDescription<ClassOrInterfaceDeclaration> parse, ClassOrInterfaceDeclaration spec, ClassOrInterfaceDeclaration intf) {
        ClassOrInterfaceDeclaration actualModifier = parse.getRegisteredClass("ModifierIntf");
        if (Objects.nonNull(actualModifier) && Objects.isNull(parse.getRegisteredClass("EmbeddedModifierIntf"))) {
            if (Objects.nonNull(parse.getProperties().getMixInClass())) {
                spec = parse.getMixIn().getSpec();
            }
            ClassOrInterfaceDeclaration actualModifierClass = parse.getRegisteredClass("Modifier");
            ClassOrInterfaceDeclaration modifier = ((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(com.github.javaparser.ast.Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[0]), false, "Embedded" + actualModifier.getNameAsString()).addTypeParameter("T")).setInterface(true);
            ((MethodDeclaration)modifier.addMethod("and", new Modifier.Keyword[0]).setType("EmbeddedCodeCollection<EmbeddedModify<T>, " + intf.getNameAsString() + ", T>")).setBody(null);
            ClassOrInterfaceDeclaration modifierClass = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration(com.github.javaparser.ast.Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[]{Modifier.Keyword.PROTECTED, Modifier.Keyword.STATIC}), false, "Embedded" + actualModifierClass.getNameAsString()).addTypeParameter("T")).addImplementedType(intf.getNameAsString() + "." + modifier.getNameAsString() + "<T>");
            modifierClass.addField("T", "parent", new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
            modifierClass.addField(spec.getNameAsString(), "entity", new Modifier.Keyword[]{Modifier.Keyword.PROTECTED});
            ((ConstructorDeclaration)((ConstructorDeclaration)modifierClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).addParameter("T", "parent")).addParameter(spec.getNameAsString(), "entity")).setBody((BlockStmt)((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this.parent")).setValue((Expression)new NameExpr().setName("parent")))).addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName("this.entity")).setValue((Expression)new NameExpr().setName("entity"))));
            ((MethodDeclaration)modifierClass.addMethod("and", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType("EmbeddedCodeCollection<" + intf.getNameAsString() + ".EmbeddedModify<T>, " + intf.getNameAsString() + ", T>")).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("(EmbeddedCodeCollection) parent"))));
            spec.addMember((BodyDeclaration)modifierClass);
            intf.addMember((BodyDeclaration)modifier);
            parse.registerClass("EmbeddedModifier", modifierClass);
            parse.registerClass("EmbeddedModifierIntf", modifier);
            ((CompilationUnit)intf.findCompilationUnit().get()).addImport("net.binis.codegen.collection.EmbeddedCodeCollection");
            spec.findCompilationUnit().ifPresent(u -> {
                u.addImport("net.binis.codegen.factory.CodeFactory");
                u.addImport("net.binis.codegen.collection.EmbeddedCodeCollection");
            });
        }
    }

    private void addModifier(ClassOrInterfaceDeclaration spec, PrototypeField declaration, String modifierClassName, String modifierName, boolean isClass) {
        String type;
        String string = type = declaration.isGenericMethod() ? "Object" : declaration.getType();
        if (Objects.isNull(type)) {
            type = Objects.isNull(declaration.getDescription()) || "dummy".equals(((PackageDeclaration)((CompilationUnit)declaration.getDescription().findCompilationUnit().get()).getPackageDeclaration().get()).getNameAsString()) ? Generator.handleType((CompilationUnit)declaration.getDeclaration().findCompilationUnit().get(), (CompilationUnit)spec.findCompilationUnit().get(), ((VariableDeclarator)declaration.getDeclaration().getVariables().get(0)).getType()) : (declaration.getDescription().getTypeParameters().isEmpty() ? Generator.handleType((CompilationUnit)declaration.getDescription().findCompilationUnit().get(), (CompilationUnit)spec.findCompilationUnit().get(), declaration.getDeclaration().getVariable(0).getType()) : "Object");
        } else {
            ((CompilationUnit)spec.findCompilationUnit().get()).addImport(declaration.getFullType());
        }
        MethodDeclaration method = (MethodDeclaration)((MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(declaration.getName())).setType(modifierName)).addParameter((Parameter)((Parameter)new Parameter().setName(declaration.getName())).setType(type));
        if (isClass) {
            ((MethodDeclaration)method.addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setBody((BlockStmt)((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr().setTarget((Expression)new NameExpr().setName(modifierClassName + ".this." + declaration.getName())).setValue((Expression)new NameExpr().setName(declaration.getName())))).addStatement((Statement)new ReturnStmt().setExpression((Expression)new NameExpr().setName("this"))));
            declaration.addModifier(method);
        } else {
            method.setBody(null);
        }
        if (!Helpers.methodExists(spec, method, isClass)) {
            spec.addMember((BodyDeclaration)method);
        }
    }
}

